﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Diagnostics;
using System.IO;

namespace ct.Asteroid
{
    /// <summary>
    /// Eine mehr oder wenige 1 zu 1 Konvertierung des Beispielprogramms von Harald Bögeholz
    /// </summary>
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            String[] args = Environment.GetCommandLineArgs();

            if (args.Length != 2)
            {
                Console.WriteLine("Aufruf: asteroid <IP-Adresse>\n");
                Environment.Exit(1);
            }

            try
            {
                IPAddress server_ip = IPAddress.Parse(args[1]);
                if (server_ip == null)
                {
                    Console.WriteLine("Ungueltige IP-Adresse: '" + args[1] + "'\n");
                    Environment.Exit(1);
                }

                EndPoint myLocalEndpoint = new IPEndPoint(IPAddress.Any, 0);
                Socket sd = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

                sd.ReceiveBufferSize = 2048;
                sd.Blocking = false;
                sd.Bind(myLocalEndpoint);

                TPlayer player = new TPlayer(sd, server_ip);
                player.Run();
            }
            finally
            {
            }
        }
    }
}
