/*
 * Decompiled with CFR 0.152.
 */
package de.dkn.asteroids;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.SpaceShip;
import de.caff.util.Tools;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;

public class DknShootingDirPreparer
implements FramePreparer {
    private static final int MAX_EXTRACTS_FOR_SYNCH = 6;
    private int usedShipDirs = 0;

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        ArrayList<FrameInfoExtract> extracts = new ArrayList<FrameInfoExtract>();
        int i = frameInfos.size();
        while (i > frameInfos.size() - 6 && i > 0) {
            FrameInfoExtract extract = new FrameInfoExtract(frameInfos.get(i - 1));
            if (!extract.isWithShip()) break;
            extracts.add(extract);
            --i;
        }
        if (extracts.size() > 2) {
            ((FrameInfoExtract)extracts.get(0)).setShootingDirection(DknShootingDirPreparer.normalize(((FrameInfoExtract)extracts.get(1)).getShootingDirection() + ((FrameInfoExtract)extracts.get(2)).getTurn()));
            frameInfos.getLast().setProbableShootingDir(DknShootingDirPreparer.normalize(((FrameInfoExtract)extracts.get(0)).getShootingDirection() + ((FrameInfoExtract)extracts.get(1)).getTurn()));
        }
        if (extracts.size() > 0) {
            FrameInfoExtract currExtract = (FrameInfoExtract)extracts.get(0);
            ArrayList[] allMatches = new ArrayList[5];
            int i2 = 0;
            while (i2 < allMatches.length) {
                allMatches[i2] = new ArrayList();
                ++i2;
            }
            i2 = 0;
            while (i2 < FrameInfo.SHOOTING_DIRECTIONS.length) {
                int entry = i2;
                int j = 0;
                while (j < extracts.size()) {
                    if (j != extracts.size() - 1 || extracts.size() <= 1) {
                        if (!FrameInfo.SHOOTING_DIRECTIONS[entry].getShipDirection().equals(((FrameInfoExtract)extracts.get(j)).getShipDirection())) break;
                        allMatches[j].add(i2);
                        if (j < extracts.size() - 2) {
                            entry = DknShootingDirPreparer.normalize(entry - ((FrameInfoExtract)extracts.get(j + 2)).getTurn());
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            int matchesPos = -1;
            int i3 = allMatches.length - 1;
            while (i3 >= 0 && matchesPos < 0) {
                if (allMatches[i3].size() > 0) {
                    matchesPos = i3;
                }
                --i3;
            }
            if (matchesPos < 0) {
                frameInfos.getLast().getDecisionData().synchInfo = new StringBuffer().append("Could not synchronize: ").append(extracts.size()).append(" extracts=").append(extracts).toString();
            } else {
                this.usedShipDirs = matchesPos + 1;
                ArrayList matches = allMatches[matchesPos];
                if (matches.contains(currExtract.getShootingDirection())) {
                    frameInfos.getLast().getDecisionData().synchInfo = new StringBuffer().append("Confirmed synchronization: ").append(currExtract.getShootingDirection()).append(", usedShipDirs=").append(this.usedShipDirs).append(", with ").append(extracts.size()).append(" extracts=").append(extracts).toString();
                } else {
                    int synchDirection = (Integer)matches.get(0);
                    ((FrameInfoExtract)extracts.get(0)).setShootingDirection(synchDirection);
                    frameInfos.getLast().getDecisionData().synchInfo = new StringBuffer().append("Resynchronized to: ").append(synchDirection).append(", usedShipDirs=").append(this.usedShipDirs).append(", with ").append(extracts.size()).append(" extracts=").append(extracts).toString();
                }
            }
            frameInfos.getLast().setBothShootingDirectionsLowLevel(this.unsignedToByte(currExtract.getShootingDirection()));
        }
    }

    public static int normalize(int index) {
        return (index + 256) % 256;
    }

    private Byte unsignedToByte(int index) {
        return new Byte(Integer.toString(index < 128 ? index : index - 256));
    }

    public static class FrameInfoExtract {
        private boolean withShip;
        private Point shipDirection;
        private int shootingDirection;
        private int turn;

        public FrameInfoExtract(FrameInfo frame) {
            SpaceShip ship = frame.getSpaceShip();
            boolean bl = this.withShip = ship != null;
            if (this.withShip) {
                this.shipDirection = ship.getDirection();
                this.shootingDirection = Tools.byteToUnsigned(frame.getShootingDirectionLowLevel());
                int nextShootingDirection = Tools.byteToUnsigned(frame.getNextShootingDirectionLowLevel());
                this.turn = nextShootingDirection == 0 && this.shootingDirection == 255 ? -1 : nextShootingDirection - this.shootingDirection;
            }
        }

        public boolean isWithShip() {
            return this.withShip;
        }

        public Point getShipDirection() {
            return this.shipDirection;
        }

        public int getTurn() {
            return this.turn;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FrameInfoExtract[").append("withShip=").append(this.withShip).append(",shipDirection=").append(this.shipDirection).append(",shootingDirection=").append(this.shootingDirection).append(",turn=").append(this.turn).append("]");
            return sb.toString();
        }

        public int getShootingDirection() {
            return this.shootingDirection;
        }

        public void setShootingDirection(int shootingDirection) {
            this.shootingDirection = shootingDirection;
        }
    }
}

