/*
 * Decompiled with CFR 0.152.
 */
package de.dkn.asteroids;

import de.caff.asteroid.MovingGameObject;
import de.dkn.asteroids.DknDecisionPreparer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DknDecisionData {
    protected boolean fire;
    protected boolean hyper;
    protected boolean thrust;
    protected boolean left;
    protected boolean right;
    protected Map<Integer, DknDecisionPreparer.ShotTargetInfo> shotTargets = new HashMap<Integer, DknDecisionPreparer.ShotTargetInfo>();
    protected List<MovingGameObject> dangerousTargets;
    protected List<MovingGameObject> highPrioTargets;
    protected List<MovingGameObject> lowPrioTargets;
    protected List<MovingGameObject> allNotShotTargets;
    protected String synchInfo;
    protected DknDecisionPreparer.TargetHitResult turnThr;
    protected DknDecisionPreparer.TargetHitResult fireThr;
    protected boolean hyperInProgress;
    protected boolean hitExpectedInNextFrame;
    protected DknDecisionPreparer.ExpectedBulletInfo expectedBulletInfo;

    public void inherit(DknDecisionData previous) {
        if (previous != null) {
            for (Map.Entry<Integer, DknDecisionPreparer.ShotTargetInfo> entry : previous.shotTargets.entrySet()) {
                this.shotTargets.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isDeathExpected(Integer targetIdentity) {
        if (targetIdentity == null || this.shotTargets == null) {
            return false;
        }
        return this.shotTargets.get(targetIdentity) != null;
    }

    public int getColorCode(MovingGameObject target) {
        int code = 0;
        if (target != null) {
            if (this.isDeathExpected(target.getIdentity())) {
                ++code;
            }
            if (target.isDangerous()) {
                code += 2;
            }
        }
        return code;
    }

    public String getSynchInfo() {
        return this.synchInfo;
    }

    public boolean isFire() {
        return this.fire;
    }

    public boolean isHyper() {
        return this.hyper;
    }

    public boolean isHitExpectedInNextFrame() {
        return this.hitExpectedInNextFrame;
    }

    public boolean isLeft() {
        return this.left;
    }

    public boolean isRight() {
        return this.right;
    }

    public DknDecisionPreparer.TargetHitResult getTurnThr() {
        return this.turnThr;
    }

    public DknDecisionPreparer.TargetHitResult getFireThr() {
        return this.fireThr;
    }

    public DknDecisionPreparer.ExpectedBulletInfo getExpectedBulletInfo() {
        return this.expectedBulletInfo;
    }
}

