/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Drawable;
import de.caff.asteroid.GameData;
import de.caff.asteroid.Property;
import de.caff.asteroid.PropertyProvider;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedList;

public abstract class GameObject
implements GameData,
PropertyProvider,
Drawable {
    protected int x;
    protected int y;

    public GameObject(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSquaredDistance(GameObject obj) {
        return this.getSquaredDistance(obj.getX(), obj.getY());
    }

    public int getSquaredDistance(int px, int py) {
        int dx = px - this.x;
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = py - this.y;
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return dx * dx + dy * dy;
    }

    public double getSquaredDistance(double px, double py) {
        double dx = GameObject.normalizeDeltaX(px - (double)this.x);
        double dy = GameObject.normalizeDeltaY(py - (double)this.y);
        return dx * dx + dy * dy;
    }

    private static int normalizeDelta(int v, int extent) {
        while (v < -extent / 2) {
            v += extent;
        }
        while (v >= extent / 2) {
            v -= extent;
        }
        return v;
    }

    public static int normalizeDeltaX(int x) {
        return GameObject.normalizeDelta(x, 1024);
    }

    public static int normalizeDeltaY(int y) {
        return GameObject.normalizeDelta(y, 768);
    }

    private static double normalizeDelta(double v, double extent) {
        while (v < -extent / 2.0) {
            v += extent;
        }
        while (v >= extent / 2.0) {
            v -= extent;
        }
        return v;
    }

    public static double normalizeDeltaX(double x) {
        return GameObject.normalizeDelta(x, 1024.0);
    }

    public static double normalizeDeltaY(double y) {
        return GameObject.normalizeDelta(y, 768.0);
    }

    public boolean isOverlappingWith(Rectangle rect) {
        Rectangle bounds = this.getBounds();
        return rect.intersects(bounds);
    }

    public abstract Rectangle getBounds();

    @Override
    public Collection<Property> getProperties() {
        LinkedList<Property> props = new LinkedList<Property>();
        props.add(new Property<String>("Type", this.getObjectType()));
        props.add(new Property<Point>("Position", this.getLocation()));
        return props;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public abstract String getObjectType();

    public Point getDelta(GameObject obj) {
        return this.getDelta(obj.x, obj.y);
    }

    public Point getDelta(Point p) {
        return this.getDelta(p.x, p.y);
    }

    public Point getDelta(int px, int py) {
        return GameObject.getTorusDelta(px, py, this.x, this.y);
    }

    public static Point getTorusDelta(Point p1, Point p2) {
        return GameObject.getTorusDelta(p1.x, p1.y, p2.x, p2.y);
    }

    public static Point getTorusDelta(int p1x, int p1y, int p2x, int p2y) {
        int dx = p1x - p2x;
        if (dx < -512) {
            dx += 1024;
        } else if (dx >= 512) {
            dx -= 1024;
        }
        int dy = p1y - p2y;
        if (dy < -384) {
            dy += 768;
        } else if (dy >= 384) {
            dy -= 768;
        }
        return new Point(dx, dy);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }
}

