// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class Game 
{
  static final int LOG_T                =0x0001;
  static final int LOG_TARGET           =0x0002;
  static final int LOG_FIRING           =0x0004;
  static final int LOG_FIRING_DBG       =0x0008;

  static final int LOG_MODE=0; 
  
  Display display;
  DatagramSocket datagramSocket;
  ControlPacket controlPacket;
  FramePacket framePacket;
  int[] vRam;
  Screen screen;
  
  int t;
  
  Target target;
  
  public Game(InetAddress host, int port, boolean withDisplay) throws IOException
  {
    try
    {
      datagramSocket=new DatagramSocket();
    }
    catch(SocketException se)
    {
      System.err.println(se);
      System.exit(1);
    }
    controlPacket=new ControlPacket(datagramSocket,host,port);
    framePacket=new FramePacket(datagramSocket);
    vRam=new int[512];
    screen=new Screen();
    if(withDisplay)display=new Display(this);
  } // constructor

  void findTarget()
  {
    target=null;
    if(screen.ship==null)return;
    
    // (1) if present set saucer as target with quite high priority
    if(screen.saucer!=null)
    {
      screen.saucer.priority=90100;
      screen.saucer.calculateFireData(t,screen.ship);
      target=screen.saucer;
    }
    
    // (2) calculate target priority of asteroids
    for(Asteroid a: screen.asteroids)
    {
      if(t>a.tExpectedFireHit)a.nFired=0;
      
      // (2.1) check wheter there are already enough shots to this 
      if(a.nFire>0 && a.nFired>=a.nFire && screen.asteroids.size()>1)continue;
      
      // (2.2) calculate fire data (fire aiming and fire time)
      a.calculateFireData(t,screen.ship);
  
      // (2.3) calculate motion data with respect to ship (minimum distance and time of minimum distance)
      double v=Math.sqrt(a.vx*a.vx + a.vy*a.vy);
      int dx=screen.ship.sx-a.sx;
      int dy=screen.ship.sy-a.sy;
      double d=Math.sqrt(dx*dx+dy*dy);
      double nx,ny;
      nx=a.vy/v;  ny=-a.vx/v; 
      // to improve: consider wrap around
      double tDMin,dMin;
      LinEqSys22.solve(a.vx,a.vy,nx,ny,screen.ship.sx-a.sx,screen.ship.sy-a.sy);
      tDMin=LinEqSys22.getSolution1();
      dMin=Math.abs(LinEqSys22.getSolution2()) - (screen.ship.getRadius()+a.getRadius());
      
      // (2.4) assign target priority
      // (a) asteroid will collide in future: the sooner it will collide, the higher its priority
      if(dMin<=0 && tDMin>1){ a.priority=90000+(int)Math.round(2000/tDMin); } //a.nFired=0; a.nFire=Integer.MAX_VALUE; }
  
      // (b) non-colliding asteroid of size 1 or 
      //     non-colliding asteroid of size 2 or 3 that is not too close:
      //     the sooner it can be hit, the higher its priority
      else if(a.getSize()==1 || d>250)   a.priority=65000+(int)Math.round(1000/(1+Math.abs(a.tExpectedFireHit-t)));
      
      // (c) non-colliding asteroid of size >1 if farther away than 100: smaller ones have higher priority
      else if(d>100)           a.priority=65010-a.getSize();
      else                     a.priority=0;
      
      // (2.4) assign number of shots (actually this is currectly a constant for each asteroid size,
      //       but later strategies may be more flexible)
      if(a.getSize()==2)a.nFire=3; else a.nFire=1; 
      
      if((target==null || target.priority<a.priority) && a.priority>0)target=a;
    }
  } // findTarget
    
  static int deltaAiming(int a0, int a1){ return ((128+a1-a0)&0xff)-128; }

  void play() throws IOException
  {
    int da=0;
    Target testTarget=new Target();
    
    while(true)
    {
      controlPacket.send();
      t=framePacket.receive(vRam);
      screen.analyze(t,vRam);

      if((LOG_MODE&LOG_T)!=0)System.out.println("---------------------------------------------------------------");
      if((LOG_MODE&LOG_T)!=0)System.out.println("t="+t);

      Aiming.verifyAndUpdateShipsAiming(screen.ship,controlPacket.getTurningDir());
      
      if((target==null || target.tFire<t) && screen.ship!=null)
      {
        findTarget();
        if(target!=null)
        {
          if((LOG_MODE&LOG_FIRING)!=0)System.out.println("t="+t+": target="+target+": tFire="+target.tFire+" aimingFire="+target.aimingFire);
          da=deltaAiming(screen.ship.aiming,target.aimingFire);
        }
      }
      if(screen.ship!=null && target!=null && target.tFire>=t)
      { 
        if(da!=0)
        {
          if(da<0){ controlPacket.setRight(true); da++; } else if(da>0){ controlPacket.setLeft(true); da--; }
        }
        if(t==target.tFire)
        {
          if(screen.ownShots.size()<4)target.nFired++;
          if((LOG_MODE&LOG_FIRING)!=0)System.out.println("t="+t+": fired at aiming="+target.aimingFire);
          if((LOG_MODE&LOG_FIRING_DBG)!=0)if(target.aimingFire!=screen.ship.aiming)System.out.println("*** firing with imperfect aiming ***");
          controlPacket.setFire(true);
        }
        if(t>target.tFire && target.nFired>=target.nFire)
        {
          target=null;
        }
      }
      if(display!=null)display.repaint();
    } // while
  } // play

} // class
