// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class FramePacket 
{

  static final int PACKET_SIZE=1026;

  byte[] buffer=new byte[PACKET_SIZE];

  DatagramSocket datagramSocket;
  DatagramPacket datagramPacket=new DatagramPacket(buffer,PACKET_SIZE);

  byte frameNumber;
  byte ping;

  public FramePacket(DatagramSocket datagramSocket)
  {
    this.datagramSocket=datagramSocket;
  } // constructor

  int prevCount=0,countOffset=0;

/**
  * @return consecutive frame count
  */
  int receive(int[] vram) throws IOException
  {
    datagramSocket.receive(datagramPacket);
    int n=datagramPacket.getLength();
    if(n!=PACKET_SIZE)
    {
      for(int i=0; i<n; i++)System.out.print((char)buffer[i]);
      System.out.println();
      System.exit(1);
    }

    for(int i=0,j=0; j<512; i+=2,j++)
      vram[j]=(0xff&buffer[i])|((0xff&buffer[i+1])<<8);
      
    int count=buffer[1024];
    if(count<prevCount)countOffset+=256; 
    prevCount=count;
    return countOffset+count;
  } // receive

} // class
