// creativ'08-Wettbewerb zum 25. c't-Geburtstag
// Beitrag von Curd Wallhaeusser

package robot41;

public class Aiming
{

  static final int LOG_INFO   =0x0001;
  static final int LOG_DEBUG  =0x0002;

  static final int LOG_MODE=0;

  public static AimingData[] table=
  {
/*   0: */ new AimingData( 1536,    0),
/*   1: */ new AimingData( 1536,    0),
/*   2: */ new AimingData( 1528,  152),
/*   3: */ new AimingData( 1504,  296),
/*   4: */ new AimingData( 1472,  440),
/*   5: */ new AimingData( 1472,  440),
/*   6: */ new AimingData( 1416,  584),
/*   7: */ new AimingData( 1360,  720),
/*   8: */ new AimingData( 1280,  856),
/*   9: */ new AimingData( 1280,  856),
/*  10: */ new AimingData( 1192,  976),
/*  11: */ new AimingData( 1088, 1088),
/*  12: */ new AimingData(  976, 1192),
/*  13: */ new AimingData(  976, 1192),
/*  14: */ new AimingData(  856, 1280),
/*  15: */ new AimingData(  720, 1360),
/*  16: */ new AimingData(  584, 1416),
/*  17: */ new AimingData(  584, 1416),
/*  18: */ new AimingData(  440, 1472),
/*  19: */ new AimingData(  296, 1504),
/*  20: */ new AimingData(  152, 1528),
/*  21: */ new AimingData(  152, 1528),
/*  22: */ new AimingData( -152, 1528),
/*  23: */ new AimingData( -296, 1504),
/*  24: */ new AimingData( -296, 1504),
/*  25: */ new AimingData( -440, 1472),
/*  26: */ new AimingData( -584, 1416),
/*  27: */ new AimingData( -720, 1360),
/*  28: */ new AimingData( -720, 1360),
/*  29: */ new AimingData( -856, 1280),
/*  30: */ new AimingData( -976, 1192),
/*  31: */ new AimingData(-1088, 1088),
/*  32: */ new AimingData(-1088, 1088),
/*  33: */ new AimingData(-1192,  976),
/*  34: */ new AimingData(-1280,  856),
/*  35: */ new AimingData(-1360,  720),
/*  36: */ new AimingData(-1360,  720),
/*  37: */ new AimingData(-1416,  584),
/*  38: */ new AimingData(-1472,  440),
/*  39: */ new AimingData(-1504,  296),
/*  40: */ new AimingData(-1504,  296),
/*  41: */ new AimingData(-1528,  152),
/*  42: */ new AimingData(-1536,    0),
/*  43: */ new AimingData(-1536,    0),
/*  44: */ new AimingData(-1528, -152),
/*  45: */ new AimingData(-1528, -152),
/*  46: */ new AimingData(-1504, -296),
/*  47: */ new AimingData(-1472, -440),
/*  48: */ new AimingData(-1416, -584),
/*  49: */ new AimingData(-1416, -584),
/*  50: */ new AimingData(-1360, -720),
/*  51: */ new AimingData(-1280, -856),
/*  52: */ new AimingData(-1192, -976),
/*  53: */ new AimingData(-1192, -976),
/*  54: */ new AimingData(-1088,-1088),
/*  55: */ new AimingData( -976,-1192),
/*  56: */ new AimingData( -856,-1280),
/*  57: */ new AimingData( -856,-1280),
/*  58: */ new AimingData( -720,-1360),
/*  59: */ new AimingData( -584,-1416),
/*  60: */ new AimingData( -440,-1472),
/*  61: */ new AimingData( -440,-1472),
/*  62: */ new AimingData( -296,-1504),
/*  63: */ new AimingData( -152,-1528),
/*  64: */ new AimingData(    0,-1536),
/*  65: */ new AimingData(  152,-1528),
/*  66: */ new AimingData(  296,-1504),
/*  67: */ new AimingData(  440,-1472),
/*  68: */ new AimingData(  440,-1472),
/*  69: */ new AimingData(  584,-1416),
/*  70: */ new AimingData(  720,-1360),
/*  71: */ new AimingData(  856,-1280),
/*  72: */ new AimingData(  856,-1280),
/*  73: */ new AimingData(  976,-1192),
/*  74: */ new AimingData( 1088,-1088),
/*  75: */ new AimingData( 1192, -976),
/*  76: */ new AimingData( 1192, -976),
/*  77: */ new AimingData( 1280, -856),
/*  78: */ new AimingData( 1360, -720),
/*  79: */ new AimingData( 1416, -584),
/*  80: */ new AimingData( 1416, -584),
/*  81: */ new AimingData( 1472, -440),
/*  82: */ new AimingData( 1504, -296),
/*  83: */ new AimingData( 1528, -152),
/*  84: */ new AimingData( 1528, -152),
/*  85: */ new AimingData( 1536,    0),
/*  86: */ new AimingData( 1536,    0),
/*  87: */ new AimingData( 1528,  152),
/*  88: */ new AimingData( 1504,  296),
/*  89: */ new AimingData( 1504,  296),
/*  90: */ new AimingData( 1472,  440),
/*  91: */ new AimingData( 1416,  584),
/*  92: */ new AimingData( 1360,  720),
/*  93: */ new AimingData( 1360,  720),
/*  94: */ new AimingData( 1280,  856),
/*  95: */ new AimingData( 1192,  976),
/*  96: */ new AimingData( 1088, 1088),
/*  97: */ new AimingData( 1088, 1088),
/*  98: */ new AimingData(  976, 1192),
/*  99: */ new AimingData(  856, 1280),
/* 100: */ new AimingData(  720, 1360),
/* 101: */ new AimingData(  720, 1360),
/* 102: */ new AimingData(  584, 1416),
/* 103: */ new AimingData(  440, 1472),
/* 104: */ new AimingData(  296, 1504),
/* 105: */ new AimingData(  296, 1504),
/* 106: */ new AimingData(  152, 1528),
/* 107: */ new AimingData( -152, 1528),
/* 108: */ new AimingData( -152, 1528),
/* 109: */ new AimingData( -296, 1504),
/* 110: */ new AimingData( -440, 1472),
/* 111: */ new AimingData( -584, 1416),
/* 112: */ new AimingData( -584, 1416),
/* 113: */ new AimingData( -720, 1360),
/* 114: */ new AimingData( -856, 1280),
/* 115: */ new AimingData( -976, 1192),
/* 116: */ new AimingData( -976, 1192),
/* 117: */ new AimingData(-1088, 1088),
/* 118: */ new AimingData(-1192,  976),
/* 119: */ new AimingData(-1280,  856),
/* 120: */ new AimingData(-1280,  856),
/* 121: */ new AimingData(-1360,  720),
/* 122: */ new AimingData(-1416,  584),
/* 123: */ new AimingData(-1472,  440),
/* 124: */ new AimingData(-1472,  440),
/* 125: */ new AimingData(-1504,  296),
/* 126: */ new AimingData(-1528,  152),
/* 127: */ new AimingData(-1536,    0),
/* 128: */ new AimingData(-1536,    0),
/* 129: */ new AimingData(-1536,    0),
/* 130: */ new AimingData(-1528, -152),
/* 131: */ new AimingData(-1504, -296),
/* 132: */ new AimingData(-1472, -440),
/* 133: */ new AimingData(-1472, -440),
/* 134: */ new AimingData(-1416, -584),
/* 135: */ new AimingData(-1360, -720),
/* 136: */ new AimingData(-1280, -856),
/* 137: */ new AimingData(-1280, -856),
/* 138: */ new AimingData(-1192, -976),
/* 139: */ new AimingData(-1088,-1088),
/* 140: */ new AimingData( -976,-1192),
/* 141: */ new AimingData( -976,-1192),
/* 142: */ new AimingData( -856,-1280),
/* 143: */ new AimingData( -720,-1360),
/* 144: */ new AimingData( -584,-1416),
/* 145: */ new AimingData( -584,-1416),
/* 146: */ new AimingData( -440,-1472),
/* 147: */ new AimingData( -296,-1504),
/* 148: */ new AimingData( -152,-1528),
/* 149: */ new AimingData( -152,-1528),
/* 150: */ new AimingData(  152,-1528),
/* 151: */ new AimingData(  296,-1504),
/* 152: */ new AimingData(  296,-1504),
/* 153: */ new AimingData(  440,-1472),
/* 154: */ new AimingData(  584,-1416),
/* 155: */ new AimingData(  720,-1360),
/* 156: */ new AimingData(  720,-1360),
/* 157: */ new AimingData(  856,-1280),
/* 158: */ new AimingData(  976,-1192),
/* 159: */ new AimingData( 1088,-1088),
/* 160: */ new AimingData( 1088,-1088),
/* 161: */ new AimingData( 1192, -976),
/* 162: */ new AimingData( 1280, -856),
/* 163: */ new AimingData( 1360, -720),
/* 164: */ new AimingData( 1360, -720),
/* 165: */ new AimingData( 1416, -584),
/* 166: */ new AimingData( 1472, -440),
/* 167: */ new AimingData( 1504, -296),
/* 168: */ new AimingData( 1504, -296),
/* 169: */ new AimingData( 1528, -152),
/* 170: */ new AimingData( 1536,    0),
/* 171: */ new AimingData( 1536,    0),
/* 172: */ new AimingData( 1528,  152),
/* 173: */ new AimingData( 1528,  152),
/* 174: */ new AimingData( 1504,  296),
/* 175: */ new AimingData( 1472,  440),
/* 176: */ new AimingData( 1416,  584),
/* 177: */ new AimingData( 1416,  584),
/* 178: */ new AimingData( 1360,  720),
/* 179: */ new AimingData( 1280,  856),
/* 180: */ new AimingData( 1192,  976),
/* 181: */ new AimingData( 1192,  976),
/* 182: */ new AimingData( 1088, 1088),
/* 183: */ new AimingData(  976, 1192),
/* 184: */ new AimingData(  856, 1280),
/* 185: */ new AimingData(  856, 1280),
/* 186: */ new AimingData(  720, 1360),
/* 187: */ new AimingData(  584, 1416),
/* 188: */ new AimingData(  440, 1472),
/* 189: */ new AimingData(  440, 1472),
/* 190: */ new AimingData(  296, 1504),
/* 191: */ new AimingData(  152, 1528),
/* 192: */ new AimingData(    0, 1536),
/* 193: */ new AimingData( -152, 1528),
/* 194: */ new AimingData( -296, 1504),
/* 195: */ new AimingData( -440, 1472),
/* 196: */ new AimingData( -440, 1472),
/* 197: */ new AimingData( -584, 1416),
/* 198: */ new AimingData( -720, 1360),
/* 199: */ new AimingData( -856, 1280),
/* 200: */ new AimingData( -856, 1280),
/* 201: */ new AimingData( -976, 1192),
/* 202: */ new AimingData(-1088, 1088),
/* 203: */ new AimingData(-1192,  976),
/* 204: */ new AimingData(-1192,  976),
/* 205: */ new AimingData(-1280,  856),
/* 206: */ new AimingData(-1360,  720),
/* 207: */ new AimingData(-1416,  584),
/* 208: */ new AimingData(-1416,  584),
/* 209: */ new AimingData(-1472,  440),
/* 210: */ new AimingData(-1504,  296),
/* 211: */ new AimingData(-1528,  152),
/* 212: */ new AimingData(-1528,  152),
/* 213: */ new AimingData(-1536,    0),
/* 214: */ new AimingData(-1536,    0),
/* 215: */ new AimingData(-1528, -152),
/* 216: */ new AimingData(-1504, -296),
/* 217: */ new AimingData(-1504, -296),
/* 218: */ new AimingData(-1472, -440),
/* 219: */ new AimingData(-1416, -584),
/* 220: */ new AimingData(-1360, -720),
/* 221: */ new AimingData(-1360, -720),
/* 222: */ new AimingData(-1280, -856),
/* 223: */ new AimingData(-1192, -976),
/* 224: */ new AimingData(-1088,-1088),
/* 225: */ new AimingData(-1088,-1088),
/* 226: */ new AimingData( -976,-1192),
/* 227: */ new AimingData( -856,-1280),
/* 228: */ new AimingData( -720,-1360),
/* 229: */ new AimingData( -720,-1360),
/* 230: */ new AimingData( -584,-1416),
/* 231: */ new AimingData( -440,-1472),
/* 232: */ new AimingData( -296,-1504),
/* 233: */ new AimingData( -296,-1504),
/* 234: */ new AimingData( -152,-1528),
/* 235: */ new AimingData(  152,-1528),
/* 236: */ new AimingData(  152,-1528),
/* 237: */ new AimingData(  296,-1504),
/* 238: */ new AimingData(  440,-1472),
/* 239: */ new AimingData(  584,-1416),
/* 240: */ new AimingData(  584,-1416),
/* 241: */ new AimingData(  720,-1360),
/* 242: */ new AimingData(  856,-1280),
/* 243: */ new AimingData(  976,-1192),
/* 244: */ new AimingData(  976,-1192),
/* 245: */ new AimingData( 1088,-1088),
/* 246: */ new AimingData( 1192, -976),
/* 247: */ new AimingData( 1280, -856),
/* 248: */ new AimingData( 1280, -856),
/* 249: */ new AimingData( 1360, -720),
/* 250: */ new AimingData( 1416, -584),
/* 251: */ new AimingData( 1472, -440),
/* 252: */ new AimingData( 1472, -440),
/* 253: */ new AimingData( 1504, -296),
/* 254: */ new AimingData( 1528, -152),
/* 255: */ new AimingData( 1536,    0)
  };

  static byte dir1,dir2;

/**
  * wrapper function
  * - to handle processing delay of 2 frame periods
  * - shield off cases without ship or change of aiming
  */
  static void verifyAndUpdateShipsAiming(Ship ship, byte dir)
  {
    dir2=dir1;
    dir1=dir;
    if(ship!=null && dir2!=0)verifyAndUpdateShipsAimingAux(ship,dir2);
  } // verifyAndUpdateShipsAiming

  static byte prevDir;
  static int countSamples,iSample;
  static int[] dxSamples=new int[4];

  static void verifyAndUpdateShipsAimingAux(Ship ship, byte dir)
  {
    // (1) calculate ships new aiming
    ship.aiming=(ship.aiming+dir)&0xff;

    // (2) if needed, initialize sample counter
    if(prevDir!=dir){ if(prevDir==0)countSamples=0; else countSamples=1; }
    prevDir=dir;

    // (3) add new sample
    if(dir<0)iSample=(iSample+3)&3;
    dxSamples[iSample]=ship.dx;
    if(dir>0)iSample=(iSample+1)&3;
    if(countSamples<4)countSamples++;

    // (4) check whether ships calculated aiming is consistent with table
    if(ship.dx==table[ship.aiming].dx)return;

    // (5) if not, a (re-)initialisation is needed; which is possible only if there are 4 samples
    if(countSamples<4)return;

    // (6) find sample array in table:
    int i,j=0;
    for(i=0; i<256; i++)
    {
      for(j=0; j<4; j++)if(table[(i+j)&0xff].dx!=dxSamples[(iSample+j)&3])break;
      if(j>=4)
      {
        if(dir>0)i=(i+3)&0xff;
        ship.aiming=i;
        if((LOG_MODE&LOG_INFO)!=0)System.out.println("Ships aiming was (re-)initialized");
        return;
      }
    }
    if((LOG_MODE&LOG_DEBUG)!=0)System.err.println("Error: was not able to initialize ships aiming");
  } // verifyAndUpdateShipsAiming

} // class
