///////////////////////////////////////////////////////////////////////////////
// @ Eduard Heidt                                                            //
///////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "ship.h"
#include "game.h"
#include "fps.h"

Vector Ship::GetRelativePos(int t/* = 0*/) const
{
	Vector dis;
	for(int i = 0; i < t; i++)
		dis = dis + GetDir(t);

	Vector v = (pos+dis)-Game::GetState()->ship.pos;
	return v.GetMod(Vector(-512,-384), Vector(+512, 384));
}

Vector Ship::GetAbsolutePos(int t/* = 0*/) const
{
	Vector dis;
	for(int i = 0; i < t; i++)
		dis = dis + GetDir(t);

	Vector v = pos+dis;
	return v.GetMod(Vector(0,MIN_Y), Vector(MAX_X, MAX_Y-MIN_Y));
}

void Ship::SetDir(int _dx, int _dy)
{
	dx = _dx;
	dy = _dy;
}

void Ship::InitWinkelBytes()
{
	deg = 0;
	byte j = 0;																	
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//0
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//1
	display_degs[j][0] = 1528; display_degs[j][1] = 152; j+=3;		//2
	display_degs[j][0] = 1504; display_degs[j][1] = 296; j+=3;		//3
	display_degs[j][0] = 1472; display_degs[j][1] = 440; j+=3;		//4
	display_degs[j][0] = 1472; display_degs[j][1] = 440; j+=3;		//5
	display_degs[j][0] = 1416; display_degs[j][1] = 584; j+=3;		//6
	display_degs[j][0] = 1360; display_degs[j][1] = 720; j+=3;		//7
	display_degs[j][0] = 1280; display_degs[j][1] = 856; j+=3;		//8
	display_degs[j][0] = 1280; display_degs[j][1] = 856; j+=3;		//9
	display_degs[j][0] = 1192; display_degs[j][1] = 976; j+=3;		//10
	display_degs[j][0] = 1088; display_degs[j][1] = 1088; j+=3;		//11
	display_degs[j][0] = 976; display_degs[j][1] = 1192; j+=3;		//12
	display_degs[j][0] = 976; display_degs[j][1] = 1192; j+=3;		//13
	display_degs[j][0] = 856; display_degs[j][1] = 1280; j+=3;		//14
	display_degs[j][0] = 720; display_degs[j][1] = 1360; j+=3;		//15
	display_degs[j][0] = 584; display_degs[j][1] = 1416; j+=3;		//16
	display_degs[j][0] = 584; display_degs[j][1] = 1416; j+=3;		//17
	display_degs[j][0] = 440; display_degs[j][1] = 1472; j+=3;		//18
	display_degs[j][0] = 296; display_degs[j][1] = 1504; j+=3;		//19
	display_degs[j][0] = 152; display_degs[j][1] = 1528; j+=3;		//20
	display_degs[j][0] = 152; display_degs[j][1] = 1528; j+=3;		//21
	display_degs[j][0] = -152; display_degs[j][1] = 1528; j+=3;		//22
	display_degs[j][0] = -296; display_degs[j][1] = 1504; j+=3;		//23
	display_degs[j][0] = -296; display_degs[j][1] = 1504; j+=3;		//24
	display_degs[j][0] = -440; display_degs[j][1] = 1472; j+=3;		//25
	display_degs[j][0] = -584; display_degs[j][1] = 1416; j+=3;		//26
	display_degs[j][0] = -720; display_degs[j][1] = 1360; j+=3;		//27
	display_degs[j][0] = -720; display_degs[j][1] = 1360; j+=3;		//28
	display_degs[j][0] = -856; display_degs[j][1] = 1280; j+=3;		//29
	display_degs[j][0] = -976; display_degs[j][1] = 1192; j+=3;		//30
	display_degs[j][0] = -1088; display_degs[j][1] = 1088; j+=3;		//31
	display_degs[j][0] = -1088; display_degs[j][1] = 1088; j+=3;		//32
	display_degs[j][0] = -1192; display_degs[j][1] = 976; j+=3;		//33
	display_degs[j][0] = -1280; display_degs[j][1] = 856; j+=3;		//34
	display_degs[j][0] = -1360; display_degs[j][1] = 720; j+=3;		//35
	display_degs[j][0] = -1360; display_degs[j][1] = 720; j+=3;		//36
	display_degs[j][0] = -1416; display_degs[j][1] = 584; j+=3;		//37
	display_degs[j][0] = -1472; display_degs[j][1] = 440; j+=3;		//38
	display_degs[j][0] = -1504; display_degs[j][1] = 296; j+=3;		//39
	display_degs[j][0] = -1504; display_degs[j][1] = 296; j+=3;		//40
	display_degs[j][0] = -1528; display_degs[j][1] = 152; j+=3;		//41
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//42
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//43
	display_degs[j][0] = -1528; display_degs[j][1] = -152; j+=3;		//44
	display_degs[j][0] = -1528; display_degs[j][1] = -152; j+=3;		//45
	display_degs[j][0] = -1504; display_degs[j][1] = -296; j+=3;		//46
	display_degs[j][0] = -1472; display_degs[j][1] = -440; j+=3;		//47
	display_degs[j][0] = -1416; display_degs[j][1] = -584; j+=3;		//48
	display_degs[j][0] = -1416; display_degs[j][1] = -584; j+=3;		//49
	display_degs[j][0] = -1360; display_degs[j][1] = -720; j+=3;		//50
	display_degs[j][0] = -1280; display_degs[j][1] = -856; j+=3;		//51
	display_degs[j][0] = -1192; display_degs[j][1] = -976; j+=3;		//52
	display_degs[j][0] = -1192; display_degs[j][1] = -976; j+=3;		//53
	display_degs[j][0] = -1088; display_degs[j][1] = -1088; j+=3;	//54
	display_degs[j][0] = -976; display_degs[j][1] = -1192; j+=3;		//55
	display_degs[j][0] = -856; display_degs[j][1] = -1280; j+=3;		//56
	display_degs[j][0] = -856; display_degs[j][1] = -1280; j+=3;		//57
	display_degs[j][0] = -720; display_degs[j][1] = -1360; j+=3;		//58
	display_degs[j][0] = -584; display_degs[j][1] = -1416; j+=3;		//59
	display_degs[j][0] = -440; display_degs[j][1] = -1472; j+=3;		//60
	display_degs[j][0] = -440; display_degs[j][1] = -1472; j+=3;		//61
	display_degs[j][0] = -296; display_degs[j][1] = -1504; j+=3;		//62
	display_degs[j][0] = -152; display_degs[j][1] = -1528; j+=3;		//63
	display_degs[j][0] = 0; display_degs[j][1] = -1536; j+=3;			//64
	display_degs[j][0] = 152; display_degs[j][1] = -1528; j+=3;		//66
	display_degs[j][0] = 296; display_degs[j][1] = -1504; j+=3;		//66
	display_degs[j][0] = 440; display_degs[j][1] = -1472; j+=3;		//67
	display_degs[j][0] = 440; display_degs[j][1] = -1472; j+=3;		//68
	display_degs[j][0] = 584; display_degs[j][1] = -1416; j+=3;		//69
	display_degs[j][0] = 720; display_degs[j][1] = -1360; j+=3;		//70
	display_degs[j][0] = 856; display_degs[j][1] = -1280; j+=3;		//71
	display_degs[j][0] = 856; display_degs[j][1] = -1280; j+=3;		//72
	display_degs[j][0] = 976; display_degs[j][1] = -1192; j+=3;		//73
	display_degs[j][0] = 1088; display_degs[j][1] = -1088; j+=3;		//74
	display_degs[j][0] = 1192; display_degs[j][1] = -976; j+=3;		//75
	display_degs[j][0] = 1192; display_degs[j][1] = -976; j+=3;		//76
	display_degs[j][0] = 1280; display_degs[j][1] = -856; j+=3;		//77
	display_degs[j][0] = 1360; display_degs[j][1] = -720; j+=3;		//78
	display_degs[j][0] = 1416; display_degs[j][1] = -584; j+=3;		//79
	display_degs[j][0] = 1416; display_degs[j][1] = -584; j+=3;		//80
	display_degs[j][0] = 1472; display_degs[j][1] = -440; j+=3;		//81
	display_degs[j][0] = 1504; display_degs[j][1] = -296; j+=3;		//82
	display_degs[j][0] = 1528; display_degs[j][1] = -152; j+=3;		//83
	display_degs[j][0] = 1528; display_degs[j][1] = -152; j+=3;		//84
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//85
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//86
	display_degs[j][0] = 1528; display_degs[j][1] = 152; j+=3;		//87
	display_degs[j][0] = 1504; display_degs[j][1] = 296; j+=3;		//88
	display_degs[j][0] = 1504; display_degs[j][1] = 296; j+=3;		//89
	display_degs[j][0] = 1472; display_degs[j][1] = 440; j+=3;		//90
	display_degs[j][0] = 1416; display_degs[j][1] = 584; j+=3;		//91
	display_degs[j][0] = 1360; display_degs[j][1] = 720; j+=3;		//92
	display_degs[j][0] = 1360; display_degs[j][1] = 720; j+=3;		//93
	display_degs[j][0] = 1280; display_degs[j][1] = 856; j+=3;		//94
	display_degs[j][0] = 1192; display_degs[j][1] = 976; j+=3;		//95
	display_degs[j][0] = 1088; display_degs[j][1] = 1088; j+=3;		//96
	display_degs[j][0] = 1088; display_degs[j][1] = 1088; j+=3;		//97
	display_degs[j][0] = 976; display_degs[j][1] = 1192; j+=3;		//98
	display_degs[j][0] = 856; display_degs[j][1] = 1280; j+=3;		//99
	display_degs[j][0] = 720; display_degs[j][1] = 1360; j+=3;		//100
	display_degs[j][0] = 720; display_degs[j][1] = 1360; j+=3;		//101
	display_degs[j][0] = 584; display_degs[j][1] = 1416; j+=3;		//102
	display_degs[j][0] = 440; display_degs[j][1] = 1472; j+=3;		//103
	display_degs[j][0] = 296; display_degs[j][1] = 1504; j+=3;		//104
	display_degs[j][0] = 296; display_degs[j][1] = 1504; j+=3;		//105
	display_degs[j][0] = 152; display_degs[j][1] = 1528; j+=3;		//106
	display_degs[j][0] = -152; display_degs[j][1] = 1528; j+=3;		//107
	display_degs[j][0] = -152; display_degs[j][1] = 1528; j+=3;		//108
	display_degs[j][0] = -296; display_degs[j][1] = 1504; j+=3;		//109
	display_degs[j][0] = -440; display_degs[j][1] = 1472; j+=3;		//110
	display_degs[j][0] = -584; display_degs[j][1] = 1416; j+=3;		//111
	display_degs[j][0] = -584; display_degs[j][1] = 1416; j+=3;		//112
	display_degs[j][0] = -720; display_degs[j][1] = 1360; j+=3;		//113
	display_degs[j][0] = -856; display_degs[j][1] = 1280; j+=3;		//114
	display_degs[j][0] = -976; display_degs[j][1] = 1192; j+=3;		//115
	display_degs[j][0] = -976; display_degs[j][1] = 1192; j+=3;		//116
	display_degs[j][0] = -1088; display_degs[j][1] = 1088; j+=3;		//117
	display_degs[j][0] = -1192; display_degs[j][1] = 976; j+=3;		//118
	display_degs[j][0] = -1280; display_degs[j][1] = 856; j+=3;		//119
	display_degs[j][0] = -1280; display_degs[j][1] = 856; j+=3;		//120
	display_degs[j][0] = -1360; display_degs[j][1] = 720; j+=3;		//121
	display_degs[j][0] = -1416; display_degs[j][1] = 584; j+=3;		//122
	display_degs[j][0] = -1472; display_degs[j][1] = 440; j+=3;		//123
	display_degs[j][0] = -1472; display_degs[j][1] = 440; j+=3;		//124
	display_degs[j][0] = -1504; display_degs[j][1] = 296; j+=3;		//125
	display_degs[j][0] = -1528; display_degs[j][1] = 152; j+=3;		//126
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//127
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//128
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//129
	display_degs[j][0] = -1528; display_degs[j][1] = -152; j+=3;		//130
	display_degs[j][0] = -1504; display_degs[j][1] = -296; j+=3;		//131
	display_degs[j][0] = -1472; display_degs[j][1] = -440; j+=3;		//132
	display_degs[j][0] = -1472; display_degs[j][1] = -440; j+=3;		//133
	display_degs[j][0] = -1416; display_degs[j][1] = -584; j+=3;		//134
	display_degs[j][0] = -1360; display_degs[j][1] = -720; j+=3;		//135
	display_degs[j][0] = -1280; display_degs[j][1] = -856; j+=3;		//136
	display_degs[j][0] = -1280; display_degs[j][1] = -856; j+=3;		//137
	display_degs[j][0] = -1192; display_degs[j][1] = -976; j+=3;		//138
	display_degs[j][0] = -1088; display_degs[j][1] = -1088; j+=3;	//139
	display_degs[j][0] = -976; display_degs[j][1] = -1192; j+=3;		//140
	display_degs[j][0] = -976; display_degs[j][1] = -1192; j+=3;		//141
	display_degs[j][0] = -856; display_degs[j][1] = -1280; j+=3;		//142
	display_degs[j][0] = -720; display_degs[j][1] = -1360; j+=3;		//143
	display_degs[j][0] = -584; display_degs[j][1] = -1416; j+=3;		//144
	display_degs[j][0] = -584; display_degs[j][1] = -1416; j+=3;		//145
	display_degs[j][0] = -440; display_degs[j][1] = -1472; j+=3;		//146
	display_degs[j][0] = -296; display_degs[j][1] = -1504; j+=3;		//147
	display_degs[j][0] = -152; display_degs[j][1] = -1528; j+=3;		//148
	display_degs[j][0] = -152; display_degs[j][1] = -1528; j+=3;		//149
	display_degs[j][0] = 152; display_degs[j][1] = -1528; j+=3;		//150
	display_degs[j][0] = 296; display_degs[j][1] = -1504; j+=3;		//151
	display_degs[j][0] = 296; display_degs[j][1] = -1504; j+=3;		//152
	display_degs[j][0] = 440; display_degs[j][1] = -1472; j+=3;		//153
	display_degs[j][0] = 584; display_degs[j][1] = -1416; j+=3;		//154
	display_degs[j][0] = 720; display_degs[j][1] = -1360; j+=3;		//155
	display_degs[j][0] = 720; display_degs[j][1] = -1360; j+=3;		//156
	display_degs[j][0] = 856; display_degs[j][1] = -1280; j+=3;		//157
	display_degs[j][0] = 976; display_degs[j][1] = -1192; j+=3;		//158
	display_degs[j][0] = 1088; display_degs[j][1] = -1088; j+=3;		//159
	display_degs[j][0] = 1088; display_degs[j][1] = -1088; j+=3;		//160
	display_degs[j][0] = 1192; display_degs[j][1] = -976; j+=3;		//161
	display_degs[j][0] = 1280; display_degs[j][1] = -856; j+=3;		//162
	display_degs[j][0] = 1360; display_degs[j][1] = -720; j+=3;		//163
	display_degs[j][0] = 1360; display_degs[j][1] = -720; j+=3;		//164
	display_degs[j][0] = 1416; display_degs[j][1] = -584; j+=3;		//165
	display_degs[j][0] = 1472; display_degs[j][1] = -440; j+=3;		//166
	display_degs[j][0] = 1504; display_degs[j][1] = -296; j+=3;		//167
	display_degs[j][0] = 1504; display_degs[j][1] = -296; j+=3;		//168
	display_degs[j][0] = 1528; display_degs[j][1] = -152; j+=3;		//169
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//170
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//171
	display_degs[j][0] = 1528; display_degs[j][1] = 152; j+=3;		//172
	display_degs[j][0] = 1528; display_degs[j][1] = 152; j+=3;		//173
	display_degs[j][0] = 1504; display_degs[j][1] = 296; j+=3;		//174
	display_degs[j][0] = 1472; display_degs[j][1] = 440; j+=3;		//175
	display_degs[j][0] = 1416; display_degs[j][1] = 584; j+=3;		//176
	display_degs[j][0] = 1416; display_degs[j][1] = 584; j+=3;		//177
	display_degs[j][0] = 1360; display_degs[j][1] = 720; j+=3;		//178
	display_degs[j][0] = 1280; display_degs[j][1] = 856; j+=3;		//179
	display_degs[j][0] = 1192; display_degs[j][1] = 976; j+=3;		//180
	display_degs[j][0] = 1192; display_degs[j][1] = 976; j+=3;		//181
	display_degs[j][0] = 1088; display_degs[j][1] = 1088; j+=3;		//182
	display_degs[j][0] = 976; display_degs[j][1] = 1192; j+=3;		//183
	display_degs[j][0] = 856; display_degs[j][1] = 1280; j+=3;		//184
	display_degs[j][0] = 856; display_degs[j][1] = 1280; j+=3;		//185
	display_degs[j][0] = 720; display_degs[j][1] = 1360; j+=3;		//186
	display_degs[j][0] = 584; display_degs[j][1] = 1416; j+=3;		//187
	display_degs[j][0] = 440; display_degs[j][1] = 1472; j+=3;		//188
	display_degs[j][0] = 440; display_degs[j][1] = 1472; j+=3;		//189
	display_degs[j][0] = 296; display_degs[j][1] = 1504; j+=3;		//190
	display_degs[j][0] = 152; display_degs[j][1] = 1528; j+=3;		//191
	display_degs[j][0] = 0; display_degs[j][1] = 1536; j+=3;			//192
	display_degs[j][0] = -152; display_degs[j][1] = 1528; j+=3;		//194
	display_degs[j][0] = -296; display_degs[j][1] = 1504; j+=3;		//194
	display_degs[j][0] = -440; display_degs[j][1] = 1472; j+=3;		//195
	display_degs[j][0] = -440; display_degs[j][1] = 1472; j+=3;		//196
	display_degs[j][0] = -584; display_degs[j][1] = 1416; j+=3;		//197
	display_degs[j][0] = -720; display_degs[j][1] = 1360; j+=3;		//198
	display_degs[j][0] = -856; display_degs[j][1] = 1280; j+=3;		//199
	display_degs[j][0] = -856; display_degs[j][1] = 1280; j+=3;		//200
	display_degs[j][0] = -976; display_degs[j][1] = 1192; j+=3;		//201
	display_degs[j][0] = -1088; display_degs[j][1] = 1088; j+=3;		//202
	display_degs[j][0] = -1192; display_degs[j][1] = 976; j+=3;		//203
	display_degs[j][0] = -1192; display_degs[j][1] = 976; j+=3;		//204
	display_degs[j][0] = -1280; display_degs[j][1] = 856; j+=3;		//205
	display_degs[j][0] = -1360; display_degs[j][1] = 720; j+=3;		//206
	display_degs[j][0] = -1416; display_degs[j][1] = 584; j+=3;		//207
	display_degs[j][0] = -1416; display_degs[j][1] = 584; j+=3;		//208
	display_degs[j][0] = -1472; display_degs[j][1] = 440; j+=3;		//209
	display_degs[j][0] = -1504; display_degs[j][1] = 296; j+=3;		//210
	display_degs[j][0] = -1528; display_degs[j][1] = 152; j+=3;		//211
	display_degs[j][0] = -1528; display_degs[j][1] = 152; j+=3;		//212
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//213
	display_degs[j][0] = -1536; display_degs[j][1] = 0; j+=3;			//214
	display_degs[j][0] = -1528; display_degs[j][1] = -152; j+=3;		//215
	display_degs[j][0] = -1504; display_degs[j][1] = -296; j+=3;		//216
	display_degs[j][0] = -1504; display_degs[j][1] = -296; j+=3;		//217
	display_degs[j][0] = -1472; display_degs[j][1] = -440; j+=3;		//218
	display_degs[j][0] = -1416; display_degs[j][1] = -584; j+=3;		//219
	display_degs[j][0] = -1360; display_degs[j][1] = -720; j+=3;		//220
	display_degs[j][0] = -1360; display_degs[j][1] = -720; j+=3;		//221
	display_degs[j][0] = -1280; display_degs[j][1] = -856; j+=3;		//222
	display_degs[j][0] = -1192; display_degs[j][1] = -976; j+=3;		//223
	display_degs[j][0] = -1088; display_degs[j][1] = -1088; j+=3;	//224
	display_degs[j][0] = -1088; display_degs[j][1] = -1088; j+=3;	//225
	display_degs[j][0] = -976; display_degs[j][1] = -1192; j+=3;		//226
	display_degs[j][0] = -856; display_degs[j][1] = -1280; j+=3;		//227
	display_degs[j][0] = -720; display_degs[j][1] = -1360; j+=3;		//228
	display_degs[j][0] = -720; display_degs[j][1] = -1360; j+=3;		//229
	display_degs[j][0] = -584; display_degs[j][1] = -1416; j+=3;		//230
	display_degs[j][0] = -440; display_degs[j][1] = -1472; j+=3;		//231
	display_degs[j][0] = -296; display_degs[j][1] = -1504; j+=3;		//232
	display_degs[j][0] = -296; display_degs[j][1] = -1504; j+=3;		//233
	display_degs[j][0] = -152; display_degs[j][1] = -1528; j+=3;		//234
	display_degs[j][0] = 152; display_degs[j][1] = -1528; j+=3;		//235
	display_degs[j][0] = 152; display_degs[j][1] = -1528; j+=3;		//236
	display_degs[j][0] = 296; display_degs[j][1] = -1504; j+=3;		//237
	display_degs[j][0] = 440; display_degs[j][1] = -1472; j+=3;		//238
	display_degs[j][0] = 584; display_degs[j][1] = -1416; j+=3;		//239
	display_degs[j][0] = 584; display_degs[j][1] = -1416; j+=3;		//240
	display_degs[j][0] = 720; display_degs[j][1] = -1360; j+=3;		//241
	display_degs[j][0] = 856; display_degs[j][1] = -1280; j+=3;		//242
	display_degs[j][0] = 976; display_degs[j][1] = -1192; j+=3;		//243
	display_degs[j][0] = 976; display_degs[j][1] = -1192; j+=3;		//244
	display_degs[j][0] = 1088; display_degs[j][1] = -1088; j+=3;		//245
	display_degs[j][0] = 1192; display_degs[j][1] = -976; j+=3;		//246
	display_degs[j][0] = 1280; display_degs[j][1] = -856; j+=3;		//247
	display_degs[j][0] = 1280; display_degs[j][1] = -856; j+=3;		//248
	display_degs[j][0] = 1360; display_degs[j][1] = -720; j+=3;		//249
	display_degs[j][0] = 1416; display_degs[j][1] = -584; j+=3;		//250
	display_degs[j][0] = 1472; display_degs[j][1] = -440; j+=3;		//251
	display_degs[j][0] = 1472; display_degs[j][1] = -440; j+=3;		//252
	display_degs[j][0] = 1504; display_degs[j][1] = -296; j+=3;		//253
	display_degs[j][0] = 1528; display_degs[j][1] = -152; j+=3;		//254
	display_degs[j][0] = 1536; display_degs[j][1] = 0; j+=3;			//255


	shotspeed[  0]=7.899763f;
	shotspeed[  1]=7.883924f;
	shotspeed[  2]=7.878967f;
	shotspeed[  3]=7.875000f;
	shotspeed[  4]=7.875992f;
	shotspeed[  5]=7.883924f;
	shotspeed[  6]=7.890857f;
	shotspeed[  7]=7.910634f;
	shotspeed[  8]=7.938238f;
	shotspeed[  9]=7.954951f;
	shotspeed[ 10]=7.871031f;
	shotspeed[ 11]=7.893826f;
	shotspeed[ 12]=7.945124f;
	shotspeed[ 13]=7.852149f;
	shotspeed[ 14]=7.915570f;
	shotspeed[ 15]=7.950039f;
	shotspeed[ 16]=7.905694f;
	shotspeed[ 17]=7.946107f;
	shotspeed[ 18]=7.915570f;
	shotspeed[ 19]=7.846178f;
	shotspeed[ 20]=7.894816f;
	shotspeed[ 21]=7.883924f;
	shotspeed[ 22]=7.826238f;
	shotspeed[ 23]=7.941190f;
	shotspeed[ 24]=7.891847f;
	shotspeed[ 25]=7.846178f;
	shotspeed[ 26]=7.871031f;
	shotspeed[ 27]=7.939222f;
	shotspeed[ 28]=7.905694f;
	shotspeed[ 29]=7.950039f;
	shotspeed[ 30]=7.926419f;
	shotspeed[ 31]=7.906682f;
	shotspeed[ 32]=7.890857f;
	shotspeed[ 33]=7.878967f;
	shotspeed[ 34]=7.956915f;
	shotspeed[ 35]=7.954951f;
	shotspeed[ 36]=7.956915f;
	shotspeed[ 37]=7.878967f;
	shotspeed[ 38]=7.890857f;
	shotspeed[ 39]=7.906682f;
	shotspeed[ 40]=7.926419f;
	shotspeed[ 41]=7.950039f;
	shotspeed[ 42]=7.905694f;
	shotspeed[ 43]=7.939222f;
	shotspeed[ 44]=7.871031f;
	shotspeed[ 45]=7.846178f;
	shotspeed[ 46]=7.891847f;
	shotspeed[ 47]=7.941190f;
	shotspeed[ 48]=7.826238f;
	shotspeed[ 49]=7.883924f;
	shotspeed[ 50]=7.894816f;
	shotspeed[ 51]=7.846178f;
	shotspeed[ 52]=7.915570f;
	shotspeed[ 53]=7.946107f;
	shotspeed[ 54]=7.905694f;
	shotspeed[ 55]=7.950039f;
	shotspeed[ 56]=7.915570f;
	shotspeed[ 57]=7.852149f;
	shotspeed[ 58]=7.945124f;
	shotspeed[ 59]=7.893826f;
	shotspeed[ 60]=7.871031f;
	shotspeed[ 61]=7.954951f;
	shotspeed[ 62]=7.938238f;
	shotspeed[ 63]=7.910634f;
	shotspeed[ 64]=7.890857f;
	shotspeed[ 65]=7.883924f;
	shotspeed[ 66]=7.875992f;
	shotspeed[ 67]=7.875000f;
	shotspeed[ 68]=7.878967f;
	shotspeed[ 69]=7.883924f;
	shotspeed[ 70]=7.899763f;
	shotspeed[ 71]=7.910634f;
	shotspeed[ 72]=7.938238f;
	shotspeed[ 73]=7.973589f;
	shotspeed[ 74]=7.871031f;
	shotspeed[ 75]=7.918530f;
	shotspeed[ 76]=7.945124f;
	shotspeed[ 77]=7.882933f;
	shotspeed[ 78]=7.915570f;
	shotspeed[ 79]=7.986316f;
	shotspeed[ 80]=7.905694f;
	shotspeed[ 81]=7.988273f;
	shotspeed[ 82]=7.915570f;
	shotspeed[ 83]=7.894816f;
	shotspeed[ 84]=7.945124f;
	shotspeed[ 85]=7.883924f;
	shotspeed[ 86]=7.882933f;
	shotspeed[ 87]=7.941190f;
	shotspeed[ 88]=7.953969f;
	shotspeed[ 89]=7.910634f;
	shotspeed[ 90]=7.871031f;
	shotspeed[ 91]=8.008784f;
	shotspeed[ 92]=7.977508f;
	shotspeed[ 93]=7.950039f;
	shotspeed[ 94]=7.926419f;
	shotspeed[ 95]=7.986316f;
	shotspeed[ 96]=7.972610f;
	shotspeed[ 97]=7.962804f;
	shotspeed[ 98]=7.956915f;
	shotspeed[ 99]=7.954951f;
	shotspeed[100]=7.956915f;
	shotspeed[101]=7.878967f;
	shotspeed[102]=7.890857f;
	shotspeed[103]=7.906682f;
	shotspeed[104]=7.926419f;
	shotspeed[105]=7.950039f;
	shotspeed[106]=7.905694f;
	shotspeed[107]=7.939222f;
	shotspeed[108]=7.976528f;
	shotspeed[109]=7.953969f;
	shotspeed[110]=8.000977f;
	shotspeed[111]=7.941190f;
	shotspeed[112]=7.938238f;
	shotspeed[113]=7.997070f;
	shotspeed[114]=7.894816f;
	shotspeed[115]=7.961823f;
	shotspeed[116]=7.915570f;
	shotspeed[117]=7.946107f;
	shotspeed[118]=8.024377f;
	shotspeed[119]=7.950039f;
	shotspeed[120]=7.915570f;
	shotspeed[121]=7.973589f;
	shotspeed[122]=7.945124f;
	shotspeed[123]=8.016584f;
	shotspeed[124]=7.994138f;
	shotspeed[125]=7.954951f;
	shotspeed[126]=7.938238f;
	shotspeed[127]=7.910634f;
	shotspeed[128]=8.015610f;
	shotspeed[129]=8.008784f;
	shotspeed[130]=8.000977f;
	shotspeed[131]=8.000000f;
	shotspeed[132]=8.003905f;
	shotspeed[133]=8.008784f;
	shotspeed[134]=8.024377f;
	shotspeed[135]=7.910634f;
	shotspeed[136]=7.938238f;
	shotspeed[137]=7.973589f;
	shotspeed[138]=7.994138f;
	shotspeed[139]=8.040911f;
	shotspeed[140]=7.945124f;
	shotspeed[141]=8.003905f;
	shotspeed[142]=7.915570f;
	shotspeed[143]=7.986316f;
	shotspeed[144]=8.024377f;
	shotspeed[145]=7.988273f;
	shotspeed[146]=7.915570f;
	shotspeed[147]=8.009760f;
	shotspeed[148]=7.945124f;
	shotspeed[149]=7.997070f;
	shotspeed[150]=7.994138f;
	shotspeed[151]=7.941190f;
	shotspeed[152]=8.062258f;
	shotspeed[153]=8.017559f;
	shotspeed[154]=7.976528f;
	shotspeed[155]=8.008784f;
	shotspeed[156]=7.977508f;
	shotspeed[157]=7.950039f;
	shotspeed[158]=7.926419f;
	shotspeed[159]=7.986316f;
	shotspeed[160]=7.972610f;
	shotspeed[161]=7.962804f;
	shotspeed[162]=7.956915f;
	shotspeed[163]=7.954951f;
	shotspeed[164]=7.956915f;
	shotspeed[165]=7.962804f;
	shotspeed[166]=7.972610f;
	shotspeed[167]=7.986316f;
	shotspeed[168]=7.926419f;
	shotspeed[169]=7.950039f;
	shotspeed[170]=7.977508f;
	shotspeed[171]=8.008784f;
	shotspeed[172]=7.976528f;
	shotspeed[173]=8.017559f;
	shotspeed[174]=8.062258f;
	shotspeed[175]=7.941190f;
	shotspeed[176]=7.994138f;
	shotspeed[177]=7.997070f;
	shotspeed[178]=7.945124f;
	shotspeed[179]=8.009760f;
	shotspeed[180]=7.915570f;
	shotspeed[181]=7.988273f;
	shotspeed[182]=8.024377f;
	shotspeed[183]=7.986316f;
	shotspeed[184]=7.915570f;
	shotspeed[185]=8.003905f;
	shotspeed[186]=7.945124f;
	shotspeed[187]=8.040911f;
	shotspeed[188]=7.994138f;
	shotspeed[189]=7.973589f;
	shotspeed[190]=7.938238f;
	shotspeed[191]=7.910634f;
	shotspeed[192]=8.024377f;
	shotspeed[193]=8.008784f;
	shotspeed[194]=8.003905f;
	shotspeed[195]=8.000000f;
	shotspeed[196]=8.000977f;
	shotspeed[197]=8.008784f;
	shotspeed[198]=8.015610f;
	shotspeed[199]=7.910634f;
	shotspeed[200]=7.938238f;
	shotspeed[201]=7.954951f;
	shotspeed[202]=7.994138f;
	shotspeed[203]=8.016584f;
	shotspeed[204]=7.945124f;
	shotspeed[205]=7.973589f;
	shotspeed[206]=7.915570f;
	shotspeed[207]=7.950039f;
	shotspeed[208]=8.024377f;
	shotspeed[209]=7.946107f;
	shotspeed[210]=7.915570f;
	shotspeed[211]=7.961823f;
	shotspeed[212]=7.894816f;
	shotspeed[213]=7.997070f;
	shotspeed[214]=7.938238f;
	shotspeed[215]=7.941190f;
	shotspeed[216]=8.000977f;
	shotspeed[217]=7.953969f;
	shotspeed[218]=7.976528f;
	shotspeed[219]=7.939222f;
	shotspeed[220]=7.905694f;
	shotspeed[221]=7.950039f;
	shotspeed[222]=7.926419f;
	shotspeed[223]=7.906682f;
	shotspeed[224]=7.890857f;
	shotspeed[225]=7.878967f;
	shotspeed[226]=7.956915f;
	shotspeed[227]=7.954951f;
	shotspeed[228]=7.956915f;
	shotspeed[229]=7.962804f;
	shotspeed[230]=7.972610f;
	shotspeed[231]=7.986316f;
	shotspeed[232]=7.926419f;
	shotspeed[233]=7.950039f;
	shotspeed[234]=7.977508f;
	shotspeed[235]=8.008784f;
	shotspeed[236]=7.871031f;
	shotspeed[237]=7.910634f;
	shotspeed[238]=7.953969f;
	shotspeed[239]=7.941190f;
	shotspeed[240]=7.882933f;
	shotspeed[241]=7.883924f;
	shotspeed[242]=7.945124f;
	shotspeed[243]=7.894816f;
	shotspeed[244]=7.915570f;
	shotspeed[245]=7.988273f;
	shotspeed[246]=7.905694f;
	shotspeed[247]=7.986316f;
	shotspeed[248]=7.915570f;
	shotspeed[249]=7.882933f;
	shotspeed[250]=7.945124f;
	shotspeed[251]=7.918530f;
	shotspeed[252]=7.871031f;
	shotspeed[253]=7.973589f;
	shotspeed[254]=7.938238f;
	shotspeed[255]=7.910634f;

}		

