// game.h: Beispielspieler fr Asteroids
// Matthias Fuchs
// Original: Harald Bgeholz / c't
#ifndef GAME_H
#define GAME_H

#include "eigen/vector.h"

#include "connection.h"
#include "interfaceplayer.h"

class GameObject
{
  public:
   Eigen::Vector2d x;           // current center coordinates

   Eigen::Vector2d x0;
   int dt;                      /* time in frames since passing of x0 */

   Eigen::Vector2d v;           // velocity per frame wrt x,y

   Eigen::Vector2d x_rel;       // coordinates wrt ship

   Eigen::Vector2d v_rel;       // velocity per frame wrt ship

   double dist;
   int    radius;
   double collisionTime;

   double aimAngle;             /* shooting direction */
   double deltaAimAngle;        /* shooting direction tollerance*/
   double impactTime;

   int impactCountdown;

   GameObject(void);            /* ctor */
};

class Asteroid : public GameObject
{
  public:
   int type;      // 1 ... 4, uere Form
   int sf;        // scale factor: 0 = gro, 15 = mittel, 14 = klein
   int points;    // Punkte fr Abschu

   void set(int x, int y, int type, int sf);
};

class Shot : public GameObject
{
  public:
   void set(int x, int y);
};

class Saucer : public GameObject
{
  public:
   int size;      // Gre: 15 = gro, 14 = klein, 0 = nicht sichtbar
   int points;    // Punkte fr Abschu

   bool IsPresent(void) const;
   void set(int x, int y, int size);
};

class Ship : public GameObject
{
  public:
   Eigen::Vector2d view;     // Blickrichtung des Schiffes
   bool present;             // Schiff sichtbar

   bool IsPresent (void) const;
   void set(int x, int y, int viewx, int viewy);
};


class GameStatus
{
  private:
   static const int MAX_ASTEROIDS = 30;
   static const int MAX_SHOTS     = 6;

  public:
   Ship     ship;               // Schiff
   Saucer   saucer;             // UFO
   int      nasteroids;         // Anzahl Asteroiden
   Asteroid asteroids[MAX_ASTEROIDS];
   int      nshots;             // Anzahl Schsse
   Shot     shots[MAX_SHOTS];
   unsigned int t;         // Anzahl Durchlufe
   unsigned int frameno;   // aktuelle Framezahl; ohne Frameverlust == t
   unsigned int score;     // erreichte Punktzahl

   GameStatus(void);
   void clear(void);
   void RelCoordinates(GameObject& obj) const;
};

class Game
{
  public:
   inline Game(Connection& con, InterfacePlayer &pl);

   void Run(void);

  protected:
   void InterpretScreen(
      const FramePacket& packet, GameStatus& game);

  private:
   Connection&      connection;
   InterfacePlayer& player;
};


inline Game::Game(Connection &con, InterfacePlayer &pl)
:  connection(con),
   player(pl)
{}

#endif
