// player.h: Bot fr Asteroids
// Arne Binder (Harald Bgeholz / c't)

#define ADDRESS DWORD

#define SENDNAME
#define SILENT

#define MAX_INT 0x7fffffff
#define MAX_X 1024
#define MAX_Y 768

// Spieleigenschaften
static const char   MAGICBYTES[]    = {'c', 't', 'm', 'a', 'm', 'e'};
static const char   MAGICBNAME[]    = {'c', 't', 'n', 'a', 'm', 'e'};
static const wchar_t *MYNAME        = L"Arne Binder";

static const int    FRAMERATE       = 60;    // Framerate fr Zeitberechnung
static const int    GAMETIME        = 300;   // Spielzeit in s
static const int    TIMEADVANCE     = 1;     // Korrekturwert nat. Latenzzeit
static const int    MEANLATENCY     = 16;    // Mittelwert Latenz Speichertiefe

static const int    MAX_OBJECTS     = 32;    // Max. Objektanzahl
static const int    MAX_ASTEROIDS   = 26;    // Max. Asteroidanzahl
static const int    MAX_SHOTS       =  6;    // Max. Schussanzahl
static const int    MAX_SHOTEVENTS  = 24;    // Max. Treffer

static const double SHOTSPEED       = 8*8;   // Initialgeschwindigkeit Schsse
static const double SHOTTTL         = 70;    // Max. Reichweite Schsse

// Objektradien - real & zielen
static const int    SZ_ASMALL[]     = { 8,  6}; // kleiner Asteroid
static const int    SZ_AMEDIUM[]    = {16, 12}; // mittlerer Asteroid
static const int    SZ_ALARGE[]     = {32, 26}; // groer Aseroid
static const int    SZ_SSMALL[]     = {10,  8}; // kleines Ufo
static const int    SZ_SMEDIUM[]    = {20, 18}; // groes Ufo

static const int    SHIPVLEN[17]    =        // Blickvektorlngen Schiff
{
   0,  19,  37,  55,  73,  90, 107, 122,
 136, 149, 160, 170, 177, 184, 188, 191,
 192
};
static const int    SHIPDIR[256]    =        // Blickrichtungen Schiff
{
 0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
 4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
 8,  8,  8,  8,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 11,
12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15,
16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20,
20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24,
24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28,
28, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32,
32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35,
36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 39,
40, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43,
44, 44, 44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47,
48, 49, 49, 49, 49, 50, 50, 50, 50, 51, 51, 51, 51, 52, 52, 52,
52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, 55, 55, 56, 56, 56,
56, 57, 57, 57, 57, 58, 58, 58, 58, 59, 59, 59, 59, 60, 60, 60,
60, 61, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63,  0,  0,  0
};
static const double SHOTDIR[256]    =        // Schussrichtungen Schiff
{
0.000000, 0.015872, 0.047583, 0.063407, 0.094952, 0.126308, 0.141897, 0.175592,
0.191184, 0.222082, 0.241118, 0.271792, 0.286939, 0.321751, 0.336675, 0.371709,
0.392340, 0.406971, 0.442374, 0.463648, 0.491809, 0.513252, 0.534955, 0.570383,
0.583636, 0.605545, 0.640356, 0.662426, 0.684617, 0.706908, 0.729277, 0.763180,
0.785398, 0.807617, 0.841519, 0.863888, 0.886179, 0.908370, 0.930440, 0.965252,
0.987161, 1.000413, 1.035841, 1.057544, 1.078987, 1.107149, 1.128422, 1.163826,
1.178456, 1.199087, 1.234122, 1.249046, 1.283858, 1.299004, 1.329679, 1.348714,
1.379612, 1.395204, 1.428899, 1.444488, 1.475845, 1.507389, 1.523213, 1.554925,
1.570796, 1.602532, 1.618379, 1.649995, 1.665748, 1.697104, 1.728213, 1.746388,
1.777480, 1.792878, 1.827313, 1.842588, 1.872747, 1.892547, 1.922241, 1.942505,
1.977767, 1.992216, 2.013171, 2.048627, 2.062606, 2.097740, 2.119346, 2.141180,
2.167457, 2.189224, 2.211153, 2.233223, 2.267539, 2.289626, 2.311779, 2.333976,
2.356194, 2.378413, 2.412315, 2.434685, 2.456975, 2.479166, 2.501236, 2.536048,
2.557957, 2.579671, 2.614649, 2.636012, 2.649783, 2.684987, 2.705910, 2.734622,
2.755255, 2.769884, 2.804918, 2.824768, 2.854654, 2.869800, 2.904218, 2.919511,
2.953371, 2.968732, 2.999696, 3.015285, 3.046641, 3.079174, 3.094752, 3.125969,
3.141593, 3.172832, 3.188433, 3.219559, 3.236544, 3.267901, 3.299010, 3.314453,
3.345086, 3.363675, 3.394147, 3.413385, 3.443544, 3.458417, 3.493037, 3.513302,
3.542386, 3.563012, 3.577276, 3.612233, 3.633402, 3.660739, 3.682012, 3.703514,
3.738253, 3.760021, 3.781949, 3.804019, 3.838335, 3.860423, 3.882576, 3.904772,
3.926991, 3.949209, 3.971406, 3.993559, 4.015647, 4.049963, 4.072033, 4.093961,
4.115729, 4.150467, 4.171969, 4.193243, 4.220580, 4.241748, 4.276706, 4.290970,
4.311596, 4.340680, 4.360944, 4.395564, 4.410438, 4.440597, 4.459835, 4.490307,
4.508896, 4.539528, 4.554972, 4.586081, 4.617437, 4.634422, 4.665548, 4.681149,
4.712389, 4.728013, 4.759230, 4.774808, 4.807341, 4.838697, 4.854286, 4.885250,
4.900610, 4.934471, 4.949763, 4.984181, 4.999328, 5.029213, 5.049064, 5.084098,
5.098726, 5.119360, 5.148072, 5.168994, 5.204198, 5.217970, 5.239332, 5.274311,
5.296025, 5.317934, 5.352745, 5.374815, 5.397006, 5.419297, 5.441666, 5.475569,
5.497787, 5.520006, 5.542202, 5.564355, 5.586443, 5.620759, 5.642829, 5.664757,
5.686525, 5.712802, 5.734636, 5.756242, 5.791376, 5.805354, 5.840811, 5.861766,
5.876215, 5.911476, 5.931741, 5.961435, 5.981234, 6.011393, 6.026669, 6.061103,
6.076502, 6.107593, 6.125768, 6.156877, 6.188234, 6.203986, 6.235602, 6.251450,
};

// Objekterkennung
static const int    OBJ_CATCH_AS    = 6*6;   // Fang fr Asteroiden (tracking)
static const int    OBJ_CATCH_SH    = 12*12; // Fang fr Schsse (tracking)
static const int    OBJ_MEANSPEED   = 8;     // Mittelwert Geschw. Speichertiefe
static const int    SHP_HSTSIZE     = 16;    // Speicher fr Winkelerkennung
static const int    SHP_MAXCORR     = 2;     // Maximale Abweichung Winkelerkennung

// KI Parameter
static const int    KI_SECDIST      = 30*30; // Sicherheitsabstand Asteroiden
static const int    KI_SECDIST_CA   = 32*32; // Collision avoidance
static const int    KI_SPEED_NORM   = 0;     // Sollgeschwindigkeit normal
static const int    KI_SPEED_SAUC   = 0;     // Sollgeschwindigkeit mit UFO

static const int    KI_WEIGHT_DIST  = 1;     // Gewichtung Distanz
static const int    KI_WEIGHT_ANGLE = 1;     // Gewichtung Winkel
static const int    KI_PROXIMITY_SM = 80;    // CA Trigger (Zeit) kleine Asteroiden
static const int    KI_PROXIMITY_ME = 100;   // CA Trigger (Zeit) mittlere Asteroiden
static const int    KI_PROXIMITY_LA = 120;   // CA Trigger (Zeit) groe Asteroiden

static const double KI_OMEGA_MIN    = .0008; // Mindestwinkelgeschwindigkeit
static const double KI_OMEGA_WEIGHT = 2;     // Bonus fr nhernde (Winkel)
static const int    KI_FIRE_SMALL   = 1;     // Schsse kleine Obj.
static const int    KI_FIRE_MEDIUM  = 2;     // Schsse mittlere Obj.
static const int    KI_FIRE_LARGE   = 3;     // Schsse groe Obj.

class Asteroid
{
public:
	int x;         // Koordinaten des Mittelpunkts
	int y;
	int type;      // 1 ... 4, uere Form
	int sf;        // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x, y;      // Koordinaten

	void set(int x, int y);
};

class GObject
{
public:
	int x, y;      // Koordinaten
	int sx, sy;    // Geschwindigkeit
	int sxm[OBJ_MEANSPEED];
  int sym[OBJ_MEANSPEED];
	int type;      // 0 (Sonstige), 1 ... 4 (Asteroiden)
	int radius[2]; // Radius
	double omega;  // Winkelgeschwindigkeit
	int sf;        // scale factor: 0 = gro, 15 = mittel, 14 = klein
  int age;       // Alter

  int shot;      // Schuss abgegeben (Zeitpunkt)
  int nshots;    // Amzahl abgegebener Schsse
  bool aim;      // wurde anvisiert
  bool hit;      // wird getroffen

	void set(int x, int y, int type, const int *r, int sf, int sx=0, int sy=0, GObject *parent=NULL);
};

class Target
{
public:
	int x, y;      // Koordinaten
	double angle;  // Winkel (Absolut)
	int adist;     // Entfernung (Absolut & korrigiert)
	int dist;      // Entfernung^2 (Vorbeiflug & korrigiert)
	int time;      // Zeitpunkt (Vorbeiflug)
	GObject *link; // Zugehriges Objekt

	int getpts (double ship_angle);
	void set(int x, int y, double angle, int adist, int dist, int time, GObject *link);
};

struct FramePacket;

class GameStatus
{
private:
 	char LOOKUP_SD[255]; // Lookup-Tabelle Blickrichtungen Schiff
 	
 	void mvHst(int n);   // Drehwinkel Korrektur

public:
	int score;           // Punkte
	int lives;           // Leben
	bool ship_present;   // Schiff sichtbar
	int ship_x;          // Mittelpunkt des Schiffs
	int ship_y;
	int ship_angle;      // Blickrichtung des Schiffes (0-64) 0=rechts
	bool saucer_present; // UFO sichtbar
	int saucer_x;        // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;     // Gre: 15 = gro, 14 = klein
	int nasteroids;      // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;          // Anzahl Schsse
	Shot shots[MAX_SHOTS];
  int score_old;       // Score voriger Frame
  int score_of;        // Score berlauf
  int score_fin;       // Score nach Spielzeit
  // Netzwerk
  int frame_count;     // Zeit (in Frames)
  int frame_lost;      // Frameloss
  int latency;         // Latenz
  int avg_latency;     // Mittelwert Latenz
	
	// Schusswinkel Korrektur
  unsigned char ShotAngle;                  // Letzter Schusswinkel
	unsigned char HstPtr;                     // Pointer Ringspeicher
  unsigned char HstShipAngle[SHP_HSTSIZE];  // Winkel
	unsigned char HstShotAngle[SHP_HSTSIZE];  // Drehungen

  int HstLatency[MEANLATENCY];              // Latenz

  GameStatus();
	void new_game();
	void CalcLatency();
	void SyncShipAngle();
	void InterpretScreen(FramePacket &packet);
	void clear();
};

class GameObjects
{
public:
  int ndests;         // Anzahl Zielobjekte
  GObject dests[MAX_ASTEROIDS];
  int nshots;         // Anzahl Schsse
  GObject shots[MAX_SHOTS];
  GObject ship;

  GameObjects() { clear(); };
  GameObjects(GameStatus& game, GameObjects& obj, int dt);
	void DetectHit();
	void clear();
};

class GameTargets
{
public:
  int ntargets;       // Anzahl Ziele
  Target targets[MAX_OBJECTS];

  GameTargets() { clear(); };
	GameTargets(GameObjects& obj, int latency);
	void clear();
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 0x01;
	static const char KEY_FIRE       = 0x02;
	static const char KEY_THRUST     = 0x04;
	static const char KEY_RIGHT      = 0x08;
	static const char KEY_LEFT       = 0x10;
  // Patch
	static const char KEY_START      = 0x20;

	char signature[6];
	char keys;

public:
	char ping;                // Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};

class NamePacket
{
private:
	char signature[6];
	char name[32];

public:
	NamePacket(void);
	void setname(const wchar_t *name);         // Name setzen
};
#pragma pack()

class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run();
	void PrintStatus();
  void ReceivePacket(FramePacket &packet);
	void SendPacket(void *packet, int size);
	//void SendPacket(NamePacket &packet);

private:
	SOCKET sd;
	ADDRESS server_ip;
	KeysPacket keys;
	NamePacket name;

  GameStatus *game;
  GameObjects *obj;
	GameTargets *targets;

  int seltarget;   // Gewhltes Ziel
  int max_pts;     // Punkte fr Ziel
};
