#using <System.Windows.Forms.dll>
#using <System.Drawing.dll>
#using <System.dll>

#include <cmath>
// sampleclient
#include <cstdio>
#include <cstdlib>
#include <cerrno>
#include <cstring>

#include <winsock2.h>
#include "player2.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Drawing;
using namespace System::Windows::Forms;
using namespace System::Threading;

namespace AsteroidsAutopilot
{
	public ref class Player2
	{
	public:
		int SchiffPositionX;
		int SchiffPositionY;
		int SchiffRichtungX;
		int SchiffRichtungY;
		int SchiffRichtungWeitX;
		int SchiffRichtungWeitY;
		int SchiffRichtungIndex;
		bool KalibrierungAngefordert;
		bool SchiffRichtungKalibrieren;
		bool SchiffRichtungBraucheKalibrierfeuer;
		int KalibrierschussAnzahl;
		int KalibrierEndeZaehler;
		int SchiffRichtungKalibrierfeuerX;
		int SchiffRichtungKalibrierfeuerY;
		int ObjektSchussSchnittpunktX, ObjektSchussSchnittpunktY;
		int tmp_v1x, tmp_v1y, tmp_dx, tmp_dy;
		double WinkelRadZuObjekt, WinkelRadZuObjekt1, WinkelRadZuObjekt2;
		int FeuerStrategie;
		bool StopThread;
		bool SendeLinks;
		bool SendeRechts;
		bool SendeBeschleunigung;
		bool SendeFeuer;
		bool SendeHyperspace;
		bool SteuerungAutomatik;
		bool Dauerfeuer;
		double Pi;
		int ZielObjektID;
		bool UFOLetztesFrame;
		bool UFODiesesFrame;
		bool SchussLetztesFrame;
		bool SchussDiesesFrame;

		static array<double>^ SchiffRichtungWinkelListe = { 0, 3.6, 8.2, 12.7, 16.5, 21.2, 25.2, 29.5, 33.5, 37.8, 41.7, 46.2, 50.8, 55.3, 59.4, 63.4, 67.5, 71.6, 76.1, 79.9, 84.5, 89.1, 92.8, 97.2, 101.8, 105.5, 110.2, 114.1, 118.1, 122.8, 126.7, 131.1, 135, 139.4, 143.3, 147.9, 151.9, 156.6, 160.7, 164.5, 169.2, 172.8, 177.3, 181.9, 185.5, 189.9, 194.5, 198.2, 203, 206.9, 211, 215.4, 220, 223.8, 227.5, 232.2, 235.9, 240.3, 245.1, 248.8, 252.7, 257.3, 261.1, 265.6, 270, 273.6, 278.2, 282.7, 286.5, 291.2, 295, 299, 303.5, 307.8, 311.7, 316.2, 320, 324.5, 328.6, 332.7, 336.6, 341.6, 345.3, 349.9, 354.5, 358.1, 2.8, 7.2, 11, 15.5, 19.3, 23.4, 28.1, 32.8, 36.7, 40.6, 45, 49.4, 53.3, 57.2, 61.9, 66.6, 70.7, 74.5, 79, 82.8, 87.2, 91.9, 95.5, 100.1, 104.7, 108.4, 113.4, 117.3, 121.4, 125.6, 130, 133.8, 138.3, 142.2, 146.5, 151, 155, 158.8, 163.6, 167.3, 171.8, 176.6, 180, 184.4, 188.9, 192.7, 197.3, 201.2, 205, 209.7, 214.2, 217.8, 222.5, 226.2, 230, 234.6, 239, 243.1, 247, 251.8, 255.5, 260.1, 264.5, 268.1, 272.7, 277.2, 280.8, 285.5, 289.3, 293.4, 298.1, 302.2, 306.7, 310.6, 315, 318.9, 323.3, 327.2, 331.9, 335.9, 339.8, 344.5, 348.2, 352.8, 357.2, 0.9, 5.5, 10.1, 13.9, 18.4, 22.5, 26.6, 30.6, 34.7, 39.2, 43.8, 48.3, 52.2, 56.5, 60.5, 64.7, 68.8, 73.5, 77.3, 81.8, 86.4, 90, 94.5, 98.9, 102.7, 107.3, 111.2, 115.3, 120.2, 124.2, 127.8, 132.5, 136.1, 140.8, 145.3, 149.8, 153.9, 157.9, 161.8, 166.3, 170.1, 174.3, 179.1, 182.9, 187.2, 191.5, 195.6, 200.3, 204.1, 208.1, 212.1, 216.6, 221, 225, 228.9, 233.3, 237.8, 241.9, 245.9, 249.8, 254.5, 258.4, 262.8, 267.3, 270.9, 275.5, 279.9, 283.7, 288.2, 292.1, 296.1, 300.2, 304.7, 309.2, 313.8, 317.5, 322.2, 325.8, 329.8, 334.7, 338.8, 342.7, 347.2, 351.1, 355.5 };
		//static array<double>^ SchiffRichtungWinkelRadListe = { 0, 3.6, 8.2, 12.7, 16.5, 21.2, 25.2, 29.5, 33.5, 37.8, 41.7, 46.2, 50.8, 55.3, 59.4, 63.4, 67.5, 71.6, 76.1, 79.9, 84.5, 89.1, 92.8, 97.2, 101.8, 105.5, 110.2, 114.1, 118.1, 122.8, 126.7, 131.1, 135, 139.4, 143.3, 147.9, 151.9, 156.6, 160.7, 164.5, 169.2, 172.8, 177.3, 181.9, 185.5, 189.9, 194.5, 198.2, 203, 206.9, 211, 215.4, 220, 223.8, 227.5, 232.2, 235.9, 240.3, 245.1, 248.8, 252.7, 257.3, 261.1, 265.6, 270, 273.6, 278.2, 282.7, 286.5, 291.2, 295, 299, 303.5, 307.8, 311.7, 316.2, 320, 324.5, 328.6, 332.7, 336.6, 341.6, 345.3, 349.9, 354.5, 358.1, 2.8, 7.2, 11, 15.5, 19.3, 23.4, 28.1, 32.8, 36.7, 40.6, 45, 49.4, 53.3, 57.2, 61.9, 66.6, 70.7, 74.5, 79, 82.8, 87.2, 91.9, 95.5, 100.1, 104.7, 108.4, 113.4, 117.3, 121.4, 125.6, 130, 133.8, 138.3, 142.2, 146.5, 151, 155, 158.8, 163.6, 167.3, 171.8, 176.6, 180, 184.4, 188.9, 192.7, 197.3, 201.2, 205, 209.7, 214.2, 217.8, 222.5, 226.2, 230, 234.6, 239, 243.1, 247, 251.8, 255.5, 260.1, 264.5, 268.1, 272.7, 277.2, 280.8, 285.5, 289.3, 293.4, 298.1, 302.2, 306.7, 310.6, 315, 318.9, 323.3, 327.2, 331.9, 335.9, 339.8, 344.5, 348.2, 352.8, 357.2, 0.9, 5.5, 10.1, 13.9, 18.4, 22.5, 26.6, 30.6, 34.7, 39.2, 43.8, 48.3, 52.2, 56.5, 60.5, 64.7, 68.8, 73.5, 77.3, 81.8, 86.4, 90, 94.5, 98.9, 102.7, 107.3, 111.2, 115.3, 120.2, 124.2, 127.8, 132.5, 136.1, 140.8, 145.3, 149.8, 153.9, 157.9, 161.8, 166.3, 170.1, 174.3, 179.1, 182.9, 187.2, 191.5, 195.6, 200.3, 204.1, 208.1, 212.1, 216.6, 221, 225, 228.9, 233.3, 237.8, 241.9, 245.9, 249.8, 254.5, 258.4, 262.8, 267.3, 270.9, 275.5, 279.9, 283.7, 288.2, 292.1, 296.1, 300.2, 304.7, 309.2, 313.8, 317.5, 322.2, 325.8, 329.8, 334.7, 338.8, 342.7, 347.2, 351.1, 355.5 };
		static array<double>^ SchiffRichtungWinkelRadListe = gcnew array<double>(SchiffRichtungWinkelListe->Length);

		static const int LATENZPAKETE = 1000;
		static array<bool>^ LatenzSyncLinksListe = gcnew array<bool>(LATENZPAKETE); // gesendete taste rechts links abspeichen
		static array<int>^ LatenzSyncPaketListe = gcnew array<int>(LATENZPAKETE); // gesendete taste rechts links abspeichen

		static const int MAX_RADAROBJEKTE = 200;
		static array<int>^ ObjektRadar = gcnew array<int>(MAX_RADAROBJEKTE); // 1. Asteroid, 2. Ufo, 3. Schuss
		static array<int>^ ObjektRadarX = gcnew array<int>(MAX_RADAROBJEKTE);
		static array<int>^ ObjektRadarY = gcnew array<int>(MAX_RADAROBJEKTE);
		static array<int>^ ObjektRadarTyp = gcnew array<int>(MAX_RADAROBJEKTE); // Zeichnungstyp des Asteroids 1...4
		static array<int>^ ObjektRadarSkalierung = gcnew array<int>(MAX_RADAROBJEKTE); // Asteroid 0 = gro, 15 = mittel, 14 = klein
		int ObjektRadarElement;

		// Die Objektspeicher enthalten die Reihenfolge der Objekte (Asteroiden, Ufos, Explosionen),
		// wie sie aus dem Vektor-RAM kommen. Die 0 markiert einen freien Platz im Array. Eine 
		// Explosion wird als 99 reprsentiert. Diese Arrays werden fr das Objekttracking ber n-Frames verwendet.
		static const int MAX_OBJEKTE = 55; // NOCH NICHT SAUBER - Siehe ObjektTracking (PushObjektSpeicher)
		static array<int>^ Objektspeicher00 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher00Info = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher01 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher02 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher03 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher04 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher05 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher06 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher07 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher08 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher09 = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher10 = gcnew array<int>(MAX_OBJEKTE);
		int Objektspeicher00Zaehler;
		int Objektspeicher00Anzahl;
		int Objektspeicher01Anzahl;
		int Objektspeicher02Anzahl;
		int Objektspeicher03Anzahl;
		int Objektspeicher04Anzahl;
		int Objektspeicher05Anzahl;
		int Objektspeicher06Anzahl;
		int Objektspeicher07Anzahl;
		int Objektspeicher08Anzahl;
		int Objektspeicher09Anzahl;
		int Objektspeicher10Anzahl;
		// Koordinaten der Objekte ber die letzten 5 Frames
		static array<int>^ Objektspeicher00_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher00_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher01_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher01_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher02_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher02_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher03_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher03_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher04_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher04_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher05_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher05_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher06_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher06_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher07_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher07_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher08_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher08_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher09_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher09_Y = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher10_X = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher10_Y = gcnew array<int>(MAX_OBJEKTE);
		// Geschwindigkeitskomponenten der Objekte ber 5 Frames - Pixel pro Frame (PPF)
		static array<float>^ ObjektPPF_X = gcnew array<float>(MAX_OBJEKTE);
		static array<float>^ ObjektPPF_Y = gcnew array<float>(MAX_OBJEKTE);

		static array<int>^ Objektspeicher00_Groesse = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher00_Typ = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher01_Groesse = gcnew array<int>(MAX_OBJEKTE);
		static array<int>^ Objektspeicher01_Typ = gcnew array<int>(MAX_OBJEKTE);


		static const int MAX_SCHUESSE = 7;
		static array<int>^ SchussSpeicher00 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher00Info = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher01 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher02 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher03 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher04 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher05 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher06 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher07 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher08 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher09 = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher10 = gcnew array<int>(MAX_SCHUESSE);
		int SchussSpeicher00Zaehler;
		int SchussSpeicher00Anzahl;
		int SchussSpeicher01Anzahl;
		int SchussSpeicher02Anzahl;
		int SchussSpeicher03Anzahl;
		int SchussSpeicher04Anzahl;
		int SchussSpeicher05Anzahl;
		int SchussSpeicher06Anzahl;
		int SchussSpeicher07Anzahl;
		int SchussSpeicher08Anzahl;
		int SchussSpeicher09Anzahl;
		int SchussSpeicher10Anzahl;
		static array<int>^ SchussSpeicher00_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher00_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher01_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher01_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher02_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher02_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher03_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher03_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher04_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher04_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher05_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher05_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher06_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher06_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher07_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher07_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher08_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher08_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher09_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher09_Y = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher10_X = gcnew array<int>(MAX_SCHUESSE);
		static array<int>^ SchussSpeicher10_Y = gcnew array<int>(MAX_SCHUESSE);

		static array<bool>^ SchussSpeicher00_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher01_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher02_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher03_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher04_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher05_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher06_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher07_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher08_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher09_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);
		static array<bool>^ SchussSpeicher10_VonSchiff = gcnew array<bool>(MAX_SCHUESSE);

		static array<float>^ SchussPPF_X = gcnew array<float>(MAX_SCHUESSE);
		static array<float>^ SchussPPF_Y = gcnew array<float>(MAX_SCHUESSE);

		static const int LEBENSDAUER_SCHUSS = 70; 
		static array<int>^ SchussZukunftX = gcnew array<int>(LEBENSDAUER_SCHUSS);
		static array<int>^ SchussZukunftY = gcnew array<int>(LEBENSDAUER_SCHUSS);

		Player2(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) 
		{
			/*ObjektRadarElement = 0;
			ObjektRadar[0] = 0;
			SetzeObjektRadar (0,0,0,0,0,0);	*/
			StopThread = false;
			SendeLinks = false;
			SendeRechts = false;
			SendeBeschleunigung = false;
			SendeFeuer = false;
			SendeHyperspace = false;
			SchussLetztesFrame = false;
			SchussDiesesFrame = false;
			SteuerungAutomatik = true;
			Dauerfeuer = false;
			SchiffRichtungIndex = 0;
			KalibrierungAngefordert = false;
			KalibrierEndeZaehler = 0;
			SchiffRichtungKalibrieren = true;
			SchiffRichtungBraucheKalibrierfeuer = false;
			KalibrierschussAnzahl = 0;
			KalibrierungAngefordert = true;
			for ( int i = 0; i <= 10; i++ ) { 
				ResetObjektspeicher(i); 
				ResetSchussSpeicher(i); 
			}

			// Umrechnen der Winkelliste in Bogenmass
			Pi = 4 * atan(double(1));
			for ( int i = 0; i <= 255; i++ ) { 
				SchiffRichtungWinkelRadListe[i] = ( SchiffRichtungWinkelListe[i] * Pi ) / 180;
			}

		}

		void SchussZukunftBerechnen ( int SchussStartX, int SchussStartY, int SchusswinkelRadIndex ) 
		{
			// Einfach mal durchrechnen, wo sich ein Schuss whrend seiner Lebenszeit aufhalten wrde.
			// Ein Abstand von ca. 8px sollte ausreichen, um alles zu erwischen, was die Flugbahn kreuzt.

			double WinkelRAD = SchiffRichtungWinkelRadListe[SchusswinkelRadIndex];

			// Verhltnis von X und Y an der Geschwindigkeit ermitteln
			double BewegungsanteilY = sin(WinkelRAD);
			double BewegungsanteilX = cos(WinkelRAD);

			for ( int i = 0; i < LEBENSDAUER_SCHUSS; i++ )
			{
				// Wenn Schusswinkel 0, 90, 180, 270, dann haben wie die jeweilige Maxgeschwindigkeit
				// in px/Frame 0:7,875; 90:8; 180:8; 270:7,875
				
				// 270[3/2Pi], 0[0 bzw 2Pi], 90[1/2Pi] Grad
				if (WinkelRAD > ((3/2)*Pi) || ( WinkelRAD >= 0 && WinkelRAD < (Pi/2) ) ) { 
					SchussZukunftX[i] = int(BewegungsanteilX * 7.875 * (i+1)); 
				}
				// 270, 180, 90 Grad
				if (WinkelRAD >= (Pi/2) && WinkelRAD <= ((3/2)*Pi)) { 
					SchussZukunftX[i] = int(BewegungsanteilX * 8 * (i+1)); 
				}

				// 0, 90, 180 Grad
				if (WinkelRAD >= 0 && WinkelRAD < Pi) { 
					SchussZukunftY[i] = int(BewegungsanteilY * 7.875 * (i+1));
				}
				// 180, 270, 360 Grad
				if (WinkelRAD >= Pi && WinkelRAD < (2*Pi)) { 
					SchussZukunftY[i] = int(BewegungsanteilY * 8 * (i+1));
				}
			}
		}

		int TrefferMoeglich(void)
		{
			// Alle ObjektFlugbahnen durchrechnen und mit dem Schuss abgleichen
			// wenn mehrere Objekte auf Treffkurs sind, das mit dem geringsten Abstand anvisieren
			// die ObjektID des anvisierten Objektes zurckgeben
			// wenn kein Ziel da, 999 zurckgeben
			int ZielObjektID = 999;

			// Verhltnis von X und Y an der Geschwindigkeit ermitteln
			double BewegungsanteilY;
			double BewegungsanteilX;
			int TmpObjektPositionX;
			int TmpObjektPositionY;
			int TmpAbstandObjektSchuss;

			for ( int i = 0; i < MAX_OBJEKTE; i++ )
			{
				if ( this->Objektspeicher01[i] != 0 ) // abbrechen bei nicht vorhandenem Objekt
				{
					// Verhltnis von X und Y an der Geschwindigkeit pro Frame ermitteln
					BewegungsanteilX = ObjektPPF_X[i];// / 10;
					BewegungsanteilY = ObjektPPF_Y[i];// / 10; // ObjektPPF bezieht sich auf 10 Frames

					// abbrechen, bei 0 geschwindigkeit
					if ( BewegungsanteilY != 0 || BewegungsanteilX != 0 )
					{
						for ( int j = 0; j < LEBENSDAUER_SCHUSS; j++ )
						{
							// jede Objektposition berechnen und Vergleichen mit Schussbahn
							TmpObjektPositionX = Objektspeicher01_X[i] + (BewegungsanteilX * j);
							TmpObjektPositionY = Objektspeicher01_Y[i] + (BewegungsanteilY * j);
							
							for ( int k = 0; k < LEBENSDAUER_SCHUSS; k++ )
							{
								TmpAbstandObjektSchuss = pow(double(TmpObjektPositionX-SchussZukunftX[k]), 2) + pow(double(TmpObjektPositionY-SchussZukunftY[k]), 2); 
								switch ( Objektspeicher01_Groesse[i] )
								{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
								case 0:  // groer Asteroid: 20 Pkt
									TmpAbstandObjektSchuss -= 40*40;
									if (TmpAbstandObjektSchuss < 40*40) { ZielObjektID = Objektspeicher01[i]; }
									break;
								case 15: // mittlerer Asteroid: 50 Pkt
									TmpAbstandObjektSchuss -= 20*20;
									if (TmpAbstandObjektSchuss < 20*20) { ZielObjektID = Objektspeicher01[i]; }
									break;
								case 14: // kleiner Asteroid: 100 Pkt
									TmpAbstandObjektSchuss -= 8*8;
									if (TmpAbstandObjektSchuss < 10*10) { ZielObjektID = Objektspeicher01[i]; }
									break;
								}
							}
						}
					}
				}
			}
			return ZielObjektID;
		}

		void SchiffRichtungSetzen( int SPositionX, int SPositionY, int SRichtungSchrittzaehler )
		{
			// Mit dieser Funktion werden die Variablen SchiffRichtungX und SchiffRichtungY gesetzt.
			// Diese sind Abhngig von der Schiffsposition und dem RichtungsWinkel. 
			// Y = sinAlpha * (Hyp) 
			// Winkel (Grad) = (Winkel(Bogenma)*180)/Pi
			double xRichtung = cos(SchiffRichtungWinkelRadListe[SRichtungSchrittzaehler]) * 52;
			double yRichtung = sin(SchiffRichtungWinkelRadListe[SRichtungSchrittzaehler]) * 52;
			//printf("xRichtung: %f = cos(%f);\n", xRichtung, SchiffRichtungWinkelRadListe[SRichtungSchrittzaehler]);
			this->SchiffRichtungX = SPositionX + xRichtung;
			this->SchiffRichtungY = SPositionY + yRichtung;

			/*double xRichtungWeit = cos(SchiffRichtungWinkelRadListe[SRichtungSchrittzaehler]) * 1116;
			double yRichtungWeit = sin(SchiffRichtungWinkelRadListe[SRichtungSchrittzaehler]) * 1116;
			this->SchiffRichtungWeitX = SPositionX - xRichtungWeit;
			this->SchiffRichtungWeitY = SPositionY - yRichtungWeit;*/
		}

		int FindeSchiffRichtungIndex ( double Winkel )
		{
			// FUNKTION URSPRNGLICH FR DEG GESCHRIEBEN JETZT RAD
			int KleinsterWinkelabstandListenposition;
			double KleinsterWinkelabstand, Abstand;

			// Differenz bilden, Negative Werte umkehren und kleisten Abstand zum Winkel vergleichen
			// also erstes den Sonderfall 360 Grad betrachten
			// Winkel (Grad) = (Winkel(Bogenma)*180)/Pi
			// Winkel (Bogenma) = (Winkel(Grad)*Pi)/180
			printf("Kalibrierung Winkel: %f ( %f Grad)\n", Winkel, ( (Winkel * 180) / Pi) );
			//Abstand = Winkel - 360;
			if ( Winkel < 0 ) Winkel = ( 2*Pi ) + Winkel;
			Abstand = ( 2*Pi );
			//if ( Abstand < 0 ) { Abstand = Abstand * (-1); }
			KleinsterWinkelabstand = Abstand; 
			KleinsterWinkelabstandListenposition = 0;

			for ( int i = 0; i <= 255; i++ ) 
			{
				// Wenn der Winkel einem Wert enspricht, geht es nicht nher
				//if ( SchiffRichtungWinkelListe[i] == Winkel ) { return i; }
				if ( SchiffRichtungWinkelRadListe[i] == Winkel ) { return i; }

				// Differenz bilden, Negative Werte umkehren und kleisten Abstand zum Winkel vergleichen
				Abstand = Winkel - SchiffRichtungWinkelRadListe[i];
				if ( Abstand < 0 ) { Abstand = Abstand * (-1); }
				if ( Abstand < KleinsterWinkelabstand ) 
				{ 
					KleinsterWinkelabstand = Abstand; 
					KleinsterWinkelabstandListenposition = i;
				}
			}
			return KleinsterWinkelabstandListenposition;
		}

		bool SchiffRichtungKalibrierungCheck ( void )
		{
			int KalibrierFeuerX;
			int KalibrierFeuerY;
			bool IstKalibriert = false;

			if ( SchiffRichtungKalibrieren && !this->UFODiesesFrame )
			{
				if ( SchussSpeicher01Anzahl == 0 || KalibrierschussAnzahl > 0 )
				{
					SchiffRichtungBraucheKalibrierfeuer = true;								
					Dauerfeuer = false;
					if ( SchussSpeicher05Anzahl >= 4 )
					{
						//SchiffRichtungKalibrierfeuerX = SchussSpeicher05_X[0];
						//SchiffRichtungKalibrierfeuerY = SchussSpeicher05_Y[0];
						for ( int i = this->MAX_SCHUESSE - 1; i > 0; i-- )
						{
							if ( SchussSpeicher05[i] != 0 ) // Es sollte schon sicher sein, dass an dem Speicherplatz koordinaten liegen
							{
								KalibrierFeuerX = SchussSpeicher05_X[i];
								KalibrierFeuerY = SchussSpeicher05_Y[i];
								this->SchiffRichtungKalibrierfeuerX = SchussSpeicher05_X[i];
								this->SchiffRichtungKalibrierfeuerY = SchussSpeicher05_Y[i];
							}
						}

						//SchiffRichtungKalibrierung(SchiffPositionX, SchiffPositionY, SchiffRichtungKalibrierfeuerX, SchiffRichtungKalibrierfeuerY);
						SchiffRichtungKalibrierung( KalibrierFeuerX, KalibrierFeuerY);
						IstKalibriert = true;
						
						// Solange kalibrieren, dass mindesten 5 frames vergehen
						if ( KalibrierEndeZaehler == 0 )
						{
							SchiffRichtungKalibrieren = false;
							SchiffRichtungBraucheKalibrierfeuer = false;
							Dauerfeuer = true;
							KalibrierEndeZaehler = 0;
						} else {
							KalibrierEndeZaehler++;
						}
					} else {
						SchiffRichtungKalibrieren = true;
						SchiffRichtungBraucheKalibrierfeuer = true;
					}
				}
			}
			return IstKalibriert;
		}

		void SchiffRichtungKalibrierung ( int KalibrierFeuerX, int KalibrierFeuerY )
		{
			// 1. Herausfinden auf welchem Winkel das Schiff steht
			// 2. Die nchstgelegene Winkelnummer aus der Winkelliste heraussuchen
			// Normalisieren der Koordinaten
			int SektorX;
			int SektorY;
			int Sektor;

			double PositionsDifferenzX;
			double PositionsDifferenzY;

			printf("Normalisiertes Kalibrierfeuer (X|Y): %d | %d\n", NormalisierenX(KalibrierFeuerX), NormalisierenY(KalibrierFeuerY));

			//PositionsDifferenzX = NormalisierenX(KalibrierFeuerX) - NormalisierenX(SchiffPositionX);
			PositionsDifferenzX = KalibrierFeuerX - this->SchiffPositionX;
			//PositionsDifferenzX = NormalisierenX(KalibrierFeuerX);
			if ( PositionsDifferenzX > 0 ) { SektorX = 1; } // Winkel zwischen 270, 0 und 90 Grad
			else { 
				if ( PositionsDifferenzX == 0 ) { SektorX = 0; } // Winkel 270 oder 90 Grad
				else { SektorX = 2; } // Winkel zwischen 90, 180 und 270 Grad
			}

			//PositionsDifferenzY = NormalisierenY(KalibrierFeuerY - 128) - NormalisierenX(SchiffPositionY); // Das Offset aus InterpretFrame
			PositionsDifferenzY = KalibrierFeuerY - this->SchiffPositionY; 
			//PositionsDifferenzY = NormalisierenY(KalibrierFeuerY); // Das Offset aus InterpretFrame
			if ( PositionsDifferenzY < 0 ) { SektorY = 8; } // Winkel zwischen 0, 90 und 180 Grad
			else { 
				if ( PositionsDifferenzY == 0 ) { SektorY = 4; } // Winkel 0 oder 180 Grad
				else { SektorY = 16; } // Winkel zwischen 180, 270 und 0 Grad
			}

			Sektor = SektorX + SektorY;
			//printf( "Sektor(%d) = SektorX(%d) + SektorY(%d)\n", Sektor, SektorX, SektorY );
			//printf( "PosDiffY( %f ) = KaliFeuY( %d ) - SPosY( %d )\n", PositionsDifferenzY, KalibrierFeuerY-128, this->SchiffPositionY );
			printf( "PosDiffX( %f ) = KaliFeuX( %d ) - SPosX( %d )\n", PositionsDifferenzX, KalibrierFeuerX, this->SchiffPositionX );
			printf( "PosDiffY( %f ) = KaliFeuY( %d ) - SPosY( %d )\n", PositionsDifferenzY, KalibrierFeuerY, this->SchiffPositionY );
			//printf( "PosDiffY( %f ) = KaliFeuY( %d ) - SPosY( %d )\n", PositionsDifferenzY, NormalisierenY(KalibrierFeuerY), NormalisierenY(SchiffPositionY) );

			// Der Radius und die Katheten sollten wohl erstmal auf den Einheitskreis normiert werden
			double Radius = sqrt( pow(PositionsDifferenzX, 2) + pow(PositionsDifferenzY, 2) );
			PositionsDifferenzX = PositionsDifferenzX / Radius;
			PositionsDifferenzY = PositionsDifferenzY / Radius;
			// mal gegenrechnen, sollte 1 rauskommen
			// printf( "Einheitsbreitest: %f\n", sqrt( pow(PositionsDifferenzX, 2) + pow(PositionsDifferenzY, 2) ));

			double WinkelRAD;
			switch (Sektor)
			{
			case 4: // 0 + 4: Schiff und Feuerposition sind gleich: irgendein Fehler ... 
					// ... Pilot suizidgefhrdet oder Hperraumsprung ins eigene Feuer ... *lol*
				break;
			case 5: // 1 + 4: 0 Grad !! Winkel im Bogenmass bergeben !! Winkel (Bogenma) = (Winkel(Grad)*Pi)/180
				SchiffRichtungIndex = FindeSchiffRichtungIndex(0);
				break;
			case 8: // 0 + 8: 90 Grad
				SchiffRichtungIndex = FindeSchiffRichtungIndex( (90 * Pi) / 180 );
				break;
			case 6: // 2 + 4: 180 Grad
				SchiffRichtungIndex = FindeSchiffRichtungIndex( (180 * Pi) / 180 );
				break;
			case 16: // 0 + 16: 270 Grad
				SchiffRichtungIndex = FindeSchiffRichtungIndex( (270 * Pi) / 180 );
				break;
			case 9: // 1 + 8: Sektor 0 bis 90 Grad !! Winkel auf Bogenmass
				WinkelRAD = atan(double( PositionsDifferenzY / PositionsDifferenzX ));
				printf ( "ServerWinkel(0-90): RAD: %f - DEG: %f\n", WinkelRAD, (WinkelRAD * 180) / Pi);
				SchiffRichtungIndex = FindeSchiffRichtungIndex( ( (0 * Pi) / 180 ) - WinkelRAD );
				break;
			case 10: // 2 + 8: Sektor 90 bis 180 Grad
				WinkelRAD = atan(double( PositionsDifferenzY / ( PositionsDifferenzX * (-1))) );
				printf ( "ServerWinkel(90-180): RAD: %f - DEG: %f\n", WinkelRAD, (WinkelRAD * 180) / Pi);
				SchiffRichtungIndex = FindeSchiffRichtungIndex( ( (180 * Pi) / 180 ) + WinkelRAD );
				break;
			case 18: // 2 + 16: Sektor 180 bis 270 Grad
				WinkelRAD = atan(double( ( PositionsDifferenzY * (-1) ) / ( PositionsDifferenzX * (-1))) );
				printf ( "ServerWinkel(180-270): RAD: %f - DEG: %f\n", WinkelRAD, (WinkelRAD * 180) / Pi);
				SchiffRichtungIndex = FindeSchiffRichtungIndex( ( (180 * Pi) / 180 ) - WinkelRAD );
				break;
			case 17: // 1 + 16: Sektor 270 bis 0 Grad
				WinkelRAD = atan(double( ( PositionsDifferenzY * (-1) ) / PositionsDifferenzX ));
				printf ( "ServerWinkel(270-0): RAD: %f - DEG: %f\n", WinkelRAD, (WinkelRAD * 180) / Pi);
				SchiffRichtungIndex = FindeSchiffRichtungIndex( ( (360 * Pi) / 180 ) + WinkelRAD );
				break;
			default: // undefinierter Zustand, sollte nie eintreten
				break;
			}
		}

		void Objektgeschwindigkeiten ( void ) {
			float tmp_dx;
			float tmp_dy;
			for ( int i = 0; i < MAX_OBJEKTE; i++ ) 
			{
				//ObjektPPF_X[i] = ( Objektspeicher01_X[i] - Objektspeicher10_X[i] ) / 10;
				//ObjektPPF_Y[i] = ( Objektspeicher01_Y[i] - Objektspeicher10_Y[i] ) / 10;
				// Beim Verlassen und Wiedereintritt in das Spielfeld gibt es falssche Geschwindigkeiten.
				// Manchmal treten auch einfach so Fehler auf. Wert bei zu Hoher Geschwindigkeit nicht
				// neu berechnen.
				tmp_dx = Objektspeicher01_X[i] - Objektspeicher10_X[i];
				tmp_dy = Objektspeicher01_Y[i] - Objektspeicher10_Y[i];

				if ( ( (ObjektPPF_X[i] + 50) > tmp_dx ) && (tmp_dx > (ObjektPPF_X[i] - 50) ) ) { ObjektPPF_X[i] = ( tmp_dx ); }
				else { ObjektPPF_X[i] = 0; } // Artefaktvermeidung durch Neuberechnung

				if ( ( (ObjektPPF_Y[i] + 50) > tmp_dy ) && (tmp_dy > (ObjektPPF_Y[i] - 50) ) ) { ObjektPPF_Y[i] = ( tmp_dy ); }
				else { ObjektPPF_Y[i] = 0; } // Artefaktvermeidung durch Neuberechnung
			}
		}

		void Schussgeschwindigkeiten ( void ) {
			float tmp_dx;
			float tmp_dy;
			for ( int i = 0; i < MAX_SCHUESSE; i++ ) 
			{
				//SchussPPF_X[i] = ( SchussSpeicher01_X[i] - SchussSpeicher10_X[i] ) / 10;
				//SchussPPF_Y[i] = ( SchussSpeicher01_Y[i] - SchussSpeicher10_Y[i] ) / 10;
				// Beim Verlassen und Wiedereintritt in das Spielfeld gibt es falssche Geschwindigkeiten.
				// Manchmal treten auch einfach so Fehler auf. Wert bei zu Hoher Geschwindigkeit nicht
				// neu berechnen.
				tmp_dx = SchussSpeicher01_X[i] - SchussSpeicher10_X[i];
				tmp_dy = SchussSpeicher01_Y[i] - SchussSpeicher10_Y[i];

				if ( ( (SchussPPF_X[i] + 75) > tmp_dx ) && (tmp_dx > (SchussPPF_X[i] - 75) ) ) { SchussPPF_X[i] = ( tmp_dx ); }
				else { SchussPPF_X[i] = 0; } // Artefaktvermeidung durch Neuberechnung

				if ( ( (SchussPPF_Y[i] + 75) > tmp_dy ) && (tmp_dy > (SchussPPF_Y[i] - 75) ) ) { SchussPPF_Y[i] = ( tmp_dy ); }
				else { SchussPPF_Y[i] = 0; } // Artefaktvermeidung durch Neuberechnung
			}
		}

		bool Objektspeicher02AbHierLeer( int Zeiger02 )
		{
			for ( int i = Zeiger02; i < MAX_OBJEKTE; i++ )
			{
				if ( Objektspeicher02[i] != 0 )
				{
					return false;
				}
			}
			//fprintf(stderr, "DEBUG: Objektspeicher02[%d] = %d: Ab hier leer.\n", Zeiger02, Objektspeicher02[Zeiger02]);
			return true;
		}

		bool SchussSpeicher02AbHierLeer( int Zeiger02 )
		{
			for ( int i = Zeiger02; i < MAX_SCHUESSE; i++ )
			{
				if ( SchussSpeicher02[i] != 0 )
				{
					return false;
				}
			}
			//fprintf(stderr, "DEBUG: SchussSpeicher02[%d] = %d: Ab hier leer.\n", Zeiger02, SchussSpeicher02[Zeiger02]);
			return true;
		}

		void ResetObjektspeicher ( int ObjektspeicherNr ) {
			array<int>^ Objektspeicher = gcnew array<int>(MAX_OBJEKTE);
			for ( int i = 0; i > MAX_OBJEKTE; i++ )
			{
				Objektspeicher[i] = 0;
			}
			switch ( ObjektspeicherNr )
			{
			case 1: 
				Objektspeicher->CopyTo(Objektspeicher01, 0); 
				Objektspeicher->CopyTo(Objektspeicher01_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher01_Y, 0); 
				Objektspeicher->CopyTo(Objektspeicher01_Groesse, 0);
				Objektspeicher->CopyTo(Objektspeicher01_Typ, 0);
				Objektspeicher01Anzahl = 0; 
				break;
			case 2: 
				Objektspeicher->CopyTo(Objektspeicher02, 0); 
				Objektspeicher->CopyTo(Objektspeicher02_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher02_Y, 0); 
				Objektspeicher02Anzahl = 0; 
				break;
			case 3: 
				Objektspeicher->CopyTo(Objektspeicher03, 0); 
				Objektspeicher->CopyTo(Objektspeicher03_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher03_Y, 0); 
				Objektspeicher03Anzahl = 0; 
				break;
			case 4: 
				Objektspeicher->CopyTo(Objektspeicher04, 0); 
				Objektspeicher->CopyTo(Objektspeicher04_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher04_Y, 0); 
				Objektspeicher04Anzahl = 0; 
				break;
			case 5: 
				Objektspeicher->CopyTo(Objektspeicher05, 0); 
				Objektspeicher->CopyTo(Objektspeicher05_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher05_Y, 0); 
				Objektspeicher05Anzahl = 0; 
				break;
			case 6: 
				Objektspeicher->CopyTo(Objektspeicher06, 0); 
				Objektspeicher->CopyTo(Objektspeicher06_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher06_Y, 0); 
				Objektspeicher06Anzahl = 0; 
				break;
			case 7: 
				Objektspeicher->CopyTo(Objektspeicher07, 0); 
				Objektspeicher->CopyTo(Objektspeicher07_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher07_Y, 0); 
				Objektspeicher07Anzahl = 0; 
				break;
			case 8: 
				Objektspeicher->CopyTo(Objektspeicher08, 0); 
				Objektspeicher->CopyTo(Objektspeicher08_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher08_Y, 0); 
				Objektspeicher08Anzahl = 0; 
				break;
			case 9: 
				Objektspeicher->CopyTo(Objektspeicher09, 0); 
				Objektspeicher->CopyTo(Objektspeicher09_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher09_Y, 0); 
				Objektspeicher09Anzahl = 0; 
				break;
			case 10: 
				Objektspeicher->CopyTo(Objektspeicher10, 0); 
				Objektspeicher->CopyTo(Objektspeicher10_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher10_Y, 0); 
				Objektspeicher10Anzahl = 0; 
				break;
			default: 
				Objektspeicher->CopyTo(Objektspeicher00, 0); 
				Objektspeicher->CopyTo(Objektspeicher00_X, 0); 
				Objektspeicher->CopyTo(Objektspeicher00_Y, 0); 
				Objektspeicher->CopyTo(Objektspeicher00_Groesse, 0);
				Objektspeicher->CopyTo(Objektspeicher00_Typ, 0);
				Objektspeicher00Anzahl = 0; 
				break;
			}
		}

		
		void ResetSchussSpeicher ( int SchussSpeicherNr ) {
			array<int>^ SchussSpeicher = gcnew array<int>(MAX_SCHUESSE);
			array<bool>^ SchussSpeicherVonSchiff = gcnew array<bool>(MAX_SCHUESSE);
			for ( int i = 0; i < MAX_SCHUESSE; i++ )
			{
				SchussSpeicher[i] = 0;
				SchussSpeicherVonSchiff[i] = true;
			}
			switch ( SchussSpeicherNr )
			{
			case 1: 
				SchussSpeicher->CopyTo(SchussSpeicher01, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher01_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher01_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher01_VonSchiff, 0); 
				SchussSpeicher01Anzahl = 0; 
				break;
			case 2: 
				SchussSpeicher->CopyTo(SchussSpeicher02, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher02_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher02_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher02_VonSchiff, 0); 
				SchussSpeicher02Anzahl = 0; 
				break;
			case 3: 
				SchussSpeicher->CopyTo(SchussSpeicher03, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher03_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher03_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher03_VonSchiff, 0); 
				SchussSpeicher03Anzahl = 0; 
				break;
			case 4: 
				SchussSpeicher->CopyTo(SchussSpeicher04, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher04_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher04_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher04_VonSchiff, 0); 
				SchussSpeicher04Anzahl = 0; 
				break;
			case 5: 
				SchussSpeicher->CopyTo(SchussSpeicher05, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher05_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher05_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher05_VonSchiff, 0); 
				SchussSpeicher05Anzahl = 0; 
				break;
			case 6: 
				SchussSpeicher->CopyTo(SchussSpeicher06, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher06_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher06_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher06_VonSchiff, 0); 
				SchussSpeicher06Anzahl = 0; 
				break;
			case 7: 
				SchussSpeicher->CopyTo(SchussSpeicher07, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher07_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher07_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher07_VonSchiff, 0); 
				SchussSpeicher07Anzahl = 0; 
				break;
			case 8: 
				SchussSpeicher->CopyTo(SchussSpeicher08, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher08_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher08_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher08_VonSchiff, 0); 
				SchussSpeicher08Anzahl = 0; 
				break;
			case 9: 
				SchussSpeicher->CopyTo(SchussSpeicher09, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher09_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher09_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher09_VonSchiff, 0); 
				SchussSpeicher09Anzahl = 0; 
				break;
			case 10: 
				SchussSpeicher->CopyTo(SchussSpeicher10, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher10_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher10_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher10_VonSchiff, 0); 
				SchussSpeicher10Anzahl = 0; 
				break;
			default: 
				SchussSpeicher->CopyTo(SchussSpeicher00, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher00_X, 0); 
				SchussSpeicher->CopyTo(SchussSpeicher00_Y, 0); 
				SchussSpeicherVonSchiff->CopyTo(SchussSpeicher00_VonSchiff, 0); 
				SchussSpeicher00Anzahl = 0; 
				break;
			}
		}

		void CopyObjektspeicher ( int ObjektspeicherNrVon, int ObjektspeicherNrZu ) {
			array<int>^ Objektspeicher = gcnew array<int>(MAX_OBJEKTE);
			int ObjektspeicherAnzahl; 

			switch ( ObjektspeicherNrVon )
			{
			case 1: Objektspeicher01->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher01Anzahl; break;
			case 2: Objektspeicher02->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher02Anzahl; break;
			case 3: Objektspeicher03->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher03Anzahl; break;
			case 4: Objektspeicher04->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher04Anzahl; break;
			case 5: Objektspeicher05->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher05Anzahl; break;
			case 6: Objektspeicher06->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher06Anzahl; break;
			case 7: Objektspeicher07->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher07Anzahl; break;
			case 8: Objektspeicher08->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher08Anzahl; break;
			case 9: Objektspeicher09->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher09Anzahl; break;
			case 10: Objektspeicher10->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher10Anzahl; break;
			default: Objektspeicher00->CopyTo(Objektspeicher, 0); ObjektspeicherAnzahl = Objektspeicher00Anzahl; break;
			}
			switch ( ObjektspeicherNrZu )
			{
			case 1: Objektspeicher->CopyTo(Objektspeicher01, 0); Objektspeicher01Anzahl = ObjektspeicherAnzahl; break;
			case 2: Objektspeicher->CopyTo(Objektspeicher02, 0); Objektspeicher02Anzahl = ObjektspeicherAnzahl; break;
			case 3: Objektspeicher->CopyTo(Objektspeicher03, 0); Objektspeicher03Anzahl = ObjektspeicherAnzahl; break;
			case 4: Objektspeicher->CopyTo(Objektspeicher04, 0); Objektspeicher04Anzahl = ObjektspeicherAnzahl; break;
			case 5: Objektspeicher->CopyTo(Objektspeicher05, 0); Objektspeicher05Anzahl = ObjektspeicherAnzahl; break;
			case 6: Objektspeicher->CopyTo(Objektspeicher06, 0); Objektspeicher06Anzahl = ObjektspeicherAnzahl; break;
			case 7: Objektspeicher->CopyTo(Objektspeicher07, 0); Objektspeicher07Anzahl = ObjektspeicherAnzahl; break;
			case 8: Objektspeicher->CopyTo(Objektspeicher08, 0); Objektspeicher08Anzahl = ObjektspeicherAnzahl; break;
			case 9: Objektspeicher->CopyTo(Objektspeicher09, 0); Objektspeicher09Anzahl = ObjektspeicherAnzahl; break;
			case 10: Objektspeicher->CopyTo(Objektspeicher10, 0); Objektspeicher10Anzahl = ObjektspeicherAnzahl; break;
			default: Objektspeicher->CopyTo(Objektspeicher00, 0); Objektspeicher00Anzahl = ObjektspeicherAnzahl; break;
			}
		}

		void CopySchussSpeicher ( int SchussSpeicherNrVon, int SchussSpeicherNrZu ) {
			array<int>^ SchussSpeicher = gcnew array<int>(MAX_SCHUESSE);
			array<bool>^ SchussSpeicherVonSchiff = gcnew array<bool>(MAX_SCHUESSE);
			int SchussSpeicherAnzahl; 

			switch ( SchussSpeicherNrVon )
			{
			case 1: SchussSpeicher01->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher01Anzahl; break;
			case 2: SchussSpeicher02->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher02Anzahl; break;
			case 3: SchussSpeicher03->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher03Anzahl; break;
			case 4: SchussSpeicher04->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher04Anzahl; break;
			case 5: SchussSpeicher05->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher05Anzahl; break;
			case 6: SchussSpeicher06->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher06Anzahl; break;
			case 7: SchussSpeicher07->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher07Anzahl; break;
			case 8: SchussSpeicher08->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher08Anzahl; break;
			case 9: SchussSpeicher09->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher09Anzahl; break;
			case 10: SchussSpeicher10->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher10Anzahl; break;
			default: 
				SchussSpeicher00->CopyTo(SchussSpeicher, 0); SchussSpeicherAnzahl = SchussSpeicher00Anzahl; 
				SchussSpeicher00_VonSchiff->CopyTo(SchussSpeicherVonSchiff, 0);
				break;
			}
			switch ( SchussSpeicherNrZu )
			{
			case 1: SchussSpeicher->CopyTo(SchussSpeicher01, 0); SchussSpeicher01Anzahl = SchussSpeicherAnzahl; 
					SchussSpeicherVonSchiff->CopyTo(SchussSpeicher01_VonSchiff, 0); break;
			case 2: SchussSpeicher->CopyTo(SchussSpeicher02, 0); SchussSpeicher02Anzahl = SchussSpeicherAnzahl; break;
			case 3: SchussSpeicher->CopyTo(SchussSpeicher03, 0); SchussSpeicher03Anzahl = SchussSpeicherAnzahl; break;
			case 4: SchussSpeicher->CopyTo(SchussSpeicher04, 0); SchussSpeicher04Anzahl = SchussSpeicherAnzahl; break;
			case 5: SchussSpeicher->CopyTo(SchussSpeicher05, 0); SchussSpeicher05Anzahl = SchussSpeicherAnzahl; break;
			case 6: SchussSpeicher->CopyTo(SchussSpeicher06, 0); SchussSpeicher06Anzahl = SchussSpeicherAnzahl; break;
			case 7: SchussSpeicher->CopyTo(SchussSpeicher07, 0); SchussSpeicher07Anzahl = SchussSpeicherAnzahl; break;
			case 8: SchussSpeicher->CopyTo(SchussSpeicher08, 0); SchussSpeicher08Anzahl = SchussSpeicherAnzahl; break;
			case 9: SchussSpeicher->CopyTo(SchussSpeicher09, 0); SchussSpeicher09Anzahl = SchussSpeicherAnzahl; break;
			case 10: SchussSpeicher->CopyTo(SchussSpeicher10, 0); SchussSpeicher10Anzahl = SchussSpeicherAnzahl; break;
			default: SchussSpeicher->CopyTo(SchussSpeicher00, 0); SchussSpeicher00Anzahl = SchussSpeicherAnzahl; break;
			}
		}

		void PushObjektspeicher ( void ) 
		{
			PushObjektspeicherPositionen();
			Objektspeicher09->CopyTo(Objektspeicher10, 0);
			Objektspeicher08->CopyTo(Objektspeicher09, 0);
			Objektspeicher07->CopyTo(Objektspeicher08, 0);
			Objektspeicher06->CopyTo(Objektspeicher07, 0);
			Objektspeicher05->CopyTo(Objektspeicher06, 0);
			Objektspeicher04->CopyTo(Objektspeicher05, 0);
			Objektspeicher03->CopyTo(Objektspeicher04, 0);
			Objektspeicher02->CopyTo(Objektspeicher03, 0);
			Objektspeicher01->CopyTo(Objektspeicher02, 0);
			//ResetObjektspeicher( 0 );
			Objektspeicher10Anzahl = Objektspeicher09Anzahl;
			Objektspeicher09Anzahl = Objektspeicher08Anzahl;
			Objektspeicher08Anzahl = Objektspeicher07Anzahl;
			Objektspeicher07Anzahl = Objektspeicher06Anzahl;
			Objektspeicher06Anzahl = Objektspeicher05Anzahl;
			Objektspeicher05Anzahl = Objektspeicher04Anzahl;
			Objektspeicher04Anzahl = Objektspeicher03Anzahl;
			Objektspeicher03Anzahl = Objektspeicher02Anzahl;
			Objektspeicher02Anzahl = Objektspeicher01Anzahl;
			Objektspeicher01Anzahl = 0;
			//Objektspeicher01Anzahl = Objektspeicher00Anzahl;
			//Objektspeicher00Anzahl = Objektspeicher00Zaehler;

			/* Jetzt wird in Objektspeicher01 die Belegung der 26 Objektslots im (VektorROM?) rekonstruiert.
				Objektspeicher00 bekommt immer die Reihenfolge der gefllten Speicherpltze bergeben. Die leeren
				Pltze msste man aber wieder einfgen knnen. Wir wissen:
				1. Ein Objekt belegt Asteroidsintern einen festen Platz in einem Array, solange es existiert.
				2. Wird es zerstrt, so wird der Platz mit einer Explosion belegt. (X|Y) entspricht letzter Objektposition.
				3. Ist die Explosion beendet wird der Platz freigegeben.
				4. Ein neues Objekt wird in den ersten freien Platz gelegt.
			*/
			// Hilfsvariablen
			int Zeiger00 = 0;
			int Zeiger01 = 0;
			int Zeiger02 = 0;
			int VermutungVerlorenesFrame = 0;
			int Objektspeicher02AnzahlDifferenzZu00 = Objektspeicher02Anzahl - Objektspeicher00Anzahl;
			int Verzoegerung = 0;

			ResetObjektspeicher( 1 );
			for ( int i = 0; Objektspeicher00[i-Verzoegerung] != 0; i++ )
			{
				//if ( Objektspeicher02AbHierLeer(Zeiger02) ) { Objektspeicher01[Zeiger01] = Objektspeicher00[i-Verzoegerung]; }
				if ( Objektspeicher02AbHierLeer(Zeiger02) ) { SetzeObjektspeicher( 1, Zeiger01, Objektspeicher00[i-Verzoegerung], Objektspeicher00_X[i-Verzoegerung], Objektspeicher00_Y[i-Verzoegerung], Objektspeicher00_Typ[i-Verzoegerung], Objektspeicher00_Groesse[i-Verzoegerung]); }
				else 
				{
					switch ( Objektspeicher02[Zeiger02] )
					{
					case 0:
						if ( Objektspeicher02Anzahl >= Objektspeicher00Anzahl ) 
						{	// abnehmende Asteroidenanzahl -> Lcken in der Liste lassen
							//Objektspeicher01[Zeiger01] = 0; 
							SetzeObjektspeicher( 1, Zeiger01, 0, 0, 0, 0 ,0);
							Verzoegerung++; // Verzgerung einbauen, es knnten mehrere Lcken aufeinander folgen
						} else { // zunehmende Asteroidenanzahl -> Lcken auffllen
							if ( Objektspeicher02AnzahlDifferenzZu00 < 0 )
							{	// berzhlige, neue Asteroiden in die Lcken setzen
								//Objektspeicher01[Zeiger01] = Objektspeicher00[i-Verzoegerung];
								SetzeObjektspeicher( 1, Zeiger01, Objektspeicher00[i-Verzoegerung], Objektspeicher00_X[i-Verzoegerung], Objektspeicher00_Y[i-Verzoegerung], Objektspeicher00_Typ[i-Verzoegerung], Objektspeicher00_Groesse[i-Verzoegerung]);
								Objektspeicher02AnzahlDifferenzZu00++;
								Objektspeicher01Anzahl++;
							} else { // berzhlige neue Asteroiden verbaut, Lcken nicht mehr stopfen.
								//Objektspeicher01[Zeiger01] = 0;
								SetzeObjektspeicher( 1, Zeiger01, 0, 0, 0, 0, 0);
								Verzoegerung++;
							}
						}
						break;
					case 99:
						if ( Objektspeicher00[i-Verzoegerung] == 99 ) { Objektspeicher01[Zeiger01] = 99; }
						else { // Auf 99 kann ggf. auch ein Objekt folgen, wenn die Objekte sim im selben Zug vermehren
							if ( Objektspeicher02Anzahl >= Objektspeicher00Anzahl ) 								
							{	// abnehmende Asteroidenanzahl -> Lcken in der Liste lassen
								//Objektspeicher01[Zeiger01] = 0;
								SetzeObjektspeicher( 1, Zeiger01, 0, 0, 0, 0, 0);
								Verzoegerung++;
							} else { // zunehmende Asteroidenanzahl -> Lcken auffllen
								if ( Objektspeicher02AnzahlDifferenzZu00 < 0 )
								{	// berzhlige, neue Asteroiden in die Lcken setzen
									//Objektspeicher01[Zeiger01] = Objektspeicher00[i-Verzoegerung];
									SetzeObjektspeicher( 1, Zeiger01, Objektspeicher00[i-Verzoegerung], Objektspeicher00_X[i-Verzoegerung], Objektspeicher00_Y[i-Verzoegerung], Objektspeicher00_Typ[i-Verzoegerung], Objektspeicher00_Groesse[i-Verzoegerung]);
									Objektspeicher02AnzahlDifferenzZu00++;
									Objektspeicher01Anzahl++;
								} else { // berzhlige neue Asteroiden verbaut, Lcken nicht mehr stopfen.
									//Objektspeicher01[Zeiger01] = 0; 
									SetzeObjektspeicher( 1, Zeiger01, 0, 0, 0, 0, 0);
									Verzoegerung++;
								}
							}
						}
						break;
					default:
						//Objektspeicher01[Zeiger01] = Objektspeicher00[i-Verzoegerung];
						SetzeObjektspeicher( 1, Zeiger01, Objektspeicher00[i-Verzoegerung], Objektspeicher00_X[i-Verzoegerung], Objektspeicher00_Y[i-Verzoegerung], Objektspeicher00_Typ[i-Verzoegerung], Objektspeicher00_Groesse[i-Verzoegerung]);
						Objektspeicher01Anzahl++;
						break;
					}
					//Objektspeicher01[Zeiger01] = Objektspeicher00[i];
				}
				
				Zeiger02++;
				if (Zeiger01 < MAX_OBJEKTE-2) { Zeiger01++; } // NOCH NICHT SAUBER - Vermeidung berlauf
			} // Ende for ( int i = 0; i > MAX_OBJEKTE; i++ )

			Objektspeicher00->CopyTo(Objektspeicher00Info, 0); // Nur fr die Ausgabe, Objektspeicher00 schon wieder bereit sein muss.
			ResetObjektspeicher( 0 );
			Objektspeicher00Anzahl = 0;
			//Objektspeicher00Zaehler = 0;
		}

		void PushSchussSpeicher ( void ) 
		{
			PushSchussSpeicherPositionen();
			SchussSpeicher09->CopyTo(SchussSpeicher10, 0);
			SchussSpeicher08->CopyTo(SchussSpeicher09, 0);
			SchussSpeicher07->CopyTo(SchussSpeicher08, 0);
			SchussSpeicher06->CopyTo(SchussSpeicher07, 0);
			SchussSpeicher05->CopyTo(SchussSpeicher06, 0);
			SchussSpeicher04->CopyTo(SchussSpeicher05, 0);
			SchussSpeicher03->CopyTo(SchussSpeicher04, 0);
			SchussSpeicher02->CopyTo(SchussSpeicher03, 0);
			SchussSpeicher01->CopyTo(SchussSpeicher02, 0);
			//ResetSchussSpeicher( 0 );
			SchussSpeicher10Anzahl = SchussSpeicher09Anzahl;
			SchussSpeicher09Anzahl = SchussSpeicher08Anzahl;
			SchussSpeicher08Anzahl = SchussSpeicher07Anzahl;
			SchussSpeicher07Anzahl = SchussSpeicher06Anzahl;
			SchussSpeicher06Anzahl = SchussSpeicher05Anzahl;
			SchussSpeicher05Anzahl = SchussSpeicher04Anzahl;
			SchussSpeicher04Anzahl = SchussSpeicher03Anzahl;
			SchussSpeicher03Anzahl = SchussSpeicher02Anzahl;
			SchussSpeicher02Anzahl = SchussSpeicher01Anzahl;
			SchussSpeicher01Anzahl = 0;
			//SchussSpeicher01Anzahl = SchussSpeicher00Anzahl;
			//SchussSpeicher00Anzahl = SchussSpeicher00Zaehler;

			/* Jetzt wird in SchussSpeicher01 die Belegung der 26 Objektslots im (VektorROM?) rekonstruiert.
				SchussSpeicher00 bekommt immer die Reihenfolge der gefllten Speicherpltze bergeben. Die leeren
				Pltze msste man aber wieder einfgen knnen. Wir wissen:
				1. Ein Objekt belegt Asteroidsintern einen festen Platz in einem Array, solange es existiert.
				2. Wird es zerstrt, so wird der Platz mit einer Explosion belegt. (X|Y) entspricht letzter Objektposition.
				3. Ist die Explosion beendet wird der Platz freigegeben.
				4. Ein neues Objekt wird in den ersten freien Platz gelegt.
			*/
			// Hilfsvariablen
			int Zeiger00 = 0;
			int Zeiger01 = 0;
			int Zeiger02 = 0;
			int VermutungVerlorenesFrame = 0;
			int SchussSpeicher02AnzahlDifferenzZu00 = SchussSpeicher02Anzahl - SchussSpeicher00Anzahl;
			int Verzoegerung = 0;

			ResetSchussSpeicher( 1 );
			for ( int i = 0; SchussSpeicher00[i-Verzoegerung] != 0; i++ )
			{
				//if ( SchussSpeicher02AbHierLeer(Zeiger02) ) { SchussSpeicher01[Zeiger01] = SchussSpeicher00[i-Verzoegerung]; }
				if ( SchussSpeicher02AbHierLeer(Zeiger02) ) { SetzeSchussSpeicher( 1, Zeiger01, SchussSpeicher00[i-Verzoegerung], SchussSpeicher00_X[i-Verzoegerung], SchussSpeicher00_Y[i-Verzoegerung], true); }
				else 
				{
					switch ( SchussSpeicher02[Zeiger02] )
					{
					case 0:
						if ( SchussSpeicher02Anzahl >= SchussSpeicher00Anzahl ) 
						{	// abnehmende Asteroidenanzahl -> Lcken in der Liste lassen
							//SchussSpeicher01[Zeiger01] = 0; 
							SetzeSchussSpeicher( 1, Zeiger01, 0, 0, 0, true);
							Verzoegerung++; // Verzgerung einbauen, es knnten mehrere Lcken aufeinander folgen
						} else { // zunehmende Asteroidenanzahl -> Lcken auffllen
							if ( SchussSpeicher02AnzahlDifferenzZu00 < 0 )
							{	// berzhlige, neue Asteroiden in die Lcken setzen
								//SchussSpeicher01[Zeiger01] = SchussSpeicher00[i-Verzoegerung];
								SetzeSchussSpeicher( 1, Zeiger01, SchussSpeicher00[i-Verzoegerung], SchussSpeicher00_X[i-Verzoegerung], SchussSpeicher00_Y[i-Verzoegerung], SchussSpeicher00_VonSchiff[i-Verzoegerung]);
								SchussSpeicher02AnzahlDifferenzZu00++;
								SchussSpeicher01Anzahl++;
							} else { // berzhlige neue Asteroiden verbaut, Lcken nicht mehr stopfen.
								//SchussSpeicher01[Zeiger01] = 0;
								SetzeSchussSpeicher( 1, Zeiger01, 0, 0, 0, true);
								Verzoegerung++;
							}
						}
						break;
					case 99:
						if ( SchussSpeicher00[i-Verzoegerung] == 99 ) { SchussSpeicher01[Zeiger01] = 99; }
						else { // Auf 99 kann ggf. auch ein Objekt folgen, wenn die Objekte sim im selben Zug vermehren
							if ( SchussSpeicher02Anzahl >= SchussSpeicher00Anzahl ) 								
							{	// abnehmende Asteroidenanzahl -> Lcken in der Liste lassen
								//SchussSpeicher01[Zeiger01] = 0;
								SetzeSchussSpeicher( 1, Zeiger01, 0, 0, 0, true);
								Verzoegerung++;
							} else { // zunehmende Asteroidenanzahl -> Lcken auffllen
								if ( SchussSpeicher02AnzahlDifferenzZu00 < 0 )
								{	// berzhlige, neue Asteroiden in die Lcken setzen
									//SchussSpeicher01[Zeiger01] = SchussSpeicher00[i-Verzoegerung];
									SetzeSchussSpeicher( 1, Zeiger01, SchussSpeicher00[i-Verzoegerung], SchussSpeicher00_X[i-Verzoegerung], SchussSpeicher00_Y[i-Verzoegerung], SchussSpeicher00_VonSchiff[i-Verzoegerung]);
									SchussSpeicher02AnzahlDifferenzZu00++;
									SchussSpeicher01Anzahl++;
								} else { // berzhlige neue Asteroiden verbaut, Lcken nicht mehr stopfen.
									//SchussSpeicher01[Zeiger01] = 0; 
									SetzeSchussSpeicher( 1, Zeiger01, 0, 0, 0, true);
									Verzoegerung++;
								}
							}
						}
						break;
					default:
						//SchussSpeicher01[Zeiger01] = SchussSpeicher00[i-Verzoegerung];
						SetzeSchussSpeicher( 1, Zeiger01, SchussSpeicher00[i-Verzoegerung], SchussSpeicher00_X[i-Verzoegerung], SchussSpeicher00_Y[i-Verzoegerung], SchussSpeicher00_VonSchiff[i-Verzoegerung]);
						SchussSpeicher01Anzahl++;
						break;
					}
					//SchussSpeicher01[Zeiger01] = SchussSpeicher00[i];
				}
				
				Zeiger02++;
				if (Zeiger01 < MAX_SCHUESSE-2) { Zeiger01++; } // NOCH NICHT SAUBER - Vermeidung berlauf
			} // Ende for ( int i = 0; i > MAX_OBJEKTE; i++ )

			SchussSpeicher00->CopyTo(SchussSpeicher00Info, 0); // Nur fr die Ausgabe, SchussSpeicher00 schon wieder bereit sein muss.
			ResetSchussSpeicher( 0 );
			SchussSpeicher00Anzahl = 0;
			//SchussSpeicher00Zaehler = 0;
		}

		void SetzeObjektspeicher ( int ObjektspeicherNr, int SpeicherPosition, int SpeicherPositionIn00, int X, int Y, int Typ, int Groesse )
		{
			switch ( ObjektspeicherNr )
			{
			case 0:
				Objektspeicher00[Objektspeicher00Zaehler] = SpeicherPosition;
				Objektspeicher00_X[Objektspeicher00Zaehler] = X;
				Objektspeicher00_Y[Objektspeicher00Zaehler] = Y;
				Objektspeicher00_Groesse[Objektspeicher00Zaehler] = Groesse;
				Objektspeicher00_Typ[Objektspeicher00Zaehler] = Typ;
				Objektspeicher00Zaehler++;
				break;
			case 1:
				Objektspeicher01[SpeicherPosition] = SpeicherPositionIn00;
				Objektspeicher01_X[SpeicherPosition] = X;
				Objektspeicher01_Y[SpeicherPosition] = Y;
				Objektspeicher01_Groesse[SpeicherPosition] = Groesse;
				Objektspeicher01_Typ[SpeicherPosition] = Typ;
				break;
			default: break;
			}
		}

		void SetzeSchussSpeicher ( int SchussSpeicherNr, int SpeicherPosition, int SpeicherPositionIn00, int X, int Y, bool VonSchiff )
		{
			switch ( SchussSpeicherNr )
			{
			case 0:
				SchussSpeicher00[SchussSpeicher00Zaehler] = SpeicherPosition;
				SchussSpeicher00_X[SchussSpeicher00Zaehler] = X;
				SchussSpeicher00_Y[SchussSpeicher00Zaehler] = Y;
				SchussSpeicher00Zaehler++;
				// Vermutlich stammt ein Schuss von dem Schiff, wo er jetzt (nach einem Frame) nher dran ist
				for ( int i = 0; i < this->MAX_OBJEKTE; i++ )
				{
					if ( UFOLetztesFrame ) 
					{
						//printf("SetzeSchussSpeicher()\n");
						if ( this->Objektspeicher01_Typ[i] == 5 ) // UfoPosition ermitteln
						{
							double SchussEntfernungUfoX = Objektspeicher01_X[i] - X;
							double SchussEntfernungUfoY = Objektspeicher01_Y[i] - Y;
							double SchussEntfernungUfo = pow(SchussEntfernungUfoX, 2) + pow(SchussEntfernungUfoY, 2);

							double SchussEntfernungSchiffX = this->SchiffPositionX - X;
							double SchussEntfernungSchiffY = this->SchiffPositionY - Y;
							double SchussEntfernungSchiff = pow(SchussEntfernungSchiffX, 2) + pow(SchussEntfernungSchiffY, 2);

							//printf("SetzeSchussSpeicher(): Objektspeicher01_X[i]=%d SchiffPositionX=%d X=%d\n",Objektspeicher01_X[i], SchiffPositionX, X );
							//printf("SetzeSchussSpeicher(): SchussEntfernungSchiff=%f SchussEntfernungUfo=%f\n",SchussEntfernungSchiff, SchussEntfernungUfo );
							
							if (SchussEntfernungSchiff < SchussEntfernungUfo) { SchussSpeicher00_VonSchiff[SchussSpeicher00Zaehler] = true; }
							else { SchussSpeicher00_VonSchiff[SchussSpeicher00Zaehler] = false; }
						}
					}
				}
				break;
			case 1:
				SchussSpeicher01[SpeicherPosition] = SpeicherPositionIn00;
				SchussSpeicher01_X[SpeicherPosition] = X;
				SchussSpeicher01_Y[SpeicherPosition] = Y;
				SchussSpeicher01_VonSchiff[SpeicherPosition] = VonSchiff;
				break;
			default: break;
			}
		}

		void PushObjektspeicherPositionen ( void )
		{
			Objektspeicher09_X->CopyTo(Objektspeicher10_X, 0);
			Objektspeicher09_Y->CopyTo(Objektspeicher10_Y, 0);
			Objektspeicher08_X->CopyTo(Objektspeicher09_X, 0);
			Objektspeicher08_Y->CopyTo(Objektspeicher09_Y, 0);
			Objektspeicher07_X->CopyTo(Objektspeicher08_X, 0);
			Objektspeicher07_Y->CopyTo(Objektspeicher08_Y, 0);
			Objektspeicher06_X->CopyTo(Objektspeicher07_X, 0);
			Objektspeicher06_Y->CopyTo(Objektspeicher07_Y, 0);
			Objektspeicher05_X->CopyTo(Objektspeicher06_X, 0);
			Objektspeicher05_Y->CopyTo(Objektspeicher06_Y, 0);
			Objektspeicher04_X->CopyTo(Objektspeicher05_X, 0);
			Objektspeicher04_Y->CopyTo(Objektspeicher05_Y, 0);
			Objektspeicher03_X->CopyTo(Objektspeicher04_X, 0);
			Objektspeicher03_Y->CopyTo(Objektspeicher04_Y, 0);
			Objektspeicher02_X->CopyTo(Objektspeicher03_X, 0);
			Objektspeicher02_Y->CopyTo(Objektspeicher03_Y, 0);
			Objektspeicher01_X->CopyTo(Objektspeicher02_X, 0);
			Objektspeicher01_Y->CopyTo(Objektspeicher02_Y, 0);
		}

		void PushSchussSpeicherPositionen ( void )
		{
			SchussSpeicher09_X->CopyTo(SchussSpeicher10_X, 0);
			SchussSpeicher09_Y->CopyTo(SchussSpeicher10_Y, 0);
			SchussSpeicher09_VonSchiff->CopyTo(SchussSpeicher10_VonSchiff, 0);
			SchussSpeicher08_X->CopyTo(SchussSpeicher09_X, 0);
			SchussSpeicher08_Y->CopyTo(SchussSpeicher09_Y, 0);
			SchussSpeicher08_VonSchiff->CopyTo(SchussSpeicher09_VonSchiff, 0);
			SchussSpeicher07_X->CopyTo(SchussSpeicher08_X, 0);
			SchussSpeicher07_Y->CopyTo(SchussSpeicher08_Y, 0);
			SchussSpeicher07_VonSchiff->CopyTo(SchussSpeicher08_VonSchiff, 0);
			SchussSpeicher06_X->CopyTo(SchussSpeicher07_X, 0);
			SchussSpeicher06_Y->CopyTo(SchussSpeicher07_Y, 0);
			SchussSpeicher06_VonSchiff->CopyTo(SchussSpeicher07_VonSchiff, 0);
			SchussSpeicher05_X->CopyTo(SchussSpeicher06_X, 0);
			SchussSpeicher05_Y->CopyTo(SchussSpeicher06_Y, 0);
			SchussSpeicher05_VonSchiff->CopyTo(SchussSpeicher06_VonSchiff, 0);
			SchussSpeicher04_X->CopyTo(SchussSpeicher05_X, 0);
			SchussSpeicher04_Y->CopyTo(SchussSpeicher05_Y, 0);
			SchussSpeicher04_VonSchiff->CopyTo(SchussSpeicher05_VonSchiff, 0);
			SchussSpeicher03_X->CopyTo(SchussSpeicher04_X, 0);
			SchussSpeicher03_Y->CopyTo(SchussSpeicher04_Y, 0);
			SchussSpeicher03_VonSchiff->CopyTo(SchussSpeicher04_VonSchiff, 0);
			SchussSpeicher02_X->CopyTo(SchussSpeicher03_X, 0);
			SchussSpeicher02_Y->CopyTo(SchussSpeicher03_Y, 0);
			SchussSpeicher02_VonSchiff->CopyTo(SchussSpeicher03_VonSchiff, 0);
			SchussSpeicher01_X->CopyTo(SchussSpeicher02_X, 0);
			SchussSpeicher01_Y->CopyTo(SchussSpeicher02_Y, 0);
			SchussSpeicher01_VonSchiff->CopyTo(SchussSpeicher02_VonSchiff, 0);
		}


		int NormalisierenX ( int WertX )
		{
			while (WertX < -512) WertX += 1024; // WertX normalisieren auf -512 ... 511
			while (WertX > 511) WertX -= 1024;
			return WertX;
		}

		int NormalisierenY ( int WertY )
		{
			while (WertY < -384) WertY += 768;  // WertY normalisieren auf -384 ... 383
			while (WertY > 383) WertY -= 768;
			return WertY;
		}

		void ObjektSchussSchnittpunkt( int ObjektSpeicherPosition )
		{
			// Verhltnis von X und Y an der Geschwindigkeit ermitteln
			double BewegungsanteilX = ObjektPPF_X[ObjektSpeicherPosition];// ObjektPPF bezieht sich auf 10 Frames
			double BewegungsanteilY = ObjektPPF_Y[ObjektSpeicherPosition];
			int TmpObjektPositionX = Objektspeicher01_X[ObjektSpeicherPosition];
			int TmpObjektPositionY = Objektspeicher01_Y[ObjektSpeicherPosition];
			int Vorhalten = 1;

			// abbrechen, bei 0 geschwindigkeit
			if ( BewegungsanteilY != 0 || BewegungsanteilX != 0 )
			{
				// jede Objektposition berechnen und Vergleichen mit Schussbahn
				TmpObjektPositionX += (BewegungsanteilX * Vorhalten);
				TmpObjektPositionY += (BewegungsanteilY * Vorhalten);
			}

			this->ObjektSchussSchnittpunktX = TmpObjektPositionX;
			this->ObjektSchussSchnittpunktY = TmpObjektPositionY;
		}

		bool ZuObjektLinksrumDrehen( int ObjektSpeicherPosition )
		{
			if ( Objektspeicher01[ObjektSpeicherPosition] == 0 // freier Slot ... nix zum rechnen da
				|| Objektspeicher01[ObjektSpeicherPosition] == 99 // Explosion ... nix zum rechnen da
				|| Objektspeicher01[ObjektSpeicherPosition] > Objektspeicher01Anzahl ) // ObjektID kann nicht hher sein als Objektspeicheranzahl
			{ 
				printf ( "ZuObjektLinksrumDrehen(): Fehler: Objektspeicher01[%d]=%d\n", ObjektSpeicherPosition, Objektspeicher01[ObjektSpeicherPosition] );
				return false; 
			} 
			
			// Wenn wir uns zum Objekt drehen, dann gleich zu einer ungefhren, potentiellen Abschussposition
			// Leider nicht mehr genug Zeit ... ein bischen vorhalten
			ObjektSchussSchnittpunkt( ObjektSpeicherPosition ); // Setzen der GlobalenVar ObjektSchussSchnittpunktX bzw. Y

			// Winkel zwischen Schiffposition, Objektposition und Winkel ermitteln
			//double AbstandX = this->Objektspeicher01_X[ObjektSpeicherPosition] - this->SchiffPositionX;
			//double AbstandY = this->Objektspeicher01_Y[ObjektSpeicherPosition] - this->SchiffPositionY;
			double AbstandX = this->ObjektSchussSchnittpunktX - this->SchiffPositionX;
			double AbstandY = this->ObjektSchussSchnittpunktY - this->SchiffPositionY;
			double Abstand = sqrt( pow(AbstandX, 2) + pow(AbstandY, 2) );
			double SinAlpha = AbstandY / Abstand;
			//double WinkelRad = asin(SinAlpha);
			WinkelRadZuObjekt = asin(SinAlpha);
			WinkelRadZuObjekt1 = WinkelRadZuObjekt;
			WinkelRadZuObjekt2 = acos(AbstandX / Abstand);
			//if ( WinkelRadZuObjekt < 0 ) { WinkelRadZuObjekt *= (-1); 
				//printf ( "%f<0\n" );
			//}

			double CosAlpha = AbstandX / Abstand;
			//double WinkelRadZuObjekt; // = acos(CosAlpha);

			if (SinAlpha < 0) // 0 - 90 - 180 Grad
			{
				if (CosAlpha < 0) { WinkelRadZuObjekt = acos(CosAlpha); } // 90 - 180 Grad
				else { WinkelRadZuObjekt = acos(CosAlpha); } // 0 - 90 Grad
			}
			else // 180 - 270 - 0 Grad
			{
				if (CosAlpha < 0) { WinkelRadZuObjekt = (2*Pi) - acos(CosAlpha); } // 180 - 270 Grad
				else { WinkelRadZuObjekt = (2*Pi) - acos(CosAlpha); }// 270 - 0 Grad
			}

			/*// 270[3/2Pi], 0[0 bzw 2Pi], 90[1/2Pi] Grad
			if (WinkelRAD > ((3/2)*Pi) || ( WinkelRAD >= 0 && WinkelRAD < (Pi/2) ) ) { 
				SchussZukunftX[i] = int(BewegungsanteilX * 7.875 * (i+1)); 
			}
			// 270, 180, 90 Grad
			if (WinkelRAD >= (Pi/2) && WinkelRAD <= ((3/2)*Pi)) { 
				SchussZukunftX[i] = int(BewegungsanteilX * 8 * (i+1)); 
			}

			// 0, 90, 180 Grad
			if (WinkelRAD >= 0 && WinkelRAD < Pi) { 
				SchussZukunftY[i] = int(BewegungsanteilY * 7.875 * (i+1));
			}
			// 180, 270, 360 Grad
			if (WinkelRAD >= Pi && WinkelRAD < (2*Pi)) { 
				SchussZukunftY[i] = int(BewegungsanteilY * 8 * (i+1));
			}*/


			// Schauen, wie Schiff aus Ausrichtungswinkel schneller zum gewnschten Winkel kommt
			int ZaehlerRechts = 0;
			int ZaehlerLinks = 0;
			int notaus = 0;

			if ( WinkelRadZuObjekt < (2*Pi) )
			{
				for ( int i = SchiffRichtungIndex; SchiffRichtungWinkelRadListe[i] > WinkelRadZuObjekt; i++ ) 
				{ 
					ZaehlerRechts++;
					//printf ( "  %d:%f>%f  ", i, SchiffRichtungWinkelRadListe[i], WinkelRadZuObjekt );
					if ( i == 255 ) { i = -1; }
					if ( notaus++ > 255 ) { /*printf ( "Notaus Rechtsdrehung\n" );*/ break; }
				}
				//printf ( "\n" );
			}

			if ( WinkelRadZuObjekt > 0 )
			{
				notaus = 0;
				for ( int i = SchiffRichtungIndex; SchiffRichtungWinkelRadListe[i] < WinkelRadZuObjekt; i-- ) 
				{ 
					ZaehlerLinks++; 
					if ( i == 0 ) { i = 256; }
					if ( notaus++ > 255 ) { /*printf ( "Notaus Linksdrehung\n" );*/ break; }
				}
			}

			if ( ZaehlerLinks < ZaehlerRechts ) { return true; }
			else { return false; }
		}

		int SchiffRichtungIndexDrehung ( int Aenderung, int SRIndex )
		{
			int neuerSRIndex = SRIndex + Aenderung; 

			while ( neuerSRIndex >= 256 ) neuerSRIndex -= 256;
			while ( neuerSRIndex < 0 ) neuerSRIndex += 256;
			return neuerSRIndex;
		}

		bool FeuerFreigabe( void )
		{
			// schuss letztes Frame?
			if ( SchussLetztesFrame ) 
			{ 
				return false; 
			} else { 
				SchussDiesesFrame = true;
				return true; 
			}
		}

		void SetzeObjektRadar ( int Objekt, int ObjektX, int ObjektY, int ObjektTyp, int ObjektSkalierung, int ObjektElement )
		{
			ObjektRadar[ObjektElement] = Objekt;
			ObjektRadarX[ObjektElement] = ObjektX;
			ObjektRadarY[ObjektElement] = 767 - ObjektY;
			ObjektRadarTyp[ObjektElement] = ObjektTyp; 
			ObjektRadarSkalierung[ObjektElement] = ObjektSkalierung;
		}

		int min_dist_UfoSchuss( void ) 
		{
			int min_dist = 2000*2000;
			for ( int i = 0; i < this->MAX_SCHUESSE; i++ )
			{
				if ( this->SchussSpeicher01_VonSchiff[i] == false )
				{
					double AbstandSchussSchiffX = this->SchussSpeicher01_X[i] - this->SchiffPositionX;
					double AbstandSchussSchiffY = this->SchussSpeicher01_Y[i] - this->SchiffPositionY;
					int tmp_min_dist = pow( AbstandSchussSchiffX, 2) + pow( AbstandSchussSchiffY, 2);
					if (tmp_min_dist < min_dist) { min_dist = tmp_min_dist; } 
				}
			}
			return min_dist;
		}

		void Spiel3(void) // Wir animieren unseren Spieler zum spielen ...
		{
			FramePacket frame;
			KeysPacket keys;
			GameStatus game;
			char prevframe = 0;
			int t = 0;
			int OutOfSyncZaehler = 0;
			int HyperspaceZaehler = 0;
			bool StehendesSchiff = true;
			bool RumzappelnDiesesFrame = false;
			bool RumzappelnLetztesFrame = false;
			bool RumzappelnVorLetztesFrame = false;
			bool Rumzappeln = false;
			int LatenzListePosition = 0;
			int SchusswinkelRadIndex = 0;

			for (;;) // Hr ja nicht mit zocken auf!!!
			{
				++t;         // Zeit
				++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
				LatenzListePosition = t % this->LATENZPAKETE;
				this->LatenzSyncPaketListe[LatenzListePosition] = keys.ping;
				SendPacket(keys);
				ReceivePacket(frame);

				if (frame.frameno != ++prevframe || frame.ping != keys.ping) // Sync kontrollieren
				{
					printf("Latenz %d. %d Frames verloren. KEY:%d FRAME:%d\n", keys.ping - frame.ping, frame.frameno - prevframe, keys.ping, frame.ping);
					if ( frame.frameno - prevframe >= 0 ) { OutOfSyncZaehler += frame.frameno - prevframe; 
					} else { OutOfSyncZaehler = 1000; }
					prevframe = frame.frameno;
				} else { // Rckgelieferte Pakete OK - Was hat das key Ping fr einen Wert?
					for ( int i = 0; i > this->LATENZPAKETE; i++ ) {
						if ( this->LatenzSyncPaketListe[i] == keys.ping ) 
						{	 
							if ( this->LatenzSyncLinksListe[i] ) { SchusswinkelRadIndex = SchiffRichtungIndexDrehung( -1, SchiffRichtungIndex );
							} else { SchusswinkelRadIndex = SchiffRichtungIndexDrehung( +1, SchiffRichtungIndex ); }
						}
					}
				}


				InterpretScreen(frame, game); // Das aktuelle Frame und den Spielstatus an ScreenInterpreter geben
				// Die Objekte aus dem letzten InterpretScreen werden von Objektspeicher00 in Objektspeicher01 einsortiert
				// und die der letzten n Frames einen Objektspeicher weiter geschoben. 
				// Objektspeicher01 = aktuellstes Frame, Objektspeicher05 = ltestes Frame
				PushObjektspeicher();
				PushSchussSpeicher();
				Objektgeschwindigkeiten();
				Schussgeschwindigkeiten();

				keys.clear();   // alle Tasten loslassen
				int min_dist = 0x7fffffff; // Far, far away ...
				int min_dx = 0;
				int min_dy = 0;
				int min_ObjektSpeicherPosition;
				if (game.ship_present && SteuerungAutomatik) // Wenn unser Spacefighter bereit ist ...
				{
					// Strategieauswahl
					//switch ( FeuerStrategie )
					switch ( FeuerStrategie )
					{
					case 1:
						break;
					default:
						//for (int i=0; i<game.nasteroids; ++i)
						for (int i=0; i < this->MAX_OBJEKTE; ++i)
						{   // nchstgelegenen Asteroiden suchen
							//int dx = game.asteroids[i].x - game.ship_x;
							int dx = this->Objektspeicher01_X[i] - this->SchiffPositionX;
							dx = NormalisierenX( dx );
							//int dy = game.asteroids[i].y - game.ship_y;
							int dy = this->Objektspeicher01_Y[i] - this->SchiffPositionY;
							dy = NormalisierenY( dy );
							int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
							//switch (game.asteroids[i].sf)
							switch (this->Objektspeicher01_Groesse[i])
							{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
								case 0:  // groer Asteroid: 20 Pkt
									dist -= 40*40;
									break;
								case 15: // mittlerer Asteroid: 50 Pkt
									dist -= 20*20;
									break;
								case 14: // kleiner Asteroid: 100 Pkt
									dist -= 8*8;
									break;
							}
							if (dist < min_dist 
								&& this->Objektspeicher01_Typ[i] >= 1 
								&& this->Objektspeicher01_Typ[i] <= 5 )
							{
								min_dist = dist;
								min_dx = dx;
								min_dy = dy;
								min_ObjektSpeicherPosition = i;
							}
						} // nchsten Asteroid gesucht

						/*if (game.saucer_present) // nach Ufos schauen
						{
							//int dx = game.saucer_x - game.ship_x;
							int dx = game.saucer_x - this->SchiffPositionX;
							dx = NormalisierenX( dx );
							//int dy = game.saucer_y - game.ship_y;
							int dy = game.saucer_y - this->SchiffPositionY;
							dy = NormalisierenY( dy );
							int dist = dx*dx+dy*dy;
							switch (game.saucer_size)
							{	// Abstand um den ungefhren Radius des UFOs korrigieren
							case 15: // groes UFO: 200 Pkt
								dist -= 20*12;
								break;
							case 14: // kleines UFO: 1000 Pkt
								dist -= 10*6;
								break;
							}
							if (dist < min_dist)
							{
								min_dist = dist;
								min_dx = dx;
								min_dy = dy;
							}
						}*/
						if (min_dist > 400*400 && Objektspeicher01Anzahl > 0 && Objektspeicher01Anzahl < 4 ) // beschleunigen, wenn nichts in der Nhe
						{
							keys.thrust(true);
							StehendesSchiff = false;
						} else { StehendesSchiff = true; }


						if ( OutOfSyncZaehler > 3 || HyperspaceZaehler >= 1) 
						{
							KalibrierungAngefordert = true;
							SchiffRichtungKalibrieren = true;
						}
						if ( (Objektspeicher01Anzahl == 0 && Objektspeicher03Anzahl == 0) 
							|| KalibrierungAngefordert ) {
							if ( SchiffRichtungKalibrierungCheck() ) {
								OutOfSyncZaehler = 0;
								HyperspaceZaehler = 0;
							}
						}
						
						Rumzappeln = false;
						RumzappelnVorLetztesFrame = RumzappelnLetztesFrame;
						RumzappelnLetztesFrame = RumzappelnDiesesFrame;
						// Wenn Schiffsrichtung kalibriert wird, nicht drehen, auer ein Ufo ist da
						if ( (SchiffRichtungKalibrieren == false || this->UFODiesesFrame) && StehendesSchiff ) 
						{					
							// Wenn sich Schiff bewegt, gibt es keine Kalibrierschuesse
							KalibrierschussAnzahl = 0;

							// Schiff in Richtung auf das nchstgelegene Objekt drehen
							// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
							// ship_dx/y/0 und min_dx/y/0 berechnet
							//int tmpx = this->SchiffRichtungX;
							//int tmpy = this->SchiffRichtungY;
							//if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
							//if (this->Objektspeicher01_X[min_ObjektSpeicherPosition] * this->SchiffRichtungWeitY - this->Objektspeicher01_Y[min_ObjektSpeicherPosition] * this->SchiffRichtungWeitX > 0)
							///if (this->SchiffRichtungX * min_dy - this->SchiffRichtungY * min_dx > 0) 

							// Wir kennen die ObjektSpeicherposition des nchst gelegenen Objektes.
							// Dort drehen wir uns dann hin ... Sollen wir nach links drehen?
							if ( ZuObjektLinksrumDrehen( min_ObjektSpeicherPosition ) )
							{
								keys.left(true);
								if ( --SchiffRichtungIndex < 0 ) { SchiffRichtungIndex = 255; }
								RumzappelnDiesesFrame = true;
								this->LatenzSyncLinksListe[LatenzListePosition] = true;
							}
							else
							{
								keys.right(true);
								if ( ++SchiffRichtungIndex > 255 ) { SchiffRichtungIndex = 0; }
								RumzappelnDiesesFrame = false;
								this->LatenzSyncLinksListe[LatenzListePosition] = false;
							}
						}
						if ( (RumzappelnDiesesFrame && !RumzappelnLetztesFrame && RumzappelnVorLetztesFrame)
							|| (!RumzappelnDiesesFrame && RumzappelnLetztesFrame && !RumzappelnVorLetztesFrame) )
						{
							Rumzappeln = true;
						}

						
						//if (min_dist < 27*27)  // Flucht, wenn Kollision unausweichlich
						//if (min_dist < 32*32 || min_dist_UfoSchuss() < 45*45)  // Flucht, wenn Kollision unausweichlich
						if ( min_dist < 32*32 )  // Flucht, wenn Kollision unausweichlich
						{
							keys.hyperspace(true);
							HyperspaceZaehler++;
						}


						// Start Feuerkonditionen
						SchussLetztesFrame = SchussDiesesFrame;
						SchussDiesesFrame = false;

						if ( SchiffRichtungKalibrieren && SchiffRichtungBraucheKalibrierfeuer )  // Feuerknopf drcken, jeden 2. Takt oder bei Kalibrierung
						{
							if ( FeuerFreigabe() ) keys.fire(true);
							KalibrierschussAnzahl++;
						}
						//if ( t % 15 == 0 && Dauerfeuer ) keys.fire(true);
						SchusswinkelRadIndex = SchiffRichtungIndex;
						//if ( keys.get_left() ) SchusswinkelRadIndex = SchiffRichtungIndexDrehung( -1, SchiffRichtungIndex );
						//if ( keys.get_right() ) SchusswinkelRadIndex = SchiffRichtungIndexDrehung( +1, SchiffRichtungIndex );
						SchussZukunftBerechnen ( SchiffPositionX, SchiffPositionY, SchusswinkelRadIndex );
						// Flugbahnen der Asteroiden und Ufos ber die LEBENSDAUER_SCHUSS berechnen
						// Vergleichen, ob ein Objekt in die Flugbahn des Schusses gelangt
						// Wenn ja, dann Feuern ... wenn groer Asteroid eine Salve feuern
						ZielObjektID = TrefferMoeglich();
						if ( ZielObjektID <= MAX_OBJEKTE && !SchiffRichtungKalibrieren )
						{
							if ( FeuerFreigabe() ) keys.fire(true);
							//printf("ZielObjektID: %d\n", ZielObjektID);
						}
						// Diverse Feuerkonditionen
						if ( (t % 15) == 0 && 
							 ( this->Objektspeicher01Anzahl <= 3 || Rumzappeln ) )
						{
							if ( FeuerFreigabe() ) keys.fire(true);
						}				
						// Aus der Kalibration und UFO da ... Panikballern
						if ( (t % 15) == 0 && SchiffRichtungKalibrieren && this->UFODiesesFrame )
						{
							if ( FeuerFreigabe() ) keys.fire(true);
						}
						//Ende Feuerkonditionen

						break;
					} // Ende Default-Strategie
				} // Ende if, Spacefighter bereit

				// Manuelle Steuerung
				if (SteuerungAutomatik == false)
				{
					if (SendeLinks) 
					{ 
						SendeLinks = false; 
						keys.left(true); 
						if ( --SchiffRichtungIndex < 0 ) { SchiffRichtungIndex = 255; }
					}
					if (SendeRechts) 
					{
						SendeRechts = false; 
						keys.right(true); 
						if ( ++SchiffRichtungIndex > 255 ) { SchiffRichtungIndex = 0; }
					}
					if (SendeBeschleunigung) { SendeBeschleunigung = false; keys.thrust(true); }
					if (SendeFeuer) { SendeFeuer = false; keys.fire(true); }
					if (SendeHyperspace) { SendeHyperspace = false;	keys.hyperspace(true); }
				}

				if (StopThread) { break; }
			} // Ende Dauerzock for-schleife
		}

///////////////////////////////

		void InterpretScreen(FramePacket &packet, GameStatus& game)
		{
			unsigned short *vector_ram = (unsigned short *)packet.vectorram;
			int dx, dy, sf, vx, vy, vz, vs;
			int v1x = 0;
			int v1y = 0;
			int shipdetect = 0;

			UFOLetztesFrame = UFODiesesFrame;
			UFODiesesFrame = false;
			ObjektRadarElement = 0;
			Objektspeicher00Zaehler = 0;
			SchussSpeicher00Zaehler = 0;

			game.clear();
			if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
				return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

			int pc = 1;
			for (;;) // alle Objekte des Vektorrams auslesen und abspeichern
			{
				//fprintf(stderr, "DEBUG: ObjektRadarElement: %d\n", ObjektRadarElement);
				int op = vector_ram[pc] >> 12;
				switch (op)
				{
				case 0xa: // LABS - Strahlpositionierung
					vy = vector_ram[pc] & 0x3ff;
					vy -= 128;
					vx = vector_ram[pc+1] & 0x3ff;
					vs = vector_ram[pc+1] >> 12;
					break;
				case 0xb: // HALT - Ende
					// Ein letztes Leerzeichen setzen, damit der letzte Text auf dem Radar erscheint
					SetzeObjektRadar(36, 0, 0, 9, vs, ObjektRadarElement++);
					return;
				case 0xc: // JSRL - Adr2Stack + zu Subroutine springen
					switch (vector_ram[pc] & 0xfff) // welche Subroutine?
					{
					case 0x8f3: // Asteroid Typ1
						game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
						// ObjektRadar, ObjektRadarX, ObjektRadarY, ObjektRadarTyp, ObjektRadarSkalierung, ObjektRadarElement
						SetzeObjektRadar(1, vx, vy, 1, vs, ObjektRadarElement++);
						//Objektspeicher00[Objektspeicher00Zaehler] = ++Objektspeicher00Anzahl;
						//Objektspeicher00Zaehler++;
						SetzeObjektspeicher ( 0, ++Objektspeicher00Anzahl, 999, vx, vy, 1, vs ); // 999 ist nur ein Platzhalter
						break;
					case 0x8ff: // Asteroid Typ2
						game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
						SetzeObjektRadar(2, vx, vy, 2, vs, ObjektRadarElement++);
						SetzeObjektspeicher ( 0, ++Objektspeicher00Anzahl, 999, vx, vy, 2, vs );
						break;
					case 0x90d: // Asteroid Typ3
						game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
						SetzeObjektRadar(3, vx, vy, 3, vs, ObjektRadarElement++);
						SetzeObjektspeicher ( 0, ++Objektspeicher00Anzahl, 999, vx, vy, 3, vs );
						break;
					case 0x91a: // Asteroid Typ4
						game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
						SetzeObjektRadar(4, vx, vy, 4, vs, ObjektRadarElement++);
						SetzeObjektspeicher ( 0, ++Objektspeicher00Anzahl, 999, vx, vy, 4, vs );
						break;
					case 0x929: // UFO
						game.saucer_present = true;
						UFODiesesFrame = true;
						game.saucer_x = vx;
						game.saucer_y = vy;
						game.saucer_size = vs;
						SetzeObjektRadar(5, vx, vy, 1, vs, ObjektRadarElement++);
						SetzeObjektspeicher ( 0, ++Objektspeicher00Anzahl, 999, vx, vy, 5, vs );
						break;
					// Raumschiff (Lebenszhler)
					case 0xA6D: SetzeObjektRadar(9, vx, vy, 9, vs, ObjektRadarElement++); break; // ^
					// Buchstaben / Ziffern: A-Z 1-9
					case 0xA78: SetzeObjektRadar(10, vx, vy, 9, vs, ObjektRadarElement++); break; // A
					case 0xA80: SetzeObjektRadar(11, vx, vy, 9, vs, ObjektRadarElement++); break; // B
					case 0xA8D: SetzeObjektRadar(12, vx, vy, 9, vs, ObjektRadarElement++); break; // C ...
					case 0xA93: SetzeObjektRadar(13, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xA9B: SetzeObjektRadar(14, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAA3: SetzeObjektRadar(15, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAAA: SetzeObjektRadar(16, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAB3: SetzeObjektRadar(17, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xABA: SetzeObjektRadar(18, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAC1: SetzeObjektRadar(19, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAC7: SetzeObjektRadar(20, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xACD: SetzeObjektRadar(21, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAD2: SetzeObjektRadar(22, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAD8: SetzeObjektRadar(23, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xADD: SetzeObjektRadar(24, vx, vy, 9, vs, ObjektRadarElement++); break; // O bzw. 0 (Null)
					case 0xAE3: SetzeObjektRadar(25, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAEA: SetzeObjektRadar(26, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAF3: SetzeObjektRadar(27, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xAFB: SetzeObjektRadar(28, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB02: SetzeObjektRadar(29, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB08: SetzeObjektRadar(30, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB0E: SetzeObjektRadar(31, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB13: SetzeObjektRadar(32, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB1A: SetzeObjektRadar(33, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB1F: SetzeObjektRadar(34, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB26: SetzeObjektRadar(35, vx, vy, 9, vs, ObjektRadarElement++); break; // Z
					case 0xB2C: SetzeObjektRadar(36, vx, vy, 9, vs, ObjektRadarElement++); break; // Leerzeichen
					case 0xB2E: SetzeObjektRadar(37, vx, vy, 9, vs, ObjektRadarElement++); break; // 1 ...
					case 0xB32: SetzeObjektRadar(38, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB3A: SetzeObjektRadar(39, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB41: SetzeObjektRadar(40, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB48: SetzeObjektRadar(41, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB4F: SetzeObjektRadar(42, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB56: SetzeObjektRadar(43, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB5B: SetzeObjektRadar(44, vx, vy, 9, vs, ObjektRadarElement++); break;
					case 0xB63: SetzeObjektRadar(45, vx, vy, 9, vs, ObjektRadarElement++); break; // 9
					// Explosionsanimation
					case 0x880: 
						SetzeObjektRadar(50, vx, vy, 8, vs, ObjektRadarElement++); 
						//Objektspeicher00[Objektspeicher00Zaehler] = 99; // Explosionen mit 99 Kennzeichnen
						//Objektspeicher00Zaehler++; // Trotz Explosion weiterzhlen, damit folgende Objekte richtig bezeichnet werden
						SetzeObjektspeicher ( 0, 99, 999, vx, vy, 50, vs );
						break; 
					case 0x896: 
						SetzeObjektRadar(51, vx, vy, 8, vs, ObjektRadarElement++); 
						SetzeObjektspeicher ( 0, 99, 999, vx, vy, 51, vs );
						break; 
					case 0x8b5: 
						SetzeObjektRadar(52, vx, vy, 8, vs, ObjektRadarElement++); 
						SetzeObjektspeicher ( 0, 99, 999, vx, vy, 52, vs );
						break; 
					case 0x8d0: 
						SetzeObjektRadar(53, vx, vy, 8, vs, ObjektRadarElement++); 
						SetzeObjektspeicher ( 0, 99, 999, vx, vy, 53, vs );
						break; 
					}
					break;
				case 0xd: // RTSL - Ende Subroutine: Stack2Adr + zurck
					// Ein letztes Leerzeichen setzen, damit der letzte Text auf dem Radar erscheint
					SetzeObjektRadar(36, 0, 0, 9, vs, ObjektRadarElement++);
					return;
				case 0xe: // JMPL - Sprung an Adr ohne Rcksprungadr zu sichern
					/*
					pc = vector_ram[pc] & 0xfff;
					break;
					*/
					// Ein letztes Leerzeichen setzen, damit der letzte Text auf dem Radar erscheint
					SetzeObjektRadar(36, 0, 0, 9, vs, ObjektRadarElement++);
					return;
				case 0xf: // SVEC - zeichnen eines kurzen Vektors ... wozu?
					/*
					dy = vector_ram[pc] & 0x300;
					if ((vector_ram[pc] & 0x400) != 0)
						dy = -dy;
					dx = (vector_ram[pc] & 3) << 8;
					if ((vector_ram[pc] & 4) != 0)
						dx = -dx;
					sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
					vz = (vector_ram[pc] & 0xf0) >> 4;
					*/
					break;
				default:
					dy = vector_ram[pc] & 0x3ff;
					if ((vector_ram[pc] & 0x400) != 0)
						dy = -dy;
					dx = vector_ram[pc+1] & 0x3ff;
					if ((vector_ram[pc+1] & 0x400) != 0)
						dx = -dx;
					sf = op;
					vz = vector_ram[pc+1] >> 12;
					if (dx == 0 && dy == 0 && vz == 15) // Schusserkennung
					{
						game.shots[game.nshots++].set(vx, vy);
						SetzeObjektRadar(6, vx, vy, 1, vs, ObjektRadarElement++);
						//SetzeObjektspeicher(0, ++Objektspeicher00Anzahl, 999, vx, vy );
						SetzeSchussSpeicher(0, ++SchussSpeicher00Anzahl, 999, vx, vy, true );
						if ( SchiffRichtungKalibrieren && SchiffRichtungBraucheKalibrierfeuer ) 
						{
							SchiffRichtungBraucheKalibrierfeuer = false;
							SchiffRichtungKalibrierfeuerX = vx;
							SchiffRichtungKalibrierfeuerY = vy;
						}
					}
					if (op == 6 && vz == 12 && dx != 0 && dy != 0) // Schiffszeichnung Identifiziert
					{
						switch (shipdetect)
						{
						case 0:
							v1x = dx;
							v1y = dy;
							++shipdetect;
							//SchiffRichtungBraucheKalibrierfeuer = true;
							break;
						case 1:
							game.ship_present = true;
							game.ship_x = vx;
							game.ship_y = vy;
							game.ship_dx = v1x - dx;
							game.ship_dy = v1y - dy;
							// Setzen fr Radar
							SchiffPositionX = vx;
							//SchiffPositionY = game.ship_y - 128; // Offset abziehen
							SchiffPositionY = vy; // Offset abziehen
							this->SchiffRichtungWeitX = v1x - dx;
							this->SchiffRichtungWeitY = v1y - dy;
							/*tmp_v1x = v1x;
							tmp_v1y = v1y;
							tmp_dx = dx;
							tmp_dy = dy;
							SchiffRichtungX = game.ship_dx;
							SchiffRichtungY = game.ship_dy;*/
							SchiffRichtungSetzen( SchiffPositionX, SchiffPositionY, SchiffRichtungIndex );
							//SchiffRichtungSetzen( SchiffPositionX, SchiffPositionY, 133 );
							++shipdetect;
							SetzeObjektRadar(0, vx, vy, 1, vs, ObjektRadarElement++);
							break;
						}
					}
					else if (shipdetect == 1)
						shipdetect = 0;

					break;
				}
				if (op <= 0xa)
					++pc;
				if (op != 0xe) // JMPL - Sprung an Adr ohne Rcksprungadr zu sichern
					++pc;
			}   
		}

		//void ReceivePacket(FramePacket &packet);
		void ReceivePacket(FramePacket &packet)
		{
			sockaddr_in sender;
			int sender_size = sizeof sender;
			fd_set readfds, writefds, exceptfds;

			do
			{
				FD_ZERO(&readfds);
				FD_ZERO(&writefds);
				FD_ZERO(&exceptfds);
				FD_SET(sd, &readfds);
				FD_SET(sd, &exceptfds);
				select(sd+1, &readfds, &writefds, &exceptfds, NULL);
				int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
				if (bytes_received != sizeof packet)
				{
					int err = WSAGetLastError();
					fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
					exit(1);
				}
				FD_ZERO(&readfds);
				FD_ZERO(&writefds);
				FD_ZERO(&exceptfds);
				FD_SET(sd, &readfds);
				timeval zero;
				zero.tv_sec = zero.tv_usec = 0;
				select(sd+1, &readfds, &writefds, &exceptfds, &zero);
			} while(FD_ISSET(sd, &readfds));
		}

		//void SendPacket(KeysPacket &packet);
		void SendPacket(KeysPacket &packet)
		{
			sockaddr_in server;
			memset(&server, 0, sizeof server);
			server.sin_family = AF_INET;
			server.sin_port = htons(1979);
			server.sin_addr.s_addr = server_ip;
			if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
			{
				int err = WSAGetLastError();
				if (err != WSAEWOULDBLOCK)
				{
					fprintf(stderr, "Fehler %d bei sendto().\n", err);
					exit(1);
				}
			}
		}

	private:
		SOCKET sd;
		ADDRESS server_ip;
	};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   public ref class Radarbild: public Form
   {
   private:
      BufferedGraphicsContext^ context;
      BufferedGraphics^ grafx;
	  System::Windows::Forms::Timer^ timer1;
      System::Windows::Forms::Timer^ timer2;
	  long FrameZaehler;
	  long LetzterFrameZaehler;
	  int FramesProSekunde;
	  int SchiffPositionX;
	  int SchiffPositionY;
	  int SchiffRichtungX;
	  int SchiffRichtungY;
	  Thread^ BerechnungsThread;
	  Thread^ BerechnungsThread2;
	  Player2^ Spieler;
	  bool ZeigeHilfe;
	  bool ZeigeObjektspeicher;
	  bool ZeigeRadarStatus;
	  bool ZeigeObjektbewegung;
	  bool ZeigeObjektIDs;
	  bool ZeigeObjektvektoren;
	  bool ZeigeSchussZukunft;
	  bool ZeigeSchussSpeicher;
	  bool ZeigeSchussZukunftListe;

   public:
      Radarbild(unsigned long server_ip, SOCKET sd) : Form()
      {
		 // Anzeigevariablen setzen
		 ZeigeHilfe = false;
		 ZeigeObjektspeicher = false;
		 ZeigeRadarStatus = false;
		 ZeigeObjektbewegung = false;
		 ZeigeObjektIDs = false;
		 ZeigeObjektvektoren = false;
		 ZeigeSchussSpeicher = false;
		 ZeigeSchussZukunftListe = false;

		 // Die Koordinatenberechnung der Objekte in einem neuen Thread starten
		 Spieler = gcnew Player2(sd, server_ip); // OK, hier geht es los ...
		 BerechnungsThread = gcnew Thread( gcnew ThreadStart( Spieler, &Player2::Spiel3 ));	 
		 BerechnungsThread->Start();

		 // Fenster konfigurieren
		 this->Size = System::Drawing::Size(1033, 796);
		 this->Text = "AsteroidsAutopilot mit Radar - M. Niemeyer fr c't:creativ'08";
         this->MouseDown += gcnew MouseEventHandler( this, &Radarbild::MouseDownHandler );
		 this->KeyDown += gcnew KeyEventHandler( this, &Radarbild::KeyDownHandler );
		 this->KeyPress += gcnew KeyPressEventHandler( this, &Radarbild::KeyPressHandler );
         this->Resize += gcnew EventHandler( this, &Radarbild::OnResize );
		 
         // Ein Timer fr Grafikupdates.
         timer1 = gcnew System::Windows::Forms::Timer;
         timer1->Interval = 31; // ergibt ungefhr 32 FPS
         timer1->Tick += gcnew EventHandler( this, &Radarbild::OnTimer );
		 timer1->Start(); // direkt starten

		 // Ein zweiter Timer zum bestimmen der FPS unseres Radarbildes
         timer2 = gcnew System::Windows::Forms::Timer;
         timer2->Interval = 1000;
		 timer2->Tick += gcnew EventHandler( this, &Radarbild::OnTimer2 );
		 timer2->Start();

		 // allgemeine initialisierung
		 FrameZaehler = 0;

		 // Anlegen des Grafikpuffers
         context = BufferedGraphicsManager::Current;
         context->MaximumBuffer = System::Drawing::Size( this->Width + 1, this->Height + 1 );
		 grafx = context->Allocate( this->CreateGraphics(), System::Drawing::Rectangle(0,0,this->Width,this->Height) );

		 // das 1. Frame in den Puffer zeichnen
         RadarbildZeichnen( grafx->Graphics );
      }

	  ~Radarbild()
	  {
		  Spieler->StopThread = true;
		  BerechnungsThread->Abort();
	  }

	  void SetzeSchiffsPosition( int PositionX, int PositionY, int SchiffRichtungX, int SchiffRichtungY ) {
		  this->SchiffPositionX = PositionX;
		  //this->SchiffPositionY = 767 - PositionY; // Y-Achse invertieren damit Richtung im Radar korrekt
		  this->SchiffPositionY = 767 - PositionY; // Y-Achse invertieren damit Richtung im Radar korrekt
		  this->SchiffRichtungX = SchiffRichtungX;
		  //this->SchiffRichtungY = 767 - (Spieler->SchiffPositionY - (SchiffRichtungY - Spieler->SchiffPositionY)); // Y-Achse invertieren damit Richtung im Radar korrekt
		  this->SchiffRichtungY = 767 - (Spieler->SchiffPositionY - (SchiffRichtungY - Spieler->SchiffPositionY)); // Y-Achse invertieren damit Richtung im Radar korrekt
	  }

   private:
      void MouseDownHandler( Object^ /*sender*/, MouseEventArgs^ e )
      {
         // Bei Rechtsklick wiedergabe anhalten bzw. das aktuelle Radar zeichnen
		 if ( e->Button == ::MouseButtons::Right )
         {
			if ( timer1->Enabled ) {
				timer1->Stop();
				timer2->Stop();
			} else {
				// ein einzelnes Frame zeichnen
				RadarbildZeichnen( grafx->Graphics );
				grafx->Render( Graphics::FromHwnd( this->Handle ) );
			}
         }

		 // Bei doppelrechtsklick starten
		 if ( e->Button == ::MouseButtons::Left )
         {
            // Timer zum Zeichnen benutzen
			 if ( !timer1->Enabled ) {
				timer1->Start();
				timer2->Start();
			}
         }
      }

      void KeyPressHandler( Object^ /*sender*/, KeyPressEventArgs^ e )
	  {
		 switch ( e->KeyChar )
         {
		 // Taste Q: links durchreichen
		 case ( ::Keys::Q ): 
			 Spieler->SendeLinks = true;
			 break;
		 // Taste W: rechts durchreichen
		 case ( ::Keys::W ): 
			 Spieler->SendeRechts = true;
			 break;
		 // Taste I: beschleunigen durchreichen
		 case ( ::Keys::I ): 
			 Spieler->SendeBeschleunigung = true;
			 break;
		 // Taste O: Feuern durchreichen
		 case ( ::Keys::O ): 
			 Spieler->SendeFeuer = true;
			 break;
		 // Taste SPACE: Hyperspace durchreichen
		 case ( ::Keys::Space ): 
			 Spieler->SendeHyperspace = true;
			 break;
		 }
		 //fprintf(stderr, "DEBUG: Keypress detected\n");
	  }

      void KeyDownHandler( Object^ /*sender*/, KeyEventArgs^ e )
      {
		 switch ( e->KeyCode )
         {
		 // Taste F: aktuelles Einzelframe Zeichnen
		 case ( ::Keys::F ): 
			if ( timer1->Enabled ) {
				timer1->Stop();
				timer2->Stop();
			} else {
				// ein einzelnes Frame zeichnen
				RadarbildZeichnen( grafx->Graphics );
				grafx->Render( Graphics::FromHwnd( this->Handle ) );
			}
			break;
		 // Taste B: Objektbewegung einblenden
		 case ( ::Keys::B ):
			 if (ZeigeObjektbewegung) { ZeigeObjektbewegung = false; } else { ZeigeObjektbewegung = true; } 
			 break;
		 // Taste D: ObjektIDs ( Position in den ObjektspeicherArrays ) einblenden
		 case ( ::Keys::D ):
			 if (ZeigeObjektIDs) { ZeigeObjektIDs = false; } else { ZeigeObjektIDs = true; } 
			 break;
		 // Taste F: Dauerfeuer an/aus
		 case ( ::Keys::G ):
			 if (Spieler->Dauerfeuer) { Spieler->Dauerfeuer = false; } else { Spieler->Dauerfeuer = true; } 
			 break;
		 // Taste H: Hilfe einblenden
		 case ( ::Keys::H ):
			 if (ZeigeHilfe) { ZeigeHilfe = false; } else { ZeigeHilfe = true; } 
			 break;
		 // Taste K: Kalibrierung auslsen
		 case ( ::Keys::K ):
			 if (Spieler->SchiffRichtungKalibrieren == false) { Spieler->SchiffRichtungKalibrieren = true; Spieler->SchiffRichtungBraucheKalibrierfeuer = true; }  
			 break;
		 // Taste L: Objektspeicher einblenden
		 case ( ::Keys::L ):
			 if (ZeigeObjektspeicher) { ZeigeObjektspeicher = false; } else { ZeigeObjektspeicher = true; }
			 break;
		 // Taste M: Manuelle Steuerung an/aus
		 case ( ::Keys::M ):
			 if (Spieler->SteuerungAutomatik) { Spieler->SteuerungAutomatik = false; } else { Spieler->SteuerungAutomatik = true; }
			 break;
		 // Taste S: Status des Radar einblenden
		 case ( ::Keys::S ):
			 if (ZeigeRadarStatus) { ZeigeRadarStatus = false; } else { ZeigeRadarStatus = true; }
			 break;
		 // Taste V: Bewegungsvektoren der Objekte einblenden
		 case ( ::Keys::V ):
			 if (ZeigeObjektvektoren) { ZeigeObjektvektoren = false; } else { ZeigeObjektvektoren = true; }
			 break;
		 // Taste Z: zuknftige Schussbahn anzeigen, wenn jetzt gefeuert wird
		 case ( ::Keys::Y ):
			 if (ZeigeSchussZukunftListe) { ZeigeSchussZukunftListe = false; } else { ZeigeSchussZukunftListe = true; }
			 break;
		 // Taste Z: zuknftige Schussbahn anzeigen, wenn jetzt gefeuert wird
		 case ( ::Keys::Z ):
			 if (ZeigeSchussZukunft) { ZeigeSchussZukunft = false; } else { ZeigeSchussZukunft = true; }
			 break;
		 // Taste Q: links durchreichen
		 case ( ::Keys::Q ): 
			 Spieler->SendeLinks = true;
			 break;
		 // Taste W: rechts durchreichen
		 case ( ::Keys::W ): 
			 Spieler->SendeRechts = true;
			 break;
		 // Taste I: beschleunigen durchreichen
		 case ( ::Keys::I ): 
			 Spieler->SendeBeschleunigung = true;
			 break;
		 // Taste O: Feuern durchreichen
		 case ( ::Keys::O ): 
			 Spieler->SendeFeuer = true;
			 break;
		 // Taste SPACE: Hyperspace durchreichen
		 case ( ::Keys::Space ): 
			 Spieler->SendeHyperspace = true;
			 break;
		 // Taste ESC: Programm beenden
		 case ( ::Keys::Escape ): 
			 this->~Radarbild();
			 break;
         }
      }

   private:
      void OnTimer( Object^ /*sender*/, EventArgs^ /*e*/ )
      {
		  // Grafik in Buffer schreiben und ausgeben
		  RadarbildZeichnen( grafx->Graphics );
		  grafx->Render( Graphics::FromHwnd( this->Handle ) );
      }

	  void OnTimer2( Object^ /*sender*/, EventArgs^ /*e*/ )
      {
		  FramesProSekunde = FrameZaehler - LetzterFrameZaehler;
		  LetzterFrameZaehler = FrameZaehler;
		  //Console::WriteLine("test");
	  }

      void OnResize( Object^ /*sender*/, EventArgs^ /*e*/ )
      {
         // Grafikpuffer an genderte Fenstergren anpassen
         context->MaximumBuffer = System::Drawing::Size( this->Width + 1, this->Height + 1 );
         if ( grafx != nullptr )
         {
            delete grafx;
            grafx = nullptr;
         }
         grafx = context->Allocate( this->CreateGraphics(), System::Drawing::Rectangle(0,0,this->Width,this->Height) );
         RadarbildZeichnen( grafx->Graphics );
      }

	  // Die Ecken des Schiffs fr die Zeichnung Berechnen
	  array<Point>^ BerechneSchiffsecken( int SchiffPositionX, int SchiffPositionY, int SchiffRichtungX, int SchiffRichtungY )
	  {
		  // Aufpassen auf undefinierte Zustnde, diese knnen Auftreten, wenn Position und Richtung gleiche 
		  // Werte haben. Dann Verschieben wir die Richtung einfach ein Pixel.
		  if ( ( SchiffRichtungX - SchiffPositionX ) == 0 ) SchiffRichtungX = SchiffRichtungX+1;
		  if ( ( SchiffRichtungY - SchiffPositionY ) == 0 ) SchiffRichtungY = SchiffRichtungY+1;

		  double SpitzeAbstandVonMitte = 10;
		  // 1. Sin a
		  double sinA;
		  if ( ( SchiffRichtungX - SchiffPositionX ) == 0 ) { sinA = 1; }
		  else { sinA = ( SchiffRichtungY - SchiffPositionY ) / sqrt( pow( double(SchiffRichtungY - SchiffPositionY), 2 ) + pow( double(SchiffRichtungX - SchiffPositionX), 2) ); }
		  // 2. SpitzeY des Schiffs berechnen
		  double AbstandVonMitteY = sinA * SpitzeAbstandVonMitte;
		  double SpitzeY = SchiffPositionY + AbstandVonMitteY;
		  // 3. Cos a
		  double cosA;
		  if ( ( SchiffRichtungY - SchiffPositionY ) == 0 ) { cosA = 1; }
		  else { cosA = ( SchiffRichtungX - SchiffPositionX ) / sqrt( pow( double(SchiffRichtungY - SchiffPositionY), 2 ) + pow( double(SchiffRichtungX - SchiffPositionX), 2) ); }
		  // 4. SpitzeX des Schiffs berechnen
		  double AbstandVonMitteX = cosA * SpitzeAbstandVonMitte;
		  double SpitzeX = SchiffPositionX + AbstandVonMitteX;

		  // Mittelpunkt im Heck
		  if ( ( SchiffPositionX - SpitzeX ) == 0 ) { sinA = 1; }
		  else { sinA = ( SchiffPositionY - SpitzeY ) / sqrt( pow( double(SchiffPositionY - SpitzeY), 2 ) + pow( double(SchiffPositionX - SpitzeX), 2) ); }
		  // 2. SpitzeY des Schiffs berechnen
		  AbstandVonMitteY = sinA * ( SpitzeAbstandVonMitte * 2 );
		  double HeckY = SpitzeY + AbstandVonMitteY;
		  // 3. Cos a
		  if ( ( SchiffPositionY - SpitzeY ) == 0 ) { cosA = 1; }
		  else { cosA = ( SchiffPositionX - SpitzeX ) / sqrt( pow( double(SchiffPositionY - SpitzeY), 2 ) + pow( double(SchiffPositionX - SpitzeX), 2) ); }
		  // 4. SpitzeX des Schiffs berechnen
		  AbstandVonMitteX = cosA * (SpitzeAbstandVonMitte * 2);
		  double HeckX = SpitzeX + AbstandVonMitteX;

		  // Flgelspitzen Backbord und Steuerboard
		  // 1. Gerade aus Spitze(X|Y) und Heck(X|Y) berechnen
		  // y = dy/dx * x + b
		  double SteigungMittelachse = ( (SpitzeY - HeckY) / (SpitzeX - HeckX) );
		  double b = HeckY - ( SteigungMittelachse * HeckX );
		  //y = m * x + b
		  // 2. Gerade durch Heck und Back-/Steuerbord berechnen (Orthogonale zu 1.)
		  double SteigungOrthogonale = - ( 1 / SteigungMittelachse ); //m_o * x + c
		  double b_orth = HeckY - SteigungOrthogonale * HeckX;

		  // 3. Heck(X|Y) ist Mittelpunkt eines Kreises R = 5
		  // Eine Gerade mit der SteigungOrthogonale geht durch den Kreis
		  // beschreiben wir die Diagonale mit einem 2. Punkt: f(x) = SteigungOrthogonale * (HeckX+0,01) + b_orth
		  double OrthHilfspunktY = SteigungOrthogonale * ( HeckX + 0,01 ) + b_orth;
		  double OrthHilfspunktX = ( OrthHilfspunktY - b_orth ) / SteigungOrthogonale;
		  // 4. Berechnung der Schnittpunkte Kreis/Orthogonale
		  double Radius = 5;
		  double t = sqrt( pow(Radius, 2) / ( pow(HeckX - OrthHilfspunktX, 2) + pow(HeckY - OrthHilfspunktY, 2) ) );
		  double BackbordX = HeckX + t * (HeckX - OrthHilfspunktX);
		  double BackbordY = HeckY + t * (HeckY - OrthHilfspunktY);
		  double SteuerbordX = HeckX - t * (HeckX - OrthHilfspunktX);
		  double SteuerbordY = HeckY - t * (HeckY - OrthHilfspunktY);

		  Point Ecke1Schiff = Point(int(BackbordX), int(BackbordY));
		  Point Ecke2Schiff = Point(int(SpitzeX), int(SpitzeY));
		  Point Ecke3Schiff = Point(int(SteuerbordX), int(SteuerbordY));
		  array<Point>^ SchiffDreieck = {Ecke1Schiff,Ecke2Schiff,Ecke3Schiff};

		  // Debug: Warum gibt es manchmal merkwrdige Werte im Schiffsdreieck?
		  if ( SchiffDreieck[0].X <= -2000 ) 
		  {
			  fprintf(stderr, "DEBUG: SchiffDreieck[0].X: %d\n", SchiffDreieck[0].X);
			  fprintf(stderr, "DEBUG: BackbordX: %f\n", BackbordX);
			  fprintf(stderr, "DEBUG: BackbordY: %f\n", BackbordY);
			  fprintf(stderr, "DEBUG: SpitzeX: %f\n", SpitzeX);
			  fprintf(stderr, "DEBUG: SpitzeY: %f\n", SpitzeY);
			  fprintf(stderr, "DEBUG: SteuerbordX: %f\n", SteuerbordX);
			  fprintf(stderr, "DEBUG: SteuerbordY: %f\n", SteuerbordY);
		  }
		  
		  return SchiffDreieck;
	  }

	  String ^Schriftzeichen( int ZeichenNr )
	  {
		  String ^Zeichen;
		  switch ( ZeichenNr )
		  {
		    case 9: Zeichen = "^"; break; // Zeichen fr die Anzahl der eigenen Leben
			case 10: Zeichen = "A"; break;
			case 11: Zeichen = "B"; break; 
			case 12: Zeichen = "C"; break; 
			case 13: Zeichen = "D"; break;
			case 14: Zeichen = "E"; break;
			case 15: Zeichen = "F"; break;
			case 16: Zeichen = "G"; break;
			case 17: Zeichen = "H"; break;
			case 18: Zeichen = "I"; break;
			case 19: Zeichen = "J"; break;
			case 20: Zeichen = "K"; break;
			case 21: Zeichen = "L"; break;
			case 22: Zeichen = "M"; break;
			case 23: Zeichen = "N"; break;
			case 24: Zeichen = "0"; break; 
			case 25: Zeichen = "P"; break;
			case 26: Zeichen = "Q"; break;
			case 27: Zeichen = "R"; break;
			case 28: Zeichen = "S"; break;
			case 29: Zeichen = "T"; break;
			case 30: Zeichen = "U"; break;
			case 31: Zeichen = "V"; break;
			case 32: Zeichen = "W"; break;
			case 33: Zeichen = "X"; break;
			case 34: Zeichen = "Y"; break;
			case 35: Zeichen = "Z"; break; 
			case 36: Zeichen = " "; break; 
			case 37: Zeichen = "1"; break; 
			case 38: Zeichen = "2"; break;
			case 39: Zeichen = "3"; break;
			case 40: Zeichen = "4"; break;
			case 41: Zeichen = "5"; break;
			case 42: Zeichen = "6"; break;
			case 43: Zeichen = "7"; break;
			case 44: Zeichen = "8"; break;
			case 45: Zeichen = "9"; break;
			default: Zeichen = "?"; break;
		  }
		  return Zeichen;
	  }

      void RadarbildZeichnen( Graphics^ g )
      {
	     int UAID_ObjektspeicherPosition = 0;

		 // Die neue Position ermitteln
		 //SetzeSchiffsPosition(KoordBesorgen->SchiffPositionX,KoordBesorgen->SchiffPositionY);
		 SetzeSchiffsPosition(Spieler->SchiffPositionX,Spieler->SchiffPositionY,Spieler->SchiffRichtungX,Spieler->SchiffRichtungY);

		 // Hintergrund
         grafx->Graphics->FillRectangle( Brushes::Black, 0, 0, this->Width, this->Height );

		 // die verschiedenen Stifte bereitlegen
		 Pen^ gruenerStift = gcnew Pen(Color::Green); // grn
		 gruenerStift->Width = 1;
		 Pen^ dunkelgruenerStift = gcnew Pen(Color::DarkGreen); // dunkelgrn
		 dunkelgruenerStift->Width = 1;
		 Pen^ roterStift = gcnew Pen(Color::Red); // rot
		 roterStift->Width = 1;
		 Pen^ blauerStift = gcnew Pen(Color::Blue); // blau
		 blauerStift->Width = 1;
		 Pen^ gelberStift = gcnew Pen(Color::Yellow); // gelb
		 gelberStift->Width = 1;
		 Pen^ orangerStift = gcnew Pen(Color::OrangeRed); // orange
		 orangerStift->Width = 2;
		 Pen^ weisserStift = gcnew Pen(Color::White); // weiss
		 weisserStift->Width = 1;
		 Pen^ cyanStift = gcnew Pen(Color::DarkCyan); // cyan
		 weisserStift->Width = 1;

		 // Die Grenzen des Spielfeldes einzeichnen		
		 g->DrawRectangle( roterStift, 0, 0, 1024, 768 );

		 Point Ecke1Schiff = Point(SchiffPositionX-5,SchiffPositionY+10);
		 Point Ecke2Schiff = Point(SchiffPositionX,SchiffPositionY-10);
		 Point Ecke3Schiff = Point(SchiffPositionX+5,SchiffPositionY+10);
		 array<Point>^ SchiffDreieck = {Ecke1Schiff,Ecke2Schiff,Ecke3Schiff};
		 SchiffDreieck = BerechneSchiffsecken( SchiffPositionX, SchiffPositionY, SchiffRichtungX, SchiffRichtungY );

		 // UFO - Punkte definieren + irgendwie initalisieren
		 array<Point>^ UfoPolygon = {Ecke1Schiff,Ecke2Schiff,Ecke3Schiff,Ecke2Schiff,Ecke3Schiff,Ecke2Schiff,Ecke3Schiff,Ecke2Schiff};
		 int UfoGroesse = 1;
		 // Asteroidenparameter
		 int AsteroidGroesse = 0;
		 int UfoAsteroidID = 0;
		 int SchussID = 0;
		 // Texte
		 String ^TempText = " ";
		 int LetzteTextPosX = 0;
		 int LetzteTextPosY = 0;
		 // Zeichnen der RadarObjekte
		 for (int i = 0; Spieler->ObjektRadarElement > i; i++)
		 {	 
			 switch (Spieler->ObjektRadarSkalierung[i])
			 {
			 case 0: AsteroidGroesse = 75; break;
			 case 15: AsteroidGroesse = 37; break;
			 case 14: AsteroidGroesse = 19; break;
			 case 13: AsteroidGroesse = 15; break; // explosion
			 case 12: AsteroidGroesse = 11; break; // explosion
			 case 11: AsteroidGroesse = 7; break; // explosion
			 default: AsteroidGroesse = 1; break;
			 }
			 // ObjektRadar, ObjektRadarX, ObjektRadarY, ObjektRadarTyp, ObjektRadarSkalierung, ObjektRadarElement
			 switch ( Spieler->ObjektRadar[i] ) 
			 {
			 case 0:
				 // Raumschiff zeichnen
				 SchiffDreieck = BerechneSchiffsecken( Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], SchiffRichtungX, SchiffRichtungY );
				 g->DrawPolygon( gruenerStift, SchiffDreieck );
				 // dx des Raumschiffs
				 g->DrawLine( blauerStift,SchiffPositionX, SchiffPositionY, SchiffRichtungX, SchiffRichtungY );
				 //g->DrawLine( gruenerStift,SchiffPositionX, SchiffPositionY, Spieler->SchiffRichtungWeitX, Spieler->SchiffRichtungWeitY );
				 g->DrawEllipse( gelberStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 // Winkelkreis malen
				 g->DrawEllipse( dunkelgruenerStift, Spieler->ObjektRadarX[i]-50, Spieler->ObjektRadarY[i]-50, 100, 100);
				 g->DrawLine( dunkelgruenerStift,SchiffPositionX-55, SchiffPositionY, SchiffPositionX-45, SchiffPositionY );
				 g->DrawLine( dunkelgruenerStift,SchiffPositionX+55, SchiffPositionY, SchiffPositionX+45, SchiffPositionY );
				 g->DrawLine( dunkelgruenerStift,SchiffPositionX, SchiffPositionY+55, SchiffPositionX, SchiffPositionY+45 );
				 g->DrawLine( dunkelgruenerStift,SchiffPositionX, SchiffPositionY-55, SchiffPositionX, SchiffPositionY-45 );
				 g->DrawString( String::Format( "0" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::DarkGreen, SchiffPositionX+55, SchiffPositionY-6 );
				 g->DrawString( String::Format( "90" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::DarkGreen, SchiffPositionX-8, SchiffPositionY+55 );
				 g->DrawString( String::Format( "180" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::DarkGreen, SchiffPositionX-80, SchiffPositionY-6 );
				 g->DrawString( String::Format( "270" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::DarkGreen, SchiffPositionX-8, SchiffPositionY-67 );
				 //fprintf(stderr, "DEBUG: ObjektRadarSkalierung: %d\n", Spieler->ObjektRadarSkalierung);
				 // max. Schussdistanz
				 //g->DrawEllipse( dunkelgruenerStift, Spieler->ObjektRadarX[i]-558, Spieler->ObjektRadarY[i]-558, 1116, 1116);
				 //g->DrawEllipse( dunkelgruenerStift, (Spieler->ObjektRadarX[i]-558)+1024, Spieler->ObjektRadarY[i]-558, 1116, 1116);
				 //g->DrawEllipse( dunkelgruenerStift, Spieler->ObjektRadarX[i]-558-1024, Spieler->ObjektRadarY[i]-558, 1116, 1116);
				 //g->DrawEllipse( dunkelgruenerStift, Spieler->ObjektRadarX[i]-558, Spieler->ObjektRadarY[i]-558+768, 1116, 1116);
				 //g->DrawEllipse( dunkelgruenerStift, Spieler->ObjektRadarX[i]-558, Spieler->ObjektRadarY[i]-558-768, 1116, 1116);

				 break;
			 case 1: // alles asteroiden
			 case 2: // alles asteroiden
			 case 3: // alles asteroiden
			 case 4: // alles asteroiden
				 for ( int j = UfoAsteroidID; j < Spieler->MAX_OBJEKTE; j++ )
				 {
					 if ( Spieler->Objektspeicher01[j] != 0 ) 
					 {
						 UfoAsteroidID = j + 1;
						 UAID_ObjektspeicherPosition = j;
						 break;
					 }
				 }
				 // Darstellung der Bewegungsvektoren, aufgeteilt in X- und Y-Vektor
				 if (ZeigeObjektvektoren)
				 {
					 //g->DrawString( String::Format( "{0}", Spieler->ObjektPPF_X[UAID_ObjektspeicherPosition] * 10 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-20, Spieler->ObjektRadarY[i]-6 );
					 //g->DrawString( String::Format( "{0}", Spieler->ObjektPPF_Y[UAID_ObjektspeicherPosition] * 10 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-20 );
					 g->DrawLine( cyanStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], int(Spieler->ObjektPPF_X[UAID_ObjektspeicherPosition]) * 3 + Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
					 g->DrawLine( cyanStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], Spieler->ObjektRadarX[i], int(Spieler->ObjektPPF_Y[UAID_ObjektspeicherPosition]) * (-3) + Spieler->ObjektRadarY[i] ); // Richtungsumkehr in der Anzeige
				 }
				 if (ZeigeObjektIDs)
				 {
					 g->DrawString( String::Format( "{0}", UfoAsteroidID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
					 //g->DrawString( String::Format( "{0}   - {1}", Spieler->ObjektRadarTyp[i], UfoAsteroidID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
					 //g->DrawString( String::Format( "{0}", Spieler->ObjektRadar[i] ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
				 }
				 g->DrawEllipse(gelberStift, Spieler->ObjektRadarX[i]-((AsteroidGroesse-1)/2), Spieler->ObjektRadarY[i]-((AsteroidGroesse-1)/2), AsteroidGroesse, AsteroidGroesse);
				 g->DrawEllipse( blauerStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 break;
			 case 5: // UFO
				 for ( int j = UfoAsteroidID; j < Spieler->MAX_OBJEKTE; j++ )
				 {
					 if ( Spieler->Objektspeicher01[j] != 0 ) 
					 {
						 UfoAsteroidID = j + 1;
						 UAID_ObjektspeicherPosition = j;
						 break;
					 }
				 }
				 if (ZeigeObjektvektoren)
				 {
					 g->DrawLine( cyanStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], int(Spieler->ObjektPPF_X[UAID_ObjektspeicherPosition]) * 3 + Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
					 g->DrawLine( cyanStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], Spieler->ObjektRadarX[i], int(Spieler->ObjektPPF_Y[UAID_ObjektspeicherPosition]) * (-3) + Spieler->ObjektRadarY[i] ); // Richtungsumkehr in der Anzeige
				 }
				 if (ZeigeObjektIDs)
				 {
					g->DrawString( String::Format( "{0}", UfoAsteroidID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
				 }
				 UfoGroesse = -13 + Spieler->ObjektRadarSkalierung[i]; // UFO-Grssen = 14 oder 15
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-2 * UfoGroesse), int(Spieler->ObjektRadarY[i]-6 * UfoGroesse)), 0);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+2 * UfoGroesse), int(Spieler->ObjektRadarY[i]-6 * UfoGroesse)), 1);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+4 * UfoGroesse), int(Spieler->ObjektRadarY[i]-3 * UfoGroesse)), 2);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+9 * UfoGroesse), int(Spieler->ObjektRadarY[i]-1 * UfoGroesse)), 3);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]+3 * UfoGroesse), int(Spieler->ObjektRadarY[i]+4 * UfoGroesse)), 4);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-3 * UfoGroesse), int(Spieler->ObjektRadarY[i]+4 * UfoGroesse)), 5);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-9 * UfoGroesse), int(Spieler->ObjektRadarY[i]-1 * UfoGroesse)), 6);
				 UfoPolygon->SetValue( Point(int(Spieler->ObjektRadarX[i]-4 * UfoGroesse), int(Spieler->ObjektRadarY[i]-3 * UfoGroesse)), 7);
				 g->DrawPolygon(roterStift, UfoPolygon);
				 g->DrawEllipse( blauerStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 break;
			 case 6: // Schuss
				 for ( int j = SchussID; j < Spieler->MAX_SCHUESSE; j++ )
				 {
					 if ( Spieler->SchussSpeicher01[j] != 0 ) 
					 {
						 SchussID = j + 1;
						 //SchussID_SchussSpeicherPosition = j;
						 break;
					 }
				 }
				 if (ZeigeObjektIDs)
				 {
					 if ( Spieler->SchussSpeicher01_VonSchiff[SchussID-1] )
					 {
						g->DrawString( String::Format( "S{0}", SchussID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
					 } else {
						g->DrawString( String::Format( "U{0}", SchussID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
					 }
				 }
				 if (ZeigeObjektvektoren)
				 {
					 g->DrawLine( cyanStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], int(Spieler->SchussPPF_X[SchussID-1]) * 3 + Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
					 g->DrawLine( cyanStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], Spieler->ObjektRadarX[i], int(Spieler->SchussPPF_Y[SchussID-1]) * (-3) + Spieler->ObjektRadarY[i] ); // Richtungsumkehr in der Anzeige
				 }
				 g->DrawEllipse( weisserStift, Spieler->ObjektRadarX[i]-1, Spieler->ObjektRadarY[i]-1, 2, 2);
				 break;
			 case 50: // Explosionen
			 case 51: // Explosionen
			 case 52: // Explosionen
			 case 53: // Explosionen
				 for ( int j = UfoAsteroidID; j < Spieler->MAX_OBJEKTE; j++ )
				 {
					 if ( Spieler->Objektspeicher01[j] != 0 ) 
					 {
						 UfoAsteroidID = j + 1;
						 break;
					 }
				 }
				 if (ZeigeObjektIDs)
				 {
					 g->DrawString( String::Format( "{0}", UfoAsteroidID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
					 //g->DrawString( String::Format( "{0}   - {1}", Spieler->ObjektRadarTyp[i], UfoAsteroidID-1 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
					 //g->DrawString( String::Format( "{0}", Spieler->ObjektRadar[i] ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i]-4, Spieler->ObjektRadarY[i]-6 );
				 }
				 g->DrawEllipse(orangerStift, Spieler->ObjektRadarX[i]-((AsteroidGroesse-1)/2), Spieler->ObjektRadarY[i]-((AsteroidGroesse-1)/2), AsteroidGroesse, AsteroidGroesse);
				 g->DrawEllipse( blauerStift, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i], 1, 1);
				 break;
			 default:
				 if ( Spieler->ObjektRadarTyp[i] == 9 ) // Objekt auf dem Radar gehrt zu einem Text
				 {   // Wenn die Position des Zeichens der des letztens entspricht, dann gehren sie zum selben Text
					 if ( LetzteTextPosX == Spieler->ObjektRadarX[i] && LetzteTextPosY == Spieler->ObjektRadarY[i] )
					 {
						 TempText = TempText + Schriftzeichen( Spieler->ObjektRadar[i] );
					 }
					 else // ein neuer Text, dann gib den alten aus und setze den neuen
					 {
						 g->DrawString( TempText, gcnew System::Drawing::Font( "Courier New",16 ), Brushes::LightGreen, LetzteTextPosX, LetzteTextPosY );
						 //TempText = String::Format( "{0}", Spieler->ObjektRadar[i] );
						 TempText = Schriftzeichen( Spieler->ObjektRadar[i] );
					 }
					 LetzteTextPosX = Spieler->ObjektRadarX[i];
					 LetzteTextPosY = Spieler->ObjektRadarY[i];
				 }
				 else
				 {
					 g->DrawString( String::Format( "?" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Crimson, Spieler->ObjektRadarX[i], Spieler->ObjektRadarY[i] );
				 }
				 break;
			 }
		 }

         // Infos einblenden
		 g->DrawString( "Taste H fr Hilfe drcken.", gcnew System::Drawing::Font( "Arial",8 ), Brushes::White, 10, 52 + 700 );

		 if (Spieler->SteuerungAutomatik == false) 
		 {
			 g->DrawString( "Achtung: manuelle Kontrolle aktiv!", gcnew System::Drawing::Font( "Arial",8 ), Brushes::White, 10, 5 );
		 }

		 if (ZeigeRadarStatus) 
		 {
			 g->DrawString( String::Format( "Schiffsposition: {0}x{1}", Spieler->SchiffPositionX, Spieler->SchiffPositionY ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 58 );
			 //g->DrawString( String::Format( "aktueller Frame: {0}", FrameZaehler++ ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 850, 22 );
			 //g->DrawString( String::Format( "Frames pro Sek.: {0}", FramesProSekunde ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 850, 34 );
			 g->DrawString( String::Format( "Schiffrichtung/Winkel: {0} / {1}", Spieler->SchiffRichtungIndex, Spieler->SchiffRichtungWinkelListe[Spieler->SchiffRichtungIndex] ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 70 );
			 g->DrawString( String::Format( "Schiffrichtung: {0} | {1}", Spieler->SchiffRichtungX, Spieler->SchiffRichtungY ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 82 );
			 g->DrawString( String::Format( "dx | dy: {0} | {1}", Spieler->tmp_dx, Spieler->tmp_dy ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 94 );
			 g->DrawString( String::Format( "v1x | v1y: {0} | {1}", Spieler->SchiffRichtungWeitX, Spieler->SchiffRichtungWeitY ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 106 );
			 g->DrawString( String::Format( "Kalibrierfeuer: {0} | {1}", Spieler->SchiffRichtungKalibrierfeuerX, Spieler->SchiffRichtungKalibrierfeuerY ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 118 );
			 //g->DrawEllipse( gruenerStift, Spieler->SchiffRichtungKalibrierfeuerX-2, Spieler->SchiffRichtungKalibrierfeuerY-2, 4, 4);
			 g->DrawString( String::Format( "Kalibrieren:    {0}", Spieler->SchiffRichtungKalibrieren ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 130 );
			 g->DrawString( String::Format( "BraucheFeuer:   {0}", Spieler->SchiffRichtungBraucheKalibrierfeuer ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 142 );
			 g->DrawString( String::Format( "ZielObjektID:   {0}", Spieler->ZielObjektID ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 154 );
			 //g->DrawString( String::Format( "WinkelRadZuObjekt:   {0} | {1} | {2}", Spieler->WinkelRadZuObjekt, Spieler->WinkelRadZuObjekt1, Spieler->WinkelRadZuObjekt2 ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 166 );
			 g->DrawString( String::Format( "UfoSchussMinDist: {0}", Spieler->min_dist_UfoSchuss() ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 20, 178 );
		 } 

		 if (ZeigeObjektbewegung)
		 {
			 g->DrawString( String::Format( "Koordinaten 01 & 10:" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 650, 58 );
			 g->DrawString( String::Format( "Delta(10-01):" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 770, 58 );
			 for ( int i = 0; i < Spieler->MAX_OBJEKTE; i++ )
			 {
				 //g->DrawString( String::Format( "{0}", Spieler->ObjektPPF_X[i]), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 665, (70 + (i * 12)) );
				 //g->DrawString( String::Format( "{0}", Spieler->ObjektPPF_Y[i]), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 765, (70 + (i * 12)) );
				 g->DrawString( String::Format( "({0}|{1})", Spieler->Objektspeicher01_X[i], Spieler->Objektspeicher01_Y[i]), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 665, (70 + (i * 12)) );
				 g->DrawString( String::Format( "({0}|{1})", Spieler->Objektspeicher10_X[i], Spieler->Objektspeicher10_Y[i]), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 715, (70 + (i * 12)) );
				 g->DrawString( String::Format( "({0}|{1})", Spieler->Objektspeicher10_X[i]-Spieler->Objektspeicher01_X[i], Spieler->Objektspeicher10_Y[i]-Spieler->Objektspeicher01_Y[i]), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 785, (70 + (i * 12)) );
			 }
		 }

		 if (ZeigeSchussSpeicher)
		 {
			 String ^TempPos;
			 g->DrawString( String::Format( "SchusSpeicher00, 01:" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 450, 58 );
			 for ( int i = 0; i < Spieler->MAX_SCHUESSE; i++ )
			 {
				 TempPos = "SchPos " + i + ": ";
				 g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 465, (70 + (i * 12)) );
				 for ( int j = 0; j <= 1; j++ )
				 {
					 switch ( j ) 
					 {
					 case 0: TempPos = String::Format( "{0}", Spieler->SchussSpeicher00_VonSchiff[i] ); break;
					 case 1: TempPos = String::Format( "{0}", Spieler->SchussSpeicher01_VonSchiff[i] ); break;
					 }
 					 g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 465 + 80 + (j * 18), (70 + (i * 12)) );
				 }
			 }
		 }

		 if (ZeigeObjektspeicher)
		 {
			 String ^TempPos;
			 g->DrawString( String::Format( "Objektspeicher00 bis 05:" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 850, 58 );
			 for ( int i = 0; i < Spieler->MAX_OBJEKTE; i++ )
			 {
				 TempPos = "Pos " + i + ": ";
				 g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865, (70 + (i * 12)) );
				 for ( int j = 0; j <= 5; j++ )
				 {
					 switch ( j ) 
					 {
					 case 0: TempPos = String::Format( "{0}", Spieler->Objektspeicher00Info[i] ); break;
					 case 1: TempPos = String::Format( "{0}", Spieler->Objektspeicher01[i], Spieler->Objektspeicher01_Typ[i] ); break;
					 //case 1: TempPos = String::Format( "{0}({1})", Spieler->Objektspeicher01[i], Spieler->Objektspeicher01_Typ[i] ); break;
					 case 2: TempPos = String::Format( "{0}", Spieler->Objektspeicher02[i] ); break;
					 case 3: TempPos = String::Format( "{0}", Spieler->Objektspeicher03[i] ); break;
					 case 4: TempPos = String::Format( "{0}", Spieler->Objektspeicher04[i] ); break;
					 case 5: TempPos = String::Format( "{0}", Spieler->Objektspeicher05[i] ); break;
					 }
					 g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (j * 18), (70 + (i * 12)) );
				 }

				 if ( (Spieler->MAX_OBJEKTE - 1) == i )
				 {
					TempPos = String::Format( "-------------------------------------" );
					g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865, (70 + ((i+1) * 12)) );
					TempPos = String::Format( "Anzahl:" );
					g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865, (70 + ((i+2) * 12)) );
					g->DrawString( String::Format( "{0}", Spieler->Objektspeicher00Anzahl), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (0 * 18), (70 + ((i+2) * 12)) );
					g->DrawString( String::Format( "{0}", Spieler->Objektspeicher01Anzahl), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (1 * 18), (70 + ((i+2) * 12)) );
					g->DrawString( String::Format( "{0}", Spieler->Objektspeicher02Anzahl), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (2 * 18), (70 + ((i+2) * 12)) );
					g->DrawString( String::Format( "{0}", Spieler->Objektspeicher03Anzahl), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (3 * 18), (70 + ((i+2) * 12)) );
					g->DrawString( String::Format( "{0}", Spieler->Objektspeicher04Anzahl), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (4 * 18), (70 + ((i+2) * 12)) );
					g->DrawString( String::Format( "{0}", Spieler->Objektspeicher05Anzahl), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 865 + 40 + (5 * 18), (70 + ((i+2) * 12)) );
				 }
			 }
		 }

		 if (ZeigeSchussZukunft)
		 {
			 String ^TempPos;
			 for ( int i = 0; i < Spieler->LEBENSDAUER_SCHUSS; i++ )
			 {
				 g->DrawEllipse( dunkelgruenerStift, this->SchiffPositionX + Spieler->SchussZukunftX[i], this->SchiffPositionY + Spieler->SchussZukunftY[i], 2, 2);
			 }
			 g->DrawEllipse( dunkelgruenerStift, this->SchiffPositionX-558, this->SchiffPositionY-558, 1116, 1116);
		 }

		 if (ZeigeSchussZukunftListe)
		 {
			 String ^TempPos;
			 g->DrawString( String::Format( "Schussflugbahn:" ), gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 200, 58 );
			 for ( int i = 0; i < Spieler->LEBENSDAUER_SCHUSS; i++ )
			 {
				 TempPos = "Pos " + i + ": " + Spieler->SchussZukunftX[i] + " | " + Spieler->SchussZukunftY[i];
				 g->DrawString( TempPos, gcnew System::Drawing::Font( "Arial",8 ), Brushes::Azure, 215, (70 + (i * 12)) );
			 }
		 }

		 if (ZeigeHilfe) 
		 {
			 g->DrawRectangle( roterStift, 390, 130, 300, 300 );
			 g->FillRectangle( Brushes::Black, 391, 131, 299, 299 );
			 String ^Hilfetext = 
				 "TASTATURBELEGUNG:\n\n" +
				 "B: Bewegung zwischen Objektspeicher01 & 10 zeigen\n" +
				 "D: ObjektIDs (Position im Array Objektspeicher01)\n" +
				 "F: stehendes Radarbild (wie Rechtsklick)\n" +
				 "G: Dauerfeuer an/aus\n" +
				 "H: Hilfetext\n" +
				 "K: Richtungskalibrierung auslsen\n" +
				 "L: Objektspeicher00 - 05 (nicht gezeigt: 06 - 10)\n" +
				 "M: manuelle Steuerung (Q,W,I,O,Space)\n" +
				 "S: Status der Radaranzeige\n" +
				 "V: Bewegungsvektoren\n" +
				 "Z: Schusslinie Anzeigen\n" +
				 "ESC: Programm beenden\n\n\n" +
				 "MAUSBELEGUNG:\n\n" +
				 "Linksklick: bewegtes Radarbild\n" +
				 "Rechtsklick: stehendes Radarbild zum Klickzeitpunkt";
			 g->DrawString( Hilfetext, gcnew System::Drawing::Font( "Arial",8 ), Brushes::White, 410, 150 );
		 }

      }

   protected:
      virtual void OnPaint( PaintEventArgs^ e ) override
      {
         grafx->Render( e->Graphics );
      }
   };
}

int main(int argc, char* argv[])
{
//	if (argc != 2)
	if (argc > 2)
	{
		fprintf(stderr, "Aufruf: asteroid <IP-Adresse>\nErfolgt der ohne Parameter, entspricht dies:\nasteroid 127.0.0.1\n");
		exit(1);
	}
	unsigned long server_ip = inet_addr(argv[1]);

	// Standard-IP = local, wenn nichts bergeben wurde
	if (argc == 1)
	{
		server_ip = inet_addr("127.0.0.1");
	}

	if (server_ip == INADDR_NONE)
	{
		fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", argv[1]);
		exit(1);
	}

			WSADATA wsadata;
			if (WSAStartup(MAKEWORD(2,2), &wsadata))
			{
				fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
				exit(2);
			}

			SOCKET sd;
			sd = socket(AF_INET, SOCK_DGRAM, 0);
			if (sd == INVALID_SOCKET)
			{
				fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
				exit(2);
			}

			unsigned long enable_nonblocking = 1;
			if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
			{
				fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
				exit(1);
			}

			sockaddr_in sa;
			memset(&sa, 0, sizeof sa);
			sa.sin_family = AF_INET;
			sa.sin_addr.s_addr = 0;
			sa.sin_port = 0;

			if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
			{
				fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
				exit(2);
			}

	Application::Run( gcnew AsteroidsAutopilot::Radarbild(server_ip, sd) );

	return 0;
}

