// -*- mode:C++; -*-
// Zoltan Zomotor
// game.cpp: Beispielspieler fr Asteroids
// Matthias Fuchs
// Original: Harald Bgeholz / c't

#include "game.h"
#include "output.h"
#include <math.h>
#include<iostream>
#ifdef MESS
#include<time.h>
#endif
#ifndef MAXINT
#define MAXINT 0x7FFFFFFF
#endif
//#include<w32api/windows.h>

void normxy(int &ix, int &iy){
  while (ix >= 1024) ix -= 1024;
  while (iy >=  896) iy -= 768;
  while (ix <     0) ix += 1024;
  while (iy <   128) iy += 768;
}
void normxy(double &x, double &y){
  while (x >= 1024) x -= 1024;
  while (y >=  896) y -= 768;
  while (x <     0) x += 1024;
  while (y <   128) y += 768;
}
void normWrap(int &dx, int &dy){
  while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
  while (dx >  511) dx -= 1024;
  while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
  while (dy >  383) dy -= 768;
}
void normWrap(double &dx, double &dy){
  while (dx <  -512) dx += 1024; // dx normalisieren auf -512 ... 511
  while (dx >=  512) dx -= 1024;
  while (dy <  -384) dy += 768;  // dy normalisieren auf -384 ... 383
  while (dy >=  384) dy -= 768;
}

void dist(const int& ix, const int& iy, const int& ship_x, const int& ship_y, int &dx, int &dy, double &d){
  dx = ix - ship_x;
  dy = iy - ship_y;
  normWrap(dx,dy);
  d  = sqrt(dx*dx+dy*dy);  // Quadrat des Abstands
}
void dist(const double& x, const double& y, const int& ship_x, const int& ship_y, double &dx, double &dy, double &d){
  dx = x - ship_x;
  dy = y - ship_y;
  normWrap(dx,dy);
  d  = sqrt(dx*dx+dy*dy);  // Quadrat des Abstands
}

double astsin(int ind){
  double as= round(127*sin((ind+64)/128*M_PI));
  return as;
}
double astcos(int ind){
  double ac= round(127*cos((ind+64)/128*M_PI));
  return ac;
}

void Object::NormXY(void){
  normxy(ix,iy);
}
void Object::set(const int& _x, const int& _y){
  ix = _x;
  iy = _y;
}

void Explosion::set(const int& ix, const int& iy){
  Object::set(ix,iy);
}



void Enemy::Dist(const Ship& ship){
  dist(ix,iy,ship.ix,ship.iy,dx,dy,d);
}


void Asteroid::set(const int& _x, const int& _y, const int& _type,const  int& _sf){
  Object::set(_x,_y);
  type = _type;
  sf   = _sf;

  switch (sf){  // Abstand um den ungefhren Radius des Asteroiden korrigieren
    case AST_GROSS:  // gro
      radius = RADIUS_GROSS;    // Ziel-Radius
      points = 20;
#ifdef OUTPUT
      strcpy(name,"Asteroid big");
#endif
      break;
    case AST_MITTEL:// mittel 
      radius = RADIUS_MITTEL;  
      points = 50;
#ifdef OUTPUT
      strcpy(name,"Asteroid mid");
#endif
      break;
    case AST_KLEIN: // klein
      radius = RADIUS_KLEIN;
      points = 100;
#ifdef OUTPUT
      strcpy(name,"Asteroid sml");
#endif
      break;
  }
}
void Asteroid::Dist(const Ship& ship){
  Enemy::Dist(ship);
  double r=radius+RADIUS_SCHIFF;
  d = d-r;
}

void Shot::set(const int& _x,const  int& _y){
  ix = _x;
  iy = _y;
}

bool Saucer::IsPresent (void) const{
  return size > 0;
}

void Saucer::set(const int& _x, const int& _y, const int& _size){
  Object::set(_x,_y);
  size = _size;

  switch (size){  
    case UFO_GROSS: // groes UFO
      radius = RADIUS_UFO_GROSS;
      points = 200;
#ifdef OUTPUT
      strcpy(name,"UFO big");
#endif
      break;
    case UFO_KLEIN: // kleines UFO
      radius = RADIUS_UFO_KLEIN;
      points = 1000;
#ifdef OUTPUT
      strcpy(name,"UFO sml");
#endif
      break;
    default:
      break;
  }

}

void Saucer::Dist(const Ship& ship){
  using namespace std;
  Enemy::Dist(ship);
  double r=radius+RADIUS_SCHIFF;
  d = d-r;
}


bool Ship::IsPresent (void) const{
  return present;
}

void Ship::set(const int& _x, const int& _y, const int& _dx, const int& _dy){
  ix = _x;
  iy = _y;
  dx= _dx;
  dy= _dy;
  present=true;
}

GameStatus::GameStatus (void)
  :  nasteroids(0),
     nshots(0),
     t(0),
     frameno(0),
     gameFrameNo(0),
     level(0)
{
  ship.present = false;
  saucer.size = 0;
}

void GameStatus::clear(void){
  ship.present = false;
  saucer.size = 0;
  nasteroids = 0;
  nexplosions=0;
  nshots = 0;
  lifes = 0;
}


void Game::Run(void){
  FramePacket frame;
  KeysPacket keys;
  KeysPacket lkeys;
  NamePacket name;
  GameStatus state;
  __int8 prevframe = 0;
  unsigned int startframe = 0;

  char sscore[6]={0,0,0,0,0,0};

  int gameNo = 1;
  int highscore = 0;
  int highscoreLevel = 0;
  int highscoreGameNo=0;
  int highscoreLostShips=0;
  int lowscore = MAXINT;
  int lowscoreLevel = 0;
  int lowscoreGameNo=0;
  int lowscoreLostShips=0;
  double averageScore= 0;
  double avLostShips = 0;
  bool startship = true;

  unsigned int NFRAMES = 5*60*60;

  int letter = 0;
  int lnbigasteroids=0;

  int levelscore=0;
  int ltrackedPoints=0;
  unsigned int levelStartFrame=NFRAMES; 
  unsigned int levelEndFrame=0; 
  int levelPause=0;
  int levelTotPause=0;
  int lnOwnShotsTotSoll=0;
  int lnOwnShotsTotIst=0;
  int lnHit=0;
  int lnTtcShot=0;
  int lnTtdShot=0;
  int lnOtherShot=0;
  int lnTotTrackedAst=0;
  int lnBigSaucers=0;
  int lnSmallSaucers=0;


  unsigned int outputLevel=0;
  int lifes = 0;
  int ping = 0;
  int latenz = 0;

#ifdef MESS
  double maxTock = 0;
#endif

#ifdef PROTOKOLL
  time_t ct_current_time;
  struct tm *ct_local_time;
#endif

  const int OUTPUT_FRAMES = 360;

  for (unsigned int t = 1; /*endlos*/; ++t){
    int failed = 0;
    state.framePing = M(frame.ping + 128); // Als Index von 0...255
    state.keysPing  = M(keys.ping  + 128);
    state.ping      = ping;
    state.latenz    = latenz;

    if(latenz>0||ping>0) OutputInfo2("KeysPing=%d, Latenz %d. %d Frames verloren.\n", state.keysPing, ping, latenz);

    ++keys.ping;
    OutputSetFrame(state.gameFrameNo+1);
    connection.SendPacket(keys);
    connection.ReceivePacket(frame);


#ifdef MESS
    struct timespec tp;
    clock_gettime(CLOCK_REALTIME,&tp);
    double tick = 1e9*tp.tv_sec + tp.tv_nsec; 
#endif

    // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
    ++state.frameno;
    state.gameFrameNo = state.frameno - startframe;


    //     OutputInfo2("-------------------- keysPing = %d --framePing = %d-------------------------",state.keysPing,state.framePing);

    for(int i=0;i<4;i++) state.shotLifeSpan[i] = 68; // 71 - ((frame.frameno-i) & 3);
    ping = 0;
    latenz = 0;
    if (frame.frameno != ++prevframe || frame.ping != keys.ping){
      ping = keys.ping - frame.ping;
      if (ping < 0)
	ping += 256;
      latenz = frame.frameno - prevframe;
      if (latenz < 0)
	latenz += 256;
      prevframe = frame.frameno;
      state.frameno += latenz;
	//	OutputInfo2("KeysPing=%d, Latenz %d. %d Frames verloren.\n", keys.ping, ping, latenz);
    }

#ifdef ONLINE
    if(state.frameno%OUTPUT_FRAMES==0)
      OutputInfo2("vectorram: '%s'\n",frame.vectorram);
#endif
    

    memset(txt,0,strlen(txt));
    state.nSmallAsteroids=0;
    state.nBigAsteroids=0;
    state.nObj=0;
    state.nEnemy=0;

    InterpretScreen(frame, state);

    player.nAsteroids = state.nasteroids;
    
    if(state.lifes>0){
      memcpy(sscore,txt, 5);
      sscanf(sscore,"%d",&score);
      if (lscore>score)   overflow+=100000;
      player.totscore = score+overflow;
      state.score = score;
      lscore = score;

    }


    if(state.nasteroids==0 
       && outputLevel!=player.level 
       && state.frameno-levelStartFrame>0 ){
      outputLevel=player.level;
      OutputInfo2("Level %3d: Score=%5d, Frames=%5d, Pause=%3d, Shots=(%4d,%4d),  Asts=%4d, UFO: big=%2d small=%2d,  ttc=%3d, ttd=%3d, tOther=%d",
		  state.level, 
		  player.totscore-levelscore,
		  state.frameno-levelStartFrame,  
		  levelPause,
		  //		    player.trackedPoints-ltrackedPoints,
		  player.nOwnShotsTotSoll-lnOwnShotsTotSoll, 
		  player.nOwnShotsTotIst-lnOwnShotsTotIst, 
		  player.nTotTrackedAst-lnTotTrackedAst,
		  player.nBigSaucers - lnBigSaucers,
		  player.nSmallSaucers - lnSmallSaucers,
		  player.nTtcShot-lnTtcShot,
		  player.nTtdShot-lnTtdShot,
		  player.nOtherShot-lnOtherShot);
      OutputInfo2("Total:     Score=%5d, Frames=%5d, Pause=%3d, Shots=(%4d,%4d),  Asts=%4d, UFO: big=%2d small=%2d, ttc=%3d, ttd=%3d, tOther=%d",   
		    player.totscore,
		    state.frameno,
		    levelTotPause,
		    //		      player.trackedPoints,
		    player.nOwnShotsTotSoll,
		    player.nOwnShotsTotIst,
		    player.nTotTrackedAst,
		    player.nBigSaucers,
		    player.nSmallSaucers,
		    player.nTtcShot,
		    player.nTtdShot,
		    player.nOtherShot);
      levelEndFrame = state.frameno;
#ifdef MESS
      OutputInfo2("Time: %6.3f ms, %3.1f Hz",maxTock,1000./maxTock);
      maxTock = 0;
#endif
      }
    state.pauseLeft = 165 - (state.frameno-levelEndFrame);
    if(state.pauseLeft<0 || state.nasteroids>0) state.pauseLeft=0;

    if(lnbigasteroids < state.nBigAsteroids){ // neues Level
      if(state.nBigAsteroids==4) state.level = player.level+1;
      else state.level+=1;
      player.level=state.level;

      levelscore = player.totscore;
      ltrackedPoints = player.trackedPoints;
      levelStartFrame = state.frameno;
      if(player.level==1) levelEndFrame=levelStartFrame;
      levelPause = levelStartFrame - levelEndFrame;
      levelTotPause += levelPause;
      lnOwnShotsTotSoll=player.nOwnShotsTotSoll;
      lnOwnShotsTotIst=player.nOwnShotsTotIst;
      lnHit=player.nHit;
      lnTtcShot=player.nTtcShot;
      lnTtdShot=player.nTtdShot;
      lnOtherShot=player.nOtherShot;
      lnTotTrackedAst = player.nTotTrackedAst;
      lnBigSaucers = player.nBigSaucers;
      lnSmallSaucers=player.nSmallSaucers;
#ifdef PROFILE
      if(state.level>1) throw game_over();
#endif
    }
    lnbigasteroids = state.nBigAsteroids;


    if(startship && state.ship.IsPresent()){
#ifdef SIMULATION
      Sim::frame = 0;
#endif
      startframe = state.frameno-2;
      startship = false;
#ifdef PROTOKOLL
      time(&ct_current_time);
      ct_local_time = localtime(&ct_current_time);
      strftime(player.ct_time_string, sizeof(player.ct_time_string), "%Y-%m-%d-%H-%M-%S", ct_local_time);
#endif
    }
    // Startschirm
    if(strncmp(txt,"STARTKN0EPFE",12) == 0) {

#ifndef NOSENDNAME
      connection.SendPacket(name);
      //OutputInfo("Startknoepfe\n");
#endif


#ifdef LIMIT5MIN    
      //    keybd_event(VK_F3,0x3D, KEYEVENTF_KEYUP,0); // F3 loslassen
#endif

      keys.clear();   // alle Tasten loslassen
      
      keys.start(true);
      if(player.totscore>0){
	averageScore = (averageScore*(gameNo-1)+player.totscore)/(gameNo);
	avLostShips = (avLostShips*(gameNo-1)+player.lostShips)/(gameNo);
	OutputInfo2("\nMax %6d / Level %2d / Game %3d / Lost %d --- Min %6d / Level %2d / Game %3d / Lost %d --- Av %6.0f / Lost %2.1f \n",
		    highscore,highscoreLevel, highscoreGameNo, highscoreLostShips,
		    lowscore,lowscoreLevel, lowscoreGameNo, lowscoreLostShips,
		    averageScore, avLostShips);


	const char *file="highscore.txt";
	const char *mode="a";
	FILE *fid = fopen(file,mode);
 	fprintf(fid,"Max %6d / Level %2d / Game %3d / Lost %d --- Min %6d / Level %2d / Game %3d / Lost %d --- Av %6.0f / Lost %2.1f \n",
 		    highscore,highscoreLevel, highscoreGameNo, highscoreLostShips,
 		    lowscore,lowscoreLevel, lowscoreGameNo, lowscoreLostShips,
 		    averageScore, avLostShips);
	fclose(fid);

	gameNo++;
	OutputInfo2("\n----------- Spiel Nr.%4d ------------ \n",gameNo);
      }
      score = lscore  = overflow = 0;
      startship = true;
      letter = 0;
      state.level = 0;
      levelPause=levelTotPause=levelEndFrame=0;
      player.clear();
      continue;
    } // STARTKNOEPFE
    // 5 Minuten --> Schiff zerstren, high- und lowscore merken
#ifdef LIMIT5MIN    
    if( !startship && state.frameno-startframe > NFRAMES && state.lifes > 0){ // Schiff zerstren durch kontinuierlichen Hyperspace
      keys.clear();   // alle Tasten loslassen
      if (state.ship.IsPresent())
	if(state.nObj<14) keys.hyperspace(true); // Schiff zerstren
	else              keys.thrust(true);

      if(player.totscore>highscore){
	highscore = player.totscore;
	highscoreLostShips = player.lostShips;
	highscoreGameNo = gameNo;
	highscoreLevel = state.level;
      }
      if(player.totscore<lowscore){
	lowscore = score;
	lowscoreLostShips = player.lostShips;
	lowscoreGameNo = gameNo;
	lowscoreLevel = state.level;
      }
      continue;
    }
#endif

    // In die Highscoreliste eintragen
    if(strncmp(txt,"IHR",3) == 0) { 
      keys.clear();   // alle Tasten loslassen
      switch(letter){
      case 0:
	if(txt[143] != 'Z'){
	  if(state.frameno % 30 < 15) keys.right(true);
	} else {
	  if(state.frameno % 30 < 3 ) keys.hyperspace(true);
	  if(txt[144]=='A') letter++;
	}
	break;
      case 1:
	if(txt[144] != 'A'){
	  if(state.frameno % 30 < 15) keys.left(true);
	} else {
	  if(state.frameno % 30 < 3) keys.hyperspace(true);
	  if(txt[145]=='A') letter++;
	}
	break;
      case 2:
	if(txt[145] != 'Z'){
	  if(state.frameno % 30 < 15) keys.right(true);
	} else {
	  if(state.frameno % 30 <15) keys.hyperspace(true);
	  if(txt[145]=='Z') letter++;
	}
	break;
      default:
	if(state.frameno %30 <15) keys.hyperspace(true);
	break;
      }      
    } // Highscoreliste

    if(state.lifes==0) continue; 

    // Ausgabe 10x pro Minute
    if(state.frameno>10 && (state.frameno-startframe)%OUTPUT_FRAMES==0){
      lifes = state.lifes;
      player.lostShips = 3+player.totscore/10000-lifes;
      OutputInfo2("Score nach %2.1f min (%5d Frames): %5d, Level %2d, Lost: %d, Hyperspace Shot|Dist|TTC|SaucerDist %2d|%2d|%2d|%2d, failed=%d",
		  (state.frameno-startframe)/3600.,state.frameno-startframe,player.totscore,state.level, player.lostShips,
		  player.nHyperSaucerShot,player.nHyperAsteroid,player.nHyperTtc,player.nHyperSaucerDist,failed);
    }
    
    state.t= t;

    keys.clear();   // alle Tasten loslassen

    state.accFrame = static_cast<unsigned char>(frame.vectorram[1]) == 0xE0;

    player.MakeTurn (state, keys);

#ifdef MESS
    clock_gettime(CLOCK_REALTIME,&tp);
    double tock = (1e9*tp.tv_sec + tp.tv_nsec - tick)/1.e6; 
    if(tock>maxTock){
      maxTock=tock;
    }
#endif
  }
}

int GameStatus::IncAsteroids(void){
  int retval;
  retval = nasteroids++;
  if(nasteroids >= MAX_ASTEROIDS){
    nasteroids=MAX_ASTEROIDS-1;
    OutputError("nasteroids clipped, increase MAX_ASTEROIDS!!!\n");
    retval = nasteroids;
  }
  return retval;
}
void Game::InterpretScreen(const FramePacket &packet, GameStatus& game){
  const unsigned __int8 *vector_ram = (unsigned __int8*)packet.vectorram;
  int dx, dy, sf, vx=0, vy=0, vz, vs=0;
  int v1x = 0;
  int v1y = 0;
  int shipdetect = 0;
  int itxt;

  /* Bemerkung:
     unsigned __int16 value = vector_ram[i] | (vector_ram[i+1] << 8);
     statt
     unsigned __int16 value = reinterpret_cast<unsigned __int16*>(vector_ram)[i>>1];
     damit unabhngig von der Darstellung des Prozessors
     (Little- oder Big-Endian).
  */

  game.clear();
  {
    unsigned __int16 value = vector_ram[0] | (vector_ram[1] << 8);
    if (value != 0xe001 && value != 0xe201)
      return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
  }
  itxt = 0;
  for (unsigned int pc = 2; pc < sizeof packet.vectorram;){
    unsigned __int16 value = vector_ram[pc] | (vector_ram[pc+1] << 8);
    int op = value >> 12;
    switch (op){
      case 0xa:{ // LABS
	vy = value & 0x3ff;
	unsigned __int16 value2 = vector_ram[pc+2] | (vector_ram[pc+3] << 8);
	vx = value2 & 0x3ff;
	vs = value2 >> 12;
	break;
      }
      case 0xb: // HALT
	return;
      case 0xc: { // JSRL
	switch (value & 0xfff){
	  case 0x8f3:
	    game.raw_asteroids[game.IncAsteroids()].set(vx, vy, 1, vs);
	    switch (vs){  // Abstand um den ungefhren Radius des Asteroiden korrigieren
	    case AST_GROSS:  // gro
	      game.nBigAsteroids++;
	      break;
	    case AST_MITTEL:// mittel 
	      break;
	    case AST_KLEIN: // klein
	      game.nSmallAsteroids++;
	      break;
	    }
	    game.nObj++;
	    game.nEnemy++;
	    break;
	  case 0x8ff:
	    game.raw_asteroids[game.IncAsteroids()].set(vx, vy, 2, vs);
	    switch (vs){  
	    case AST_GROSS:  // gro
	      game.nBigAsteroids++;
	      break;
	    case AST_MITTEL:// mittel 
	      break;
	    case AST_KLEIN: // klein
	      game.nSmallAsteroids++;
	      break;
	    }
	    game.nObj++;
	    game.nEnemy++;
	    break;
	  case 0x90d:
	    game.raw_asteroids[game.IncAsteroids()].set(vx, vy, 3, vs);
	    switch (vs){ 
	    case AST_GROSS:  // gro
	      game.nBigAsteroids++;
	      break;
	    case AST_MITTEL:// mittel 
	      break;
	    case AST_KLEIN: // klein
	      game.nSmallAsteroids++;
	      break;
	    }
	    game.nObj++;
	    game.nEnemy++;
	    break;
	  case 0x91a:
	    game.raw_asteroids[game.IncAsteroids()].set(vx, vy, 4, vs);
	    switch (vs){  
	    case AST_GROSS:  // gro
	      game.nBigAsteroids++;
	      break;
	    case AST_MITTEL:// mittel 
	      break;
	    case AST_KLEIN: // klein
	      game.nSmallAsteroids++;
	      break;
	    }
	    game.nObj++;
	    game.nEnemy++;
	    break;
	  case 0x929:
	    game.saucer.set (vx, vy, vs);
	    game.nObj++;
	    game.nEnemy++;
	    break;
	  case 0x880:  //Explosion
	    game.nObj++;
	    break;
	  case 0x896:  // Explosion
	    game.nObj++;
	    break;
	  case 0x8B5:  // Explosion
	    game.nObj++;
	    if(vs==11) game.explosion[game.nexplosions++].set(vx,vy);
	    break;
	  case 0x8D0:  // Explosion
	    game.nObj++;
	    break;
	  case 0xA6D:
	    game.lifes++;
	    break;
	  case 0xA78: //A
	    txt[itxt++]='A';
	    break;
	  case 0xA80: //B
	    txt[itxt++]='B';
	    break;
	  case 0xA8D: //C
	    txt[itxt++]='C';
	    break;
	  case 0xA93: //D
	    txt[itxt++]='D';
	    break;
	  case 0xA9B: //E
	    txt[itxt++]='E';
	    break;
	  case 0xAA3: //F
	    txt[itxt++]='F';
	    break;
	  case 0xAAA: //G
	    txt[itxt++]='G';
	    break;
	  case 0xAB3: //H
	    txt[itxt++]='H';
	    break;
	  case 0xABA: //I
	    txt[itxt++]='I';
	    break;
	  case 0xAC1: //J
	    txt[itxt++]='J';
	    break;
	  case 0xAC7: //K
	    txt[itxt++]='K';
	    break;
	  case 0xACD: //L
	    txt[itxt++]='L';
	    break;
	  case 0xAD2: //M
	    txt[itxt++]='M';
	    break;
	  case 0xAD8: //N
	    txt[itxt++]='N';
	    break;
	  case 0xADD: //O
	    txt[itxt++]='0';
	    break;
	  case 0xAE3: //P
	    txt[itxt++]='P';
	    break;
	  case 0xAEA: //Q
	    txt[itxt++]='Q';
	    break;
	  case 0xAF3: //R
	    txt[itxt++]='R';
	    break;
	  case 0xAFB: //S
	    txt[itxt++]='S';
	    break;
	  case 0xB02: //T
	    txt[itxt++]='T';
	    break;
	  case 0xB08: //U
	    txt[itxt++]='U';
	    break;
	  case 0xB0E: //V
	    txt[itxt++]='V';
	    break;
	  case 0xB13: //W
	    txt[itxt++]='W';
	    break;
	  case 0xB1A: //X
	    txt[itxt++]='X';
	    break;
	  case 0xB1F: //Y
	    txt[itxt++]='Y';
	    break;
	  case 0xB26: //Z
	    txt[itxt++]='Z';
	    break;
	  case 0xB2C: //" "
	    txt[itxt++]=' ';
	    break;
	  case 0xB2E: //1
	    txt[itxt++]='1';
	    break;
	  case 0xB32: //2
	    txt[itxt++]='2';
	    break;
	  case 0xB3A: //3
	    txt[itxt++]='3';
	    break;
	  case 0xB41: //4
	    txt[itxt++]='4';
	    break;
	  case 0xB48: //5
	    txt[itxt++]='5';
	    break;
	  case 0xB4F: //6
	    txt[itxt++]='6';
	    break;
	  case 0xB56: //7
	    txt[itxt++]='7';
	    break;
	  case 0xB5B: //8
	    txt[itxt++]='8';
	    break;
	  case 0xB63: //9
	    txt[itxt++]='9';
	    break;
	}
	break;
      }// 0xc
      case 0xd: // RTSL
	return;
      case 0xe: // JMPL
	/*
	  pc = (value & 0xfff) << 1;
	  break;
	*/
	return;
      case 0xf: // SVEC
	/*
	  dy = value & 0x300;
	  if ((value & 0x400) != 0)
	  dy = -dy;
	  dx = (value & 3) << 8;
	  if ((value & 4) != 0)
	  dx = -dx;
	  sf = (((value & 8) >> 2) | ((value & 0x800) >> 11)) + 2;
	  vz = (value & 0xf0) >> 4;
	*/
	break;
      default:{
	unsigned __int16 value2 = vector_ram[pc+2] | (vector_ram[pc+3] << 8);
	dy = value & 0x3ff;
	if ((value & 0x400) != 0)
	  dy = -dy;
	dx = value2 & 0x3ff;
	if ((value2 & 0x400) != 0)
	  dx = -dx;
	sf = op;
	vz = value2 >> 12;
	if (dx == 0 && dy == 0 && vz == 15)
	  game.raw_shots[game.nshots++].set(vx, vy);
	if (op == 6 && vz == 12 && dx != 0 && dy != 0){
	  switch (shipdetect){
	    case 0:
	      v1x = dx;
	      v1y = dy;
	      ++shipdetect;
	      break;
	    case 1:
	      game.ship.set(vx, vy, v1x - dx, v1y - dy);
	      ++shipdetect;
	      // !!! hat dann Wert == 2 ???
	      break;
	  }
	}
	else if (shipdetect == 1)
	  shipdetect = 0;
	
	break;
      }
    } // switch op
    if (op <= 0xa)
      pc+=2;
    if (op != 0xe) // JMPL
      pc+=2;
  }
}
InterfacePlayer::InterfacePlayer(void)
  :      totscore(0),
	 lostShips(0)  ,
	 level(0),
	 lHyper(0),
	 nHyperSaucerShot(0),
	 nHyperSaucerDist(0),
	 nHyperAsteroid(0),
	 nHyperTtc(0),
	 nHit(0),
	 nSaucerShot(0),
	 nTtcShot(0),
	 nTttShot(0),
	 nTtdShot(0),
	 nOtherShot(0),
	 nOwnShotsTotSoll(0),
	 nOwnShotsTotIst(0),
	 nTotTrackedAst(0),
	 nBigSaucers(0),
	 nSmallSaucers(0),
	 trackedPoints(0)
{
}
void InterfacePlayer::clear(void){
  totscore=0;
  level=0;
  lostShips=0;
  lHyper = 0;
  nHyperSaucerShot = 0;
  nHyperSaucerDist = 0;
  nHyperAsteroid = 0;
  nHyperTtc = 0;
  nHit = 0;
  nSaucerShot = 0;
  nTtcShot = 0;
  nTttShot = 0;
  nTtdShot = 0;
  nOtherShot = 0;
  nOwnShotsTotSoll = 0;
  nOwnShotsTotIst = 0;
  nTotTrackedAst = 0;
  nBigSaucers = 0;
  nSmallSaucers = 0;
  trackedPoints = 0;

}
Game::Game(Connection &con, InterfacePlayer &pl)
  : score(0),
    overflow(0),
    lscore(0),
    connection(con),
    player(pl)
{
  for(int i=0;i<1025;i++) txt[i]=0;
}
