// connection.h: Beispielspieler fr Asteroids (Verbindung zu Mame)
// Harald Bgeholz / c't; Umstrukturierung Matthias Fuchs

#ifndef ConnectionH
#define ConnectionH

#if defined(WINDOWS) || defined(_WIN32)
#include <winsock2.h>
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#define __int8 char
#define __int16 short
#endif

#ifdef SIMULATION
#include <zlib.h>
#include<libgen.h>
#define gzfile gzFile
#include "output.h"
#endif

#pragma pack(1)

// byteweise Ausrichtung der Datenstrukturen
struct FramePacket
{
   __int8 vectorram[1024];
   __int8 frameno;  // wird bei jedem Frame inkrementiert
   __int8 ping;     // Der Server schickt das letzte empfangene ping-Byte zurck

   FramePacket(void);
};

class NamePacket{
 private:
  char signature[38];
 public:
  NamePacket(void);
};

class KeysPacket
{
private:
   static const char KEY_HYPERSPACE = 1;
   static const char KEY_FIRE = 2;
   static const char KEY_THRUST = 4;
   static const char KEY_RIGHT = 8;
   static const char KEY_LEFT = 0x10;
   static const char KEY_START = 0x20;

   char signature[6];
   char keys;
public:
   __int8 ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

   KeysPacket(void);
   void clear(void);         // alle Tasten loslassen
   void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
   void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
   void thrust(bool b);      // Beschleunigen ...
   void right(bool b);       // rechts drehen ...
   void left(bool b);        // links drehen
   void start(bool b);       // Spiel starten
   bool getThrust();         // Beschleunigung ausgeben

   bool start(void) const;
   bool hyperspace(void) const;
   bool fire(void) const;
   bool thrust(void) const;
   bool right(void) const;
   bool left(void) const;
   inline char getKeys(void) const{
     return keys;
   }

};
#pragma pack()

class game_over{
 public:
  game_over(void);
};
class busy{
 public:
   busy (const char* format, ...);
   inline const char* what(void) const;
private:
   char message[1024];
};

class connection_error
{
public:
   connection_error (const char* format, ...);
   inline const char* what(void) const;
private:
   char message[1024];
};

 
#ifdef SIMULATION
class Sim{
 public:
   static gzfile gzf;
   static bool sim;
   static unsigned char simkey;
   static unsigned char aktkey;
   static int frame;
   static const char KEY_HYPERSPACE = 1;
   static const char KEY_FIRE = 2;
   static const char KEY_THRUST = 4;
   static const char KEY_RIGHT = 8;
   static const char KEY_LEFT = 0x10;
   static const char KEY_START = 0x20;
   static char ping;
};
#endif
class Connection
{
public:
  Connection (const char* server_ip_str);
   ~Connection();
   void ReceivePacket(FramePacket &packet);
   void SendPacket(const KeysPacket &packet);
   void SendPacket(const NamePacket &packet);
  static bool IsLittleEndian(void);
#ifdef SIMULATION
  Sim sim;
#endif
private:
   SOCKET sd;
   ADDRESS server_ip;
};



inline const char* connection_error::what(void) const
{
   return message;
}

inline const char* busy::what(void) const
{
   return message;
}


#endif
