#ifndef KeysPacket_h_
#define KeysPacket_h_

#include <stdint.h>

#pragma pack(1)
class KeysPacket
{
private:
    static const char KEY_HYPERSPACE = 1;
    static const char KEY_FIRE = 2;
    static const char KEY_THRUST = 4;
    static const char KEY_RIGHT = 8;
    static const char KEY_LEFT = 0x10;
    
    char signature[6];
    uint8_t keys;
public:
    uint8_t ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.
    
    KeysPacket();
    void clear();         // alle Tasten loslassen
    void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
    void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
    void thrust(bool b);      // Beschleunigen ...
    void right(bool b);       // rechts drehen ...
    void left(bool b);        // links drehen
};
#pragma pack()

#endif

