#ifndef FrameData_h_
#define FrameData_h_

#include <stdint.h>

// forward decls
struct FramePacket;


const int MAX_ASTEROIDS = 30;
const int MAX_SHOTS = 10;



class FrameAsteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};


class FrameShot
{
public:
	int x;
	int y;

	void set(int x, int y);
};


class FrameData
{
public:
    // data
    bool ship_present;  // Schiff sichtbar
    int ship_x;         // Mittelpunkt des Schiffs
    int ship_y;
    int ship_dx;        // Blickrichtung des Schiffes
    int ship_dy;
    
    bool saucer_present;// UFO sichtbar
    int saucer_x;       // Mittelpunkt des UFOs
    int saucer_y;
    int saucer_size;    // Gre: 15 = gro, 14 = klein
    
    int nasteroids;     // Anzahl Asteroiden
    FrameAsteroid asteroids[MAX_ASTEROIDS];
    
    uint32_t timestep;  // timestep this frame belongs to
    
    int nshots;         // Anzahl Schsse
    FrameShot shots[MAX_SHOTS];
    
    // methods
    FrameData() { clear(); }
    void clear();
    void initFromFramePacket(FramePacket &framePacket, uint32_t timestep);
};


#endif
