// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2005  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.util.settings.SettingsTools;

import java.util.Locale;

/**
 * @author <a href="mailto:rammi@caff.de">Rammi</a>
 * @version $Revision$
 */
abstract class AbstractBasicEditorProvider
        implements EditorProvider
{
  /** The name of the label. */
  private final String labelName;
  /** Tool tip text to use. */
  private final String toolTipText;
  /** Description to use. */
  private final String description;

  /**
   * Constructor.
   * @param baseTag base tag (will be expanded by various suffixes)
   * @param l       locale
   */
  protected AbstractBasicEditorProvider(String baseTag, Locale l)
  {
    labelName = SettingsTools.getOptionalI18nString(baseTag+I18n.SUFFIX_TEXT, l);
    toolTipText = SettingsTools.getOptionalI18nString(baseTag+ I18n.SUFFIX_TOOLTIP, l);
    description = SettingsTools.getOptionalI18nString(baseTag+I18n.SUFFIX_DESCRIPTION, l);
  }

  /**
   * Constructor.
   * @param property property to edit
   * @param l        locale to use
   */
  protected AbstractBasicEditorProvider(AbstractBasicSimpleEditablePreferenceProperty property,
                                        Locale l)
  {
    this(property.getBaseTag(), l);
  }

  /**
   *  Is the value in the editor component valid?
   *  @return the answer
   */
  public boolean isValid()
  {
    return true;
  }

  /**
   * Get a label text for this editor component.
   * If the text is null the editor component is inserted without a label.
   *
   * @return something to be displayed as a label
   */
  public String getLabelText()
  {
    return labelName;
  }

  /**
   * Get a title text for this editor component.
   *
   * @return a title text or <code>null</code> if a title makes no sense
   */
  public String getTitleText()
  {
    return null;
  }

  /**
   * Get a tool tip string for this editor component.
   *
   * @return tooltip text or <code>null</code> if no tooltip is used
   */
  public String getToolTipText()
  {
    return toolTipText;
  }

  /**
   * Get a description for the property used.
   *
   * @return description, possibly multi-line
   */
  public String getDescription()
  {
    return description;
  }

}
