// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  Print out the score a given number of frames after the ship appeared the first time.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class TimedScorePrinter
        implements FrameListener
{
  /** The default number of frames. */
  public static final int DEFAULT_FRAMES = 60*60*5;
  /** Frame to print while unknown. */
  public static final int NO_FRAME = -1;
  /** Number of frame where tto count (-1: yet unknown). */
  private int printFrame = -1;
  /** The numbers of frames to count until printing. */
  private final int countFrames;
  /** The last score printed. */
  private int score = 0;

  /**
   *  Default constructor.
   */
  public TimedScorePrinter()
  {
    this(DEFAULT_FRAMES);
  }

  /**
   *  Constructors.
   *  @param frames frames to count before score is printed
   */
  public TimedScorePrinter(int frames)
  {
    countFrames = frames;
  }

  /**
   * Called each time a frame is received.
   * <p/>
   * <b>ATTENTION:</b> this is called from the communication thread!
   * Implementing classes must be aware of this and take care by synchronization or similar!
   *
   * @param frame the received frame
   */
  public void frameReceived(FrameInfo frame)
  {
    if (!frame.isGameRunning()) {
      printFrame = -1;
    }
    else if (printFrame == -1) {
      if (frame.getSpaceShip() != null) {
        printFrame = frame.getIndex() + countFrames;
      }
    }
    else if (frame.getIndex() == printFrame) {
      score = frame.getScore();
      System.out.println(String.format("Score after %d frames: %d", countFrames, score));
    }
  }

  /**
   *  Get the last score counted.
   *  @return last counted score (<code>0</code> if not counted yet)
   */
  public int getScore()
  {
    return score;
  }
}
