/*
created: Jun 19, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.data;

import static asteroids.AsteroidsConstants.*;

import java.io.*;



public class ShotData
{
  private final static boolean LOAD_FROM_CLASSPATH = true;
  
  public final static int SLOT_SIZE = 68;
  private final static String PATH = "shot.data";
  
  private static int[][][] data = new int[256][][];
  
  
  
  static
  {
    try {
      tryLoad();
    }
    catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
  
  
  public static void setData(int angleCounter, int[][] measurement)
  {
    assert angleCounter >= 0;
    assert angleCounter <= 255;
    assert measurement.length == SLOT_SIZE;
    assert measurement[0].length == 2;
    
    data[angleCounter] = new int[measurement.length][2];
    for (int i=0; i<measurement.length; i++) {
      data[angleCounter][i] = new int[2];
      data[angleCounter][i][0] = measurement[i][0];
      data[angleCounter][i][1] = measurement[i][1];
    }
    
    try {
      save();
    }
    catch (IOException ex) {
      throw new RuntimeException(ex);
    }
    
    int emptySlots = 0;
    for (int i=0; i<data.length; i++) {
      if (data[i] == null) {
        emptySlots++;
      }
    }
    
    System.out.println("empty slots: " + emptySlots);
    if (emptySlots == 0) {
      printData();
    }
  }
  
  
  public static boolean existData(int angleCounter)
  {
    return data[angleCounter] != null;
  }
  
  
  public static int[][] getData(int angleCounter)
  {
    return data[angleCounter];
  }
  
  
  public static void printData()
  {
    for (int slot=0; slot<data.length; slot++) {
      int[][] s = data[slot];
      if (s == null) {
        System.out.println("*** EMPTY ***");
        continue;
      }
      assert s.length == SLOT_SIZE;
      System.out.println("        {  // Slot " + slot);
      for (int i=0; i<SLOT_SIZE; i++) {
        int[] tuple = s[i];
        assert tuple.length == 2;
        System.out.println("          { " + tuple[0] + ", " + tuple[1] + " },  // " + i);
      }
      System.out.println("        },");
    }
  }
  
  
  private static int correctSlotValueX(int v)
  {
    if (v >= 0) {
      return v - WIDTH;
    }
    else {
      return v + WIDTH;
    }
  }
  
  
  private static int correctSlotValueY(int v)
  {
    if (v >= 0) {
      return v - HEIGHT;
    }
    else {
      return v + HEIGHT;
    }
  }
  
  
  private static void correctSlot(int[][] slot, int axis)
  {
    int first = slot[0][axis];
    for (int i=1; i<SLOT_SIZE; i++) {
      if (slot[i][axis] * first < 0) {
        assert i > 40 : "i=" + i;
        if (axis == 0) {
          slot[i][axis] = correctSlotValueX(slot[i][axis]);
        }
        else {
          slot[i][axis] = correctSlotValueY(slot[i][axis]);
        }
      }
      assert slot[i][axis] * first >= 0;
    }
  }
  
  
  public static void correctData()
  {
    for (int slot=0; slot<data.length; slot++) {
      int[][] s = data[slot];
      if (s == null) {
        System.out.println("*** EMPTY ***");
        continue;
      }
      assert s.length == SLOT_SIZE;
      correctSlot(s, 0);
      correctSlot(s, 1);
    }
  }
  
  
  public static void save() throws IOException
  {
    //if (true) throw new RuntimeException("save deactivated");
    
    System.out.println("saving shot data...");
    File f = new File(PATH);
    ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));
    try {
      out.writeObject(data);
    }
    finally {
      out.close();
    }
  }
  
  
  public static void tryLoad() throws IOException, ClassNotFoundException
  {
    InputStream fin;
    if (LOAD_FROM_CLASSPATH) {
      fin = ShotData.class.getResourceAsStream(PATH);
      if (fin == null) {
        return;
      }
    }
    else {
      File f = new File(PATH);
      if (!f.exists()) {
        return;
      }
      fin = new FileInputStream(f);
    }
    
    ObjectInputStream in = new ObjectInputStream(fin);
    try {
      data = (int[][][]) in.readObject();
      //correctData();
    }
    finally {
      in.close();
    }
  }
  
  
  
  public static void main(String[] args)
  {
    printData();
  }
}
