/*
created: Jun 22, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.behaviours;

import static asteroids.AsteroidsConstants.*;
import asteroids.*;
import asteroids.gui.DebugPainter;
import de.heise.anniversary.contest.asteroids.Ship;



public class GreedyBehaviour implements Behaviour
{
  private final static int LATENCY = 200;
  private final static int SEARCH_FRAMES = 30;
  
  private TurnDirection dir = TurnDirection.RIGHT;
  //private long lastTurnTime;
  //private TurnDirection nextTurn;
  //private int nextTurnFrames;
  private Target lastFocus;
  
  
  
  private float calcBang(Target t, int targetCount)
  {
    if (t.getKind().isUfo()) {
      return 1000000;
    }
    
    float bang = 100.0f; //t.getKind().getRadius();
                 // * (Math.abs(t.getSpeedX()) + Math.abs(t.getSpeedY()));
    bang = bang / ((t.getHitShotFrames() + 1) * (t.getHitTurnFrames() + 1));
    
    if (targetCount >= 7) {
      bang = bang / (t.getHitShotFrames() + 1);
    }
    
    if (t.getKind() == TargetKind.BIG_ASTEROID) {
      bang = bang * 20 / t.getHitShotFrames();
    }
    
    assert !Float.isNaN(bang);
    assert !Float.isInfinite(bang);
    assert bang >= 0;
    
    return bang;
  }
  
  
  private static boolean shouldTurn(Target t)
  {
    if (t.getKind() == TargetKind.MEDIUM_ASTEROID ||
        t.getKind() == TargetKind.BIG_ASTEROID) {
      return true;
    }
    else {
      return t.getHitTurnFrames() >= 2;
    }
  }
  
  
  public void action(GameWorld world)
  {
    //AngleMonitor angle = world.getAngleMonitor();
    TargetMonitor targets = world.getTargetMonitor();
    //BulletMonitor bullets = world.getBulletMonitor();
    
    Target focus = null;
    float focusBang = 0;
    TurnDirection focusDir = null;
    
    for (Target t: targets.getTargets()) {
      if (t.getEstimationAccuracy() >= 1 &&
          t.isFirePermission(world) &&
          t.isDistanceOk(world)) {
        TurnDirection d = t.getHitDirection();
        if (d != null) {
          float bang = calcBang(t, targets.getTargetCount());
          if (t == lastFocus || t.isOnCollision()) {
            bang *= 2.0f;
          }
          if (bang > focusBang) {
            focus = t;
            focusBang = bang;
            focusDir = d;
          }
        }
      }
    }
    
    lastFocus = focus;
    DebugPainter.get().setGreedyFocus(focus);
    
    if (focus != null) {
      if (dir != focusDir &&
          focusDir != TurnDirection.STILL &&
          shouldTurn(focus)) {
        //System.out.println("bang " + bang);
        dir = focusDir;
        /*
        if (focus.getHitTurnFrames() > 2) {
          dir = focusDir;
        }
        else {
          nextTurn = focusDir;
          nextTurnFrames = 2; // TODO optimieren   wieder rausnehmen?
        }
        */
      }
      /*
      else {
        nextTurn = null;
      }
      */
    }
    
    /*
    if (nextTurn != null) {
      nextTurnFrames--;
      if (nextTurnFrames <= 0) {
        dir = nextTurn;
        nextTurn = null;
      }
    }
    */
    
    int prio = (focus != null && focus.getKind().isUfo()) ? 40 : 15;
    world.turn(dir, prio);
  }
}
