/*
created: Jun 21, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids.behaviours;

import asteroids.*;
import de.heise.anniversary.contest.asteroids.Position;



public class AdjustBehaviour implements Behaviour
{
  private final static int FIXPOINT_ONE = 64;
  private final static int[] FIXPOINT_ONE_DATA = AngleMonitor.DATA[FIXPOINT_ONE];
  private final static int FIXPOINT_TWO = 192;
  private final static int[] FIXPOINT_TWO_DATA = AngleMonitor.DATA[FIXPOINT_TWO];
  
  private boolean adjusted = true;
  
  
  
  public boolean isAdjusted()
  {
    return adjusted;
  }
  
  public void startAdjust()
  {
    System.out.println("ADJUST...");
    adjusted = false;
  }

  
  private void adjustAngleCounter(GameWorld world, int value)
  {
    AngleMonitor angle = world.getAngleMonitor();
    int oldVal = angle.getAngleCounter();
    int newVal = value;
    switch (world.getLastTurn()) {
      case LEFT :
        newVal--;
        break;
      case RIGHT :
        newVal++;
        break;
      case STILL :
    }
    angle.setAngleCounter(newVal);
    System.out.println("ADJUSTED: " + oldVal + " -> " + newVal + " (" + value + ")");
    adjusted = true;
  }
  

  public void action(GameWorld world)
  {
    //int ac = world.getAngleMonitor().getAngleCounter();
    
    Position o = world.getGameStatus().getShip().getOrientation();
    
    if (o.getX() == FIXPOINT_ONE_DATA[0] && o.getY() == FIXPOINT_ONE_DATA[1]) {
      adjustAngleCounter(world, FIXPOINT_ONE);
    }
    else if (o.getX() == FIXPOINT_TWO_DATA[0] && o.getY() == FIXPOINT_TWO_DATA[1]) {
      adjustAngleCounter(world, FIXPOINT_TWO);
    }
    else {
      //System.out.println("adjusting...");
      adjusted = false;
      world.turn(TurnDirection.RIGHT, 100);
    }
  }
}
