/*
created: Jun 18, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import static asteroids.AsteroidsConstants.*;
import static org.junit.Assert.*;

import org.junit.Test;



public class Tools
{
  public static int mathModulo(int v, int mod)
  {
    if (v >= 0) {
      return v % mod;
    }
    else {
      return (mod + (v % mod)) % mod;
    }
  }
  
  
  public static int correctX(int x)
  {
    if (x < X_MIN) {
      return x + X_MAX - X_MIN;
    }
    else if (x > X_MAX) {
      return x - X_MAX + X_MIN;
    }
    return x;
  }
  
  
  public static int correctY(int y)
  {
    if (y < Y_MIN) {
      return y + Y_MAX - Y_MIN;
    }
    else if (y > Y_MAX) {
      return y - Y_MAX + Y_MIN;
    }
    return y;
  }
  
  
  public static float correctX(float x)
  {
    if (x < X_MIN) {
      return x + X_MAX - X_MIN;
    }
    else if (x > X_MAX) {
      return x - X_MAX + X_MIN;
    }
    return x;
  }
  
  
  public static float correctY(float y)
  {
    if (y < Y_MIN) {
      return y + Y_MAX - Y_MIN;
    }
    else if (y > Y_MAX) {
      return y - Y_MAX + Y_MIN;
    }
    return y;
  }
  
  
  public static double correctAngle(double radian)
  {
    if (radian >= 0) {
      return radian % (Math.PI * 2.0);
    }
    else {
      return Math.PI * 2.0 + (radian % (Math.PI * 2.0));
    }
  }
  
  
  public static int correctDistX(int dx)
  {
    if (dx > WIDTH / 2) {
      return dx - WIDTH;
    }
    if (dx < - WIDTH / 2) {
      return dx + WIDTH;
    }
    return dx;
  }
  
  
  public static int correctDistY(int dy)
  {
    if (dy > HEIGHT / 2) {
      return dy - HEIGHT;
    }
    if (dy < - HEIGHT / 2) {
      return dy + HEIGHT;
    }
    return dy;
  }
  
  
  public static int calcDistance(int x1, int y1, int x2, int y2)
  {
    int w = correctDistX(x1 - x2);
    int h = correctDistY(y1 - y2);
    
    return (int) Math.sqrt(w * w + h * h);
  }
  
  
  public static double calcAngle(double posX, double posY)
  {
    double len = Math.sqrt(posX * posX + posY * posY) + 0.1;
    //System.out.println("len=" + len);
    double dx = posX / len;
    assert dx <= 1 : "dx=" + dx;
    double a = Math.acos(dx);
    assert !Double.isNaN(a);
    
    if (posY >= 0) {
      return a;
    }
    else {
      return Math.PI * 2.0 - a;
    }
  }
  
  
  public static int calcCompassAngle(double radian)
  {
    int a = (int) Math.round(radian * 180.0 / Math.PI);
    return (360 - a + 90) % 360;
  }
  
  
  public static double calcAngleDistance(double a1, double a2)
  {
    double diff = Math.abs(a1 - a2);
    if (diff <= Math.PI) {
      return diff;
    }
    else {
      return Math.PI * 2.0 - diff;
    }
  }
  
  
  public static double calcAngleDiff(double a1, double a2)
  {
    double diff = Math.abs(a1 - a2);
    if (diff <= Math.PI) {
      return a1 - a2;
    }
    else {
      if (a1 >= a2) {
        return - (Math.PI * 2.0 - (a1 - a2));
      }
      else {
        return Math.PI * 2.0 + (a1 - a2);
      }
    }
  }
  
  
  
  // JUnit Test
  @Test
  public void test()
  {
    double pi2 = Math.PI * 2.0;
    double delta = 0.0001;
    double a = 0.12;
    double b = 2.5;
    double c = 5.7;
    
    assertEquals(a - b, calcAngleDiff(a, b), delta);
    assertEquals(b - a, calcAngleDiff(b, a), delta);
    assertEquals(pi2 - c + a, calcAngleDiff(a, c),  delta);
    assertEquals(-calcAngleDiff(a, c), calcAngleDiff(c, a),  delta);
    
    assertEquals(Math.abs(calcAngleDiff(a, b)), calcAngleDistance(a, b),  delta);
    assertEquals(Math.abs(calcAngleDiff(a, c)), calcAngleDistance(a, c),  delta);
    assertEquals(Math.abs(calcAngleDiff(b, a)), calcAngleDistance(b, a),  delta);
    assertEquals(Math.abs(calcAngleDiff(b, c)), calcAngleDistance(b, c),  delta);
    assertEquals(Math.abs(calcAngleDiff(c, a)), calcAngleDistance(c, a),  delta);
    assertEquals(Math.abs(calcAngleDiff(c, b)), calcAngleDistance(c, b),  delta);
    
    assertEquals(a, correctAngle(a), delta);
    assertEquals(a, correctAngle(pi2 +  a), delta);
    assertEquals(pi2 - a, correctAngle(-a), delta);
    
    assertEquals(0, mathModulo(0, 3));
    assertEquals(1, mathModulo(1, 3));
    assertEquals(2, mathModulo(5, 3));
    assertEquals(0, mathModulo(3, 3));
    assertEquals(1, mathModulo(-2, 3));
    assertEquals(2, mathModulo(-1, 3));
    assertEquals(0, mathModulo(-3, 3));
    assertEquals(1, mathModulo(-5, 3));
  }
}
