/*
created: Jun 19, 2008  Gereon Fassbender

$Revision$
$Date$
$Log$
*/

package asteroids;

import static asteroids.AsteroidsConstants.*;

import java.util.Arrays;

import de.heise.anniversary.contest.asteroids.*;



public class AngleMonitor
{
  private final static int COUNTER_SHIFT = 0;
  
  private boolean adjusted;
  private boolean fineAdjusted;
  private int angleCounter; // 0-255, Uhrzeigersinn, 0 ist rechts
  private int lastAngleCounter;
  private int[] currTuple = new int[2];
  private int[] lastTuple = new int[2];
  private int testFrameNo;
  
  private float[][] arcVectors = new float[256][2];
  
  
  
  public AngleMonitor()
  {
    for (int i=0; i<255; i++) {
      double a = calcAngleRadian(i);
      arcVectors[i][0] = (float) Math.cos(a);
      arcVectors[i][1] = (float) Math.sin(a);
    }
  }
  
  
  public int getAngleCounter()
  {
    return angleCounter;
  }
  
  
  private static double calcAngleRadian(int ac)
  {
    double angle = 360.0 - ((ac * ANGLE_RASTER / 1000) % 36000) / 100.0;
    //System.out.println("degree: " + angle);
    angle = angle * Math.PI / 180.0;
    
    return angle;
  }
  
  
  public double getAngleRadian()
  {
    return calcAngleRadian(angleCounter);
  }
  
  
  // negativ = Linksdrehung
  public float[] getArcVector(int relativeFrames)
  {
    int ac = Tools.mathModulo(angleCounter + relativeFrames, 256);
    return arcVectors[ac];
  }
  
  
  public boolean testHeading(double angleRad)
  {
    double diff = Math.abs(angleRad - getAngleRadian());
    if (diff > Math.PI) {
      diff = Math.PI * 2.0 - diff;
    }
    return diff < 0.03;
  }
  
  
  public boolean isFineAdjusted()
  {
    return true; //fineAdjusted;
  }


  public void setAngleCounter(int value)
  {
    angleCounter = Tools.mathModulo(value, 256);
    
    //System.out.println("angle-counter: " + angleCounter);
  }
  
  
  private void adjust()
  {
    for (int i=0; i<DATA.length; i++) {
      if (Arrays.equals(DATA[i], currTuple)) {
        setAngleCounter(i + COUNTER_SHIFT);
        adjusted = true;
        fineAdjusted = false;
        System.out.println("adjusted");
        return;
      }
    }
    
    throw new AssertionError("Illegal orientation: " + currTuple[0] + "/" + currTuple[1]);
  }
  
  
  private void fineAdjust(TurnDirection dir)
  {
    // TODO statt AssertionError adjust()? (Frames koennen verloren sein)
    
    if (dir == TurnDirection.LEFT) {
      for (int i=DATA.length-2; i>=0; i--) {
        if (Arrays.equals(DATA[i], currTuple) &&
            Arrays.equals(DATA[i+1], lastTuple)) {
          setAngleCounter(i + COUNTER_SHIFT);
          fineAdjusted = true;
          return;
        }
      }
      adjust();
      /*
      throw new AssertionError("Illegal orientation: " +
                               currTuple[0] + "/" + currTuple[1] + "  " +
                               lastTuple[0] + "/" + lastTuple[1]);*/
    }
    else {
      for (int i=1; i<DATA.length; i++) {
        if (Arrays.equals(DATA[i], currTuple) &&
            Arrays.equals(DATA[i-1], lastTuple)) {
          setAngleCounter(i + COUNTER_SHIFT);
          fineAdjusted = true;
          return;
        }
      }
      adjust();
      /*
      throw new AssertionError("Illegal orientation: " +
                               currTuple[0] + "/" + currTuple[1] + "  " +
                               lastTuple[0] + "/" + lastTuple[1]);*/
    }
  }
  
  
  public void moveOLD(TurnDirection dir, GameStatus game)
  {
    if (game.getShip() == null) {
      adjusted = false;
      fineAdjusted = false;
      return;
    }
    
    Position o = game.getShip().getOrientation();
    currTuple[0] = o.getX();
    currTuple[1] = o.getY();
    
    if (adjusted == false) {
      adjust();
      lastTuple[0] = currTuple[0];
      lastTuple[1] = currTuple[1];
      return;
    }
    
    if (dir == TurnDirection.STILL) {
      return;
    }
    
    if (Arrays.equals(currTuple, lastTuple)) {
      if (dir == TurnDirection.LEFT) {
        setAngleCounter(angleCounter - 1);
      }
      else {
        setAngleCounter(angleCounter + 1);
      }
      fineAdjusted = true;
    }
    else {
      fineAdjust(dir);
      lastTuple[0] = currTuple[0];
      lastTuple[1] = currTuple[1];
    }
  }
  
  
  public void registerMovement(TurnDirection dir, GameStatus game)
  {
    lastAngleCounter = angleCounter;
    
    if (game.getShip() == null) {
      return;
    }
    
    switch (dir) {
      case LEFT :
        setAngleCounter(angleCounter - 1);
        break;
      case RIGHT :
        setAngleCounter(angleCounter + 1);
        break;
      case STILL :
    }
  }
  
  
  public void ignoreLastMovement()
  {
    angleCounter = lastAngleCounter;
  }
  
  
  public boolean isConsistent(GameStatus game, TurnDirection lastTurn)
  {
    Ship ship = game.getShip();
    if (ship == null) {
      return true;
    }
    
    int expectedCounter = angleCounter;
    switch (lastTurn) {
      case RIGHT :
        expectedCounter--;
        if (expectedCounter < 0) {
          expectedCounter = 255;
        }
        break;
      case LEFT :
        expectedCounter++;
        if (expectedCounter > 255) {
          expectedCounter = 0;
        }
        break;
      case STILL :
    }
    
    boolean consistent = DATA[expectedCounter][0] == ship.getOrientation().getX() &&
                         DATA[expectedCounter][1] == ship.getOrientation().getY();
    if (!consistent) {
      System.out.println("ac: " + expectedCounter + "  " +
                         ship.getOrientation().getX() + "/" + ship.getOrientation().getY());
    }
    return consistent;
  }
  
  
  public void printTestData(GameStatus game)
  {
    Ship ship = game.getShip();
    if (ship == null) {
      //System.out.println("noship");
      return;
    }
    
    Position o = ship.getOrientation();
    System.out.println("          { " + o.getX() + ", " + o.getY() + " }, // " + testFrameNo);
    testFrameNo++;
  }
  
  
  
  
  // DATA ---------------------------------------------------------------------
  
  public final static int[][] DATA = {
      { 1536, 0 }, // 0
      { 1536, 0 }, // 1
      { 1528, -152 }, // 2
      { 1504, -296 }, // 3
      { 1472, -440 }, // 4
      { 1472, -440 }, // 5
      { 1416, -584 }, // 6
      { 1360, -720 }, // 7
      { 1280, -856 }, // 8
      { 1280, -856 }, // 9
      { 1192, -976 }, // 10
      { 1088, -1088 }, // 11
      { 976, -1192 }, // 12
      { 976, -1192 }, // 13
      { 856, -1280 }, // 14
      { 720, -1360 }, // 15
      { 584, -1416 }, // 16
      { 584, -1416 }, // 17
      { 440, -1472 }, // 18
      { 296, -1504 }, // 19
      { 152, -1528 }, // 20
      { 152, -1528 }, // 21
      { -152, -1528 }, // 22
      { -296, -1504 }, // 23
      { -296, -1504 }, // 24
      { -440, -1472 }, // 25
      { -584, -1416 }, // 26
      { -720, -1360 }, // 27
      { -720, -1360 }, // 28
      { -856, -1280 }, // 29
      { -976, -1192 }, // 30
      { -1088, -1088 }, // 31
      { -1088, -1088 }, // 32
      { -1192, -976 }, // 33
      { -1280, -856 }, // 34
      { -1360, -720 }, // 35
      { -1360, -720 }, // 36
      { -1416, -584 }, // 37
      { -1472, -440 }, // 38
      { -1504, -296 }, // 39
      { -1504, -296 }, // 40
      { -1528, -152 }, // 41
      { -1536, 0 }, // 42
      { -1536, 0 }, // 43
      { -1528, 152 }, // 44
      { -1528, 152 }, // 45
      { -1504, 296 }, // 46
      { -1472, 440 }, // 47
      { -1416, 584 }, // 48
      { -1416, 584 }, // 49
      { -1360, 720 }, // 50
      { -1280, 856 }, // 51
      { -1192, 976 }, // 52
      { -1192, 976 }, // 53
      { -1088, 1088 }, // 54
      { -976, 1192 }, // 55
      { -856, 1280 }, // 56
      { -856, 1280 }, // 57
      { -720, 1360 }, // 58
      { -584, 1416 }, // 59
      { -440, 1472 }, // 60
      { -440, 1472 }, // 61
      { -296, 1504 }, // 62
      { -152, 1528 }, // 63
      { 0, 1536 }, // 64
      { 152, 1528 }, // 65
      { 296, 1504 }, // 66
      { 440, 1472 }, // 67
      { 440, 1472 }, // 68
      { 584, 1416 }, // 69
      { 720, 1360 }, // 70
      { 856, 1280 }, // 71
      { 856, 1280 }, // 72
      { 976, 1192 }, // 73
      { 1088, 1088 }, // 74
      { 1192, 976 }, // 75
      { 1192, 976 }, // 76
      { 1280, 856 }, // 77
      { 1360, 720 }, // 78
      { 1416, 584 }, // 79
      { 1416, 584 }, // 80
      { 1472, 440 }, // 81
      { 1504, 296 }, // 82
      { 1528, 152 }, // 83
      { 1528, 152 }, // 84
      { 1536, 0 }, // 85
      { 1536, 0 }, // 86
      { 1528, -152 }, // 87
      { 1504, -296 }, // 88
      { 1504, -296 }, // 89
      { 1472, -440 }, // 90
      { 1416, -584 }, // 91
      { 1360, -720 }, // 92
      { 1360, -720 }, // 93
      { 1280, -856 }, // 94
      { 1192, -976 }, // 95
      { 1088, -1088 }, // 96
      { 1088, -1088 }, // 97
      { 976, -1192 }, // 98
      { 856, -1280 }, // 99
      { 720, -1360 }, // 100
      { 720, -1360 }, // 101
      { 584, -1416 }, // 102
      { 440, -1472 }, // 103
      { 296, -1504 }, // 104
      { 296, -1504 }, // 105
      { 152, -1528 }, // 106
      { -152, -1528 }, // 107
      { -152, -1528 }, // 108
      { -296, -1504 }, // 109
      { -440, -1472 }, // 110
      { -584, -1416 }, // 111
      { -584, -1416 }, // 112
      { -720, -1360 }, // 113
      { -856, -1280 }, // 114
      { -976, -1192 }, // 115
      { -976, -1192 }, // 116
      { -1088, -1088 }, // 117
      { -1192, -976 }, // 118
      { -1280, -856 }, // 119
      { -1280, -856 }, // 120
      { -1360, -720 }, // 121
      { -1416, -584 }, // 122
      { -1472, -440 }, // 123
      { -1472, -440 }, // 124
      { -1504, -296 }, // 125
      { -1528, -152 }, // 126
      { -1536, 0 }, // 127
      { -1536, 0 }, // 128
      { -1536, 0 }, // 129
      { -1528, 152 }, // 130
      { -1504, 296 }, // 131
      { -1472, 440 }, // 132
      { -1472, 440 }, // 133
      { -1416, 584 }, // 134
      { -1360, 720 }, // 135
      { -1280, 856 }, // 136
      { -1280, 856 }, // 137
      { -1192, 976 }, // 138
      { -1088, 1088 }, // 139
      { -976, 1192 }, // 140
      { -976, 1192 }, // 141
      { -856, 1280 }, // 142
      { -720, 1360 }, // 143
      { -584, 1416 }, // 144
      { -584, 1416 }, // 145
      { -440, 1472 }, // 146
      { -296, 1504 }, // 147
      { -152, 1528 }, // 148
      { -152, 1528 }, // 149
      { 152, 1528 }, // 150
      { 296, 1504 }, // 151
      { 296, 1504 }, // 152
      { 440, 1472 }, // 153
      { 584, 1416 }, // 154
      { 720, 1360 }, // 155
      { 720, 1360 }, // 156
      { 856, 1280 }, // 157
      { 976, 1192 }, // 158
      { 1088, 1088 }, // 159
      { 1088, 1088 }, // 160
      { 1192, 976 }, // 161
      { 1280, 856 }, // 162
      { 1360, 720 }, // 163
      { 1360, 720 }, // 164
      { 1416, 584 }, // 165
      { 1472, 440 }, // 166
      { 1504, 296 }, // 167
      { 1504, 296 }, // 168
      { 1528, 152 }, // 169
      { 1536, 0 }, // 170
      { 1536, 0 }, // 171
      { 1528, -152 }, // 172
      { 1528, -152 }, // 173
      { 1504, -296 }, // 174
      { 1472, -440 }, // 175
      { 1416, -584 }, // 176
      { 1416, -584 }, // 177
      { 1360, -720 }, // 178
      { 1280, -856 }, // 179
      { 1192, -976 }, // 180
      { 1192, -976 }, // 181
      { 1088, -1088 }, // 182
      { 976, -1192 }, // 183
      { 856, -1280 }, // 184
      { 856, -1280 }, // 185
      { 720, -1360 }, // 186
      { 584, -1416 }, // 187
      { 440, -1472 }, // 188
      { 440, -1472 }, // 189
      { 296, -1504 }, // 190
      { 152, -1528 }, // 191
      { 0, -1536 }, // 192
      { -152, -1528 }, // 193
      { -296, -1504 }, // 194
      { -440, -1472 }, // 195
      { -440, -1472 }, // 196
      { -584, -1416 }, // 197
      { -720, -1360 }, // 198
      { -856, -1280 }, // 199
      { -856, -1280 }, // 200
      { -976, -1192 }, // 201
      { -1088, -1088 }, // 202
      { -1192, -976 }, // 203
      { -1192, -976 }, // 204
      { -1280, -856 }, // 205
      { -1360, -720 }, // 206
      { -1416, -584 }, // 207
      { -1416, -584 }, // 208
      { -1472, -440 }, // 209
      { -1504, -296 }, // 210
      { -1528, -152 }, // 211
      { -1528, -152 }, // 212
      { -1536, 0 }, // 213
      { -1536, 0 }, // 214
      { -1528, 152 }, // 215
      { -1504, 296 }, // 216
      { -1504, 296 }, // 217
      { -1472, 440 }, // 218
      { -1416, 584 }, // 219
      { -1360, 720 }, // 220
      { -1360, 720 }, // 221
      { -1280, 856 }, // 222
      { -1192, 976 }, // 223
      { -1088, 1088 }, // 224
      { -1088, 1088 }, // 225
      { -976, 1192 }, // 226
      { -856, 1280 }, // 227
      { -720, 1360 }, // 228
      { -720, 1360 }, // 229
      { -584, 1416 }, // 230
      { -440, 1472 }, // 231
      { -296, 1504 }, // 232
      { -296, 1504 }, // 233
      { -152, 1528 }, // 234
      { 152, 1528 }, // 235
      { 152, 1528 }, // 236
      { 296, 1504 }, // 237
      { 440, 1472 }, // 238
      { 584, 1416 }, // 239
      { 584, 1416 }, // 240
      { 720, 1360 }, // 241
      { 856, 1280 }, // 242
      { 976, 1192 }, // 243
      { 976, 1192 }, // 244
      { 1088, 1088 }, // 245
      { 1192, 976 }, // 246
      { 1280, 856 }, // 247
      { 1280, 856 }, // 248
      { 1360, 720 }, // 249
      { 1416, 584 }, // 250
      { 1472, 440 }, // 251
      { 1472, 440 }, // 252
      { 1504, 296 }, // 253
      { 1528, 152 }, // 254
      { 1536, 0 } // 255
      /*
      { 1536, 0 }, // 256
      { 1536, 0 }, // 257
      { 1528, -152 }, // 258
      { 1504, -296 }, // 259
      { 1472, -440 }, // 260
      { 1472, -440 }, // 261
      { 1416, -584 }, // 262
      { 1360, -720 }, // 263
      { 1280, -856 }, // 264
      { 1280, -856 }, // 265
      { 1192, -976 }, // 266
      { 1088, -1088 }, // 267
      { 976, -1192 }, // 268
      { 976, -1192 }, // 269
      { 856, -1280 }, // 270
      { 720, -1360 }, // 271
      { 584, -1416 }, // 272
      { 584, -1416 }, // 273
      { 440, -1472 }, // 274
      { 296, -1504 }, // 275
      { 152, -1528 }, // 276
      { 152, -1528 }, // 277
      */
  };
  
  
  static
  {
    assert DATA.length == 256;
  }
  
  
  
  public static void main(String[] args)
  {
    for (int i=0; i<DATA.length-1; i++) {
      boolean found = false;
      for (int j=0; j<DATA.length-1; j++) {
        if (i != j && Arrays.equals(DATA[i], DATA[j])) {
          //System.out.println("" + i + " " +j);
          found = true;
        }
      }
      if (!found) {
        System.out.println("> " + i);
      }
    }
  }
}
