// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#ifndef __AST_HELPER_H
#define __AST_HELPER_H

#include "defines.h"

void matchObjects (const int*    xa, 
                   const int*    ya, 
                   const double* ta, 
                   const int*    xb, 
                   const int*    yb, 
                   const double* tb, 
                   int           sa, 
                   int           sb, 
                   double        knownSpeed,
                   int*          matchIndexListRet);

int testIntersection (double ax, double ay, double vx, double vy,
                      double bx, double by, double wx, double wym,
                      double& tRet, double& sRet);

double getShotAngle (double ax, double ay, double vx, double vy,
                     double bx, double by, double ws,
                     double& tRet);

bool trajectoryPointDist (double ax, double ay, double vx, double vy,
                          double bx, double by,
                          double& tRet, double& distRet);

double getCollisionTime (double ax, double ay, double vx, double vy,
                         double bx, double by, double ra, double rb);

double getCollisionTimeSingle (double ax, double ay, double vx, double vy,
                               double bx, double by, double ra, double rb);

int    wrapRel (int    x, int    xRel, int size);
double wrapRel (double x, double xRel, int size);

int    wrapAbs (int    x, int size);
double wrapAbs (double x, int size);

double angleForVec (double x, double y);
void   vecForAngle (double a, double& xRet, double& yRet);

double mySqrt (double x);
double myAcos (double x);

#endif

