#ifndef INC_TOOLS
#define INC_TOOLS

/// here are some tools we use in our code to make it easiert
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <string.h>
#include <conio.h>

#define PI       (float)3.14159265358979323846

inline void fatalError(const char * text)
{
	fprintf(stderr,text);
	// give the debugger a hint
	
	// _asm int 0x3;

	printf("fatal error %s\n",text);
	// getch();
	
	// exit(0);
}

#ifndef _DEBUG
#define printLog
#else
void printLog(const char * fmt,...);
#endif

#define fatalAssert(cond,txt) if (!(cond)) fatalError(txt);

template <class X> void swap(X & o1,X & o2) {X h=o1;o1=o2;o2=h;}

template <unsigned int MAXSIZE,class X,int isBaseType=1> class constArrayT {	
	/// data ob object
	X data[MAXSIZE];
	/// items in this list
	int size;
public:
	///
	int getMaxCount() const { return MAXSIZE;}
	///
	template <int OT> void assign(const constArrayT<OT,X> & sec)
	{
		if (sec.count()>MAXSIZE)
			fatalError("size problem");
		for (int i=0;i<sec.count();i++)
			data[i]=sec.item(i);
		size=sec.count();
	}	
	/// copy ctor
	constArrayT(const constArrayT<MAXSIZE,X,isBaseType> & sec)
	{
		size=0;
		assign(sec);		
	}
	///
	constArrayT<MAXSIZE,X,isBaseType> & operator=(const constArrayT<MAXSIZE,X,isBaseType> & sec)  { assign(sec);return *this;}
  /// ctor
	constArrayT() { size=0;}
	///
	void clear()  { size=0;}
	/// remove item on position nr
	void del(int nr)
	{	if (nr>=size)
			fatalError("const array out of bounce");

	  if (nr!=size-1)
		{
			if (isBaseType)
				memmove(data+nr,data+nr+1,sizeof(X)*(size-nr-1));
			else
				for (int i=nr;i<size-1;i++)
					data[i]=data[i+1];
		}
		size--;
	}
	///
	X & add()
	{	if (size>=MAXSIZE)
		  fatalError("const array out of bounce");				
		return data[size++]=X();
	}
	///
	X & add(const X & item)
	{
		if (size>=MAXSIZE)
		  fatalError("const array out of bounce");				
		return data[size++]=item;
		
	}
	///
	void resize(int newSize) 
	{ if (newSize>MAXSIZE)
			fatalError("const array out of bounce");				
		size=newSize;
	}
	/// return item on pos
	X & last() const
	{ if (size==0)
	    fatalError("const array out of bounce");
		return (X&)data[size-1];
	}
	/// return item on pos
	X & item(int pos) const
	{ if (pos>=size)
	    fatalError("const array out of bounce");
		return (X&)data[pos];
	}
	/// overload op to mnake it easier to write
	X & operator [] (int pos) const
	{ if (pos>=size)
	    fatalError("const array out of bounce");
		return (X&)data[pos];
	}
	///
	int count() const { return size;}
};

/// 
template <unsigned int MAXSIZE,class X> class constFlowArrayT {
	X   data[MAXSIZE];
	int write;
	int size;
	///
	int wrapUp(int p)   const { return p>=MAXSIZE?MAXSIZE-p:p;}
	int wrapDown(int p) const { return p<0?MAXSIZE+p:p;}
public:
	///
	int getMaxCount() const { return MAXSIZE;}
	/// set with equal values
	void set(const X & obj) 
	{
		for (int i=0;i<MAXSIZE;i++)
			data[i]=obj;
	}
	/// ctor
	constFlowArrayT() { write=0;size=0;}
	///
	int count() const
	{				
		return size;
	}
	///
	void clear() { write=0;size=0;}
	///
	void add(const X & obj) 
	{ 		
		data[write++]=obj;	  
		write=wrapUp(write);
		size++;
		if (size>MAXSIZE)
			size=MAXSIZE;				
	}
	/// number 0 is the oldest number MAXSIZE-1 the latest)
	X & item(int nr) const
	{	if (nr>=count())
			fatalError("out or range");
		int pos=wrapDown(write-size+nr);		
		return (X&)data[pos];
	}
	///
	X & first() const	{	return (X&)data[wrapDown(write-size)];	}
	///
	X & last() const  { return (X&)data[wrapDown(write-1)];	}
};

/// some basic vector stuff
template <class X> class vecT {
	X xd,yd;
public:
	///
	vecT<X>(X * obj) { xd=obj[0];yd=obj[1];}
	///
	vecT<X>(X _x,X _y) { xd=_x;yd=_y;}
	///
	vecT<X>() {xd=0;yd=0;}
	///
	void operator()(X x,X y) { this->xd=x;this->yd=y;}
	///
	vecT<X> operator *(X s) const { return vecT<X>(xd*s,yd*s);}
	///
	vecT<X> operator /(X s) const { return vecT<X>(xd/s,yd/s);}
	///
	vecT<X> operator +(const vecT<X> & sec) const { return vecT<X>(xd+sec.xd,yd+sec.yd);}
	///
	int equ(const vecT<X> & sec) const { return fabs(xd-sec.xd)<1e-6 && fabs(yd-sec.yd)<1e-6;}
	///
	vecT<X> operator -(const vecT<X> & sec) const { return vecT<X>(xd-sec.xd,yd-sec.yd);}
	///
	X len() const { return sqrt(float(xd*xd+yd*yd));}
	///
	X lenQ() const { return xd*xd+yd*yd;}
	///
	vecT<X> normale() const { return vecT<X>(-yd,xd);}		
	///
	vecT<X> norm(float v)  const
	{ float l=len();
		if (l<1e-10) return vecT<X>(0,0);
		float h=v/l;	  
	  return vecT<X>(xd*h,yd*h);
	};
	///
	X  skalar(const vecT<X> & sec) const { return xd*sec.xd+yd*sec.yd;}
	///
	X  cross(const vecT<X> & sec) const { return xd*sec.yd-yd*sec.xd;}
	///
	X  & x() const { return (X&)xd;}
	X  & y() const { return (X&)yd;}	
};

typedef vecT<int> vecIntC;
typedef vecT<float> vecDblC;

/// einen Shell Sort mit externen Comperator !
template <class X,class Y,class Z> void shellSort(X & l,size_t count,const Y & comp,Z)
{
  int para,paraq;
  para=3;
  paraq=para*para;
  // get the min element
  long h;
  int N=int(count);
  if (N>0){
    Z v;
    int j;
    for (h=1;h<N/paraq;h=para*h+1);
     for (;h>0;h/=para)
      for (int i=h+1;i<=N;i++)
      { v=l[i-1];
        j=i;
        while (j>h && comp.greater(l[j-h-1],v))
          { l[j-1]=l[j-h-1];j-=h;
          }
        l[j-1]=v;
      }
  }
}


/** raw intersect from two straigt liens without any additional overhead
    
		parameter
		
		p0 and p1 point on first line
		p2 and p3 point on second line

		return 
		0 : no intersection is possible
		1 : intersection was made and return is in pOut
*/ 
template <class X> int intersectLineLine(const X & p0,const X & p1,const X & p2,const X & p3,X & pOut)
{

  X     u (p1-p0);
  X     v (p3-p2);
  X     a (p2-p0);

  // Systemdeterminante berechnen
  float sysdet = u.x()*v.y()-u.y()*v.x();

  if (fabs(sysdet)<1e-8)
    return 0;

  pOut = p0 + u*((a.x()*v.y()-a.y()*v.x())/sysdet); 
  return 1;
}


inline int round(float x) { return int(x>0?x+0.5:x-0.5);}

inline float angle(const vecDblC & base,const vecDblC & vec)
{
	vecDblC h(base.norm(1));
	vecDblC v(vec.norm(1));
	float s=h.skalar(v);
	float a=acos(s);

	if (h.cross(vec)<0.0)
		a=2*PI-a;
	return a;
}

inline vecDblC convVec(const vecIntC & v) { return vecDblC(v.x(),v.y());}
inline vecIntC convVec(const vecDblC & v) { return vecIntC(round(v.x()),round(v.y()));}

/// something special .. screen coord .. because the screen is continues ..
template <int XDIM,int YDIM> class vecScreenT {
	vecIntC pos;
public:
	/// 
	vecScreenT(const vecIntC & p):pos(p) { };
};

typedef vecScreenT<1024,768> vecScreenC;

/// 
inline void vecScreenPositionMap(vecIntC & p)
{
	p.x()%=1024;
	p.y()%=768;

	while(p.x()<0) p.x()+=1024;
	while(p.y()<0) p.y()+=768;
	
}

inline void vecScreenPositionMap(vecDblC & p)
{
	p.x()=fmod(p.x(),1024);
	p.y()=fmod(p.y(),768);

	while(p.x()<0) p.x()+=1024;
	while(p.y()<0) p.y()+=768;

	
}

inline void vecScreenPositionMap(vecIntC & p0,vecIntC & p1)
{
	int oldX=p0.x();
	int oldY=p0.y();

	while(p0.x()<0) p0.x()+=1024;
	while(p0.y()<0) p0.y()+=768;
	while(p0.x()>1024) p0.x()-=1024;
	while(p0.y()>768) p0.y()-=768;
	
	p1.x()+=p0.x()-oldX;
	p1.y()+=p0.y()-oldY;
}

inline void vecScreenPositionMap(vecIntC & p0,vecIntC & p1,vecIntC & p2)
{
	int oldX=p0.x();
	int oldY=p0.y();

	
	while(p0.x()<0) p0.x()+=1024;
	while(p0.y()<0) p0.y()+=768;
	while(p0.x()>1024) p0.x()-=1024;
	while(p0.y()>768) p0.y()-=768;
	
	p1.x()+=p0.x()-oldX;
	p1.y()+=p0.y()-oldY;
	
	p2.x()+=p0.x()-oldX;
	p2.y()+=p0.y()-oldY;
}

inline void vecScreenPositionMap(vecDblC & p0,vecDblC & p1)
{
		
	float oldX=p0.x();
	float oldY=p0.y();

	while(p0.x()<0) p0.x()+=1024;
	while(p0.y()<0) p0.y()+=768;
	while(p0.x()>1024) p0.x()-=1024;
	while(p0.y()>768) p0.y()-=768;
	
	p1.x()+=p0.x()-oldX;
	p1.y()+=p0.y()-oldY;
}
/// methode to normalize two points on the same screen
template <class Z,class X> inline void vecScreenPositionNormalize(const X & p1,X & p2)
{
	// select p1 as base
	Z dx=p2.x()-p1.x();
	Z dy=p2.y()-p1.y();

	while (dx < -512) dx += 1024;
	while (dx > 511) dx -= 1024;

	while (dy < -384) dy += 768; 
	while (dy > 383) dy -= 768;

	p2.x()=p1.x()+dx;
	p2.y()=p1.y()+dy;
}

/** class to make some time measurement
*/
class timeFrameC {
	float startTime;
public:
	/// ctor take current time
	timeFrameC();
	/// return the run time up to this point
	long runTime(int update=0);
	/// update to current time
	void update();
};


int intersectWrapLinePoint(
				const vecDblC & _p0,
				const vecDblC & _dir,
				const vecDblC & _point,
				float minDist,
				float maxDist,
				int maxResult,int * resultCount,
				// result holds entry time and exit time on point (in,out)
				float * resultArray);


/** raw intersect on vector base two lines and return values to intersection point 
    there is no timing return value

		a= scale factor for d0 -> p0+d0*a
		b= scale factor for d1 -> p1+d1*b
*/
int intersectLineLine(const vecDblC & p0,const vecDblC & d0,const vecDblC & p1,const vecDblC & d1,float epsParallel,float & a,float & b);

/** intersect a line with a given cicle
    
		return code 
		< 0 no intersection   a1 a2 undef distCenter is distance from center
		> 0 intersection      a1 a2 defines a1<a2 distCenter is distance from center
		= 0 tangent           a1=a2 distCenter is distance from center (=rad);
*/

int intersectLineCircle(const vecDblC & p0,const vecDblC & d0,const vecDblC & m,float rad,vecDblC & a1,vecDblC & a2);
/// same as above but returns the factors of a1 and a2 instead of the points
int intersectLineCircle(const vecDblC & p0,const vecDblC & d0,const vecDblC & m,float rad,float & a1,float & a2);

/** methode return the intersection with offsets 

    return array has
		a,b pair for each hit which indicate the offset time for p0+d0*a and p1+d1*b
*/
int intersectWrapLineLineHit(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & dir0,
			///
			const vecDblC & p1,const vecDblC & dir1,						
			/// minDist for parallel info
			float minDist,
			///
			float maxDist,			
			/// per result item are two results !
			int maxResult,
			/// number of return results
			int * resultCount,
			/// return arry for the times ..
			float * resultArray
);


struct intersectWrapLineLineWaitFireS {
	///
	intersectWrapLineLineWaitFireS() { startWaitTime=0;startFlyTime=0;endWaitTime=0;endFlyTime=0;}
	///
	intersectWrapLineLineWaitFireS(const intersectWrapLineLineWaitFireS & sec)
	{
		set(sec);		
	}
	/// set data from other objects
	void set(const intersectWrapLineLineWaitFireS & sec)
	{
		memcpy(this,&sec,sizeof(*this));		
	}	
	/// wait time to fire
	float startWaitTime;
	/// time to hit object after wait (relative)
	float startFlyTime;
	/// 
	float endWaitTime;
	///
	float endFlyTime;
	///
	void offset(float deltaT) { startWaitTime+=deltaT;endWaitTime+=deltaT;}
	/// limit fly time to the given value return 0 if this is not possibe
	int  limitFlyTime(float minLimit,float maxLimit);
	/** calc real hit with this data
	    intput time is the current time
			output fireTime and flyTime we return here only real time data in full frames
	*/
	int  calcFireTime(float time,unsigned int & fireTime,unsigned int & flyTime);	
	///
	void sum(const intersectWrapLineLineWaitFireS & sec)
	{ startWaitTime+=sec.startWaitTime;
	  startFlyTime+= sec.startFlyTime;
		endWaitTime += sec.endWaitTime;
		endFlyTime  += sec.endFlyTime;
	}
	/// 
	void div(int count)
	{
		startWaitTime/=float(count);
		startFlyTime/=float(count);
		endWaitTime/=float(count);
		endFlyTime/=float(count);

	}
};


/** this methode will return the exact timing for a object intersection 
    the return values are indication the offset for p0,d0 as

		result is in intersectWrapLineLineWaitFireS 
*/
int intersectWrapLineLineWaitFire(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & dir0,
			///
			const vecDblC & p1,const vecDblC & dir1,			
			/// minimal distace to be a hit ..
			float minDist,
			/// the maximal time for p0+a*d0
			float maxTime,
			/* the result */
			intersectWrapLineLineWaitFireS * resultArray
);
    


/** methode to intersect and return timmings for the intersections 
    retunrs the hit time of two objects or nohting if this is not possible
		important the timing is used at this case and if they are not at the same place/time no result is returned
*/
int intersectWrapLineLineTime(
			/// point for first and for second line				
			const vecDblC & p0,const vecDblC & dir0,
			///
			const vecDblC & p1,const vecDblC & dir1,			
			///
			int maxTime,
			///
			int minDist,
			/// per result item are two results !
			int maxResult,
			/// number of return results
			int * resultCount,
			/// return arry for the times ..
			float * resultArray
);


#if 0
/** when and in which direction do i have to fire to hit a given target */
int getHitData(
			/// my current position					
			const  vecIntC & p0,			
			/// this distance on which offset the shot starts from my position
			float fireOff,
			/// the speed of the object that we fire ..
			float fireSpeed,
			/// my target object position0 and position1
			const vecIntC & posTarget0,const vecIntC & posTarget1,
			/// my target object timing
			unsigned int t0,unsigned int t1,
			///
			int maxTime,
			/// minimal distance of object
			int minDist,
			/// max result that i want
			int maxResults,
			/// return return
			int * resultCount,
			/// return a array of timing and angle for a possible hit in center of object (angle is not in wb)
			float * resultArray);

#endif


#endif