#include "gameobj.h"

/** important props we found out ..
    a source type 5 fire in 40 Frame offset shoots !

*/

gameObjPropS gameObjProp[objTypeShip+1]={

  {   1,   0,-1,TIME_INFINITE/2,TIME_INFINITE,  0,0}, // unknown 0
	{   2,   7,-1,TIME_INFINITE/2,TIME_INFINITE,  16 | 32 | 64,100 }, // astro small 1
	{   4,  15,-1,TIME_INFINITE/2,TIME_INFINITE,  16 | 32 | 64,50 }, // astro med 2
	{   8,  31,-1,TIME_INFINITE/2,TIME_INFINITE,  16 | 32 | 64,20 }, // astro large 3
	{  16,  10,-1,1024,1024									 ,  16 | 32 | 64 | 2 | 4 | 8,1000 }, // soucer small 4
	{  32,  20,-1,1024,1024									 ,  16 | 32 | 64 | 2 | 4 | 8,200 }, // soucer large 5
	{  64,   1,-1,71           ,71           ,  16 | 32 |  2 | 4 | 8 ,0}, // shoot 6
	{ 128,  15,-1,TIME_INFINITE/2,TIME_INFINITE,  16 | 32 | 64 | 2 | 4 | 8,0  }  // my ship 7
};

rotationDataS rotationData[MAX_ANGLE]={
	{1536 ,0		,				 0.0 }		,
	{1536 ,0		,		      3.6   },
	{1528 ,152	,		      8.2   },
	{1504 ,296	,		      12.7  },
	{1472 ,440	,		      16.5  },
	{1472 ,440,			      21.2}, 
	{1416 ,584,			      25.2}, 
	{1360 ,720	,		      29.5	},
	{1280 ,856	,		       33.5 },
	{1280 ,856	,		       37.8 },
	{1192 ,976	,		       41.7    },
	{1088 ,1088,		       46.2		 },
	{976 ,1192	,		       50.8		 },
	{976 ,1192	,		       55.3		 },
	{856 ,1280,			       59.4	 },
	{720 ,1360	,		       63.4		 },
	{584 ,1416	,		       67.5		 },
	{584 ,1416	,		       71.6		 },
	{440 ,1472	,		       76.1		 },
	{296 ,1504	,		       79.9		 },
	{152 ,1528	,		       84.5    },
	{152 ,1528	,		       89.1		 },
	{-152 ,1528,		       92.8		 },
	{-296 ,1504,		       97.2		 },
	{-296 ,1504,		       101.8	 },
	{-440 ,1472,		       105.5	 },
	{-584 ,1416,		       110.2	 },
	{-720 ,1360,		       114.1	 },
	{-720 ,1360,		       118.1	 },
	{-856 ,1280,		       122.8	 },
	{-976 ,1192,		       126.7   },
	{-1088 ,1088,		       131.1 },
	{-1088 ,1088	,	       135.0	 },
	{-1192 ,976	,	       139.4	 },
	{-1280 ,856	,	       143.3	 },
	{-1360 ,720	,	       147.9	 },
	{-1360 ,720	,	       151.9	 },
	{-1416 ,584	,	       156.6	 },
	{-1472 ,440	,	       160.7	 },
	{-1504 ,296	,	       164.5	 },
	{-1504 ,296	,	       169.2	 },
	{-1528 ,152	,	       172.8	 },
	{-1536 ,0		,	       177.3	 },
	{-1536 ,0		,	       181.9	 },
	{-1528 ,-152	,	       185.5	 },
	{-1528 ,-152	,	       189.9	 },
	{-1504 ,-296	,	       194.5	 },
	{-1472 ,-440	,	       198.2	 },
	{-1416 ,-584	,	       203.0	 },
	{-1416 ,-584	,	       206.9	 },
	{-1360 ,-720	,	       211.0   },
	{-1280 ,-856	,	       215.4	 },
	{-1192 ,-976	,	       220.0	 },
	{-1192 ,-976	,	       223.8	 },
	{-1088 ,-1088,	       227.5	 },
	{-976 ,-1192	,	       232.2	 },
	{-856 ,-1280	,	       235.9	 },
	{-856 ,-1280	,	       240.3	 },
	{-720 ,-1360	,	       245.1	 },
	{-584 ,-1416	,	       248.8	 },
	{-440 ,-1472	,	       252.7	 },
	{-440 ,-1472	,	       257.3	 },
	{-296 ,-1504	,	       261.1	 },
	{-152 ,-1528	,	       265.6	 },
	{0 ,-1536		,	       270.0	 },
	{152 ,-1528	,	       273.6	 },
	{296 ,-1504	,	       278.2	 },
	{440 ,-1472	,	       282.7	 },
	{440 ,-1472	,	       286.5	 },
	{584 ,-1416	,	       291.2	 },
	{720 ,-1360	,	       295.0   },
	{856 ,-1280	,	       299.0	 },
	{856 ,-1280	,	       303.5	 },
	{976 ,-1192	,	       307.8	 },
	{1088 ,-1088	,	       311.7	 },
	{1192 ,-976	,	       316.2	 },
	{1192 ,-976	,	       320.0	 },
	{1280 ,-856	,	       324.5	 },
	{1360 ,-720	,	       328.6	 },
	{1416 ,-584	,	       332.7	 },
	{1416 ,-584	,	       336.6	 },
	{1472 ,-440	,	       341.6	 },
	{1504 ,-296	,	       345.3	 },
	{1528 ,-152	,	       349.9	 },
	{1528 ,-152	,	       354.5	 },
	{1536 ,0			,	       358.1	 },
	{1536 ,0			,	       2.8		 },
	{1528 ,152		,	       7.2		 },
	{1504 ,296		,	       11.0		 },
	{1504 ,296		,	       15.5		 },
	{1472 ,440		,	       19.3    },
	{1416 ,584		,	       23.4		 },
	{1360 ,720		,	       28.1		 },
	{1360 ,720		,	       32.8		 },
	{1280 ,856		,	       36.7		 },
	{1192 ,976		,	       40.6		 },
	{1088 ,1088	,	       45.0		 },
	{1088 ,1088	,	       49.4		 },
	{976 ,1192		,	        53.3	 },
	{856 ,1280		,	        57.2	 },
	{720 ,1360		,	        61.9	 },
	{720 ,1360		,	        66.6	 },
	{584 ,1416		,	        70.7	 },
	{440 ,1472		,	        74.5	 },
	{296 ,1504		,	        79.0	 },
	{296 ,1504		,	        82.8	 },
	{152 ,1528		,	        87.2	 },
	{-152 ,1528	,	        91.9	 },
	{-152 ,1528	,	        95.5	 },
	{-296 ,1504	,	        100.1	 },
	{-440 ,1472	,	        104.7  },
	{-584 ,1416	,	        108.4	 },
	{-584 ,1416	,	        113.4	 },
	{-720 ,1360	,	        117.3	 },
	{-856 ,1280	,	        121.4	 },
	{-976 ,1192	,	        125.6	 },
	{-976 ,1192	,	        130.0	 },
	{-1088 ,1088	,	        133.8	 },
	{-1192 ,976	,	        138.3	 },
	{-1280 ,856	,	        142.2	 },
	{-1280 ,856	,	        146.5	 },
	{-1360 ,720	,	        151.0	 },
	{-1416 ,584	,	        155.0	 },
	{-1472 ,440	,	        158.8	 },
	{-1472 ,440	,	        163.6	 },
	{-1504 ,296	,	        167.3	 },
	{-1528 ,152	,	        171.8	 },
	{-1536 ,0		,	        176.6	 },
	{-1536 ,0		,	        180.0	 },
	{-1536 ,0		,	        184.4	 },
	{-1528 ,-152	,	        188.9  },
	{-1504 ,-296	,	        192.7	 },
	{-1472 ,-440	,	        197.3	 },
	{-1472 ,-440	,	        201.2	 },
	{-1416 ,-584	,	        205.0	 },
	{-1360 ,-720	,	        209.7	 },
	{-1280 ,-856	,	        214.2	 },
	{-1280 ,-856	,	        217.8	 },
	{-1192 ,-976	,	        222.5	 },
	{-1088 ,-1088,	        226.2	 },
	{-976 ,-1192	,	        230.0	 },
	{-976 ,-1192	,	        234.6	 },
	{-856 ,-1280	,	        239.0	 },
	{-720 ,-1360	,	        243.1	 },
	{-584 ,-1416	,	        247.0	 },
	{-584 ,-1416	,	        251.8	 },
	{-440 ,-1472	,	        255.5	 },
	{-296 ,-1504	,	        260.1	 },
	{-152 ,-1528	,	        264.5	 },
	{-152 ,-1528	,	        268.1	 },
	{152 ,-1528	,	        272.7  },
	{296 ,-1504	,	        277.2	 },
	{296 ,-1504	,	        280.8	 },
	{440 ,-1472	,	        285.5	 },
	{584 ,-1416	,	        289.3	 },
	{720 ,-1360	,	        293.4	 },
	{720 ,-1360	,	        298.1	 },
	{856 ,-1280	,	        302.2	 },
	{976 ,-1192	,	        306.7	 },
	{1088 ,-1088	,	        310.6	 },
	{1088 ,-1088	,	        315.0	 },
	{1192 ,-976	,	        318.9	 },
	{1280 ,-856	,	        323.3	 },
	{1360 ,-720	,	        327.2	 },
	{1360 ,-720	,	        331.9	 },
	{1416 ,-584	,	        335.9	 },
	{1472 ,-440	,	        339.8	 },
	{1504 ,-296	,	        344.5	 },
	{1504 ,-296	,	        348.2	 },
	{1528 ,-152	,	        352.8	 },
	{1536 ,0			,	        357.2  },
	{1536 ,0			,	        0.9		 },
	{1528 ,152		,	        5.5		 },
	{1528 ,152		,	        10.1	 },
	{1504 ,296		,	        13.9	 },
	{1472 ,440		,	        18.4	 },
	{1416 ,584		,	        22.5	 },
	{1416 ,584		,	        26.6	 },
	{1360 ,720		,	        30.6	 },
	{1280 ,856		,	        34.7	 },
	{1192 ,976		,	        39.2	 },
	{1192 ,976		,	        43.8	 },
	{1088 ,1088	,	        48.3	 },
	{976 ,1192		,	        52.2	 },
	{856 ,1280		,	        56.5	 },
	{856 ,1280		,	        60.5	 },
	{720 ,1360		,	        64.7	 },
	{584 ,1416		,	        68.8	 },
	{440 ,1472		,	        73.5	 },
	{440 ,1472		,	        77.3	 },
	{296 ,1504		,	        81.8  },
	{152 ,1528		,	        86.4	},
	{0 ,1536			,	        90.0	},
	{-152 ,1528	,	        94.5	},
	{-296 ,1504	,	        98.9	},
	{-440 ,1472	,	        102.7 },
	{-440 ,1472	,	        107.3 },
	{-584 ,1416	,	        111.2 },
	{-720 ,1360	,	        115.3 },
	{-856 ,1280	,	        120.2 },
	{-856 ,1280	,	        124.2 },
	{-976 ,1192	,	        127.8 },
	{-1088 ,1088	,	        132.5 },
	{-1192 ,976	,	        136.1 },
	{-1192 ,976	,	        140.8 },
	{-1280 ,856	,	        145.3 },
	{-1360 ,720	,	        149.8 },
	{-1416 ,584	,	        153.9 },
	{-1416 ,584	,	        157.9 },
	{-1472 ,440	,	        161.8 },
	{-1504 ,296	,	        166.3 },
	{-1528 ,152	,	        170.1 },
	{-1528 ,152	,	        174.3 },
	{-1536 ,0		,	        179.1 },
	{-1536 ,0		,	        182.9 },
	{-1528 ,-152	,	        187.2 },
	{-1504 ,-296	,	        191.5 },
	{-1504 ,-296	,	        195.6 },
	{-1472 ,-440	,	        200.3 },
	{-1416 ,-584	,	        204.1 },
	{-1360 ,-720	,	        208.1 },
	{-1360 ,-720	,	        212.1 },
	{-1280 ,-856	,	        216.6 },
	{-1192 ,-976	,	        221.0 },
	{-1088 ,-1088,	        225.0 },
	{-1088 ,-1088,	        228.9 },
	{-976 ,-1192	,	        233.3 },
	{-856 ,-1280	,	        237.8 },
	{-720 ,-1360	,	        241.9 },
	{-720 ,-1360	,	        245.9 },
	{-584 ,-1416	,	        249.8 },
	{-440 ,-1472	,	        254.5 },
	{-296 ,-1504	,	        258.4 },
	{-296 ,-1504	,	        262.8 },
	{-152 ,-1528	,	        267.3 },
	{152 ,-1528	,	        270.9 },
	{152 ,-1528	,	        275.5 },
	{296 ,-1504	,	        279.9 },
	{440 ,-1472	,	        283.7 },
	{584 ,-1416	,	        288.2 },
	{584 ,-1416	,	        292.1 },
	{720 ,-1360	,	        296.1 },
	{856 ,-1280	,	        300.2 },
	{976 ,-1192	,	        304.7 },
	{976 ,-1192	,	        309.2 },
	{1088 ,-1088	,	        313.8 },
	{1192 ,-976	,	        317.5 },
	{1280 ,-856	,	        322.2 },
	{1280 ,-856	,	        325.8 },
	{1360 ,-720	,	        329.8 },
	{1416 ,-584	,	        334.7 },
	{1472 ,-440	,	        338.8} ,
	{1472 ,-440	,	        342.7 },
	{1504 ,-296	,	        347.2,}, 
	{1528 ,-152	,	        351.1},
	{1536 ,0			,	        355.5} 
};



/// we get an update point for the given data ..
void gameObjTimePointsC::update(unsigned int updateTimer,const vecIntC & inPos) 
{
	
	vecDblC h=convVec(inPos);
	/*
	if ((h-points.first().p).len()<1e-5)
	{
		// fatalError("no real update point");
	}
	*/

	pointDataS tmp;
	tmp.t=updateTimer;
	tmp.p=h;

	points.add(tmp);
	
	vecDblC & p0=points.first().p;

	int size=points.count();
	
	vecDblC m;

	float t=0;
	for (int i=1;i<size;i++)
	{		
		pointDataS & o=points.item(i);
		vecDblC & wp=o.p;
		t+=o.t;
		vecScreenPositionNormalize<float>(p0,wp);
		vecScreenPositionMap(p0,wp);	

		m=m+wp;
	}

	
	m=(m+p0)/float(size);

	predictTime=(t+points.first().t)/float(size);
	predictPos=m;

	vecDblC completeHead=points.last().p-points.first().p;

	vecDblC sum;

	if (size>2)
	{
		for (int a=0;a<size;a++)
		{
			vecDblC v1=points.item(a).p-m;
			sum=sum+vecDblC(v1.x()*v1.x(),v1.x()*v1.y());
		}
	}
	else
		sum=completeHead;

	if (sum.len()<1e-8)
		head=completeHead.norm(1);
	else
		head=(sum).norm(1);

	/*
	if (head.len()<1e-8)
		fatalError("head len");
	*/
	

	if (head.skalar(completeHead)<0)
		head=head*-1.0;

	/* debug scan code for min/max checkn 
	static int minX=10000,minY=100000;
	static int maxX=0,maxY=0;

	if (inPos.x()<minX) minX=inPos.x();
	if (inPos.y()<minY) minY=inPos.y();

	if (inPos.x()>maxX) maxX=inPos.x();
	if (inPos.y()>maxY) maxY=inPos.y();

	printLog("%d %d %d %d\n",minX,minY,maxX,maxY);
	*/

	// calc speed
	{
		int size=points.count();

		vecDblC p1,p2;
		float  t1=0,t2=0;
		
		int i=0,a;
		for (i=0;i<size/2;i++)    { p1=p1+points.item(i).p;t1=t1+points.item(i).t;}
		for (a=size/2;a<size;a++) { p2=p2+points.item(a).p;t2=t2+points.item(a).t;}

		p1=p1/float(i);
		t1/=float(i);

		p2=p2/float(a-size/2);
		t2/=float(a-size/2);


		vecDblC vec(p2-p1);
		float dt=t2-t1;
	

		if (dt<1)
			fatalError("calc speed on non track object");

		speed=vec.len()/dt;	
	}
	
}


vecDblC gameObjTimePointsC::getPredictPos(float t) const
{		
	
	float speed=getSpeed();

	// here we have the speed based on the known points (variable speed)

	float fullT=t-predictTime;
		
	vecDblC ret(predictPos+head.norm(speed*fullT));
	return ret;
}


void spaceShipC::update(unsigned int time,const vecIntC & pos,const vecIntC & head,int rotate)
{
	// update ship
	updateTime=time;
	// read new position
	position=pos;

	// we know our last index .. we will search for the values
	int sel=0;
		
			
	for (int i=0;i<256;i++)
	{
		// start on old value to search for new ..
		int idx=getHeadIdx(rotationIndex+sel);
		while(idx<0) idx+=256;
		
		int x=rotationData[idx].dx;
		int y=rotationData[idx].dy;
		if (head.x()==x && head.y()==y)
			break;

		sel*=-1;
		if (sel>=0)
			sel++;

	}


	// see if old and new are different
	int idx=getHeadIdx(rotationIndex+sel);	
	/*
	// see if this value is unique
	int u1=getHeadIdx(idx-1);
	int u2=getHeadIdx(idx+1);

	int uni=1;
	if (rotationData[idx].dx==rotationData[u1].dx && rotationData[idx].dy==rotationData[u1].dy) uni=0;
	if (rotationData[idx].dx==rotationData[u2].dx && rotationData[idx].dy==rotationData[u2].dy) uni=0;

	if (uni)
	{
		if (abs(getHeadDiff(idx,rotationIndex))>0)
			rotationIndex=idx;
	}
	*/
	// see if this is a single value ..
	if (abs(getHeadDiff(idx,rotationIndex))>1)
		rotationIndex=(idx+rotationIndex)/2.0;
	
					
}

int gameObjC::setKillTime(unsigned int currentTime,unsigned int time,unsigned int callerId,unsigned int callerTx,unsigned int & free)
{
	free=0;
	
	if (time>callerTx) return 0;

	// still alive here ?
	if (currentTime+getLiveTime(currentTime)<=time) 
		return 0;

	if (tx==TIME_INFINITE)
	{		
	}	
	else if (tx!=TIME_INFINITE)
	{				
		free=killerId;
	}
	
	tx=time;killerId=callerId;			
	return 1;
	
}

/// set my killing time and the object id of the killer
int gameObjC::setKillTime(unsigned int currentTime,unsigned int time,gameObjC & killer,unsigned int & free1,unsigned int & free2)
{ 	
	free1=0;
	free2=0;
	
	// still alive here ?
	if (currentTime+getLiveTime(currentTime)<=time) 
		return 0;
	if (currentTime+killer.getLiveTime(currentTime)<=time) 
		return 0;

	// ok both are living at this time ..

	// if both are not set at the moment accept them

	if (tx==TIME_INFINITE && killer.tx==TIME_INFINITE)
	{		
	}	
	else if (tx!=TIME_INFINITE && killer.tx==TIME_INFINITE)
	{				
		free1=killerId;
	}
	else if (tx==TIME_INFINITE && killer.tx!=TIME_INFINITE)
	{				
		free1=killer.killerId;
	}
	else 
	{				
		free1=killerId;
		free2=killer.killerId;

	}

	tx=time;killerId=killer.getKey();		
	killer.tx=time;killer.killerId=getKey();		
	return 1;
}

