#include "netcom.h"
#include "framescanner.h"

gameStatusC::gameStatusC()
{
	clear();
	points=0;
}

#define ADDDIGIT(d) ++numofdigits, currentPoints = currentPoints*10 + d

void gameStatusC::scanFrame(const framePacketC &packet)
{	
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;
	int numofdigits=0;
	int currentPoints=0;
	

	clear();

	frameindex=packet.frameno;

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;

	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{		 
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;

			if (numofdigits > 0)
      {  // Score sind die zuerst auftretenden Zahlen
         numofdigits = -numofdigits;
      }
			break;
		case 0xb: // HALT
			pc=1024;
			break;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3: // type 1
				objects.add().set(vsToAstroType(vs),vecIntC(vx+GAME_OFFX, vy+GAME_OFFY));
				break;
			case 0x8ff: // type 2
				objects.add().set(vsToAstroType(vs),vecIntC(vx+GAME_OFFX, vy+GAME_OFFY));
				break;
			case 0x90d: // type 3
				objects.add().set(vsToAstroType(vs),vecIntC(vx+GAME_OFFX, vy+GAME_OFFY));
				break;
			case 0x91a: // type 4
				objects.add().set(vsToAstroType(vs),vecIntC(vx+GAME_OFFX, vy+GAME_OFFY));
				break;
			case 0x929:				
				objects.add().set(vsToSaucerType(vs),vecIntC(vx+GAME_OFFX,vy+GAME_OFFY));	
				break;
				// taken from wiki sample .. thx to Matthias Fuchs
			 // http://www.heise.de/ct/projekte/machmit/asteroids/wiki/ContributedPorts
			 case 0xadd:    // Ziffer 0 oder O
					if (numofdigits >= 0)
						 ADDDIGIT(0);
					break;
			 case 0xb2e:    // Ziffer 1
					if (numofdigits >= 0)
						 ADDDIGIT(1);
					break;
			 case 0xb32:    // Ziffer 2
					if (numofdigits >= 0)
						 ADDDIGIT(2);
					break;
			 case 0xb3a:    // Ziffer 3
					if (numofdigits >= 0)
						 ADDDIGIT(3);
					break;
			 case 0xb41:    // Ziffer 4
					if (numofdigits >= 0)
						 ADDDIGIT(4);
					break;
			 case 0xb48:    // Ziffer 5
					if (numofdigits >= 0)
						 ADDDIGIT(5);
					break;
			 case 0xb4f:    // Ziffer 6
					if (numofdigits >= 0)
						 ADDDIGIT(6);
					break;
			 case 0xb56:    // Ziffer 7
					if (numofdigits >= 0)
						 ADDDIGIT(7);
					break;
			 case 0xb5b:    // Ziffer 8
					if (numofdigits >= 0)
						 ADDDIGIT(8);
					break;
			 case 0xb63:    // Ziffer 9
					if (numofdigits >= 0)
						 ADDDIGIT(9);
					break;
			}  
			break;
		case 0xd: // RTSL
			pc=1024;
			break;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			pc=1024;
			break;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				objects.add().set(objTypeShot,vecIntC(vx+GAME_OFFX, vy+GAME_OFFY));
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					ship_present = true;
					ship_x = vx+GAME_OFFX;
					ship_y = vy+GAME_OFFY;
					ship_dx = v1x - dx;
					ship_dy = v1y - dy;
					++shipdetect;

					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   
	
	points=currentPoints;
}


void gameStatusC::clear(void)
{
	ship_present = false;
	frameindex=0;
	objects.clear();
}
