﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;


namespace AKTGR_Asteroids
{
    public class VectorMachine
    {
        public int middleX;
        public int middleY;
        public int actX;
        public int actY;
        public Pen pen;
        public Brush brush;
        public int actS;
        public byte zdraw;
        public Graphics myG;
        public Boolean testDrawd = false;
        Bitmap BackBuffer;
        public VectorMachine(Graphics g)
        {
            BackBuffer = new Bitmap(Convert.ToInt16(g.VisibleClipBounds.Width), Convert.ToInt16(g.VisibleClipBounds.Height));
            brush = new SolidBrush(Color.Red);
            pen = new Pen(brush);
            pen.Color = Color.Red;
            myG = g;
            myG.PageUnit = GraphicsUnit.Pixel;
            middleX = Convert.ToInt16(myG.VisibleClipBounds.Width / 2);
            middleY = Convert.ToInt16(myG.VisibleClipBounds.Height / 2);
            actX = 0;
            actY = 0;
            myG.Clear(Color.Black);
            myG.DrawLine(pen, 0, middleY, myG.VisibleClipBounds.Width, middleY);
            myG.DrawLine(pen, middleX, 0, middleX, myG.VisibleClipBounds.Height);
            middleX = 0;
            middleY = 64;
            /// DEMO SCREEN
            /// 
            LABS(785, 284, 0);
            VCTR(0, 0, 7, 15);// Schuss
            LABS(700, 359, 14);
            VCTR(0, 0, 7, 15);// Schuss
            LABS(641, 413, 15);
            VCTR(0, 0, 7, 15); // Schuss
            LABS(572, 635, 14);
            VCTR(0, 0, 7, 15);  // Schuss
            LABS(294, 708, 15);
            JRSL("929"); // UFO
            LABS(626, 427, 14);
            VCTR(0, 0, 9, 0);
            VCTR(-256, 896, 4, 0); // Schiff
            VCTR(-640, -800, 4, 12);
            VCTR(-736, -64, 4, 12);
            VCTR(760, -288, 6, 12);
            VCTR(-432, 688, 6, 12);
            VCTR(64, -736, 4, 12);
            LABS(562, 168, 14);
            JRSL("8F3"); // Asteroid Type 1
            LABS(264, 789, 0);
            JRSL("91A"); // Asteroid Type 4
            LABS(319, 790, 14);
            JRSL("8FF"); // Asteroid Type 2
            LABS(17, 474, 14);
            JRSL("8F3"); // Asteroid Type 1
            LABS(819, 538, 15);
            JRSL("91A"); // Asteroid Type 4
            LABS(477, 463, 14);
            JRSL("8F3"); // Asteroid Type 1
            LABS(413, 643, 14);
            JRSL("91A"); // Asteroid Type 4
            LABS(306, 295, 15);
            JRSL("8FF"); // Asteroid Type 2
            LABS(605, 748, 15);
            JRSL("8FF"); // Asteroid Type 2
            JRSL("852"); //             ; Copyright-Meldung
            LABS(100, 876, 1);
            JRSL("B2C"); //             ; Leerzeichen
            JRSL("B2C"); //             ; Leerzeichen
            JRSL("B3A");//             ; 3
            JRSL("B2E"); //             ; 1
            JRSL("ADD"); //             ; 0
            LABS(160, 852, 14);
            JRSL("A6D"); //             ; Schiff
            JRSL("A6D"); //             ; Schiff
            JRSL("A6D"); //             ; Schiff
            LABS(480, 876, 0);
            JRSL("B2C");        //     ; Leerzeichen
            JRSL("B2C");          //   ; Leerzeichen
            JRSL("B2C");            // ; Leerzeichen
            JRSL("ADD");            // ; Leerzeichen
            JRSL("ADD");            // ; Leerzeichen
        }

        public void zcolor(int z)
        {
                switch (z)
                {
                    case 15:
                        pen.Color = Color.White;
                        break;
                    case 14:
                    case 13:
                    case 12:
                    case 11:
                    case 10:
                        pen.Color = Color.Gray;
                        break;
                    case 9:
                    case 8:
                    case 7:
                    case 6:
                    case 5:
                    case 4:
                    case 3:
                    case 2:
                    case 1:
                        pen.Color = Color.DarkGray;
                        break;
                    case 0:
                        pen.Color = Color.Black;
                        break;
                }
        }

        public void LABS(int x, int y, int s)
        {
            actX = x/2;
            actY = (Convert.ToInt16(myG.VisibleClipBounds.Height) - y/2);
            actS = s;
        }

        public void HALT()
        { 
        }

        public void JRSL(string adr)
        {
            switch (adr)
            {
                case "8F3":
                    drawAsteroid(1);
                    break;
                case "8FF":
                    drawAsteroid(2);
                    break;
                case "90D":
                    drawAsteroid(3);
                    break;
                case "91A":
                    drawAsteroid(4);
                    break;
                case "929":
                    drawUFO();
                    break;
                case "852":
                    drawLetter('c');
                    break;
                case "B2C":
                    drawLetter(' ');
                    break;
                case "A6D":
                    drawLetter('s');
                    break;
                case "B2E":
                    drawLetter('1');
                    break;
                case "B32":
                    drawLetter('2');
                    break;
                case "B3A":
                    drawLetter('3');
                    break;
                case "B41":
                    drawLetter('4');
                    break;
                case "B48":
                    drawLetter('5');
                    break;
                case "B4F":
                    drawLetter('6');
                    break;
                case "B56":
                    drawLetter('7');
                    break;
                case "B5B":
                    drawLetter('8');
                    break;
                case "B63":
                    drawLetter('9');
                    break;
                case "ADD":
                    drawLetter('O');
                    break;
                case "880":
                    drawExplosion(3);
                    break;
                case "896":
                    drawExplosion(2);
                    break;
                case "8B5":
                    drawExplosion(1);
                    break;
                case "8D0":
                    drawExplosion(0);
                    break;
            }

        }

        public void JRSL(int adr)
        {
            switch (adr)
            {
                case 0x8F3:
                    drawAsteroid(1);
                    break;
                case 0x8FF:
                    drawAsteroid(2);
                    break;
                case 0x90D:
                    drawAsteroid(3);
                    break;
                case 0x91A:
                    drawAsteroid(4);
                    break;
                case 0x929:
                    drawUFO();
                    break;
                case 0x852:
                    drawLetter('c');
                    break;
                case 0xB2C:
                    drawLetter(' ');
                    break;
                case 0xA6D:
                    drawLetter('s');
                    break;
                case 0xB2E:
                    drawLetter('1');
                    break;
                case 0xB32:
                    drawLetter('2');
                    break;
                case 0xB3A:
                    drawLetter('3');
                    break;
                case 0xB41:
                    drawLetter('4');
                    break;
                case 0xB48:
                    drawLetter('5');
                    break;
                case 0xB4F:
                    drawLetter('6');
                    break;
                case 0xB56:
                    drawLetter('7');
                    break;
                case 0xB5B:
                    drawLetter('8');
                    break;
                case 0xB63:
                    drawLetter('9');
                    break;
                case 0xADD:
                    drawLetter('O');
                    break;
                case 0x880:
                    drawExplosion(3);
                    break;
                case 0x896:
                    drawExplosion(2);
                    break;
                case 0x8B5:
                    drawExplosion(1);
                    break;
                case 0x8D0:
                    drawExplosion(0);
                    break;
                case 0xA78:
                    drawLetter('A'); 
                    break;
                case 0xA80:
                    drawLetter('B');
                    break;
                case 0xA8D:
                    drawLetter('C');
                    break;
                case 0xA93:
                    drawLetter('D');
                    break;
                case 0xA9B:
                    drawLetter('E');
                    break;
                case 0xAA3:
                    drawLetter('F');
                    break;
                case 0xAAA:
                    drawLetter('G');
                    break;
                case 0xAB3:
                    drawLetter('H');
                    break;
                case 0xABA:
                    drawLetter('I');
                    break;
                case 0xAC1:
                    drawLetter('J');
                    break;
                case 0xAC7:
                    drawLetter('K');
                    break;
                case 0xACD:
                    drawLetter('L');
                    break;
                case 0xAD2:
                    drawLetter('M');
                    break;
                case 0xAD8:
                    drawLetter('N');
                    break;
                case 0xAE3:
                    drawLetter('P');
                    break;
                case 0xAEA:
                    drawLetter('Q');
                    break;
                case 0xAF3:
                    drawLetter('R');
                    break;
                case 0xAFB:
                    drawLetter('S');
                    break;
                case 0xB02:              
                    drawLetter('T');
                    break;
                case 0xB08:
                    drawLetter('U');
                    break;
                case 0xB0E:
                    drawLetter('V');
                    break;
                case 0xB13:
                    drawLetter('W');
                    break;
                case 0xB1A:
                    drawLetter('X');
                    break;
                case 0xB1F:
                    drawLetter('Y');
                    break;
                case 0xB26:
                    drawLetter('Z');
                    break;

            }

        }

        public void JMPL(string adr)
        {
        }

        public int calcScale(int s)
        {
            return (actS + s) % 16;
        }

        public int calcDivisor(int myS, Boolean sVec)
        {
            int divisor;
            divisor = 1;
            if (sVec)
            {
                switch (myS)
                {
                    case 3:
                        divisor = 16;
                        break;
                    case 2:
                        divisor = 32;
                        break;
                    case 1:
                        divisor = 64;
                        break;
                    case 0:
                        divisor = 128;
                        break;
                    default:
                        divisor = 1;
                        break;


                }



            }
            else
            {
                switch (myS)
                {
                    case 9:
                        divisor = 1;
                        break;
                    case 8:
                        divisor = 2;
                        break;
                    case 7:
                        divisor = 4;
                        break;
                    case 6:
                        divisor = 8;
                        break;
                    case 5:
                        divisor = 16;
                        break;
                    case 4:
                        divisor = 32;
                        break;
                    case 3:
                        divisor = 64;
                        break;
                    case 2:
                        divisor = 128;
                        break;
                    case 1:
                        divisor = 256;
                        break;
                    case 0:
                        divisor = 512;
                        break;
                    default:
                        divisor = 1;
                        break;
                }

            }
            return divisor;
        }

        public void drawDirectionVector(Graphics myG,Color col, int x, int y, int dx, int dy)
        {
            int divisor;
            int newX;
            int newY;
            int myx1;
            int myy1;
            int myx2;
            int myy2;
            LABS(x, y, 0);
            divisor = 1;
            pen.Color = col;
            newX = actX + (dx / divisor / 2);
            newY = actY - (dy / divisor / 2);
            myx1 = middleX + (actX / 1);
            myy1 = middleY + (actY / 1);
            myx2 = middleX + (newX / 1);
            myy2 = middleY + (newY / 1);
            myG.DrawLine(pen, myx1, myy1, myx2, myy2);
            myG.Flush();
        }


        private void drawVector(Color col,int x, int y, int divisor, int z)
        {
            int newX;
            int newY;
            int myx1;
            int myy1;
            int myx2;
            int myy2;
            newX = actX + (x / divisor / 2);
            newY = actY - (y / divisor / 2);
            if (z > 0)
            {
                if (col == Color.White)
                {
                    zcolor(z);
                }
                else
                {
                    pen.Color = col;
                }
                myx1 = middleX + (actX / 1);
                myy1 = middleY + (actY / 1);
                myx2 = middleX + (newX / 1);
                myy2 = middleY + (newY / 1);
                if (x == 0 && y == 0)
                {
                    if (col != Color.Yellow)
                    {
                        pen.Color = Color.Orange;
                    }
                    myG.DrawEllipse(pen, myx1, myy1, 2, 2);
                }
                else
                {
                    myG.DrawLine(pen, myx1, myy1, myx2, myy2);
                }
            }
            actX = newX;
            actY = newY;
        }


        public void VCTR(Color col, int x, int y, int s, int z)
        {
            int myS;
            int divisor;
            myS = calcScale(s);
            divisor = calcDivisor(myS, false);
            drawVector(col,x,y,divisor,z);
        }

        public void VCTR(int x, int y, int s, int z)
        {
            VCTR(Color.White, x, y, s, z);
        }


        public void SVEC(Color col, int x, int y, int s, int z)
        {
            int myS;
            int divisor;
            divisor = 1;
            myS = calcScale(s);
            divisor = calcDivisor(myS, true);
            drawVector(col,x,y,divisor,z);
        }

        public void SVEC(int x, int y, int s, int z)
        {
            SVEC(Color.White, x, y, s, z);
        }
 
        public void drawAsteroid(int atype)
        {
            switch (atype)
            {
                case 1:
                    SVEC(Color.Red, 0, 256, 3, 0);
                    SVEC(Color.Red, 256, 256, 3, 7);
                    SVEC(Color.Red, 256, -256, 3, 7);
                    SVEC(Color.Red, -256, -512, 2, 7);
                    SVEC(Color.Red, 256, -512, 2, 7);
                    SVEC(Color.Red, -768, -512, 2, 8);
                    SVEC(Color.Red, -768, 0, 2, 8);
                    SVEC(Color.Red, -256, 256, 3, 7);
                    SVEC(Color.Red, 0, 512, 3, 7);
                    SVEC(Color.Red, 256, 256, 3, 7);
                    SVEC(Color.Red, 256, -256, 3, 7);
                    break;
                case 2:
                    SVEC (Color.Red,512, 256, 2, 0);
                    SVEC(Color.Red, 512, 256, 2, 7);
                    SVEC(Color.Red, -256, 256, 3, 7);
                    SVEC(Color.Red, -512, -256, 2, 7);
                    SVEC(Color.Red, -512, 256, 2, 7);
                    SVEC(Color.Red, -256, -256, 3, 7);
                    SVEC(Color.Red, 256, -512, 2, 7);
                    SVEC (Color.Red,-256, -512, 2, 7);
                    SVEC(Color.Red, 256, -256, 3, 7);
                    SVEC(Color.Red, 256, 256, 2, 7);
                    SVEC(Color.Red, 768, -256, 2, 8);
                    SVEC(Color.Red, 512, 768, 2, 8);
                    SVEC(Color.Red, -256, 256, 3, 7);                    
                    break;
                case 3:
                    SVEC(Color.Red, -256, 0, 3, 0);
                    SVEC(Color.Red, -512, -256, 2, 7);
                    SVEC (Color.Red,512, -768, 2, 7);
                    SVEC(Color.Red, 512, 768, 2, 7);
                    SVEC(Color.Red, 0, -768, 2, 7);
                    SVEC(Color.Red, 256, 0, 3, 7);
                    SVEC(Color.Red, 512, 768, 2, 7);
                    SVEC(Color.Red, 0, 256, 3, 7);
                    SVEC(Color.Red, -512, 768, 2, 7);
                    SVEC(Color.Red, -768, 0, 2, 7);
                    SVEC(Color.Red, -768, -768, 2, 7);
                    SVEC(Color.Red, 512, -256, 2, 7);
                    break;
                case 4:
                    SVEC(Color.Red, 256, 0, 2, 0);
                    SVEC(Color.Red, 768, 256, 2, 7);
                    SVEC(Color.Red, 0, 256, 2, 6);
                    SVEC(Color.Red, -768, 512, 2, 7);
                    SVEC(Color.Red, -768, 0, 2, 7);
                    SVEC(Color.Red, 256, -512, 2, 6);
                    SVEC(Color.Red, -768, 0, 2, 7);
                    SVEC(Color.Red, 0, -768, 2, 7);
                    SVEC(Color.Red, 512, -768, 2, 7);
                    SVEC(Color.Red, 768, 256, 2, 7);
                    SVEC(Color.Red, 256, -256, 2, 6);
                    SVEC(Color.Red, 256, 256, 3, 6);
                    SVEC(Color.Red, -768, 512, 2, 7);
                    break;
            }
        }

        public void drawUFO()
        {
            SVEC(Color.Cyan, -512, 256, 2, 0);
            SVEC(Color.Cyan, 512, 0, 3, 12);
            SVEC(Color.Cyan, 768, -512, 2, 0);
            VCTR(Color.Cyan, -640, 0, 6, 13);
            SVEC(Color.Cyan, 768, -512, 2, 13);
            SVEC(Color.Cyan, 512, 0, 3, 12);
            SVEC(Color.Cyan, 768, 512, 2, 13);
            SVEC(Color.Cyan, -768, 512, 2, 13);
            SVEC(Color.Cyan, -256, 512, 2, 12);
            SVEC(Color.Cyan, -256, 0, 3, 12);
            SVEC(Color.Cyan, -256, -512, 2, 12);
            SVEC(Color.Cyan, -768, -512, 2, 13);
        }

        public void drawExplosion(int etype)
        {
            switch (etype)
            {
                case 3:
                    SVEC(Color.Yellow,-256, 0, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, -256, -256, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 256, -256, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 768, 256, 2, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 512, -256, 2, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 0, 256, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 256, 768, 2, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, -256, 768, 2, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -512, -128, 5, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, -768, 256, 2, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);    
                    break;
                case 2:
                    VCTR(Color.Yellow, -896, 0, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -896, -896, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 896, -896, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 672, 224, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 896, -448, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 0, 896, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 224, 672, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -224, 672, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -896, -224, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -672, 224, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);    
                    break;
                case 1:
                    SVEC(Color.Yellow, -768, 0, 1, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, -768, -768, 1, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 768, -768, 1, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 576, 192, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 768, -384, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    SVEC(Color.Yellow, 0, 768, 1, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 192, 576, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -192, 576, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -768, -192, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -576, 192, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);    
                    break;
                case 0:
                    VCTR(Color.Yellow, -640, 0, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -640, -640, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 640, -640, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 960, 320, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 640, -320, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 0, 640, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, 320, 960, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -320, 960, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -640, -160, 4, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);
                    VCTR(Color.Yellow, -960, 320, 3, 0);
                    SVEC(Color.Yellow, 0, 0, 3, 7);    
                    break;
            }
        }

        public void drawLetter(char a)
        {
            switch (a)
            {
                case 'A':
                    SVEC (0, 512, 1, 7);  
                    SVEC (512, 512, 0, 7);
                    SVEC (512, -512, 0, 7);
                    SVEC (0, -512, 1, 7); 
                    SVEC (-512, 256, 1, 0);
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, -512, 0, 0);
                    break;
                case 'B':
                    SVEC (0, 768, 1, 7);  
                    SVEC (768, 0, 0, 7);  
                    SVEC (256, -256, 0, 7);
                    SVEC (0, -256, 0, 7); 
                    SVEC (-256, -256, 0, 7);
                    SVEC (-768, 0, 0, 7); 
                    SVEC (768, 0, 0, 0);  
                    SVEC (256, -256, 0, 7);
                    SVEC (0, -256, 0, 7); 
                    SVEC (-256, -256, 0, 7);
                    SVEC (-768, 0, 0, 7); 
                    SVEC (768, 0, 1, 0);
                    break;
                case 'C':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (-512, -768, 1, 0);
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, 0, 0, 0);
                    break;
                case 'D':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 0, 7);  
                    SVEC (512, -512, 0, 7);
                    SVEC (0, -512, 0, 7); 
                    SVEC (-512, -512, 0, 7);
                    SVEC (-512, 0, 0, 7); 
                    SVEC (768, 0, 1, 0);
                    break;
                case 'E':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (-256, -768, 0, 0);
                    SVEC (-768, 0, 0, 7); 
                    SVEC (0, -768, 0, 0); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, 0, 0, 0);
                    break;
                case 'F':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (-256, -768, 0, 0);
                    SVEC (-768, 0, 0, 7); 
                    SVEC (0, -768, 0, 0); 
                    SVEC (768, 0, 1, 0);
                    break;
                case 'G':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -512, 0, 7); 
                    SVEC (-512, -512, 0, 0);
                    SVEC (512, 0, 0, 7);  
                    SVEC (0, -512, 0, 7); 
                    SVEC (-512, 0, 1, 7); 
                    SVEC (768, 0, 1, 0);
                    break;
                case 'H':
                    SVEC (0, 768, 1, 7);  
                    SVEC (0, -768, 0, 0); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 0, 0);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 0, 0, 0);
                    break;
                case 'I':
                    SVEC (512, 0, 1, 7);  
                    SVEC (-512, 0, 0, 0); 
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 0, 0);
                    SVEC (-512, 0, 1, 7); 
                    SVEC (768, -768, 1, 0);
                    break;
                case 'J':
                    SVEC (0, 512, 0, 0);  
                    SVEC (512, -512, 0, 7);
                    SVEC (512, 0, 0, 7);  
                    SVEC (0, 768, 1, 7);
                    SVEC(256, -768, 1, 0);
                    break;
                case 'K':
                    SVEC (0, 768, 1, 7);  
                    SVEC (768, 0, 0, 0);  
                    SVEC (-768, -768, 0, 7);
                    SVEC (768, -768, 0, 7);
                    SVEC (768, 0, 0, 0);
                    break;
                case 'L':
                    SVEC (0, 768, 1, 0);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, 0, 0, 0);
                    break;
                case 'M':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, -512, 0, 7);
                    SVEC (512, 512, 0, 7);
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 0, 0, 0);
                    break;
                case 'N':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, -768, 1, 7);
                    SVEC (0, 768, 1, 7);  
                    SVEC (256, -768, 1, 0);
                    break;
                case 'O':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (-512, 0, 1, 7); 
                    SVEC (768, 0, 1, 0);
                    break;
                case 'P':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -768, 0, 7); 
                    SVEC (-512, 0, 1, 7); 
                    SVEC (768, -768, 0, 0);
                    SVEC (768, 0, 0, 0);
                    break;
                case 'Q':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -512, 1, 7); 
                    SVEC (-512, -512, 0, 7);
                    SVEC (-512, 0, 0, 7); 
                    SVEC (512, 512, 0, 0);
                    SVEC (512, -512, 0, 7);
                    SVEC (512, 0, 0, 0);
                    break;
                case 'R':
                    SVEC (0, 768, 1, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -768, 0, 7); 
                    SVEC (-512, 0, 1, 7); 
                    SVEC (256, 0, 0, 0);  
                    SVEC (768, -768, 0, 7);
                    SVEC (512, 0, 0, 0);
                    break;
                case 'S':
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 0, 7);  
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, 768, 0, 7);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (256, -768, 1, 0);
                    break;
                case 'T':
                    SVEC (512, 0, 0, 0);  
                    SVEC (0, 768, 1, 7);  
                    SVEC (-512, 0, 0, 0); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (256, -768, 1, 0);
                    break;
                case 'U':
                    SVEC (0, 768, 1, 0);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 1, 7);  
                    SVEC (256, -768, 1, 0);
                    break;
                case 'V':
                    SVEC (0, 768, 1, 0);  
                    SVEC (256, -768, 1, 7);
                    SVEC (256, 768, 1, 7);
                    SVEC (256, -768, 1, 0);
                    break;
                case 'W':
                    SVEC (0, 768, 1, 0);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 512, 0, 7);
                    SVEC (512, -512, 0, 7);
                    SVEC (0, 768, 1, 7);  
                    SVEC (256, -768, 1, 0);
                    break;
                case 'X':
                    SVEC (512, 768, 1, 7);
                    SVEC (-512, 0, 1, 0); 
                    SVEC (512, -768, 1, 7);
                    SVEC (512, 0, 0, 0);
                    break;
                case 'Y':
                    SVEC (512, 0, 0, 0);  
                    SVEC (0, 512, 1, 7);  
                    SVEC (-512, 512, 0, 7);
                    SVEC (512, 0, 1, 0);  
                    SVEC (-512, -512, 0, 7);
                    SVEC (512, -512, 1, 0);
                    break;
                case 'Z':
                    SVEC (0, 768, 1, 0);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (-512, -768, 1, 7);
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, 0, 0, 0);
                    break;
                case ' ':
                    SVEC (768, 0, 1, 0);
                    break;
                case '1':
                    SVEC (512, 0, 0, 0);  
                    SVEC (0, 768, 1, 7);
                    SVEC(512, -768, 1, 0);
                    break;
                case '2':
                    SVEC (0, 768, 1, 0);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -768, 0, 7); 
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, -768, 0, 7); 
                    SVEC (512, 0, 1, 7);
                    SVEC(512, 0, 0, 0);  
                    break;
                case '3':
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 1, 7);  
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, -768, 0, 0); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, -768, 0, 0);
                    break;
                case '4':
                    SVEC (0, 768, 1, 0);  
                    SVEC (0, -768, 0, 7); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 0, 0);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 0, 0, 0);
                    break;
                case '5':
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 0, 7);  
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, 768, 0, 7);  
                    SVEC (512, 0, 1, 7);
                    SVEC (256, -768, 1, 0);
                    break;
                case '6':
                    SVEC (0, 768, 0, 0);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -768, 0, 7); 
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, 768, 1, 7);  
                    SVEC (768, -768, 1, 0);
                    break;
                case '7':
                    SVEC (0, 768, 1, 0);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, -768, 1, 7); 
                    SVEC (512, 0, 0, 0);
                    break;
                case '8':
                    SVEC (512, 0, 1, 7);  
                    SVEC (0, 768, 1, 7);  
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, -768, 1, 7); 
                    SVEC (0, 768, 0, 0);  
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, -768, 0, 0);
                    break;
                case '9':
                    SVEC (512, 0, 1, 0);  
                    SVEC (0, 768, 1, 7);  
                    SVEC (-512, 0, 1, 7); 
                    SVEC (0, -768, 0, 7); 
                    SVEC (512, 0, 1, 7);  
                    SVEC (512, -768, 0, 0);
                    break;
                case '0':
                    drawLetter('O');
                    break;
                case 's': //LIFE (SHIP)
                    SVEC(Color.Green,-512, -768, 2, 0);
                    SVEC(Color.Green, 512, 0, 3, 7);
                    SVEC(Color.Green, 256, -256, 3, 7);
                    VCTR(Color.Green, -256, 768, 6, 7);
                    VCTR(Color.Green, -256, -768, 6, 7);
                    SVEC(Color.Green, 256, 256, 3, 7);
                    VCTR(Color.Green, 640, 192, 6, 0);
                    break;
                case 'c': //COPYRIGHT
                    LABS(400, 138, 0);
                    VCTR (0, 0, 7, 0);//    ; Ruhezeit
                    SVEC (768, -256, 0, 7);
                    SVEC (768, 256, 0, 7);
                    SVEC (0, 256, 2, 7);  
                    SVEC (-768, 256, 0, 7);
                    SVEC (-768, -256, 0, 7);
                    SVEC (0, -256, 2, 7); 
                    VCTR (512, 384, 3, 0);
                    SVEC (-256, 0, 1, 7); 
                    SVEC (0, -256, 1, 7); 
                    SVEC (256, 0, 1, 7);  
                    SVEC (512, -256, 1, 0);
                    drawLetter('1');
                    drawLetter('9');
                    drawLetter('7');
                    drawLetter('9');
                    drawLetter(' ');
                    drawLetter('A');
                    drawLetter('T');
                    drawLetter('A');
                    drawLetter('R');
                    drawLetter('I');
                    drawLetter(' ');
                    drawLetter('I');
                    drawLetter('N');
                    drawLetter('C');
                    break;            
            }
        }

        public void DrawCircle(Graphics myG, Color col, int x, int y, int w, int h)
        {
            int myx1;
            int myy1;
            LABS(x, y, 0);
            myx1 = middleX + (actX / 1);
            myy1 = middleY + (actY / 1);
            pen.Color = col;
            myG.DrawEllipse(pen,myx1-(w/2),myy1-(h/2), w, h);
        }

        public void drawArray(Graphics g, UInt16[] vArray)
        {
            int n;
            int i;
            int j;
            int x;
            int y;
            int s;
            int z;
            int o;
            int a;
            int w1;
            int w2;
            myG = Graphics.FromImage(BackBuffer);
            myG.PageUnit = GraphicsUnit.Pixel;
            middleX = Convert.ToInt16(myG.VisibleClipBounds.Width / 2);
            middleY = Convert.ToInt16(myG.VisibleClipBounds.Height / 2);
            actX = 0;
            actY = 0;
            myG.Clear(Color.Black);
            middleX = 0;
            middleY = 64;
            n = vArray.Count() - 1;
            for (i = 0; i < n; i++ )
            {
                w1 = vArray[i];

                o = (ushort) w1 >> 12;
                switch (o)
                {
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9: // VCTR                        
                        j = i + 1;
                        w2 = vArray[j];
                        
                        x = (w2 & 0x3FF);
                        if ((w2 & 0x400) != 0)
                        {
                           x = -x;
                        }
                        y = (w1 & 0x3FF);
                        if ((w1 & 0x400) != 0)
                        {
                           y = -y;
                        }
                        s = (w1 & 0xF000) >> 12;
                        //s = w1 >> 12;
                        z = (w2 & 0xF000) >> 12;
                        VCTR(Color.LightCyan, x, y, s, z);
                        i++;
                        break;
                    case 0xF: // SVEC
                        x = (w1 & 0x3);
                        x = x * 0x100;
                        if ((w1 & 0x4) != 0)
                        {
                            x = -x;
                        }
                        y = (w1 & 0x300);
                        if ((w1 & 0x400) != 0)
                        {
                            y = -y;
                        }
                        s = ((w1 & 0x8) >> 2) | ((w1 & 0x800) >> 11);
                        z = (w1 & 0xF0) >> 4;
                        SVEC(Color.LightCyan, x, y, s, z);
                        break;
                    case 0xA: // LABS
                        j = i + 1;
                        w2 = vArray[j];
                        x = w2 & 0x03FF;
                        y = w1 & 0x03FF;
                        s = (w2 & 0xF000) >> 12;
                        LABS(x, y, s);
                        i++;
                        break;
                    case 0xB: // HALT
                        myG.Flush();
                        g.DrawImageUnscaled(BackBuffer, 0, 0);
                        g.Flush();
                        return;
                    //  break;
                    case 0xC: // JSRL
                        a = w1 & 0x0FFF;
                        JRSL(a);
                        break;
                    case 0xD: // RTSL
                        break;
                    case 0xE: // JMPL
                        break;
                }
            }
            myG.Flush();
            g.DrawImageUnscaled(BackBuffer, 0, 0);
            g.Flush();
        }
    }
}
