unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, WinSock, ExtCtrls;

const
  WM_UDPSocket = WM_APP+1;
//  cLocalHost:String='127.0.0.1';//'85.176.196.106';//'127.0.0.1';//
//  cctServer:String={'asteroids.heise.de';//}'193.99.145.178';
  cMagic:ShortString = 'ctmame';
  cMagicPlayerName:ShortString = 'ctnamePROMETHEUS';
  cAsteroidsPort = 1979;
  cYOffset = 128; // y=0 ist bei y-Koordinate 128
  cMaxX=1024;
  cMaxY=768;
  cMaxAsteroids=28; // Baustelle

  cFramesPerShot = 70;
  cMaxShots = 6;
  cMaxFriendlyShots = 4;

  cMaxWinkelByteSyncArray=9;

  cAbstandShipShot8 = 30*8; // Baustelle

  // Kollisionsabstnde Schiff<->Asteroid (bei bekannten Asteroiden-Geschwindigkeiten)
  cCollisionDistAstSmall8  = 11*8;
  cCollisionDistAstMedium8 = 15*8;
  cCollisionDistAstLarge8  = 23*8;

  // Kollisionsabstnde Schiff<->Asteroid (bei unbekanten Asteroiden-Geschwindigkeiten)
  cAsteroidDangerSmall8  = 27*8;
  cAsteroidDangerMedium8 = 38*8;
  cAsteroidDangerLarge8  = 45*8;

  cWinkelByteTab : array[0..255,0..1] of Integer =

(
(1536,0),
(1536,0),
(1528,152),
(1504,296),
(1472,440),
(1472,440),
(1416,584),
(1360,720),
(1280,856),
(1280,856),
(1192,976),
(1088,1088),
(976,1192),
(976,1192),
(856,1280),
(720,1360),
(584,1416),
(584,1416),
(440,1472),
(296,1504),
(152,1528),
(152,1528),
(-152,1528),
(-296,1504),
(-296,1504),
(-440,1472),
(-584,1416),
(-720,1360),
(-720,1360),
(-856,1280),
(-976,1192),
(-1088,1088),
(-1088,1088),
(-1192,976),
(-1280,856),
(-1360,720),
(-1360,720),
(-1416,584),
(-1472,440),
(-1504,296),
(-1504,296),
(-1528,152),
(-1536,0),
(-1536,0),
(-1528,-152),
(-1528,-152),
(-1504,-296),
(-1472,-440),
(-1416,-584),
(-1416,-584),
(-1360,-720),
(-1280,-856),
(-1192,-976),
(-1192,-976),
(-1088,-1088),
(-976,-1192),
(-856,-1280),
(-856,-1280),
(-720,-1360),
(-584,-1416),
(-440,-1472),
(-440,-1472),
(-296,-1504),
(-152,-1528),
(0,-1536),
(152,-1528),
(296,-1504),
(440,-1472),
(440,-1472),
(584,-1416),
(720,-1360),
(856,-1280),
(856,-1280),
(976,-1192),
(1088,-1088),
(1192,-976),
(1192,-976),
(1280,-856),
(1360,-720),
(1416,-584),
(1416,-584),
(1472,-440),
(1504,-296),
(1528,-152),
(1528,-152),
(1536,0),
(1536,0),
(1528,152),
(1504,296),
(1504,296),
(1472,440),
(1416,584),
(1360,720),
(1360,720),
(1280,856),
(1192,976),
(1088,1088),
(1088,1088),
(976,1192),
(856,1280),
(720,1360),
(720,1360),
(584,1416),
(440,1472),
(296,1504),
(296,1504),
(152,1528),
(-152,1528),
(-152,1528),
(-296,1504),
(-440,1472),
(-584,1416),
(-584,1416),
(-720,1360),
(-856,1280),
(-976,1192),
(-976,1192),
(-1088,1088),
(-1192,976),
(-1280,856),
(-1280,856),
(-1360,720),
(-1416,584),
(-1472,440),
(-1472,440),
(-1504,296),
(-1528,152),
(-1536,0),
(-1536,0),
(-1536,0),
(-1528,-152),
(-1504,-296),
(-1472,-440),
(-1472,-440),
(-1416,-584),
(-1360,-720),
(-1280,-856),
(-1280,-856),
(-1192,-976),
(-1088,-1088),
(-976,-1192),
(-976,-1192),
(-856,-1280),
(-720,-1360),
(-584,-1416),
(-584,-1416),
(-440,-1472),
(-296,-1504),
(-152,-1528),
(-152,-1528),
(152,-1528),
(296,-1504),
(296,-1504),
(440,-1472),
(584,-1416),
(720,-1360),
(720,-1360),
(856,-1280),
(976,-1192),
(1088,-1088),
(1088,-1088),
(1192,-976),
(1280,-856),
(1360,-720),
(1360,-720),
(1416,-584),
(1472,-440),
(1504,-296),
(1504,-296),
(1528,-152),
(1536,0),
(1536,0),
(1528,152),
(1528,152),
(1504,296),
(1472,440),
(1416,584),
(1416,584),
(1360,720),
(1280,856),
(1192,976),
(1192,976),
(1088,1088),
(976,1192),
(856,1280),
(856,1280),
(720,1360),
(584,1416),
(440,1472),
(440,1472),
(296,1504),
(152,1528),
(0,1536),
(-152,1528),
(-296,1504),
(-440,1472),
(-440,1472),
(-584,1416),
(-720,1360),
(-856,1280),
(-856,1280),
(-976,1192),
(-1088,1088),
(-1192,976),
(-1192,976),
(-1280,856),
(-1360,720),
(-1416,584),
(-1416,584),
(-1472,440),
(-1504,296),
(-1528,152),
(-1528,152),
(-1536,0),
(-1536,0),
(-1528,-152),
(-1504,-296),
(-1504,-296),
(-1472,-440),
(-1416,-584),
(-1360,-720),
(-1360,-720),
(-1280,-856),
(-1192,-976),
(-1088,-1088),
(-1088,-1088),
(-976,-1192),
(-856,-1280),
(-720,-1360),
(-720,-1360),
(-584,-1416),
(-440,-1472),
(-296,-1504),
(-296,-1504),
(-152,-1528),
(152,-1528),
(152,-1528),
(296,-1504),
(440,-1472),
(584,-1416),
(584,-1416),
(720,-1360),
(856,-1280),
(976,-1192),
(976,-1192),
(1088,-1088),
(1192,-976),
(1280,-856),
(1280,-856),
(1360,-720),
(1416,-584),
(1472,-440),
(1472,-440),
(1504,-296),
(1528,-152),
(1536,0));


  // OP-Codes Vektorgenerator
  cOPVCTR0 =  0;
  cOPVCTR1 =  1;
  cOPVCTR2 =  2;
  cOPVCTR3 =  3;
  cOPVCTR4 =  4;
  cOPVCTR5 =  5;
  cOPVCTR6 =  6;
  cOPVCTR7 =  7;
  cOPVCTR8 =  8;
  cOPVCTR9 =  9;
  cOPLABS  = 10;
  cOPHALT  = 11;
  cOPJSRL  = 12;
  cOPRTSL  = 13;
  cOPJMPL  = 14;
  cOPSVEC  = 15;

  cAsteroidType0 = 0;
  cAsteroidType1 = 1;
  cAsteroidType2 = 2;
  cAsteroidType3 = 3;

  // Tasten
  cKEY_HYPERSPACE  = 1;
  cKEY_FIRE        = 2;
  cKEY_THRUST      = 4;
  cKEY_RIGHT       = 8;
  cKEY_LEFT        = 16;

type
  TSize = (eSmall,eMedium,eLarge);
  TAsteroidTypus = (eAsteroidTypus0,eAsteroidTypus1,eAsteroidTypus2,eAsteroidTypus3);

  TSendMsg = packed record
    Magic:array[0..5] of Char; // 'ctmame'
    Key:Byte;
    Ping:Byte;
  end;

  TSendMsgPlayerName = packed record
    MagicAndPlayerName:array[0..37] of Char; // 'ctname...'
  end;

  TReceiveMsg = record
    case Boolean of
      True:(
        VectorRAM:array[0..511] of Word;
        Cnt:Byte;
        Ping:Byte;);
      False:(Bytes:array[0..513] of Byte;)
  end;

  TWinkelByteSync = record
    Active:Boolean;
    WinkelByte:Integer;
    Synced:Boolean;
    SyncArray:array[0..cMaxWinkelByteSyncArray-1,0..1] of Integer;
    SyncIndex:Integer;
  end;

  TShip = record
    Present:Boolean;
    X8,Y8:Integer;
    DirX,DirY:Integer; // aus cWinkelByteTab
  end;

  TShot = record
    X8,Y8:Integer;
  end;

  TSaucer = record
    Present:Boolean;
    X8,Y8:Integer;
    dX8,dY8:Integer; // nur Prediction
    PredX8,PredY8:Integer; // nur Prediction
    FirstX8,FirstY8,FirstCnt:Integer; // fr dX,dY-Ermittelung
    BrainX8,BrainY8:Integer; // nur Intelligence
    Size:TSize;
    Beschuss:Integer; // nur Intelligence
  end;

  TAsteroid = record
    Valid:Boolean; // nur Prediction
    X8,Y8:Integer;
    FirstX8,FirstY8,FirstCnt:Integer; // fr dX,dY-Ermittelung
    PredX8,PredY8:Integer; // nur Prediction
    dX8,dY8:Integer; // nur Prediction
    BrainX8,BrainY8:Integer; // nur Intelligence
    Typus:TAsteroidTypus;
    Size:TSize;
    Beschuss:Integer; // nur Intelligence
    Collision:Boolean;
  end;

  TPredShot = record
    Valid:Boolean; // nur Prediction
    X8,Y8:Integer;
    FirstX8,FirstY8,FirstCnt:Integer; // fr dX,dY-Ermittelung
    PredX8,PredY8:Integer; // nur Prediction
    dX8,dY8:Integer; // nur Prediction
    Beschuss:Integer; // nur Intelligence
    Friendly:Boolean; // nur Intelligence, Shot
  end;

  TDecodedFrame = record
    Ship:TShip;
    Saucer:TSaucer;
    AnzAsteroids:Integer;
    Asteroids:array[0..cMaxAsteroids-1] of TAsteroid;
    AnzShots:Integer;
    Shots:array[0..cMaxShots-1] of TShot;
  end;

  TPrediction = record
    AnzAsteroids:Integer;
    Asteroids:array[0..cMaxAsteroids-1] of TAsteroid;
    AnzShots:Integer;
    Shots:array[0..cMaxShots-1] of TPredShot;
    Saucer:TSaucer;
  end;

  TBrain = record
    Active:Boolean;
    TurnsLeft:Integer;
    MultiShot:Integer;
  end;

  TForm1 = class(TForm)
    StartBtn: TButton;
    Memo1: TMemo;
    PB: TPaintBox;
    ServerRG: TRadioGroup;
    Label2: TLabel;
    ServerIPEdit: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    EigeneIPEdit: TEdit;
    StoppBtn: TButton;
    DebugAusgabenCB: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartBtnClick(Sender: TObject);
    procedure StoppBtnClick(Sender: TObject);
  private
    { Private-Deklarationen }
cnt:Integer;
    UDPSocket : TSocket;
    SendMsg : TSendMsg;
    SendMsgPlayerName : TSendMsgPlayerName;
    ReceiveMsg : TReceiveMsg;
    GSF : Integer; // Globaler Skalierungsfaktor
    DecodedFrame : TDecodedFrame;
    Prediction:TPrediction;
    FirstTel:Boolean;
    Brain:TBrain;
    WinkelByteSync:TWinkelByteSync;
  minx,miny,maxx,maxy:integer;
    WinkelByte2dXdYTab8:array[0..255,0..1] of Integer;
    OldKeys:array[0..1] of Integer;
    function  InitSockets():Boolean;
    procedure InitUDPSocket();
    procedure SendUDP(IP: string; Port: Word; var Buf; BufLen: Integer);
    procedure ProcessError(s:ShortString);
    procedure SocketMessage(var msg: TMessage); message WM_UDPSocket;
    procedure DecodeVectorRAM;
    procedure DrawAsteroid(x,y:Integer;Size:TSize);
    procedure DrawPredAsteroid(x,y:Integer;Size:TSize);
    procedure DrawPredSaucer(x,y:Integer;Size:TSize);
    procedure DrawPredShot(x,y:Integer;Friendly:Boolean);
    procedure DrawShot(x,y:Integer);
    procedure DrawSaucer();
    procedure DrawShip();
//    procedure DrawHit();
    function  GSF2AsteroidSize():TSize;
    function  GSF2SaucerSize():TSize;
    procedure DrawVectorRAM();
    function  DoIntelligence:Byte;
    procedure SendKeys(Key:Byte);
    procedure DoPrediction();
    function  AbstX8(X1,X2:Integer):Integer;
    function  AbstY8(Y1,Y2:Integer):Integer;
    function  SumX8(X1,X2:Integer):Integer;
    function  SumY8(Y1,Y2:Integer):Integer;
    function  MulX8(X1,X2:Integer):Integer;
    function  MulY8(Y1,Y2:Integer):Integer;
    function  FindFreeAsteroid:Integer;
    function  FindFreeShot:Integer;
    procedure DoWinkelByteSync(Keys:Byte);
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.DoWinkelByteSync(Keys:Byte);
var
  i,rr,ii:Integer;
  Found:Boolean;
begin
  if (DecodedFrame.Ship.Present) then
  begin
    if (OldKeys[0] and cKEY_RIGHT) <> 0 then
    begin
      dec(WinkelByteSync.WinkelByte);
      if WinkelByteSync.WinkelByte<0 then
        inc(WinkelByteSync.WinkelByte,256);
    end
    else
      if (OldKeys[0] and cKEY_LEFT) <> 0 then
      begin
        inc(WinkelByteSync.WinkelByte);
        if WinkelByteSync.WinkelByte>255 then
          dec(WinkelByteSync.WinkelByte,256);
      end
  end;

  if (DecodedFrame.Ship.Present) and (WinkelByteSync.Active) then
  begin
    // Schiffposition des aktuellen Frames ist Reaktion auf Tastendrcke von OldKeys[0]
    if (OldKeys[0] and cKEY_RIGHT) <> 0 then
    begin
      inc(WinkelByteSync.SyncIndex);
      WinkelByteSync.SyncArray[WinkelByteSync.SyncIndex,0]:=DecodedFrame.Ship.DirX;
      WinkelByteSync.SyncArray[WinkelByteSync.SyncIndex,1]:=DecodedFrame.Ship.DirY;
    end
    else
      if (OldKeys[0] and cKEY_LEFT) <> 0 then
      begin
        dec(WinkelByteSync.SyncIndex);
        WinkelByteSync.SyncArray[WinkelByteSync.SyncIndex,0]:=DecodedFrame.Ship.DirX;
        WinkelByteSync.SyncArray[WinkelByteSync.SyncIndex,1]:=DecodedFrame.Ship.DirY;
      end
      else
      begin
        WinkelByteSync.SyncArray[WinkelByteSync.SyncIndex,0]:=DecodedFrame.Ship.DirX;
        WinkelByteSync.SyncArray[WinkelByteSync.SyncIndex,1]:=DecodedFrame.Ship.DirY;
      end;

    if WinkelByteSync.SyncIndex=0 then
    begin
      WinkelByteSync.Synced:=True;
//      WinkelByteSync.Active:=False;

      Memo1.Lines.Add('found0');
      Found:=False;
      rr:=0;
      while (not Found) and (rr<256) do
      begin
        Found:=True;
        ii:=rr;
        i:=0;
        while (found) and (i<5) do
        begin
          if (WinkelByteSync.SyncArray[4-i,0]<>cWinkelByteTab[ii,0]) then
            Found:=False;
          if (WinkelByteSync.SyncArray[4-i,1]<>cWinkelByteTab[ii,1]) then
            Found:=False;
          inc(ii);
          if ii>255 then
            dec(ii,256);
          inc(i);
        end;
        if Found then
        begin

          WinkelByteSync.WinkelByte:=rr+4;
//if (OldKeys[1] and cKEY_RIGHT) <> 0 then dec(WinkelByteSync.WinkelByte);
//if (OldKeys[1] and cKEY_LEFT) <> 0 then inc(WinkelByteSync.WinkelByte);
          if WinkelByteSync.WinkelByte>255 then
            dec(WinkelByteSync.WinkelByte,256)
          else
            if WinkelByteSync.WinkelByte<0 then
              inc(WinkelByteSync.WinkelByte,256);

          Memo1.Lines.Add('WB0 found:'+inttostr(WinkelByteSync.WinkelByte));
          // Syncvorgang ggf. neu starten
          WinkelByteSync.SyncIndex:=cMaxWinkelByteSyncArray div 2;
          WinkelByteSync.SyncArray[4,0]:=cWinkelByteTab[WinkelByteSync.WinkelByte,0];
          WinkelByteSync.SyncArray[4,1]:=cWinkelByteTab[WinkelByteSync.WinkelByte,1];
        end
        else
        begin
          // Syncvorgang ggf. neu starten
          WinkelByteSync.SyncIndex:=cMaxWinkelByteSyncArray div 2;
          WinkelByteSync.SyncArray[4,0]:=cWinkelByteTab[WinkelByteSync.WinkelByte,0];
          WinkelByteSync.SyncArray[4,1]:=cWinkelByteTab[WinkelByteSync.WinkelByte,1];
        end;
        inc(rr);
      end;
    end
    else
      if WinkelByteSync.SyncIndex=cMaxWinkelByteSyncArray-1 then
      begin
        WinkelByteSync.Synced:=True;
//        WinkelByteSync.Active:=False;

        Memo1.Lines.Add('found1');
        Found:=False;
        rr:=0;
        while (not Found) and (rr<256) do
        begin
          Found:=True;
          ii:=rr;
          i:=0;
          while (Found) and (i<5) do
          begin
            if (WinkelByteSync.SyncArray[8-i,0]<>cWinkelByteTab[ii,0]) then
              Found:=False;
            if (WinkelByteSync.SyncArray[8-i,1]<>cWinkelByteTab[ii,1]) then
              Found:=False;
            inc(ii);
            if ii>255 then
              dec(ii,256);
            inc(i);
          end;
          if Found then
          begin
            WinkelByteSync.WinkelByte:=rr;
//if (OldKeys[1] and cKEY_RIGHT) <> 0 then dec(WinkelByteSync.WinkelByte);
//if (OldKeys[1] and cKEY_LEFT) <> 0 then inc(WinkelByteSync.WinkelByte);
            if WinkelByteSync.WinkelByte>255 then
              dec(WinkelByteSync.WinkelByte,256)
            else
              if WinkelByteSync.WinkelByte<0 then
                inc(WinkelByteSync.WinkelByte,256);

            Memo1.Lines.Add('WB1 found:'+inttostr(WinkelByteSync.WinkelByte));
            // Syncvorgang ggf. neu starten
            WinkelByteSync.SyncIndex:=cMaxWinkelByteSyncArray div 2;
            WinkelByteSync.SyncArray[4,0]:=cWinkelByteTab[WinkelByteSync.WinkelByte,0];
            WinkelByteSync.SyncArray[4,1]:=cWinkelByteTab[WinkelByteSync.WinkelByte,1];
          end
          else
          begin
            // Syncvorgang ggf. neu starten
            WinkelByteSync.SyncIndex:=cMaxWinkelByteSyncArray div 2;
            WinkelByteSync.SyncArray[4,0]:=cWinkelByteTab[WinkelByteSync.WinkelByte,0];
            WinkelByteSync.SyncArray[4,1]:=cWinkelByteTab[WinkelByteSync.WinkelByte,1];
          end;
          inc(rr);
        end;
      end;
  end;
end;

procedure TForm1.ProcessError(s:ShortString);
begin
  ShowMessage('Error: '+s);
end;

function TForm1.AbstX8(X1,X2:Integer):Integer;
begin
  result:=abs(X1-X2);
  if result > ((cMaxX*8) div 2) then
    result:=-(result - (cMaxX*8));
end;

function TForm1.AbstY8(Y1,Y2:Integer):Integer;
begin
  result:=abs(Y1-Y2);
  if result > ((cMaxY*8) div 2) then
    result:=-(result - (cMaxY*8));
end;

function TForm1.MulX8(X1,X2:Integer):Integer;
begin
  result:=X1*X2;
  if result<0 then
  begin
    while result<0 do
      result:=result+cMaxX*8;
  end
  else
    if result>=cMaxX*8 then
    begin
      while (result>=cMaxX*8) do
        result:=result-cMaxX*8;
    end;
end;

function TForm1.SumX8(X1,X2:Integer):Integer;
begin
  result:=X1+X2;
  if result<0 then
  begin
    while result<0 do
      result:=result+cMaxX*8;
  end
  else
    if result>=cMaxX*8 then
    begin
      while (result>=cMaxX*8) do
        result:=result-cMaxX*8;
    end;
end;

function TForm1.MulY8(Y1,Y2:Integer):Integer;
begin
  result:=Y1*Y2;
  if result<0 then
  begin
    while result<0 do
      result:=result+cMaxY*8
  end
  else
    if result>=cMaxY*8 then
    begin
      while (result>=cMaxY*8) do
        result:=result-cMaxY*8;
    end;
end;

function TForm1.SumY8(Y1,Y2:Integer):Integer;
begin
  result:=Y1+Y2;
  if result<0 then
  begin
    while result<0 do
      result:=result+cMaxY*8
  end
  else
    if result>=cMaxY*8 then
    begin
      while (result>=cMaxY*8) do
        result:=result-cMaxY*8;
    end;
end;

function TForm1.DoIntelligence:Byte;
var
  ShotXLeft8,ShotYLeft8,
  ShotXRight8,ShotYRight8,
  x1,x2,y1,y2,DistX8,DistY8,Shot,WBLeft,WBRight,Turns,r,rr,minDist,Dist,minDx,minDy: Integer;
  Key:Byte;
  SaucerAction,Geeignet,Abbruch,Hyperspace:Boolean;
  ShotAbschussFrames,TurnAbschussFrames,GesamtAbschussFrames,Drehung,Ind:Integer;
myWB:Integer;
  Frames,FriendlyShots,SaucerDrehung,SaucerGesamtAbschussFrames:Integer;
  Collision,Kandidat:Boolean;
begin
  Key:=0;

  if DecodedFrame.Ship.Present then
  begin

    if Brain.Active then
    begin
      // alte Strategie verfolgen
      if Brain.TurnsLeft<0 then
      begin
        Inc(Brain.TurnsLeft);
        Key := Key or cKEY_LEFT;
      end
      else
        if Brain.TurnsLeft>0 then
        begin
          Dec(Brain.TurnsLeft);
          Key := Key or cKEY_RIGHT;
        end
        else
        begin
          if Brain.MultiShot>0 then
          begin
            if ((Brain.MultiShot) and 1) = 0 then
              Key := Key or cKEY_FIRE
            else
              Key:=0;
            Dec(Brain.MultiShot);
          end
          else
          begin
            Brain.Active:=False;
            Key := Key or cKEY_FIRE;
          end;
        end;
    end;

    begin
      // Neue Strategie bestimmen

      // SAUCER-ABSCHUSS-STRATEGIE
      SaucerAction:=False;
      if Prediction.Saucer.Present then // Saucer hat Prioritt
      begin
        Turns:=0;
        Abbruch:=False;
        while (Turns<43) and (not Abbruch) do
        begin
          // WinkelByte und Asteroiden hochrechnen:
          // "Turns" * Drehung nach links
          WBLeft:=WinkelByteSync.WinkelByte + Turns;
          if WBLeft<0 then
            inc(WBLeft,256)
          else
            if WBLeft>255 then
              dec(WBLeft,256);
          WBRight:=WinkelByteSync.WinkelByte - Turns;
          if WBRight<0 then
            inc(WBRight,256)
          else
            if WBRight>255 then
              dec(WBRight,256);

          // Saucer hochrechnen
          Prediction.Saucer.BrainX8:=SumX8(Prediction.Saucer.X8,MulX8(Turns,Prediction.Saucer.dX8));
          Prediction.Saucer.BrainY8:=SumY8(Prediction.Saucer.Y8,MulY8(Turns,Prediction.Saucer.dY8));

          // Schusslinie auf Kollision abprfen
          ShotXLeft8:=DecodedFrame.Ship.X8;
          ShotYLeft8:=DecodedFrame.Ship.Y8;
          ShotXRight8:=DecodedFrame.Ship.X8;
          ShotYRight8:=DecodedFrame.Ship.Y8;
          Shot:=1;
          while (Shot<=cFramesPerShot) and (not Abbruch) do  // Schuss "lebt" ca. 70 Frames
          begin
            Prediction.Saucer.BrainX8:=SumX8(Prediction.Saucer.BrainX8,Prediction.Saucer.dX8);
            Prediction.Saucer.BrainY8:=SumY8(Prediction.Saucer.BrainY8,Prediction.Saucer.dY8);

            ShotXLeft8:=SumX8(ShotXLeft8,WinkelByte2dXdYTab8[WBLeft,0]);
            ShotYLeft8:=SumY8(ShotYLeft8,WinkelByte2dXdYTab8[WBLeft,1]);
            ShotXRight8:=SumX8(ShotXRight8,WinkelByte2dXdYTab8[WBRight,0]);
            ShotYRight8:=SumY8(ShotYRight8,WinkelByte2dXdYTab8[WBRight,1]);
            // Auf Abschuss abprfen, dann Abbruch
            case Prediction.Saucer.Size of
              eSmall:
                begin
                  DistX8:=3*8; // Baustelle
                  DistY8:=3*8; // Baustelle
                end;
              eLarge:
                begin
                  DistX8:=8*8; // Baustelle  15
                  DistY8:=8*8; // Baustelle  15
                end;
            end; // case
            if Prediction.Saucer.Beschuss=0 then // Saucer noch nicht beschossen
            begin
              if AbstX8(Prediction.Saucer.BrainX8,ShotXLeft8) < DistX8 then
                if AbstY8(Prediction.Saucer.BrainY8,ShotYLeft8) < DistY8 then
                  begin
                    Abbruch:=True;
                    Drehung:=-Turns;
                    GesamtAbschussFrames:=Shot+Turns; // Frames des Schusses bis zum Treffpunkt
                  end;
                if AbstX8(Prediction.Saucer.BrainX8,ShotXRight8) < DistX8 then
                  if AbstY8(Prediction.Saucer.BrainY8,ShotYRight8) < DistY8 then
                  begin
                    Abbruch:=True;
                    Drehung:=Turns;
                    GesamtAbschussFrames:=Shot+Turns; // Frames des Schusses bis zum Treffpunkt
                  end;
            end;
            inc(Shot);
          end;
          inc(Turns);
        end;

        if Abbruch then
        begin
          SaucerAction:=True;
          SaucerDrehung:=Drehung;
          SaucerGesamtAbschussFrames:=GesamtAbschussFrames; // Ast. fr x Frames (Schussdauer) nicht beschiessen
        end;
      end;

      // ASTEROIDEN AUF KOLLISIONSKURS BERECHNEN
      // Asteroiden vorbelegen (Brain...)
      for r:=0 to cMaxAsteroids-1 do
      begin
        if Prediction.Asteroids[r].Valid then
        begin
          Prediction.Asteroids[r].BrainX8:=Prediction.Asteroids[r].X8;
          Prediction.Asteroids[r].BrainY8:=Prediction.Asteroids[r].Y8;
          Prediction.Asteroids[r].Collision:=False;
        end;
      end;
      Frames:=0;
      Abbruch:=False;
      while (Frames<(80)) and (not Abbruch) do // Baustelle
      begin
        // Asteroiden auf Kollision mit Schiff abprfen
        r:=0;
        while (r<cMaxAsteroids) and (not Abbruch) do
        begin
          if Prediction.Asteroids[r].Valid then
          begin
            case Prediction.Asteroids[r].Size of
              eSmall:
                begin
                  DistX8:=cAsteroidDangerSmall8; // Baustelle
                  DistY8:=cAsteroidDangerSmall8; // Baustelle
                end;
              eMedium:
                begin
                  DistX8:=cAsteroidDangerMedium8; // Baustelle
                  DistY8:=cAsteroidDangerMedium8; // Baustelle
                end;
              eLarge:
                begin
                  DistX8:=cAsteroidDangerLarge8; // Baustelle
                  DistY8:=cAsteroidDangerLarge8; // Baustelle
                end;
            end; // case

            if AbstX8(Prediction.Asteroids[r].BrainX8,DecodedFrame.Ship.X8) < DistX8 then
              if AbstY8(Prediction.Asteroids[r].BrainY8,DecodedFrame.Ship.Y8) < DistY8 then
              begin
//                Abbruch:=True;
                Prediction.Asteroids[r].Collision:=True;
              end;
          end;
          for rr:=0 to cMaxAsteroids-1 do
          begin
            if Prediction.Asteroids[rr].Valid then
            begin
              Prediction.Asteroids[rr].BrainX8:=SumX8(Prediction.Asteroids[rr].BrainX8,Prediction.Asteroids[rr].dX8);
              Prediction.Asteroids[rr].BrainY8:=SumY8(Prediction.Asteroids[rr].BrainY8,Prediction.Asteroids[rr].dY8);
            end;
          end;
          inc(r);
        end;
        inc(Frames);
      end; // while


      // ASTEROIDEN-ABSCHUSS-STRATEGIE:
      begin
        Turns:=0;
        Abbruch:=False;
        GesamtAbschussFrames:=999999999;
        TurnAbschussFrames:=999999999;
        ShotAbschussFrames:=999999999;
        Collision:=False;
        while (Turns<43) and (not Abbruch) do
        begin

          // WinkelByte und Asteroiden hochrechnen:
          // "Turns" * Drehung nach links
          WBLeft:=WinkelByteSync.WinkelByte + Turns;
          if WBLeft<0 then
            inc(WBLeft,256)
          else
            if WBLeft>255 then
              dec(WBLeft,256);
          WBRight:=WinkelByteSync.WinkelByte - Turns;
          if WBRight<0 then
            inc(WBRight,256)
          else
            if WBRight>255 then
              dec(WBRight,256);

          // Asteroiden fr Drehzeit hochrechnen
          for r:=0 to cMaxAsteroids-1 do
          begin
            if Prediction.Asteroids[r].Valid then
            begin
              Prediction.Asteroids[r].BrainX8:=SumX8(Prediction.Asteroids[r].X8,MulX8(Turns,Prediction.Asteroids[r].dX8));
              Prediction.Asteroids[r].BrainY8:=SumY8(Prediction.Asteroids[r].Y8,MulY8(Turns,Prediction.Asteroids[r].dY8));
            end;
          end;

          // Schusslinie auf Kollision abprfen (inkl. Schussstartabstand von ca 20 Px)
          ShotXLeft8:=SumX8(DecodedFrame.Ship.X8,MulX8(2,WinkelByte2dXdYTab8[WBLeft,0]));
          ShotYLeft8:=SumY8(DecodedFrame.Ship.Y8,MulY8(2,WinkelByte2dXdYTab8[WBLeft,1]));
          ShotXRight8:=SumX8(DecodedFrame.Ship.X8,MulX8(2,WinkelByte2dXdYTab8[WBRight,0]));
          ShotYRight8:=SumY8(DecodedFrame.Ship.Y8,MulY8(2,WinkelByte2dXdYTab8[WBRight,1]));

          Shot:=1;
          while (Shot<=cFramesPerShot) and (not Abbruch) do  // Schuss "lebt" ca. 70 Frames
          begin
            for r:=0 to cMaxAsteroids-1 do
            begin
              if Prediction.Asteroids[r].Valid then
              begin
                Prediction.Asteroids[r].BrainX8:=SumX8(Prediction.Asteroids[r].BrainX8,Prediction.Asteroids[r].dX8);
                Prediction.Asteroids[r].BrainY8:=SumY8(Prediction.Asteroids[r].BrainY8,Prediction.Asteroids[r].dY8);
              end;
            end;
            ShotXLeft8:=SumX8(ShotXLeft8,WinkelByte2dXdYTab8[WBLeft,0]);
            ShotYLeft8:=SumY8(ShotYLeft8,WinkelByte2dXdYTab8[WBLeft,1]);
            ShotXRight8:=SumX8(ShotXRight8,WinkelByte2dXdYTab8[WBRight,0]);
            ShotYRight8:=SumY8(ShotYRight8,WinkelByte2dXdYTab8[WBRight,1]);
            // Auf Abschuss abprfen, dann Abbruch
            r:=0;
            while (r<cMaxAsteroids) and (not Abbruch) do
            begin
              if Prediction.Asteroids[r].Valid then
              begin
                case Prediction.Asteroids[r].Size of
                  eSmall:
                    begin
                      DistX8:=2*8; // Baustelle 2
                      DistY8:=2*8; // Baustelle 2
                    end;
                  eMedium:
                    begin
                      DistX8:=6*8; // Baustelle 6
                      DistY8:=6*8; // Baustelle 6
                    end;
                  eLarge:
                    begin
                      DistX8:=8*8; // Baustelle 8
                      DistY8:=8*8; // Baustelle 8
                    end;
                end; // case

                // Asteroid abschussbereit ?

                Geeignet:=(Prediction.Asteroids[r].Beschuss=0); // Ast. noch nicht beschossen
                if (Prediction.Asteroids[r].Size=eLarge) and (Prediction.Asteroids[r].FirstCnt<8) then
                  Geeignet:=False;

                begin // Linksdrehung
                  if AbstX8(Prediction.Asteroids[r].BrainX8,ShotXLeft8) < DistX8 then
                    if AbstY8(Prediction.Asteroids[r].BrainY8,ShotYLeft8) < DistY8 then
                      begin
                        Kandidat:=False;
{                        if (Prediction.Asteroids[r].Collision) then
                        begin
                          if not Collision then
                          begin
                            Kandidat:=True;
                            Collision:=True;
                          end
                          else
                          begin
                            if GesamtAbschussFrames>(Shot+Turns) then
//                              if ShotAbschussFrames>Shot then
//                              if TurnAbschussFrames>Turns then
                                Kandidat:=True;
                          end;
                        end;}
                        if Geeignet then
                          if GesamtAbschussFrames>(Shot+Turns) then
//                            if ShotAbschussFrames>Shot then
//                            if TurnAbschussFrames>Turns then
                              Kandidat:=True;
                        if Kandidat then
                        begin
//                          Abbruch:=True;
                          Drehung:=-Turns;
                          Ind:=r;
                          GesamtAbschussFrames:=Shot+Turns; // Frames des Schusses bis zum Treffpunkt
                          TurnAbschussFrames:=Turns;
                          ShotAbschussFrames:=Shot;
                        end;
                      end;
                    if not Abbruch then
                    begin // Rechtsdrehung
                      if AbstX8(Prediction.Asteroids[r].BrainX8,ShotXRight8) < DistX8 then
                        if AbstY8(Prediction.Asteroids[r].BrainY8,ShotYRight8) < DistY8 then
                        begin
                          Kandidat:=False;
{                          if (Prediction.Asteroids[r].Collision) then
                          begin
                            if not Collision then
                            begin
                              Kandidat:=True;
                              Collision:=True;
                            end
                            else
                            begin
                              if GesamtAbschussFrames>(Shot+Turns) then
//                                if ShotAbschussFrames>Shot then
  //                              if TurnAbschussFrames>Turns then
                                  Kandidat:=True;
                            end;
                          end;}
                          if Geeignet then
                            if GesamtAbschussFrames>(Shot+Turns) then
//                              if ShotAbschussFrames>Shot then
//                                if TurnAbschussFrames>Turns then
                                Kandidat:=True;
                          if Kandidat then
                          begin
  //                          Abbruch:=True;
                            Drehung:=Turns;
                            Ind:=r;
                            GesamtAbschussFrames:=Shot+Turns; // Frames des Schusses bis zum Treffpunkt
                            TurnAbschussFrames:=Turns;
                            ShotAbschussFrames:=Shot;
                          end;
                        end;
                    end;
                end;
              end;
              inc(r);
            end;
            inc(Shot);
          end;
          inc(Turns);
        end;



        if not Brain.Active then
        begin
          FriendlyShots:=0;
          for r := 0 to cMaxShots-1 do
            if (Prediction.Shots[r].Valid) then
              if (Prediction.Shots[r].Friendly) then
                 inc(FriendlyShots);

          Brain.Active:=True;
          begin
            if SaucerAction then
            begin
              Brain.MultiShot:=2;
              Brain.TurnsLeft:=SaucerDrehung;
              // noch eigene Schsse vorhanden ?
              if FriendlyShots<cMaxFriendlyShots then
                Prediction.Saucer.Beschuss:=SaucerGesamtAbschussFrames // Ast. fr x Frames (Schussdauer) nicht beschiessen, falls Schuss vorhanden
              else
                Prediction.Saucer.Beschuss:=0; // zum erneuten Beschuss freigeben
            end
            else
            begin
              if (GesamtAbschussFrames<>999999999) then
              begin

//myWB:=WinkelByteSync.WinkelByte-Drehung;
//if myWB>255 then
//  dec(myWB,256)
//else
//  if myWB<0 then
//    inc(myWB,256);
//PB.Canvas.Pen.Color:=clBlack;
//PB.Canvas.MoveTo(DecodedFrame.Ship.X8 div 8,cMaxY-(DecodedFrame.Ship.Y8 div 8));
//PB.Canvas.LineTo((DecodedFrame.Ship.X8+100*WinkelByte2dXdYTab8[myWB,0]) div 8,cMaxY-((DecodedFrame.Ship.Y8+100*WinkelByte2dXdYTab8[myWB,1]) div 8));

                Brain.TurnsLeft:=Drehung;
                case Prediction.Asteroids[Ind].Size of
                  eLarge:Brain.MultiShot:=6; // 4 Schuesse auf grossen Asteroiden
                  eMedium:Brain.MultiShot:=2; // 2 Schuesse auf mittleren Asteroiden
                else
                  Brain.MultiShot:=0; // 1 Schuss
                // noch eigene Schsse vorhanden ?
                end;
                if FriendlyShots<cMaxFriendlyShots then
//                  Prediction.Asteroids[Ind].Beschuss:=GesamtAbschussFrames // Ast. fr x Frames (Schussdauer) nicht beschiessen, falls Schuss vorhanden
                  Prediction.Asteroids[Ind].Beschuss:=0 // Ast. fr x Frames (Schussdauer) nicht beschiessen, falls Schuss vorhanden
                else
                  Prediction.Asteroids[Ind].Beschuss:=0; // zum erneuten Beschuss freigeben
              end;
            end;
          end;
        end;

      end;

    end;

    Hyperspace:=False;

    // Asteroidengefahr unmittelbar ?, dann Hyperspace
    if DecodedFrame.Ship.Present then
    begin
      x1:=DecodedFrame.Ship.X8;
      y1:=DecodedFrame.Ship.Y8;
      for r:=0 to DecodedFrame.AnzAsteroids-1 do
      begin
        case DecodedFrame.Asteroids[r].Size of
          eSmall:
            begin
              DistX8:=cAsteroidDangerSmall8; // Baustelle 25*8
              DistY8:=cAsteroidDangerSmall8; // Baustelle 25*8
            end;
          eMedium:
            begin
              DistX8:=cAsteroidDangerMedium8; // Baustelle 38*8
              DistY8:=cAsteroidDangerMedium8; // Baustelle 38*8
            end;
          eLarge:
            begin
              DistX8:=cAsteroidDangerLarge8; // Baustelle 45*8
              DistY8:=cAsteroidDangerLarge8; // Baustelle 45*8
            end;
        else
          ShowMessage('unbek. AstSize in DoIntelligence: '+inttostr(integer(DecodedFrame.Asteroids[r].Size)));
        end; // case
        x2:=DecodedFrame.Asteroids[r].X8;
        y2:=DecodedFrame.Asteroids[r].Y8;

        if abs(x2-x1)<DistX8 then
          if abs(y2-y1)<DistY8 then
            Hyperspace:=True;
      end;
    end;

    // Schuss aufs eigene Schiff vom Saucer unmittelbar ?, dann Hyperspace
    if DecodedFrame.Ship.Present then
    begin
      x1:=DecodedFrame.Ship.X8;
      y1:=DecodedFrame.Ship.Y8;
      DistX8:=cAbstandShipShot8; // Baustelle
      DistY8:=cAbstandShipShot8; // Baustelle
      for r := 0 to Prediction.AnzShots-1 do
      begin
        if (Prediction.Shots[r].Valid) and (not Prediction.Shots[r].Friendly) then
        begin
          x2:=SumX8(Prediction.Shots[r].X8,Prediction.Shots[r].dX8);
          y2:=SumY8(Prediction.Shots[r].Y8,Prediction.Shots[r].dY8);
          if AbstX8(x2,x1)<DistX8 then
            if AbstY8(y2,y1)<DistY8 then
            begin
              Hyperspace:=True;
//              memo1.lines.add('Hyper wegen Schuss');
            end;
        end;
      end;
    end;

    if Hyperspace then
      result:=cKEY_HYPERSPACE
    else
      result:=key;
  end // if Ship.Present
  else
  begin
    result:=key;
    Brain.Active:=False;
  end;
end;

function TForm1.FindFreeAsteroid:Integer;
var
  r : Integer;
  Abbruch : Boolean;
begin
  r:=0;
  Abbruch:=False;
  while (r<cMaxAsteroids) and (not Abbruch) do
  begin
    if not Prediction.Asteroids[r].Valid then
    begin
      result:=r;
      Abbruch:=True;
    end;
    inc(r);
  end;
  if not Abbruch then
    result:=-1;
end;

function TForm1.FindFreeShot:Integer;
var
  r : Integer;
  Abbruch : Boolean;
begin
  r:=0;
  Abbruch:=False;
  while (r<cMaxShots) and (not Abbruch) do
  begin
    if not Prediction.Shots[r].Valid then
    begin
      result:=r;
      Abbruch:=True;
    end;
    inc(r);
  end;
  if not Abbruch then
    result:=-1;
end;

function TForm1.InitSockets:Boolean;
var
   Data: WSAData;
   Res: Integer;
   ErrorCode: Integer;
   S: string;
   Len: Integer;
begin
  res := WSAStartup( MakeWord(1,1), Data);
  if Res = SOCKET_ERROR then
  begin
    // get error code
    ErrorCode := WSAGetLastError;

    //transform ErrorCode to string
    Setlength(s, 260);
    Len := Formatmessage(Format_Message_from_System,
      nil, errorCode, 0, @s[1], length(s), nil);
    Setlength(s, Len);

    //display error-string
    MessageBox(0, PChar(s), 'Socket Error',
      MB_OK or MB_ICONERROR or MB_TASKMODAL);

    result:=FALSE;
  end
  else
    result:=TRUE;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  r : Integer;
begin

minx:=10000;
miny:=10000;
maxx:=-10000;
maxy:=-10000;

  Brain.Active:=False;

  OldKeys[0]:=0;
  OldKeys[1]:=0;

   // Syncvorgang starten
  WinkelByteSync.SyncIndex:=cMaxWinkelByteSyncArray div 2;
  WinkelByteSync.WinkelByte:=0; // noch unbekannt
  WinkelByteSync.Synced:=False;
  WinkelByteSync.Active:=True;

  // dX,dY-Tab
  for r := 0 to 255 do
  begin
    WinkelByte2dXdYTab8[r,0]:=Round(64.0 * cos(r/(256.0 / 6.0)*pi));
    WinkelByte2dXdYTab8[r,1]:=Round(64.0 * sin(r/(256.0 / 6.0)*pi));
  end;

  Prediction.Saucer.Present:=False; // noch kein UFO vorhanden

  // alle Asteroiden invalid
  Prediction.AnzAsteroids:=0;
  for r:=0 to Prediction.AnzAsteroids-1 do
  begin
    Prediction.Asteroids[r].Valid:=False;
  end;

  // alle Schsse invalid
  Prediction.AnzShots:=0;
  for r:=0 to Prediction.AnzShots-1 do
  begin
    Prediction.Shots[r].Valid:=False;
  end;
end;

procedure TForm1.InitUDPSocket();
var
  SockAddr: TSockAddrIn;
  AddrLen: Integer;
begin
  UDPSocket := socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if UDPSocket = INVALID_SOCKET then
    ProcessError('Create Socket, '+ IntToStr(WSAGetLastError()));

  AddrLen := SizeOf(SockAddr);
  SockAddr.sin_family := AF_INET;
  SockAddr.sin_port := htons(cAsteroidsPort+1);
  SockAddr.sin_addr.S_addr := inet_addr(PChar(EigeneIPEdit.Text));
  if bind(UDPSocket, SockAddr, AddrLen) = SOCKET_ERROR then
    ProcessError('Bind Socket, '+ IntToStr(WSAGetLastError()));

  if WSAAsyncSelect(UDPSocket, Self.Handle, WM_UDPSocket, FD_READ or FD_WRITE) = SOCKET_ERROR then
    ProcessError('WSAAsyncSelect');
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CloseSocket(UDPSocket);
  WSACleanup;
end;

procedure TForm1.DrawAsteroid(x,y:Integer;Size:TSize);
var
  Groesse:Integer;
begin

  if x < minx then
    minx:=x;
  if y < miny then
    miny:=y;
  if x > maxx then
    maxx:=x;
  if y > maxy then
    maxy:=y;

  case Size of
    eLarge :Groesse:=30;
    eMedium:Groesse:=20;
    eSmall :Groesse:=10;
  else
    Groesse:=2;
    ShowMessage('DrawAsteroid: unknown Size');
  end;
  y:=cMaxy-y;
  PB.Canvas.Brush.Color:=clSilver;
  PB.Canvas.Pen.Color:=clBlack;
  PB.Canvas.Ellipse(x-Groesse,y-Groesse,x+Groesse,y+Groesse);

end;

{procedure TForm1.DrawHit();
var
  Groesse:Integer;
  x,y:Integer;
begin
  x:=HitX8 div 8;
  y:=HitY8 div 8;
  Groesse:=10;
  y:=cMaxy-y;
  PB.Canvas.Pen.Color:=clWhite;
  PB.Canvas.Brush.Color:=clWhite;
  PB.Canvas.Ellipse(x-Groesse,y-Groesse,x+Groesse,y+Groesse);
end;}

procedure TForm1.DrawPredAsteroid(x,y:Integer;Size:TSize);
var
  Groesse:Integer;
begin
  case Size of
    eLarge :Groesse:=25;
    eMedium:Groesse:=15;
    eSmall :Groesse:=5;
  else
    Groesse:=2;
    ShowMessage('DrawPredAsteroid: unknown Size');
  end;
  y:=cMaxy-y;
  PB.Canvas.Brush.Color:=clSilver;
  PB.Canvas.Pen.Color:=clFuchsia;
  PB.Canvas.Ellipse(x-Groesse,y-Groesse,x+Groesse,y+Groesse);
end;

procedure TForm1.DrawPredSaucer(x,y:Integer;Size:TSize);
var
  Groesse:Integer;
begin
  if Size=eSmall then
    Groesse:=5
   else
    Groesse:=10;
  y:=cMaxy-y;
  PB.Canvas.Brush.Color:=clSilver;
  PB.Canvas.Pen.Color:=clFuchsia;
  PB.Canvas.Ellipse(x-Groesse,y-Groesse,x+Groesse,y+Groesse);
end;

procedure TForm1.DrawShot(x,y:Integer);
begin
  y:=cMaxy-y;
  PB.Canvas.Pen.Color:=clYellow;
  PB.Canvas.Brush.Color:=clSilver;
  PB.Canvas.Ellipse(x-5,y-5,x+5,y+5);
end;

procedure TForm1.DrawPredShot(x,y:Integer;Friendly:Boolean);
begin
  y:=cMaxy-y;
  if Friendly then
    PB.Canvas.Pen.Color:=clGreen
  else
    PB.Canvas.Pen.Color:=clRed;
  PB.Canvas.Brush.Color:=clSilver;
  PB.Canvas.Ellipse(x-5,y-5,x+5,y+5);
end;

procedure TForm1.DrawSaucer();
var
  x,y,Size : Integer;
begin
  y:=cMaxy-DecodedFrame.Saucer.Y8 div 8;
  x:=DecodedFrame.Saucer.X8 div 8;
  PB.Canvas.Pen.Color:=clRed;
  if DecodedFrame.Saucer.Size=eSmall then
    Size:=5
  else
    Size:=10;
  PB.Canvas.Brush.Color:=clSilver;
  PB.Canvas.Ellipse(x-Size,y-Size,x+Size,y+Size);
end;

procedure TForm1.DrawShip();
var
  x,y,Size : Integer;
begin
  y:=cMaxy-(DecodedFrame.Ship.Y8 div 8);
  x:=DecodedFrame.Ship.X8 div 8;
  PB.Canvas.Pen.Color:=clLime;
  PB.Canvas.Brush.Color:=clSilver;
  Size:=5;
  PB.Canvas.Ellipse(x-Size,y-Size,x+Size,y+Size);
  PB.Canvas.MoveTo(x,y);
  PB.Canvas.LineTo(x+DecodedFrame.Ship.DirX,y+(cMaxY-DecodedFrame.Ship.DirY));
end;

procedure TForm1.SendUDP(IP: string; Port: Word; var Buf; BufLen: Integer);
var
  SockAddr: TSockAddrIn;
  AddrLen: Integer;
begin
  AddrLen := SizeOf(SockAddr);

  SockAddr.sin_family := AF_INET;
  SockAddr.sin_Port := htons(Port);
  SockAddr.sin_Addr.S_Addr := inet_addr(PChar(IP));

  if SendTo(UDPSocket, Buf, BufLen, 0, SockAddr, AddrLen) = SOCKET_ERROR then
    ProcessError('SendTo, '+ IntToStr(WSAGetLastError()));
end;

function TForm1.GSF2AsteroidSize():TSize;
begin
  case GSF of
     0:result:=eLarge;
    14:result:=eSmall;
    15:result:=eMedium;
  else
    ShowMessage('unknown Asteroid size');
  end;
end;

function TForm1.GSF2SaucerSize():TSize;
begin
  case GSF of
    14:result:=eSmall;
    15:result:=eLarge;
  else
    ShowMessage('unknown Saucer size');
  end;
end;

procedure TForm1.DrawVectorRAM();
var
  r,rr : Integer;
begin
  if DebugAusgabenCB.Checked then
  begin
    for r:=0 to DecodedFrame.AnzAsteroids-1 do
      DrawAsteroid(DecodedFrame.Asteroids[r].X8 div 8,DecodedFrame.Asteroids[r].Y8 div 8,DecodedFrame.Asteroids[r].Size);
    for r:=0 to cMaxAsteroids-1 do
     if Prediction.Asteroids[r].Valid then
     begin
       for rr := 20 to 20 do
       begin
         DrawPredAsteroid((Prediction.Asteroids[r].X8 + rr*Prediction.Asteroids[r].dX8) div 8,
                          (Prediction.Asteroids[r].Y8 + rr*Prediction.Asteroids[r].dY8 )div 8,
                           Prediction.Asteroids[r].Size);
       end;
     end;

    for r:=0 to DecodedFrame.AnzShots-1 do
      DrawShot(DecodedFrame.Shots[r].X8 div 8,DecodedFrame.Shots[r].Y8 div 8);
    for r:=0 to cMaxShots-1 do
     if Prediction.Shots[r].Valid then
       for rr := 20 to 20 do
       begin
         DrawPredShot((Prediction.Shots[r].X8 + rr*Prediction.Shots[r].dX8) div 8,
                      (Prediction.Shots[r].Y8 + rr*Prediction.Shots[r].dY8) div 8,
                       Prediction.Shots[r].Friendly);
       end;

    if DecodedFrame.Saucer.Present then
    begin
      DrawSaucer();
      DrawPredSaucer((Prediction.Saucer.X8 + 20*Prediction.Saucer.dX8) div 8,
                     (Prediction.Saucer.Y8 + 20*Prediction.Saucer.dY8 )div 8,
                      Prediction.Saucer.Size);
    end;
    if DecodedFrame.Ship.Present then
      DrawShip();
  //  DrawHit();
  end;
end;

procedure TForm1.DecodeVectorRAM;
var
  Word0,Word1:Word;
  PC, // Program Counter
  OPCode,
  PosX,
  PosY,
  Hell,
  SF, // Skalierungsfaktor bei SVEC
  Adr,
  VectX,
  VectY:Integer;
  Abbruch:Boolean;
  ShipDetect,ShipVectX,ShipVectY:Integer;
begin
  ShipDetect:=0;
  DecodedFrame.AnzAsteroids:=0;
  DecodedFrame.AnzShots:=0;
  DecodedFrame.Ship.Present:=False;
  DecodedFrame.Saucer.Present:=False;

  PosX:=0;
  PosY:=0;

//memo1.lines.add(inttohex(ReceiveMsg.VectorRAM[PC],4));

  ReceiveMsg.Ping:=0;

  if (ReceiveMsg.VectorRAM[0]=$e001) or (ReceiveMsg.VectorRAM[0]=$e201) then
    Abbruch:=False
  else
  begin
    Abbruch:=True;
    ShowMessage('VectorRAM corrupt !');
  end;

  PC:=1; // 1. Jump berspringen
  while not Abbruch do
  begin

    OPCode:=ReceiveMsg.VectorRAM[PC] shr 12;
    case OPCode of
     cOPVCTR0..cOPVCTR9:
       begin
         Word0:=ReceiveMsg.VectorRAM[PC];
         Inc(PC);
         Word1:=ReceiveMsg.VectorRAM[PC];
         Inc(PC);
         VectY:=Word0 and $3ff;
         VectX:=Word1 and $3ff;
         if (Word0 and $400)=$400 then
           VectY:=-VectY;
         if (Word1 and $400)=$400 then
           VectX:=-VectX;
         VectY:=VectY-cYOffset;
         Hell:=Word1 shr 12;

         if (Hell=15) and (VectX=0) and (VectY=-cYOffset) then
         begin
           DecodedFrame.Shots[DecodedFrame.AnzShots].X8 := PosX * 8;
           DecodedFrame.Shots[DecodedFrame.AnzShots].Y8 := PosY * 8;
//           showmessage(inttostr(posx)+','+inttostr(posy));
           Inc(DecodedFrame.AnzShots);
         end;

         if (OPCode=cOPVCTR6) and (Hell=12) and (VectX<>0) and (VectY<>0) then
         begin
           case ShipDetect of
             0:begin
                 ShipVectX:=VectX;
                 ShipVectY:=VectY;
                 Inc(ShipDetect);
             end;
             1:begin
                 DecodedFrame.Ship.Present:=True;
                 DecodedFrame.Ship.X8 := PosX * 8;
                 DecodedFrame.Ship.Y8 := PosY * 8;
                 DecodedFrame.Ship.DirX:=ShipVectX - VectX;
                 DecodedFrame.Ship.DirY:=ShipVectY - VectY;

                 Inc(ShipDetect);
             end;
           end;
         end
         else
           if ShipDetect=1 then
             ShipDetect:=0;

{         VectY:=Word0 and $3ff;
         VectX:=Word1 and $3ff;
         if (Word0 and $400)=$400 then
           VectY:=-VectY;
         if (Word1 and $400)=$400 then
           VectX:=-VectX;
         Hell:=Word1 shr 12;
         Divi:=OPCode+GSF;
         if Divi<0 then Divi:=0
           else if Divi>9 then Divi:=9;
         Divi:=512 shr Divi;
         VectX:=VectX div Divi;
         VectY:=VectY div Divi;
         PosX:=PosX+VectX;
         PosY:=PosY+VectY;}
       end;
     cOPLABS:
       begin
         Word0:=ReceiveMsg.VectorRAM[PC];
         Inc(PC);
         Word1:=ReceiveMsg.VectorRAM[PC];
         Inc(PC);
         VectX:=Word1 and $3ff;
         VectY:=Word0 and $3ff;
         VectY:=VectY-cYOffset;
         GSF:=Word1 shr 12;
         PosX:=VectX;
         PosY:=VectY;
       end;
     cOPHALT:
       begin
         Abbruch:=TRUE;
         Inc(PC);
       end;
     cOPJSRL:
       begin
         Adr:=ReceiveMsg.VectorRAM[PC] and $fff;
         case Adr of
           $8f3:
             begin
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].X8:=PosX * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Y8:=PosY * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Typus:=eAsteroidTypus0;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Size:=GSF2AsteroidSize();
               Inc(DecodedFrame.AnzAsteroids);
             end;
           $8ff:
             begin
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].X8:=PosX * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Y8:=PosY * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Typus:=eAsteroidTypus1;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Size:=GSF2AsteroidSize();
               Inc(DecodedFrame.AnzAsteroids);
             end;
           $90d:
             begin
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].X8:=PosX * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Y8:=PosY * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Typus:=eAsteroidTypus2;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Size:=GSF2AsteroidSize();
               Inc(DecodedFrame.AnzAsteroids);
             end;
           $91a:
             begin
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].X8:=PosX * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Y8:=PosY * 8;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Typus:=eAsteroidTypus3;
               DecodedFrame.Asteroids[DecodedFrame.AnzAsteroids].Size:=GSF2AsteroidSize();
               Inc(DecodedFrame.AnzAsteroids);
             end;
           $929:
             begin
               DecodedFrame.Saucer.Present:=True;
               DecodedFrame.Saucer.X8 := PosX * 8;
               DecodedFrame.Saucer.Y8 := PosY * 8;
               DecodedFrame.Saucer.Size:=GSF2SaucerSize();
             end;
         end;
         Inc(PC);
       end;
     cOPRTSL:
       begin
         Inc(PC);
       end;
     cOPJMPL:
       begin
//         PC:=ReceiveMsg.VectorRAM[PC] and $fff;
        Inc(PC);
       end;
     cOPSVEC:
       begin
         Word0:=ReceiveMsg.VectorRAM[PC];
         Inc(PC);
{         VectY:=Word0 and $300;
         VectX:=(Word0 and 3) shl 8;
         Hell:=(Word0 and $f0) shr 4;
         if (Word0 and 4)=4 then
           VectX:=-VectX;
         if (Word0 and $400)=$400 then
           VectY:=-VectY;
         if (Word0 and 4)=4 then
           VectX:=-VectX;
         VectY:=VectY-cYOffset;
         SF:=(Word0 and 8) shr 2;
         SF:=SF or ((Word0 and $800) shr 11);
         Divi:=SF+GSF;
         if Divi<0 then Divi:=0
           else if Divi>3 then Divi:=3;
         Divi:=128 shr Divi;
         VectX:=VectX div Divi;
         VectY:=VectY div Divi;
         PosX:=PosX+VectX;
         PosY:=PosY+VectY;}
       end;
    else

//       ProcessError('unknown Vector-OPCode !');
    end; // case
  end; // while
end;

procedure TForm1.DoPrediction();
var
  NewDx8,NewDy8,TempDist,Dist,r,rr,ind,x1,y1,x2,y2 : Integer;
  NewAsteroidUsed,OldAsteroidUsed:array[0..cMaxAsteroids-1] of Boolean;
  NewShotUsed,OldShotUsed:array[0..cMaxShots-1] of Boolean;
  Found,NewAsteroid,NewShot:Boolean;
t1,t2:Integer;
begin
  // Winkelbyte ggf. grob ermitteln
  if DecodedFrame.Ship.Present and (not WinkelByteSync.Synced) then
  begin
    Found:=False;
    for r := 0 to 255 do
    begin
      if cWinkelByteTab[r,0] = DecodedFrame.Ship.DirX then
        if cWinkelByteTab[r,1] = DecodedFrame.Ship.DirY then
        begin
          WinkelByteSync.WinkelByte:=r;
          Found:=True;
        end;
    end;
    if not Found then
      ShowMessage ('WinkelByte not found');
  end;

  // alle Asteroiden hochrechnen
  for r:=0 to cMaxAsteroids-1 do
  begin
    if Prediction.Asteroids[r].Valid then
    begin
      if Prediction.Asteroids[r].Beschuss>0 then
        Dec(Prediction.Asteroids[r].Beschuss);
      Prediction.Asteroids[r].PredX8:=SumX8(Prediction.Asteroids[r].X8,Prediction.Asteroids[r].dX8);
      Prediction.Asteroids[r].PredY8:=SumY8(Prediction.Asteroids[r].Y8,Prediction.Asteroids[r].dY8);
    end;
  end;

  // alle Schuesse hochrechnen
  for r:=0 to cMaxShots-1 do
  begin
    if Prediction.Shots[r].Valid then
    begin
      Prediction.Shots[r].PredX8:=SumX8(Prediction.Shots[r].X8,Prediction.Shots[r].dX8);
      Prediction.Shots[r].PredY8:=SumY8(Prediction.Shots[r].Y8,Prediction.Shots[r].dY8);
    end;
  end;

  // Saucer, falls vorhanden, hochrechnen
  if Prediction.Saucer.Present then
  begin
    if Prediction.Saucer.Beschuss>0 then
        Dec(Prediction.Saucer.Beschuss);
      Prediction.Saucer.PredX8:=SumX8(Prediction.Saucer.X8,Prediction.Saucer.dX8);
      Prediction.Saucer.PredY8:=SumY8(Prediction.Saucer.Y8,Prediction.Saucer.dY8);
  end;


  // Saucer, falls vorhanden, neue dX,dY bestimmen, sonst lschen
  if DecodedFrame.Saucer.Present then
  begin
    if (not Prediction.Saucer.Present) then // 1. Auftreten
    begin
      Prediction.Saucer:=DecodedFrame.Saucer;
      Prediction.Saucer.Present:=True;
      Prediction.Saucer.dX8:=0;
      Prediction.Saucer.dY8:=0;
      Prediction.Saucer.FirstX8:=DecodedFrame.Saucer.X8;
      Prediction.Saucer.FirstY8:=DecodedFrame.Saucer.Y8;
      Prediction.Saucer.FirstCnt:=0;
      Prediction.Saucer.Beschuss:=0;
    end
    else
    begin
      inc(Prediction.Saucer.FirstCnt); // wichtig HIER

      if (Prediction.Saucer.FirstCnt >= 1) then
      begin
//        NewDx8:=(DecodedFrame.Saucer.X8-Prediction.Saucer.FirstX8) div Prediction.Saucer.FirstCnt;
//        NewDy8:=(DecodedFrame.Saucer.Y8-Prediction.Saucer.FirstY8) div Prediction.Saucer.FirstCnt;
        NewDx8:=(DecodedFrame.Saucer.X8-Prediction.Saucer.X8);
        NewDy8:=(DecodedFrame.Saucer.Y8-Prediction.Saucer.Y8);
      end
      else
      begin
        NewDx8:=Prediction.Saucer.dX8;
        NewDy8:=Prediction.Saucer.dY8;
      end;

      if abs(NewDx8)<100*8 then // x-ber-Unterlauf
        Prediction.Saucer.dX8 := NewDx8
      else
      begin
        Prediction.Saucer.FirstCnt:=0;
        Prediction.Saucer.FirstX8 := DecodedFrame.Saucer.X8;
        Prediction.Saucer.FirstY8 := DecodedFrame.Saucer.Y8;
      end;
      if abs(NewDy8)<100*8 then // y-ber-Unterlauf
        Prediction.Saucer.dY8 := NewDy8
      else
      begin
        Prediction.Saucer.FirstCnt := 0;
        Prediction.Saucer.FirstX8 := DecodedFrame.Saucer.X8;
        Prediction.Saucer.FirstY8 := DecodedFrame.Saucer.Y8;
      end;
      Prediction.Saucer.X8 := DecodedFrame.Saucer.X8;
      Prediction.Saucer.Y8 := DecodedFrame.Saucer.Y8;
    end;
  end
  else
    Prediction.Saucer.Present:=False;

  // ASTEROIDEN-PREDICTION:
  // alle Asteroiden aus dem aktuellen Frame/Verwaltung noch "unused"
  for r:=0 to cMaxAsteroids-1 do
  begin
    NewAsteroidUsed[r]:=False;
    OldAsteroidUsed[r]:=False;
  end;

  if Prediction.AnzAsteroids=0 then
  begin
    for r:=0 to DecodedFrame.AnzAsteroids-1 do
    begin
      Prediction.Asteroids[r] := DecodedFrame.Asteroids[r];
      Prediction.Asteroids[r].FirstX8 := DecodedFrame.Asteroids[r].X8;
      Prediction.Asteroids[r].FirstY8 := DecodedFrame.Asteroids[r].Y8;
      Prediction.Asteroids[r].FirstCnt := 0;
      Prediction.Asteroids[r].Valid := True;
      Prediction.Asteroids[r].dX8 := 0;
      Prediction.Asteroids[r].dY8 := 0;
      Prediction.Asteroids[r].Beschuss:=0; // zum Beschuss freigeben
      Inc(Prediction.AnzAsteroids);
    end;
  end
  else
  begin
    for r:=0 to DecodedFrame.AnzAsteroids-1 do
    begin
      NewAsteroid:=False;
      ind:=-1;
      Dist := 999999999;
      for rr:=0 to cMaxAsteroids-1 do
      begin
        if Prediction.Asteroids[rr].Valid then
          if Prediction.Asteroids[rr].Typus=DecodedFrame.Asteroids[r].Typus then
            if Prediction.Asteroids[rr].Size=DecodedFrame.Asteroids[r].Size then
              if (not OldAsteroidUsed[rr]) then // Ast. in der Verwaltung noch nicht zugewiesen
              begin
                x1:=DecodedFrame.Asteroids[r].X8;
                y1:=DecodedFrame.Asteroids[r].Y8;
                x2:=Prediction.Asteroids[rr].PredX8;
                y2:=Prediction.Asteroids[rr].PredY8;
                TempDist:=abs(x2-x1)+abs(y2-y1); //(x1-x2)*(x1-x2) + (y1-y2)*(y1-y2);
                if TempDist<Dist then
                begin
                  Dist:=TempDist;
                  ind:=rr;
                end;
              end;
      end; // for rr

      if ind <> -1 then
      begin // gefunden
        if Dist < 50*8 then // Baustelle
        begin
          NewAsteroidUsed[r]:=True;
          OldAsteroidUsed[ind]:=True;
          inc(Prediction.Asteroids[ind].FirstCnt); // wichtig HIER

          if (Prediction.Asteroids[ind].FirstCnt <=10 ) then
          begin
            NewDx8:=(DecodedFrame.Asteroids[r].X8-Prediction.Asteroids[ind].FirstX8) div Prediction.Asteroids[ind].FirstCnt;
            NewDy8:=(DecodedFrame.Asteroids[r].Y8-Prediction.Asteroids[ind].FirstY8) div Prediction.Asteroids[ind].FirstCnt;
          end
          else
          begin
            NewDx8:=Prediction.Asteroids[ind].dX8;
            NewDy8:=Prediction.Asteroids[ind].dY8;
          end;

          if abs(NewDx8)<100*8 then // x-ber-Unterlauf
            Prediction.Asteroids[ind].dX8 := NewDx8
          else
          begin
            Prediction.Asteroids[ind].FirstCnt:=0;
            Prediction.Asteroids[ind].FirstX8 := DecodedFrame.Asteroids[r].X8;
            Prediction.Asteroids[ind].FirstY8 := DecodedFrame.Asteroids[r].Y8;
          end;
          if abs(NewDy8)<100*8 then // y-ber-Unterlauf
            Prediction.Asteroids[ind].dY8 := NewDy8
          else
          begin
            Prediction.Asteroids[ind].FirstCnt := 0;
            Prediction.Asteroids[ind].FirstX8 := DecodedFrame.Asteroids[r].X8;
            Prediction.Asteroids[ind].FirstY8 := DecodedFrame.Asteroids[r].Y8;
          end;
          Prediction.Asteroids[ind].X8 := DecodedFrame.Asteroids[r].X8;
          Prediction.Asteroids[ind].Y8 := DecodedFrame.Asteroids[r].Y8;

        end
        else
          NewAsteroid:=True;
      end
      else
      begin
        NewAsteroid:=True;
      end;

      if NewAsteroid then
      begin
        // Asteroid noch nicht in der Veraltung: neu aufnehmen
        ind:=FindFreeAsteroid();
        if ind <> -1 then
        begin
          NewAsteroidUsed[r]:=True;
          OldAsteroidUsed[ind]:=True;
          Prediction.Asteroids[ind] := DecodedFrame.Asteroids[r];
          Prediction.Asteroids[ind].FirstX8 := DecodedFrame.Asteroids[r].X8;
          Prediction.Asteroids[ind].FirstY8 := DecodedFrame.Asteroids[r].Y8;
          Prediction.Asteroids[ind].FirstCnt := 0;
          Prediction.Asteroids[ind].Valid := True;
          Prediction.Asteroids[ind].dX8 := 0;
          Prediction.Asteroids[ind].dY8 := 0;
          Prediction.Asteroids[ind].Beschuss:=0; // zum Beschuss freigeben
          Inc(Prediction.AnzAsteroids);
        end;
      end;
    end;

    // nicht zugeordnete Asteroiden in der Verwaltung lschen
    for r:=0 to cMaxAsteroids-1 do
    begin
      if (not OldAsteroidUsed[r]) and (Prediction.Asteroids[r].Valid) then
      begin
        Prediction.Asteroids[r].Valid:=False;
        Dec(Prediction.AnzAsteroids);
      end;
    end;

  end;

  // SHOT-PREDICTION:
  // alle Shots aus dem aktuellen Frame/Verwaltung noch "unused"
  for r:=0 to cMaxShots-1 do
  begin
    NewShotUsed[r]:=False;
    OldShotUsed[r]:=False;
  end;

  if Prediction.AnzShots=0 then
  begin
    for r:=0 to DecodedFrame.AnzShots-1 do
    begin
      Prediction.Shots[r].Valid := True;
      Prediction.Shots[r].X8 := DecodedFrame.Shots[r].X8;
      Prediction.Shots[r].Y8 := DecodedFrame.Shots[r].Y8;
      Prediction.Shots[r].dX8 := 0;
      Prediction.Shots[r].dY8 := 0;
      Prediction.Shots[r].FirstX8 := DecodedFrame.Shots[r].X8;
      Prediction.Shots[r].FirstY8 := DecodedFrame.Shots[r].Y8;
      Prediction.Shots[r].FirstCnt := 0;
      if DecodedFrame.Ship.Present then
      begin
        if (DecodedFrame.Saucer.Present) then
        begin
          if (AbstX8(DecodedFrame.Saucer.X8,DecodedFrame.Shots[r].X8) < cAbstandShipShot8) and
             (AbstY8(DecodedFrame.Saucer.Y8,DecodedFrame.Shots[r].Y8) < cAbstandShipShot8) then
            Prediction.Shots[r].Friendly:=False
          else
            Prediction.Shots[r].Friendly:=True;
        end
        else
        begin
          Prediction.Shots[r].Friendly:=True;
        end;
      end
      else
        Prediction.Shots[r].Friendly:=False; // Schuss vom Saucer
      Inc(Prediction.AnzShots);
    end;
  end
  else
  begin
    for r:=0 to DecodedFrame.AnzShots-1 do
    begin
      NewShot:=False;
      ind:=-1;
      Dist := 999999999;
      for rr:=0 to cMaxShots-1 do
      begin
        if Prediction.Shots[rr].Valid then
              if (not OldShotUsed[rr]) then // Shot in der Verwaltung noch nicht zugewiesen
              begin
                x1:=DecodedFrame.Shots[r].X8;
                y1:=DecodedFrame.Shots[r].Y8;
                x2:=Prediction.Shots[rr].PredX8;
                y2:=Prediction.Shots[rr].PredY8;
                TempDist:=abs(x2-x1)+abs(y2-y1); //(x1-x2)*(x1-x2) + (y1-y2)*(y1-y2);
                if TempDist<Dist then
                begin
                  Dist:=TempDist;
                  ind:=rr;
                end;
              end;
      end; // for rr

      if ind <> -1 then
      begin // gefunden
        if Dist < 20*8 then // Baustelle
        begin
          NewShotUsed[r]:=True;
          OldShotUsed[ind]:=True;
          inc(Prediction.Shots[ind].FirstCnt); // wichtig HIER

          if (Prediction.Shots[ind].FirstCnt <=10 ) then
          begin
            NewDx8:=(DecodedFrame.Shots[r].X8-Prediction.Shots[ind].FirstX8) div Prediction.Shots[ind].FirstCnt;
            NewDy8:=(DecodedFrame.Shots[r].Y8-Prediction.Shots[ind].FirstY8) div Prediction.Shots[ind].FirstCnt;
          end
          else
          begin
            NewDx8:=Prediction.Shots[ind].dX8;
            NewDy8:=Prediction.Shots[ind].dY8;
          end;

          if abs(NewDx8)<100*8 then // x-ber-Unterlauf
            Prediction.Shots[ind].dX8 := NewDx8
          else
          begin
            Prediction.Shots[ind].FirstCnt:=0;
            Prediction.Shots[ind].FirstX8 := DecodedFrame.Shots[r].X8;
            Prediction.Shots[ind].FirstY8 := DecodedFrame.Shots[r].Y8;
          end;
          if abs(NewDy8)<100*8 then // y-ber-Unterlauf
            Prediction.Shots[ind].dY8 := NewDy8
          else
          begin
            Prediction.Shots[ind].FirstCnt := 0;
            Prediction.Shots[ind].FirstX8 := DecodedFrame.Shots[r].X8;
            Prediction.Shots[ind].FirstY8 := DecodedFrame.Shots[r].Y8;
          end;
          Prediction.Shots[ind].X8 := DecodedFrame.Shots[r].X8;
          Prediction.Shots[ind].Y8 := DecodedFrame.Shots[r].Y8;

        end
        else
          NewShot:=True;
      end
      else
      begin
        NewShot:=True;
      end;

      if NewShot then
      begin
        // Shot noch nicht in der Veraltung: neu aufnehmen
        ind:=FindFreeShot();
        if ind <> -1 then
        begin
          NewShotUsed[r]:=True;
          OldShotUsed[ind]:=True;
          Prediction.Shots[ind].Valid := True;
          Prediction.Shots[ind].X8 := DecodedFrame.Shots[r].X8;
          Prediction.Shots[ind].Y8 := DecodedFrame.Shots[r].Y8;
          Prediction.Shots[ind].dX8 := 0;
          Prediction.Shots[ind].dY8 := 0;
          Prediction.Shots[ind].FirstX8 := DecodedFrame.Shots[r].X8;
          Prediction.Shots[ind].FirstY8 := DecodedFrame.Shots[r].Y8;
          Prediction.Shots[ind].FirstCnt := 0;
          if DecodedFrame.Ship.Present then
          begin
            if (DecodedFrame.Saucer.Present) then
            begin
              if (AbstX8(DecodedFrame.Saucer.X8,DecodedFrame.Shots[r].X8) < cAbstandShipShot8) and
                 (AbstY8(DecodedFrame.Saucer.Y8,DecodedFrame.Shots[r].Y8) < cAbstandShipShot8) then
                Prediction.Shots[ind].Friendly:=False
              else
                Prediction.Shots[ind].Friendly:=True;
            end
            else
            begin
              Prediction.Shots[ind].Friendly:=True;
            end;
          end
          else
            Prediction.Shots[ind].Friendly:=False; // Schuss vom Saucer
          Inc(Prediction.AnzShots);
        end;
      end;
    end;

    // nicht zugeordnete Shots in der Verwaltung lschen
    for r:=0 to cMaxShots-1 do
    begin
      if (not OldShotUsed[r]) and (Prediction.Shots[r].Valid) then
      begin
        Prediction.Shots[r].Valid:=False;
        Dec(Prediction.AnzShots);
      end;
    end;

  end;

end;

procedure TForm1.SocketMessage(var msg: TMessage);
var
  SockAddr: TSockAddrIn;
  AddrLen,r: Integer;
  RecvLen : Integer;
  s:ShortString;
  Keys:Byte;
begin
  case msg.LParamLo of
    FD_READ:
      begin
        AddrLen := SizeOf(SockAddr);
        RecvLen:=recvFrom(msg.wparam,ReceiveMsg,sizeof(ReceiveMsg),0,SockAddr,AddrLen);

        if RecvLen = SOCKET_ERROR then
          ProcessError('recvFrom ')
        else
          if RecvLen=1026 then
          begin
            DecodeVectorRAM();
            DoPrediction();
            DrawVectorRAM();

            Keys:=DoIntelligence();
//            DoWinkelByteSync(Keys);
            OldKeys[0]:=OldKeys[1];
            OldKeys[1]:=Keys;

            SendKeys(Keys);
            inc(cnt);
          end
          else
          begin
           s:='';
           for r := 0 to RecvLen-1 do
           begin
             if chr(ReceiveMsg.Bytes[r]) in ['a'..'z','A'..'Z','0'..'9',' '] then
               s:=s+chr(ReceiveMsg.Bytes[r]);
           end;
           Memo1.Lines.Add('Len:'+inttostr(recvlen)+'"'+s+'"');
          end;
      end;

    FD_WRITE:;// Memo1.Lines.Add('FD_WRITE');
  end;
end;

procedure TForm1.SendKeys(Key:Byte);
begin
  SendMsg.Key:=Key;
  SendMsg.Ping:=0;
  SendUDP(ServerIPEdit.Text,cAsteroidsPort,SendMsg,sizeof(SendMsg));
end;

procedure TForm1.StartBtnClick(Sender: TObject);
var
  r:Integer;
begin
  StartBtn.Enabled:=False;
  StoppBtn.Enabled:=True;

  if InitSockets() then
  begin
    InitUDPSocket();
    for r:=0 to 5 do
      SendMsg.Magic[r]:=cMagic[r+1];
    FillChar(SendMsgPlayerName.MagicAndPlayerName,sizeof(SendMsgPlayerName.MagicAndPlayerName),0);
    for r:=0 to Length(cMagicPlayerName)-1 do
      SendMsgPlayerName.MagicAndPlayerName[r]:=cMagicPlayerName[r+1];
    GSF:=0;
  end
  else
    Close();

  FirstTel:=True;
  SendMsg.Key:=0;
  SendMsg.Ping:=0;

  if ServerRG.ItemIndex=0 then
    SendUDP(ServerIPEdit.Text,cAsteroidsPort,SendMsg,sizeof(SendMsg))
  else
  begin
    SendUDP(ServerIPEdit.Text,cAsteroidsPort,SendMsg,sizeof(SendMsg));
    SendUDP(ServerIPEdit.Text,cAsteroidsPort,SendMsgPlayerName,sizeof(SendMsgPlayerName));
  end;

end;

procedure TForm1.StoppBtnClick(Sender: TObject);
begin
  StartBtn.Enabled:=True;
  StoppBtn.Enabled:=False;
  CloseSocket(UDPSocket);
  WSACleanup;
end;

end.


