// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <math.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

void Player::Run(void) 
{ 
    FramePacket frame;
    KeysPacket keys;
    GameStatus game;
    char prevframe = 0;
    int t = 0;
    
    for (;;)
    {
	++t;         // Zeit
	++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
	SendPacket(keys);
	ReceivePacket(frame);
	
	if (frame.frameno != ++prevframe || frame.ping != keys.ping)
	{
	    printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
	    prevframe = frame.frameno;
	}
	
	InterpretScreen(frame, game);
	
	keys.clear();   // alle Tasten loslassen
	int min_dist = 0x7fffffff;
	int min_dx = 0;
	int min_dy = 0;
	if (game.ship_present)
	{
	    for (int i=0; i<game.nshots; i++) 
	    {
		int dx;
		int dy;
		// berechne schuss geschwindigkeit
		dx = game.old_shots[i].x - game.shots[i].x;
		dy = game.old_shots[i].y - game.shots[i].y;
		if (dx*dx + dy*dy < 70)
		    game.shots[i].set_d( dx, dy );
		else
		    game.shots[i].set_d( 0, 0 );
		float v=sqrt(game.shots[i].dx * game.shots[i].dx + 
			     game.shots[i].dy * game.shots[i].dy);
		printf("Sht: %d x=%d, y=%d; dx=%d, dy=%d v=%f\n", i, game.shots[i].x, game.shots[i].y, game.shots[i].dx, game.shots[i].dy, v);
	    }
	    printf("Shp: x=%d, y=%d, dx=%d, dy=%d \n",game.ship_x, game.ship_y, game.ship_dx, game.ship_dy);
	    for (int i=0; i<game.nasteroids; ++i)
	    {   
		int vx;
		int vy;
		// berechne schuss geschwindigkeit
		vx = game.old_asteroids[i].x - game.asteroids[i].x;
		vy = game.old_asteroids[i].y - game.asteroids[i].y;
		if (vx*vx + vy*vy < 200000)
		    game.asteroids[i].set_d( vx, vy );
		else
		    game.asteroids[i].set_d( 0, 0 );


		// nchstgelegenen Asteroiden suchen
		int dx = game.asteroids[i].x - game.ship_x;
		while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
		while (dx > 511) dx -= 1024;
		int dy = game.asteroids[i].y - game.ship_y;
		while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
		while (dy > 383) dy -= 768;
		int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden

		// calc frames until hit
		game.asteroids[i].frames_to_hit = sqrt(dist/64);

		// calc position to aim
		game.asteroids[i].x_aim = game.asteroids[i].x - game.asteroids[i].dx * game.asteroids[i].frames_to_hit;
		game.asteroids[i].y_aim = game.asteroids[i].y - game.asteroids[i].dy * game.asteroids[i].frames_to_hit;

		// calc closes position 
		int closest_dist ;
		if ((((game.asteroids[i].dx)^2 + (game.asteroids[i].dy)^2)) != 0) {
		    closest_dist =  sqrt(((game.ship_x-game.asteroids[i].x) * game.asteroids[i].dy 
				     - (game.ship_y-game.asteroids[i].y) * game.asteroids[i].dx)^2 / 
					 ((game.asteroids[i].dx)^2 + (game.asteroids[i].dy)^2));
		}
		int dist_until_closest = sqrt(dist - closest_dist^2);
		int vel_asteroid       = sqrt(game.asteroids[i].dx^2 + game.asteroids[i].dy^2);
		if (vel_asteroid != 0)
		    game.asteroids[i].set_course( closest_dist, dist_until_closest/vel_asteroid);
		
		switch (game.asteroids[i].sf)
		{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
		    case 0:  // groer Asteroid
			dist -= 40*40;
			break;
		    case 15: // mittlerer Asteroid
			dist -= 20*20;
			break;
		    case 14: // kleiner Asteroid
			dist -= 8*8;
			break;
		}
		printf("Ast: %d, x=%d, y=%d, dx=%d, dy=%d, dist=%1.2f frames2hit=%d aimx=%d, aimy=%d dist_c=%d fr_cl=%d\n",i,game.asteroids[i].x, game.asteroids[i].y, 
		       game.asteroids[i].dx, game.asteroids[i].dy, sqrt(dist),  game.asteroids[i].frames_to_hit,
		       game.asteroids[i].x_aim, game.asteroids[i].y_aim, 
		       game.asteroids[i].dist_closest, game.asteroids[i].frames_closest);  
		if (dist < min_dist)
		{
		    min_dist = dist;
		    min_dx = game.asteroids[i].x_aim - game.ship_x;//dx; 
		    min_dy = game.asteroids[i].y_aim - game.ship_y;//dy;
		}
	    }
	    if (game.saucer_present)
	    {
		int dx = game.saucer_x - game.ship_x;
		printf("Ufo: x=%d, y=%d \n",game.saucer_x, game.saucer_y);  
		while (dx < -512) dx += 1024;
		while (dx > 511) dx -= 1024;
		int dy = game.saucer_y - game.ship_y;
		while (dy < -384) dy += 768;
		while (dy > 383) dy -= 768;
		int dist = dx*dx+dy*dy;

		
		
		switch (game.saucer_size)
		{	// Abstand um den ungefhren Radius des UFOs korrigieren
		    case 15: // groes UFO
			dist -= 20*12;
			break;
		    case 14: // kleines UFO
			dist -= 10*6;
			break;
		}
		if (dist < min_dist)
		{
		    min_dist = dist;
		    min_dx = dx;
		    min_dy = dy;
		}
	    }
	    
	    // Schiff in Richtung auf das nchstgelegene Objekt drehen
	    // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
	    // ship_dx/y/0 und min_dx/y/0 berechnet
	    //printf("ship_dx: %d ship_dy: %d\n",game.ship_dx, game.ship_dy); 
	    if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
		keys.left(true);
	    else
		keys.right(true);
	    
	    if (min_dist < 27*27)  // Flucht, wenn Kollision unausweichlich
		keys.hyperspace(true);

	 //   if (min_dist > 400*400 && (game.nasteroids > 0 || game.saucer_present )) // beschleunigen, wenn nichts in der Nhe
	//	keys.thrust(true);
	    
	    if ((t % 2 == 0) && (game.nasteroids > 0 || game.saucer_present ))  // Feuerknopf drcken, so schnell es geht
		keys.fire(true);
	    
	    //aktuelle shusspositionen speichern
	    for (int i=0; i<game.nshots; i++) 
	    {
		game.old_shots[i].set( game.shots[i].x, game.shots[i].y );
//				printf("Sht: %d x=%d, y=%d\n", i, game.shots[i].x, game.shots[i].y);
	    }
	    //aktuelle asteroidenposition speichern
	    for (int i=0; i<game.nasteroids; ++i)
	    {   // nchstgelegenen Asteroiden suchen
				int x = game.asteroids[i].x;
				int y = game.asteroids[i].y;
				game.old_asteroids[i].set( x, y, game.asteroids[i].type, game.asteroids[i].sf );
				
	    }
	    game.old_saucer.set( game.saucer.x, game.saucer.y );
	}
    }
}
    
void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
    unsigned short *vector_ram = (unsigned short *)packet.vectorram;
    int dx, dy, sf, vx, vy, vz, vs;
    int v1x = 0;
    int v1y = 0;
    int shipdetect = 0;
    
    game.clear();
    if ((unsigned char)packet.vectorram[1] != 0xe0 && (unsigned char)packet.vectorram[1] != 0xe2)
	return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
    
    int pc = 1;
    for (;;)
    {
	int op = vector_ram[pc] >> 12;
	switch (op)
	{
	    case 0xa: // LABS
		vy = vector_ram[pc] & 0x3ff;
		vx = vector_ram[pc+1] & 0x3ff;
		vs = vector_ram[pc+1] >> 12;
		break;
	    case 0xb: // HALT
		return;
	    case 0xc: // JSRL
		switch (vector_ram[pc] & 0xfff)
		{
		    case 0x8f3:
			game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
			break;
		    case 0x8ff:
			game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
			break;
		    case 0x90d:
			game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
			break;
		    case 0x91a:
			game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
			break;
		    case 0x929:
			game.saucer_present = true;
			game.saucer.set( vx, vy );
//			game.saucer_x = vx;
//			game.saucer_y = vy;
			game.saucer_size = vs;
			break;
		}  
		break;
	    case 0xd: // RTSL
		return;
	    case 0xe: // JMPL
		/*
		  pc = vector_ram[pc] & 0xfff;
		      break;
		    */
		return;
	    case 0xf: // SVEC
		/*
		  dy = vector_ram[pc] & 0x300;
		  if ((vector_ram[pc] & 0x400) != 0)
		  dy = -dy;
		  dx = (vector_ram[pc] & 3) << 8;
		  if ((vector_ram[pc] & 4) != 0)
		  dx = -dx;
		  sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
		  vz = (vector_ram[pc] & 0xf0) >> 4;
		*/
		break;
	    default:
		dy = vector_ram[pc] & 0x3ff;
		if ((vector_ram[pc] & 0x400) != 0)
		    dy = -dy;
		dx = vector_ram[pc+1] & 0x3ff;
		if ((vector_ram[pc+1] & 0x400) != 0)
		    dx = -dx;
		sf = op;
		vz = vector_ram[pc+1] >> 12;
		if (dx == 0 && dy == 0 && vz == 15)
		    game.shots[game.nshots++].set(vx, vy);
		if (op == 6 && vz == 12 && dx != 0 && dy != 0)
		{
		    switch (shipdetect)
		    {
			case 0:
			    v1x = dx;
			    v1y = dy;
			    ++shipdetect;
			    break;
			case 1:
			    game.ship_present = true;
			    game.ship_x = vx;
			    game.ship_y = vy;
			    game.ship_dx = v1x - dx;
			    game.ship_dy = v1y - dy;
			    ++shipdetect;
			    break;
		    }
		}
		else if (shipdetect == 1)
		    shipdetect = 0;
		
		break;
	}
	if (op <= 0xa)
	    ++pc;
	if (op != 0xe) // JMPL
	    ++pc;
    }   
    
}
    

void Asteroid::set(int x, int y, int type, int sf)
{
    this->x = x;
    this->y = y;
    this->type = type;
    this->sf = sf;
}
void Asteroid::set_d(int dx, int dy)
{
    this->dx = dx;
    this->dy = dy;
}

void Asteroid::set_course( int dist_closest, int frames_closest)
{
    this->dist_closest   = dist_closest;
    this->frames_closest = frames_closest;
}

void Saucer::set(int x, int y)
{
    this->x = x;
    this->y = y;
}
void Saucer::set_d(int dx, int dy)
{
    this->dx = dx;
    this->dy = dy;
}

void Shot::set(int x, int y)
{
    this->x = x;
    this->y = y;
}

void Shot::set_d(int dx, int dy)
{
    this->dx = dx;
    this->dy = dy;
}
/*
  void Old_Shot::set(int x, int y)
  {
  this->x = x;
  this->y = y;
  }
*/
void GameStatus::clear(void)
{
    ship_present = false;
    saucer_present = false;
    nasteroids = 0;
    nshots = 0;
}

KeysPacket::KeysPacket(void)
{
    signature[0] = 'c';
    signature[1] = 't';
    signature[2] = 'm';
    signature[3] = 'a';
    signature[4] = 'm';
    signature[5] = 'e';
    keys = '@';
    ping = 0;
}

void KeysPacket::clear(void)
{
    keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
    if (b)
	keys |= KEY_HYPERSPACE;
    else
	keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
    if (b)
	keys |= KEY_FIRE;
    else
	keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
    if (b)
	keys |= KEY_THRUST;
    else
	keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
    if (b)
    {
	keys |= KEY_LEFT;
	right(false);
    }
    else
	keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
    if (b)
    {
	keys |= KEY_RIGHT;
	left(false);
    }
    else
	keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
    sockaddr_in sender;
    int sender_size = sizeof sender;
    fd_set readfds, writefds, exceptfds;
    
    do
    {
	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
	FD_SET(sd, &readfds);
	FD_SET(sd, &exceptfds);
	select(sd+1, &readfds, &writefds, &exceptfds, NULL);
	int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
	if (bytes_received != sizeof packet)
	{
	    int err = WSAGetLastError();
	    fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
	    exit(1);
	}
	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
	FD_SET(sd, &readfds);
	timeval zero;
	zero.tv_sec = zero.tv_usec = 0;
	select(sd+1, &readfds, &writefds, &exceptfds, &zero);
    } while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
    sockaddr_in server;
    memset(&server, 0, sizeof server);
    server.sin_family = AF_INET;
    server.sin_port = htons(1979);
    server.sin_addr.s_addr = server_ip;
    if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
    {
#if defined(WINDOWS)
	int err = WSAGetLastError();
	if (err != WSAEWOULDBLOCK)
	{
	    fprintf(stderr, "Fehler %d bei sendto().\n", err);
	    exit(1);
	}
#else
	if (errno != EAGAIN)
	{
	    perror("Fehler bei sendto()");
	    exit(1);
	}
#endif
    }
}
