// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"
#include "pilot.h"
#include "ODAD.h"
#include "log.h"
#include <conio.h>


ODAD radar;
ship Spirit_of_St_Louis;
bool debug_bool;

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus game;
	char prevframe = 0;
	int test=0;
	int t = 0;

	pilot Lindberg(keys,radar,Spirit_of_St_Louis,game);

	log_init("debug\\asteroids");
	
#ifndef __FINAL__
	init_targeter();
#endif //__FINAL__

	debug_bool=true;
	while (debug_bool)
	{
		++t;         // Zeit
//		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);

		if((0 != _kbhit()) && ('x' == (test=_getch())))
		{
			break;
		}
		else
		{
			// DO NOTHING HERE
		}

		

		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			//printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
		}

		char buffer[256];
		bool game_running = false;
		static int prev_asteroid_count = 0;
		asteroid_list* p_asteroids = &(radar.asteroids);

		InterpretScreen(frame, game);
		radar.validate_saucer(game.saucer_present);
		if (game.ship_present eq true)
		{	
			game_running = true;
			Spirit_of_St_Louis.is_present = true;
			Spirit_of_St_Louis.update(game.ship_x,game.ship_y,game.ship_dx,game.ship_dy);
		}
		else
		{
			Spirit_of_St_Louis.erase();
		}
#if _DEBUG
		//if(p_asteroids->n_totalAsteroids != prev_asteroid_count)
		{
			prev_asteroid_count = p_asteroids->n_totalAsteroids;
			for(int i = 0; i < p_asteroids->n_totalAsteroids; i++)
			{
				_snprintf(buffer, sizeof(buffer),"%02x\tx: %d  y: %d  type: %d  size: %d", i, p_asteroids->asteroids[i].x, p_asteroids->asteroids[i].y, p_asteroids->asteroids[i].type,p_asteroids->asteroids[i].sf);
				log_type_text("asteroid",buffer);
			}
			log_newline();
			log_newline();
		}
		/*      else
		{
		//DO NOTHING HERE
		}
		*/
#endif
		if(true == game_running)
		{
			radar.update();
		}
		else
		{
			// DO NOTHING HERE
		}

		Lindberg.set_ping(frame.ping);
		Lindberg.set (frame.frameno);
		Lindberg.set_new_course ();
		keys.ping = Lindberg.get_ping();

	}//while (run_loop)

	log_exit();
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512] = {0};
	int dx = 0,
		dy = 0,
		sf = 0, 
		vx = 0, 
		vy = 0, 
		Luminance = 0, 
		vec_GSF = 0;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;
	asteroid_list* p_asteroids = NULL;

	game.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
	{
		vector_ram[i] = 
			(unsigned char)packet.vectorram[2*i] | 
			(unsigned char)packet.vectorram[2*i+1] << 8;
	}

	if ((vector_ram[0] != 0xe001) && (vector_ram[0] != 0xe201))
	{
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL
	}

	p_asteroids = radar.get_asteroid_buffer();

	//switch to determine whether a saucer is in the game
	game.saucer_present = false;

	int pc = 1; //pc auf "1" statt "0", da "0" in der Zeile drber schon bewertet wurde
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vec_GSF = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx, vy, 1, vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_livingAsteroids++;

				game.asteroids[game.n_totalAsteroids].set(vx, vy, 1, vec_GSF);
				game.n_totalAsteroids++;
				break;
			case 0x8ff:
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx, vy, 2, vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_livingAsteroids++;

				game.asteroids[game.n_totalAsteroids].set(vx, vy, 2, vec_GSF);
				game.n_totalAsteroids++;
				break;
			case 0x90d:
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx, vy, 3, vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_livingAsteroids++;

				game.asteroids[game.n_totalAsteroids].set(vx, vy, 3, vec_GSF);
				game.n_totalAsteroids++;
				break;
			case 0x91a:
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx, vy, 4, vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_livingAsteroids++;

				game.asteroids[game.n_totalAsteroids].set(vx, vy, 4, vec_GSF);
				game.n_totalAsteroids++;
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer.x = vx;
				game.saucer.y = vy;
				game.saucer.size = vec_GSF;
				radar.update_saucer(vx, vy, vec_GSF);
				break;
			case 0x880:  //Explosion gro (3)
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx,vy,5,vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_explodedAsteroids++;
				break;
			case 0x896:  //Explosion (2)
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx,vy,5,vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_explodedAsteroids++;
				break;
			case 0x8B5:  //Explosion (1)
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx,vy,5,vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_explodedAsteroids++;
				break;
			case 0x8D0:  //Explosion klein (0)

				//TODO you have to ignore ship explosion here!
				//or you destroy an asteroid, that still exists
				p_asteroids->asteroids[p_asteroids->n_totalAsteroids].set(vx,vy,5,vec_GSF);
				p_asteroids->n_totalAsteroids++;
				p_asteroids->n_explodedAsteroids++;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
			dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
			dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			Luminance = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
			{
				dy = -dy;
			}

			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
			{
				dx = -dx;
			}

			sf = op;
			Luminance = vector_ram[pc+1] >> 12;

			if ((dx == 0) && (dy == 0) && (Luminance == 15))
			{
				game.shots[game.nshots].set(vx, vy);
				game.nshots++;
				//            printf("%d %d  %d %d\n",vx,vy,Luminance,sf);
			}

			//warum op=6 auf das Schiff hinweist, wissen wir noch nicht
			if ((op == 6) && (Luminance == 12) && (dx != 0) && (dy != 0))
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect; //shipdetect->2
					break;
				default:
					//do nothing
					break;
				}
			}
			else 
			{
				if (shipdetect == 1)
				{
					shipdetect = 0;
				}
			}
			break;
		}//switch (op)

		if (op <= 0xa)
		{
			++pc;
		}

		if (op != 0xe) // JMPL
		{
			++pc;
		}

	}//while (pc<512)   
}

void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	n_totalAsteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}

