;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: weltraumputze -*-

(in-package :weltraumputze)

(defclass mame-socket ()
  ((socket-descriptor :accessor socket-descriptor)))

(defgeneric send-command (s command command-no))
(defgeneric receive-vrams (s))
(defgeneric hang-up (s))

(defmethod initialize-instance :after ((s mame-socket) &key host port)
  (if (and host port)
      (progn (setf (socket-descriptor s)
                   (make-instance 'inet-socket :type :datagram :protocol :udp))
             (socket-connect (socket-descriptor s) host port)
             (setf (non-blocking-mode (socket-descriptor s)) t))
      (error "No host and/or port were given for socket initialization.")))


(defmethod send-command ((s mame-socket) command command-no)
  (socket-send
   (socket-descriptor s)
   (make-array '(8) :element-type '(unsigned-byte 8)
               :initial-contents (list 99 116 109 97 109 101 ; "ctmame"
                                       command command-no))
   nil))

;; Returns all vector ram packets that could be read
;; from the udp socket specified. Returns at least
;; one packet. Packets are sorted by ascending packet
;; numbers.
(defmethod receive-vrams ((s mame-socket))
  (labels ((get-counter (a)
             (aref a 1024))
           (compare-after-overflow (x y)
             (< (if (< x 91) (+ x 256) x) (if (< y 91) (+ y 256) y)))
           (sort-vrams (vrams)
             (sort vrams
                   (if (> (apply #'max (mapcar #'get-counter vrams)) 144)
                       #'compare-after-overflow
                       #'<)
                   :key #'get-counter)))
    (do* ((vram) (vrams nil (if vram (push vram vrams) vrams)))
         ((and (not vram) vrams) (sort-vrams vrams))
      (setf vram
            (socket-receive
             (socket-descriptor s)
             (make-array 1026 :element-type '(unsigned-byte 8))
             nil)))))

(let ((received-vrams (make-array 10))
      (initialized nil)
      (counter 0))
(defun receive-vrams-slowed (s)
  (when (not initialized)
    (dotimes (n (length received-vrams))
      (setf (svref received-vrams n) (receive-vrams s))
      (setf initialized t)))
  (let ((vram-to-return (svref received-vrams counter)))
    (setf (svref received-vrams counter) (receive-vrams s))
    (setf counter (mod (1+ counter) (length received-vrams)))
    vram-to-return)))

(defmethod hang-up ((s mame-socket))
  (socket-close (socket-descriptor s)))
