package asteroid.strategy.measure;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Magazine;
import asteroid.model.Shot;
import asteroid.model.TargetInfo;

public class CanShot extends AMeasure {
	private Magazine mMag;

	public CanShot( Magazine mag) {
		mMag = mag;
	}

	protected void measure( AEnemy enemy) {
		if (enemy.canFire() && (mMag.getShots() < Shot.MAX_SHIP_SHOTS)) {
			TargetInfo info = enemy.getInfo();
			if (info.getRot() == 0) {
				enemy.mWeight -= 100;
			}
		}
	}

	protected void print( AEnemy enemy, PrintWriterFormat out) {
		TargetInfo info = enemy.getInfo();
		if (enemy.canFire() && (mMag.getShots() < Shot.MAX_SHIP_SHOTS) && (info.getRot() == 0)) {
			out.print( "can");
		}
		else {
			out.print( '-');
		}
		out.fill( 10);
	}
}
