package asteroid.printer;

import java.io.PrintStream;

import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Shot;

public class Shots extends APrinter {
	private RememberModel mLast = new RememberModel();
	private GameModel mModel;

	public Shots( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public Shots( GameModel model, String file) {
		super( file);
		mModel = model;
	}

	public void forShot( Shot shot) {
		Remember rem = mLast.mShots[shot.getIndex()];
		mOut.savePos();
		mOut.print( shot.getIndex());
		mOut.print( ':');
		if (shot.isVisible()) {
			if (rem.mActive) {
//				double betha = Math.round( 100.0 * shot.getBetha()) / 100.0;
				mOut.print( Angle.getAngle( shot.getBetha()));
				mOut.print( ',');
//				mPrint.print( Operation.signX8( rem.mX - shot.getX8()));
				mOut.print( shot.getMoveX8());
				mOut.print( ',');
//				mPrint.print( Operation.signY8( rem.mY - shot.getY8()));
				mOut.print( shot.getMoveY8());
			}
			else {
				mOut.print( mModel.getFireDirection());
			}
		}
		mOut.fill( 18);
	}

	public void print() {
		if (mModel.getShip().isVisible()) {
			mModel.forAllShots( this);
			mModel.forAllShots( mLast);
			mOut.println();
		}
	}
}
