package asteroid.printer;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ufo;

public class Analyse extends APrinter {
	private HashMap mMap = new HashMap();
	private GameModel mModel;

	public Analyse( GameModel model, PrintStream ps) {
		super( ps);
		mModel = model;
	}

	public void forAsteroid( Asteroid ast) {
		if (ast.isVisible()) {
			forFlyable( ast);
		}
	}

	private void forFlyable( AFlyable fly) {
		if (fly.getModify() > 8) {
			int key = (fly.getMoveX8() << 8) + fly.getMoveY8();
			mMap.put( new Integer( key), fly.toString());
		}
	}

	public void forUfo( Ufo ufo) {
		if (ufo.isVisible()) {
			forFlyable( ufo);
		}
	}

	public void print() {
		if (mModel.getShip().isVisible()) {
			mModel.forAllAsteroids( this);
			mModel.forUfo( this);
			for (Iterator i = mMap.keySet().iterator(); i.hasNext();) {
				Object key = i.next();
				String fly = (String) mMap.get( key);
				mOut.println( fly);
			}
			mOut.println();
		}
	}
}
