package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;

public class Ufo extends AEnemy {
	public static final int UFO_ID = AsteroidVector.MAX_ASTEROIDS;
	public static final int MAX_FIRE = 1;
	private boolean mMissing;
	private Ship mShip;

	Ufo( Ship ship) {
		mShip = ship;
	}

	void addUfo( int x, int y, int z) {
		x <<= 3;
		y <<= 3;
		switch (mState) {
			case STATE_HIDDEN:
				mCreate = 1;
				initFire();
				initStep( 0, 0);
				break;
			case STATE_VISIBLE:
				addStep8( x, y);
				break;
			default:
				SimpleLogging.addLog( "illegal Ufo state");
		}
		setPos8( x, y, z);
		mType = Operation.UFO;
		mState = STATE_VISIBLE;
		mMissing = false;
	}

	void detect() {
		switch (mState) {
			case STATE_VISIBLE:
				if (mMissing) {
					mState = STATE_HIDDEN;
				}
				else {
					init( mShip);
				}
			case STATE_HIDDEN:
			case STATE_EXPLOSION:
				break;
			default:
				mType = Operation.UFO;
				SimpleLogging.addLog( "illegal Ufo state");
		}
	}

	int detExplosion( FlyDetect exp) {
		int res = 0;
		switch (mState) {
			case STATE_HIDDEN:
				break;
			case STATE_VISIBLE:
				if ((exp != null) && exp.mExplosion && (mX8 == exp.mX8) && (mY8 == exp.mY8)) {
					mState = STATE_EXPLOSION;
					mVanish = 1;
					mType = exp.mType;
					res = 1;
				}
				break;
			case STATE_EXPLOSION:
				if ((exp != null) && exp.mExplosion && (mX8 == exp.mX8) && (mY8 == exp.mY8)) {
					mType = exp.mType;
					res = 1;
				}
				else {
					mState = STATE_HIDDEN;
					mType = Operation.UFO;
				}
				mVanish = 0;
				break;
			default:
				mState = STATE_HIDDEN;
				mType = Operation.UFO;
				mVanish = 0;
				SimpleLogging.addLog( "illegal Ufo state");
		}
		return res;
	}

	void doIt( ICompute comp) {
		comp.forUfo( this);
	}

	public boolean isFired() {
		return mFire < MAX_FIRE;
	}

	public int getID() {
		return UFO_ID;
	}

	public String getIdent() {
		return "U";
	}

	public void initFire() {
		mFire = MAX_FIRE;
	}

	void prepare() {
		mMissing = true;
		mVanish = 0;
	}

	public int getScore() {
		switch (mZ) {
			case 15: // grosses UFO
				return 200;
			case 14: // kleines UFO
				return 1000;
		}
		return 0;
	}

	public int size() {
		switch (mZ) {
			case 15: // grosses UFO
				return 96;
			case 14: // kleines UFO
				return 64;
		}
		return 0;
	}

	public int sizeX() {
		switch (mZ) {
			case 15: // grosses UFO
				return 160;
			case 14: // kleines UFO
				return 80;
		}
		return 0;
	}

	public int sizeY() {
		switch (mZ) {
			case 15: // grosses UFO
				return 96;
			case 14: // kleines UFO
				return 64;
		}
		return 0;
	}
}
