package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;

public class Ship extends AFlyable {
	private int mDetectShip, mDetectExplosion;
	private int mDx, mDy;
	private int mVx, mVy;

	Ship() {
		mState = STATE_HIDDEN;
	}

	Ship( int x8, int y8, int z, int moveX8, int moveY8) {
		super( x8, y8, z, moveX8, moveY8);
		mState = STATE_VISIBLE;
	}

	void addExplosion( int x, int y) {
		initStep( 0, 0);
		setPos8( x << 3, y << 3, Operation.SHIP_HELL);
		++mDetectExplosion;
	}

	void addShip( int x, int y, int dx, int dy) {
		switch (mDetectShip) {
			case 0:
				mVx = dx;
				mVy = dy;
				++mDetectShip;
				break;
			case 1:
				x <<= 3;
				y <<= 3;
				switch (mState) {
					case STATE_JUMP:
					case STATE_HIDDEN:
						mCreate = 1;
						initStep( 0, 0);
						break;
					case STATE_VISIBLE:
						addStep8( x, y);
						break;
					default:
						SimpleLogging.addLog( "illegal Ship state");
				}
				setPos8( x, y, Operation.SHIP_HELL);
				mState = STATE_VISIBLE;
				mDx = mVx - dx;
				mDy = mVy - dy;
				++mDetectShip;
				break;
		}
	}

	void detect() {
		if (mDetectShip < 2) {
			mVanish = (mState == STATE_VISIBLE) ? 1 : 0;
			if (mDetectExplosion > 0) {
				mState = STATE_EXPLOSION;
			}
			else {
				switch (mState) {
					case STATE_VISIBLE:
						mState = STATE_JUMP;
						break;
					case STATE_EXPLOSION:
						mState = STATE_HIDDEN;
						break;
				}
			}
		}
	}

	void doIt( ICompute comp) {
		comp.forShip( this);
	}

	public int getDx() {
		return mDx;
	}

	public int getDy() {
		return mDy;
	}

	public String getIdent() {
		return "S";
	}

	void prepare() {
		mVx = mVy = mDetectShip = mDetectExplosion = 0;
		mVanish = 0;
	}

	void reset() {
		if (mDetectShip == 1) {
			mDetectShip = 0;
		}
	}

	public int size() {
		return 80;
	}

	public int sizeX() {
		return size();
	}

	public int sizeY() {
		return size();
	}

	public int getType() {
		return Operation.SHIP;
	}
}
