package asteroid.model;

public class FlyInfo {
	int mMoveX8, mMoveY8;
	int mX8, mY8, mZ;

	public FlyInfo() {
	}

	public FlyInfo( int x8, int y8, int z, int moveX8, int moveY8) {
		mX8 = x8;
		mY8 = y8;
		mZ = z;
		mMoveX8 = moveX8;
		mMoveY8 = moveY8;
	}

	public final int getMoveX8() {
		return mMoveX8;
	}

	public final int getMoveY8() {
		return mMoveY8;
	}

	public final void set( FlyInfo info) {
		mX8 = info.mX8;
		mY8 = info.mY8;
		mZ = info.mZ;
		mMoveX8 = info.mMoveX8;
		mMoveY8 = info.mMoveY8;
	}

	public final void set( int x8, int y8, int z, int moveX8, int moveY8) {
		mX8 = x8;
		mY8 = y8;
		mZ = z;
		mMoveX8 = moveX8;
		mMoveY8 = moveY8;
	}

	public String toString() {
		return mX8 + "," + mY8 + "," + mZ + "," + mMoveX8 + "," + mMoveY8;
	}

	public final int getX8() {
		return mX8;
	}

	public final int getX8( int time) {
		return mX8 + (time * mMoveX8);
	}

	public final double getX8( double time) {
		return (double) mX8 + (time * mMoveX8);
	}

	public final int getY8() {
		return mY8;
	}

	public final int getY8( int time) {
		return mY8 + (time * mMoveY8);
	}

	public final double getY8( double time) {
		return (double) mY8 + (time * mMoveY8);
	}

	public final int getZ() {
		return mZ;
	}
}
