package asteroid;

import java.net.InetAddress;
import java.nio.ByteBuffer;

import asteroid.model.GameModel;
import asteroid.printer.APrinter;
import asteroid.printer.Shortly;
import asteroid.statistic.GameValues;
import asteroid.statistic.LevelValues;
import asteroid.strategy.AStrategie;
import asteroid.strategy.Priority;
import asteroid.udp.AHandler;
import asteroid.udp.FileHandler;
import asteroid.udp.NetHandler;
import asteroid.ui.MainFrame;

public class Player {
	private static final int TEST_LATENZ = 0;
	private static final int READ_WRITE = 0; // >0 read file; <0 write file, read udp; == 0 read upd
	public static final boolean DEBUG = true;
	public static final String HOME;
	public static final String PROTOCOL;
	public static final String POSITION;
	public static final int HOST_LOCAL = 0;
	public static final int HOST_GAME = 1;
	public static final int HOST_HEISE = 2;
	public static int sHost = 0; // 0 localhost, 1 game, 2 heise.de

	static {
		String os = System.getProperty( "os.name");
		if (os.regionMatches( true, 0, "win32", 0, 3)) {
			HOME = "D:\\Tools\\ct\\output\\";
		}
		else {
			HOME = System.getProperty( "user.home") + "/tar/ct/save/";
		}
		PROTOCOL = HOME + "self-2008-06-30-15-14-21";
		POSITION = HOME + "position.txt";
	}

	private MainFrame mFrame;
	private AStrategie mGenetic;
	private LevelValues mLevel = new LevelValues();
	private GameModel mModel;
	private APrinter mPrint;
	private AHandler mSrc;
	private AStrategie mStrategy;
	private GameValues mValues = new GameValues();

	private Player( AHandler src) {
		mSrc = src;
		mModel = new GameModel( src);
//		mPrint = new Printer( mModel, POSITION);
//		mPrint = new Analyse( mModel, System.out);
//		mPrint = new Direction( mModel, System.out);
//		mPrint = new Shots( mModel, System.out);
//		mPrint = new Collision( mModel, System.out);
//		mPrint = new AnalyseHit1( mModel, System.out);
//		mPrint = new Direction( mModel, System.out);
//		mPrint = new Position( mModel, POSITION);
		mPrint = new Shortly( mModel, POSITION);
//
//		mStrategy = new DistanceDemo( mModel);
//		mStrategy = new FollowTheFirst( mModel);
//		mStrategy = new Charge( mModel);
//		mStrategy = new ChargeSingle( mModel);
//		mStrategy = new Rotate( mModel);
		mStrategy = new Priority( mModel);
//
//		mGenetic = new Permutation( mModel);
	}

	private void createFrame() {
		mFrame = new MainFrame( mModel, mValues);
		mFrame.pack();
		mFrame.setVisible( true);
	}

	public static void main( String[] args) {
		String host;
		if (args.length > 0) {
			host = args[0];
		}
		else {
			System.out.println( "Aufruf: asteroid <IP-Adresse>");
			switch (sHost) {
				case HOST_LOCAL:
				default:
					host = "127.0.0.1";
					break;
				case HOST_GAME:
					host = "192.168.0.152";
					break;
				case HOST_HEISE:
					host = "asteroids.heise.de";
					break;
			}
		}
		AHandler src = null;
		try {
			InetAddress addr = InetAddress.getByName( host);
			if (READ_WRITE > 0) {
				src = new FileHandler( PROTOCOL, TEST_LATENZ);
			}
			else {
				src = new NetHandler( addr, TEST_LATENZ);
			}
			if (READ_WRITE < 0) {
				src.createOutput( HOME + Operation.createFileName( "self"), addr); // "asteroids"
			}
			Player player = new Player( src);
			player.createFrame();
			player.play();
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
		finally {
			if (src != null) {
				src.close();
			}
		}
	}

	private void play() {
		switch (sHost) {
			case HOST_LOCAL:
			case HOST_GAME:
				mModel.setRepeat( false);
				mModel.setTopList( false);
				break;
			case HOST_HEISE:
				mModel.setRepeat( true);
				mModel.setTopList( true);
				break;
		}
		mSrc.start();
		mValues.reset();
		mModel.addKey( 0);
		if (mStrategy != null) {
			runStrategy( mStrategy);
		}
		else {
			runGenetic( mGenetic);
		}
	}

	private void printData() {
		if (mPrint != null) {
			mPrint.print();
		}
	}

	private void runGenetic( AStrategie strategy) {
		while (mSrc.isAlive()) {
			ByteBuffer data = mSrc.getNext( !mModel.isPlayTime());
			if (data != null) {
				updateData( data);
				strategy.cleanup();
				printData();
				mModel.updateKey( strategy);
				updateKey();
			}
			if (mModel.isPlayTime()) {
				strategy.refresh();
			}
		}
	}

	private void runStrategy( AStrategie strategy) {
		while (mSrc.isAlive()) {
			ByteBuffer data = mSrc.getNext( true);
			while (data != null) {
				updateData( data);
				strategy.cleanup();
				printData();
				data = mSrc.getNext( false);
			}
			if (mModel.isPlayTime()) {
				strategy.refresh();
			}
			mModel.updateKey( strategy);
			updateKey();
		}
	}

	private void updateData( ByteBuffer data) {
		mValues.init();
		mModel.interpret( data);
		mLevel.update( mModel);
	}

	private void updateKey() {
		mValues.update( mModel);
		if (mFrame != null) {
			mFrame.refresh();
		}
	}
}
