package asteroid;

import java.nio.ByteBuffer;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Operation {
	public static final int SIZE_X = 1024;
	public static final int SIZE_Y = 768;
	public static final int WIDTH = SIZE_X << 3; // 8192
	public static final int HEIGHT = SIZE_Y << 3; // 6144
	public static final int WIDTH_05 = SIZE_X << 2; // 4096
	public static final int HEIGHT_05 = SIZE_Y << 2; // 3072
	public static final int WIDTH_25 = SIZE_X << 1; // 2048
	public static final int HEIGHT_25 = SIZE_Y << 1; // 1536
	public static final int WIDTH_1 = SIZE_X * 5; // 5120
	public static final int HEIGHT_1 = SIZE_Y * 5; // 3840
	public static final int SOURCER_BIG = 15;
	public static final int SOURCER_SMALL = 14;
	public static final int SHIP_HELL = 12;
	public static final int VCTR_SHIP = 6;
	public static final int VCTR_SHIP_EXPLOSION = 3;
	public static final int LABS = 0xA;
	public static final int HALT = 0xB;
	public static final int JSRL = 0xC;
	public static final int RTSL = 0xD;
	public static final int JMPL = 0xE;
	public static final int SVEC = 0xF;
	public static final int EXPLOSION_3 = 0x880;
	public static final int EXPLOSION_2 = 0x896;
	public static final int EXPLOSION_1 = 0x8B5;
	public static final int EXPLOSION_0 = 0x8D0;
	public static final int ASTEROID_1 = 0x8F3;
	public static final int ASTEROID_2 = 0x8FF;
	public static final int ASTEROID_3 = 0x90D;
	public static final int ASTEROID_4 = 0x91A;
	public static final int UFO = 0x929;
	public static final int SHIP = 0xA6D;
	public static final int SHOT = 0xFFF;
	public static final int CHAR_A = 0xA78;
	public static final int CHAR_B = 0xA80;
	public static final int CHAR_C = 0xA8D;
	public static final int CHAR_D = 0xA93;
	public static final int CHAR_E = 0xA9B;
	public static final int CHAR_F = 0xAA3;
	public static final int CHAR_G = 0xAAA;
	public static final int CHAR_H = 0xAB3;
	public static final int CHAR_I = 0xABA;
	public static final int CHAR_J = 0xAC1;
	public static final int CHAR_K = 0xAC7;
	public static final int CHAR_L = 0xACD;
	public static final int CHAR_M = 0xAD2;
	public static final int CHAR_N = 0xAD8;
	public static final int CHAR_O_0 = 0xADD;
	public static final int CHAR_P = 0xAE3;
	public static final int CHAR_Q = 0xAEA;
	public static final int CHAR_R = 0xAF3;
	public static final int CHAR_S = 0xAFB;
	public static final int CHAR_T = 0xB02;
	public static final int CHAR_U = 0xB08;
	public static final int CHAR_V = 0xB0E;
	public static final int CHAR_W = 0xB13;
	public static final int CHAR_X = 0xB1A;
	public static final int CHAR_Y = 0xB1F;
	public static final int CHAR_Z = 0xB26;
	public static final int CHAR_SPACE = 0xB2C;
	public static final int CHAR_1 = 0xB2E;
	public static final int CHAR_2 = 0xB32;
	public static final int CHAR_3 = 0xB3A;
	public static final int CHAR_4 = 0xB41;
	public static final int CHAR_5 = 0xB48;
	public static final int CHAR_6 = 0xB4F;
	public static final int CHAR_7 = 0xB56;
	public static final int CHAR_8 = 0xB5B;
	public static final int CHAR_9 = 0xB63;
	public static final int[] ADDRESS = {
			0x852, EXPLOSION_3, EXPLOSION_2, EXPLOSION_1,
			EXPLOSION_0, ASTEROID_1, ASTEROID_2, ASTEROID_3,
			ASTEROID_4, UFO, SHIP, CHAR_A, CHAR_B, CHAR_C, CHAR_D, CHAR_E,
			CHAR_F, CHAR_G, CHAR_H, CHAR_I, CHAR_J, CHAR_K, CHAR_L, CHAR_M,
			CHAR_N, CHAR_O_0, CHAR_P, CHAR_Q, CHAR_R, CHAR_S, CHAR_T, CHAR_U,
			CHAR_V, CHAR_W, CHAR_X, CHAR_Y, CHAR_Z, CHAR_SPACE, CHAR_1, CHAR_2,
			CHAR_3, CHAR_4, CHAR_5, CHAR_6, CHAR_7, CHAR_8, CHAR_9
		};
	public static final String[] NAMES = {
			"COPYRIGHT", "EXPLOSION_3", "EXPLOSION_2", "EXPLOSION_1",
			"EXPLOSION_0", "ASTEROID_1 ", "ASTEROID_2 ", "ASTEROID_3 ",
			"ASTEROID_4 ", "UFO", "SHIFF", "A", "B", "C", "D", "E",
			"F", "G", "H", "I", "J", "K", "L", "M",
			"N", "0", "P", "Q", "R", "S", "T", "U",
			"V", "W", "X", "Y", "Z", "SPACE", "1", "2",
			"3", "4", "5", "6", "7", "8", "9"
		};
	private static final FieldPosition INSTANCE = new FieldPosition( 0);
	private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat( "-yyyy-MM-dd-HH-mm-ss");

	public static int antiSignX8( int val) {
		val = signX8( val);
		if (val >= 0) {
			return WIDTH_05 - val;
		}
		return -WIDTH_05 - val;
	}

	public static int antiSignY8( int val) {
		val = signY8( val);
		if (val >= 0) {
			return HEIGHT_05 - val;
		}
		return -HEIGHT_05 - val;
	}

	public static int getByte( byte[] data, int pos) {
		return data[pos] & 0xFF;
	}

	public static String createFileName( String marker) {
		StringBuffer sb = new StringBuffer( marker);
		DATE_FORMAT.format( new Date(), sb, INSTANCE);
		return sb.toString();
	}

	public static int distX8( int val) {
		return Math.abs( signX8( val));
	}

	public static int distY8( int val) {
		return Math.abs( signY8( val));
	}

	public static int normX8( int val) {
//		while (val > WIDTH) { // 1024 * 8
//			val -= WIDTH; // 1024 * 8
//		}
//		while (val < 0) {
//			val += WIDTH; // 1024 * 8
//		}
//		return val;
		return val & 0x1FFF;
	}

	public static int normY8( int val) {
		while (val >= HEIGHT) { // 768 * 8
			val -= HEIGHT; // 768 * 8
		}
		while (val < 0) {
			val += HEIGHT; // 768 * 8
		}
		return val;
	}

	public static int getSigned( int val) {
		if ((val & 0x400) == 0) {
			return val & 0x3FF;
		}
		return -(val & 0x3FF);
	}

	public static int signX8( int val) {
		while (val < -WIDTH_05) { // -512 * 8
			val += WIDTH; // 1024 * 8
		}
		while (val > WIDTH_05) { // 512 * 8
			val -= WIDTH; // 1024 * 8
		}
		return val;
//		return ((val + WIDTH_05) & 0x1FFF) - WIDTH_05;
	}

	public static double signX8( double val) {
		while (val < -WIDTH_05) { // -512 * 8
			val += WIDTH; // 1024 * 8
		}
		while (val > WIDTH_05) { // 512 * 8
			val -= WIDTH; // 1024 * 8
		}
		return val;
	}

	public static int signX8a( int val) {
		while (val < -WIDTH_1) {
			val += WIDTH;
		}
		while (val > WIDTH_1) {
			val -= WIDTH;
		}
		return val;
	}

	public static int signY8( int val) {
		while (val < -HEIGHT_05) { // -384 * 8
			val += HEIGHT; // 768 * 8
		}
		while (val > HEIGHT_05) { // 384 * 8
			val -= HEIGHT; // 768 * 8
		}
		return val;
	}

	public static double signY8( double val) {
		while (val < -HEIGHT_05) { // -384 * 8
			val += HEIGHT; // 768 * 8
		}
		while (val > HEIGHT_05) { // 384 * 8
			val -= HEIGHT; // 768 * 8
		}
		return val;
	}

	public static int signY8a( int val) {
		while (val < -HEIGHT_1) {
			val += HEIGHT;
		}
		while (val > HEIGHT_1) {
			val -= HEIGHT;
		}
		return val;
	}

	public static String getText( byte[] arr, int off, int end) {
		StringBuffer sb = new StringBuffer();
		for (int i = off; i < end; ++i) {
			byte c = arr[i];
			if ((c == 0) || (c == 0xd) || (c == 0xa)) {
				break;
			}
			sb.append( (char) c);
		}
		return sb.toString();
	}

	public static String getText( ByteBuffer bb, int off, int end) {
		StringBuffer sb = new StringBuffer();
		for (int i = off; i < end; ++i) {
			byte c = bb.get( i);
			if ((c == 0) || (c == 0xd) || (c == 0xa)) {
				break;
			}
			sb.append( (char) c);
		}
		return sb.toString();
	}

	public static int getWord( byte[] data, int pos) {
		return getByte( data, pos) + (getByte( data, pos + 1) << 8);
	}
}
