/*
 * Decompiled with CFR 0.152.
 */
package asteroid.ui;

import asteroid.model.AEnemy;
import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.FlyDetect;
import asteroid.model.GameModel;
import asteroid.model.ICompute;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JComponent;

class GameView
extends JComponent
implements ICompute {
    private static final long serialVersionUID = -6626855104081248163L;
    private static final int WIDTH = 640;
    private static final int HEIGHT = 480;
    private static final double SHIP_SIZE = 5.0;
    private static final Color TEXT_COLOR = Color.WHITE;
    protected GameModel mModel;
    private boolean mDirection = false;
    private int mFade;
    private Font mFontHigh = new Font("Monospace", 0, 18);
    private Font mFontObj = new Font("Monospace", 0, 9);
    private Graphics mGraph;
    private boolean mIdentifier = true;
    private boolean mShowScore;
    private boolean mVelocity = true;

    public GameView(GameModel gameModel) {
        this.mModel = gameModel;
        Dimension dimension = new Dimension(640, 480);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
    }

    private void drawArc(AFlyable aFlyable, int n) {
        this.mGraph.drawArc(GameView.getScreenX8(aFlyable.getX8()) - n, GameView.getScreenY8(aFlyable.getY8()) - n, n << 1, n << 1, 0, 360);
    }

    private void drawDirection(int n, int n2, int n3, int n4, double d) {
        if (this.mDirection) {
            this.mGraph.setColor(Color.GRAY);
            int n5 = n + n4 + n4;
            int n6 = n2 + n3 + n3;
            int n7 = n + (int)Math.round(640.0 * Math.cos(d));
            int n8 = n2 + (int)Math.round(-640.0 * Math.sin(d));
            this.mGraph.drawLine(n5, n6, n7, n8);
        }
    }

    void drawIdentifier(AFlyable aFlyable, int n) {
        if (this.mIdentifier) {
            this.mGraph.setColor(TEXT_COLOR);
            int n2 = GameView.getScreenX8(aFlyable.getX8());
            int n3 = GameView.getScreenY8(aFlyable.getY8());
            this.mGraph.drawString(aFlyable.getIdent(), n2 + n, n3 - n);
        }
    }

    void drawStringLeft(String string, int n, int n2, int n3, FontMetrics fontMetrics) {
        this.mGraph.drawString(string, n + n3 - fontMetrics.stringWidth(string), n2);
    }

    private void drawVelocity(AFlyable aFlyable) {
        if (this.mVelocity && (aFlyable.getMoveX8() != 0 || aFlyable.getMoveY8() != 0)) {
            this.mGraph.setColor(Color.GRAY);
            int n = GameView.getScreenX8(aFlyable.getX8());
            int n2 = GameView.getScreenY8(aFlyable.getY8());
            int n3 = GameView.getScreenX8(aFlyable.getX8() + (aFlyable.getMoveX8() << 3));
            int n4 = GameView.getScreenY8(aFlyable.getY8() + (aFlyable.getMoveY8() << 3));
            this.mGraph.drawLine(n, n2, n3, n4);
        }
    }

    public void forAsteroid(Asteroid asteroid) {
        if (asteroid.isVisible()) {
            this.mGraph.setColor(Color.MAGENTA);
            switch (asteroid.getZ()) {
                case 0: {
                    this.drawArc(asteroid, 20);
                    this.drawIdentifier(asteroid, 16);
                    break;
                }
                case 15: {
                    this.drawArc(asteroid, 10);
                    this.drawIdentifier(asteroid, 9);
                    break;
                }
                default: {
                    this.drawArc(asteroid, 5);
                    this.drawIdentifier(asteroid, 6);
                }
            }
            this.drawVelocity(asteroid);
        } else if (asteroid.isExplosion()) {
            this.forExplosion(asteroid);
        }
    }

    public void forAsteroid(FlyDetect flyDetect) {
    }

    void forExplosion(AEnemy aEnemy) {
        this.mGraph.setColor(Color.ORANGE);
        switch (aEnemy.getType()) {
            case 2256: {
                this.drawArc(aEnemy, 17);
                break;
            }
            case 2229: {
                this.drawArc(aEnemy, 13);
                break;
            }
            case 2198: {
                this.drawArc(aEnemy, 9);
                break;
            }
            case 2176: {
                this.drawArc(aEnemy, 5);
            }
        }
    }

    public void forShip(Ship ship) {
        if (this.mModel.getFrameType() == 4 || this.mModel.getFrameType() == 5) {
            double d = Angle.toRadiant(this.mModel.getFireDirection());
            int n = (int)Math.round(5.0 * Math.cos(d));
            int n2 = (int)Math.round(-5.0 * Math.sin(d));
            int n3 = GameView.getScreenX8(ship.getX8());
            int n4 = GameView.getScreenY8(ship.getY8());
            switch (ship.getState()) {
                default: {
                    this.mGraph.setColor(Color.YELLOW);
                    this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 - n + n2, n4 - n2 - n);
                    this.mGraph.drawLine(n3 - n + n2, n4 - n2 - n, n3 + n - (n2 >> 1), n4 + n2 + (n >> 1));
                    this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 + n + (n2 >> 1), n4 + n2 - (n >> 1));
                    break;
                }
                case 1: {
                    this.mFade = 255;
                    this.mGraph.setColor(new Color(255, 255, 255, this.mFade));
                    this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 - n + n2, n4 - n2 - n);
                    this.mGraph.drawLine(n3 - n + n2, n4 - n2 - n, n3 + n + n, n4 + n2 + n2);
                    this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 + n + n, n4 + n2 + n2);
                    this.drawVelocity(ship);
                    this.drawDirection(n3, n4, n2, n, d);
                    break;
                }
                case 4: {
                    this.mFade = this.mFade > 16 ? (this.mFade -= 16) : 0;
                    this.mGraph.setColor(new Color(255, 255, 255, this.mFade));
                    this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 - n + n2, n4 - n2 - n);
                    this.mGraph.drawLine(n3 - n + n2, n4 - n2 - n, n3 + n + n, n4 + n2 + n2);
                    this.mGraph.drawLine(n3 - n - n2, n4 - n2 + n, n3 + n + n, n4 + n2 + n2);
                    this.drawVelocity(ship);
                }
            }
        }
    }

    public void forShot(FlyDetect flyDetect) {
    }

    public void forShot(Shot shot) {
        if (shot.isVisible()) {
            this.mGraph.setColor(shot.isShip() ? Color.GREEN : Color.PINK);
            this.drawArc(shot, 2);
            this.drawIdentifier(shot, 3);
            this.drawVelocity(shot);
        }
    }

    public void forUfo(Ufo ufo) {
        if (ufo.isVisible()) {
            int n = 0;
            int n2 = 0;
            switch (ufo.getZ()) {
                case 15: {
                    n = 12;
                    n2 = 5;
                    break;
                }
                default: {
                    n = 6;
                    n2 = 3;
                }
            }
            this.mGraph.setColor(Color.RED);
            int n3 = GameView.getScreenX8(ufo.getX8());
            int n4 = GameView.getScreenY8(ufo.getY8());
            this.mGraph.drawLine(n3 - n + n2, n4 - n2, n3 + n - n2, n4 - n2);
            this.mGraph.drawLine(n3 - n, n4, n3 + n, n4);
            this.mGraph.drawLine(n3 - n + n2, n4 + n2, n3 + n - n2, n4 + n2);
            this.mGraph.drawLine(n3 - n, n4, n3 - n + n2, n4 + n2);
            this.mGraph.drawLine(n3 + n - n2, n4 + n2, n3 + n, n4);
            this.mGraph.drawLine(n3 - n, n4, n3 - n + (n2 <<= 1), n4 - n2);
            this.mGraph.drawLine(n3 - n + n2, n4 - n2, n3 + n - n2, n4 - n2);
            this.mGraph.drawLine(n3 + n - n2, n4 - n2, n3 + n, n4);
            this.drawVelocity(ufo);
        } else if (ufo.isExplosion()) {
            this.forExplosion(ufo);
        }
    }

    public void setIdentifier(boolean bl) {
        this.mIdentifier = bl;
    }

    public boolean isIdentifier() {
        return this.mIdentifier;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.mGraph = graphics;
        if (this.mShowScore || this.mModel.getFrameType() == 2) {
            this.mGraph.setFont(this.mFontHigh);
            this.paintHighScores();
        } else {
            this.mGraph.setFont(this.mFontObj);
            this.mModel.forShip(this);
            this.mModel.forUfo(this);
            this.mModel.forAllAsteroids(this);
            this.mModel.forAllShots(this);
        }
    }

    private void paintHighScores() {
        this.mGraph.setColor(TEXT_COLOR);
        FontMetrics fontMetrics = this.mGraph.getFontMetrics(this.mFontHigh);
        int n = fontMetrics.getHeight();
        int n2 = 230;
        int n3 = 100;
        this.mGraph.drawString("HOECHSTERGEBNIS", n2, n3);
        n3 += n;
        for (int i = 0; i < 10; ++i) {
            n3 += n;
            String string = this.mModel.getScore(i);
            if (string == null) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.drawStringLeft(stringTokenizer.nextToken(), n2, n3, 20, fontMetrics);
            this.drawStringLeft(stringTokenizer.nextToken(), n2 + 10, n3, 80, fontMetrics);
            this.mGraph.drawString(stringTokenizer.nextToken(), n2 + 110, n3);
        }
    }

    private static int getScreenX8(int n) {
        return 640 * n >> 13;
    }

    private static int getScreenY8(int n) {
        return 640 * (7160 - n) >> 13;
    }

    public void setShowScore(boolean bl) {
        this.mShowScore = bl;
    }

    public void setVelocity(boolean bl) {
        this.mVelocity = bl;
    }

    public boolean isVelocity() {
        return this.mVelocity;
    }
}

