/*
 * Decompiled with CFR 0.152.
 */
package asteroid.udp;

import asteroid.Operation;
import asteroid.SimpleLogging;
import asteroid.udp.AHandler;
import asteroid.udp.BlockedFiFo;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class FileHandler
extends AHandler {
    private FileChannel mChannel;
    private int mFrame;
    private int mPing;
    private ByteBuffer mKey = ByteBuffer.allocate(1);
    private BlockedFiFo mReceives;

    public FileHandler(String string, int n) throws IOException {
        super("FileHandler");
        this.mReceives = new BlockedFiFo(n);
        FileInputStream fileInputStream = new FileInputStream(string);
        this.mChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.limit(25);
        if (this.readBuffer(byteBuffer)) {
            String string2 = Operation.getText(byteBuffer, 0, 6);
            if ("ctmame".equals(string2)) {
                StringBuffer stringBuffer = new StringBuffer("Client: ");
                stringBuffer.append(byteBuffer.get(13) & 0xFF);
                stringBuffer.append('.');
                stringBuffer.append(byteBuffer.get(14) & 0xFF);
                stringBuffer.append('.');
                stringBuffer.append(byteBuffer.get(15) & 0xFF);
                stringBuffer.append('.');
                stringBuffer.append(byteBuffer.get(16) & 0xFF);
                stringBuffer.append(':');
                stringBuffer.append(byteBuffer.getShort(11) & 0xFFFF);
                SimpleLogging.addLog(stringBuffer.toString());
                if (byteBuffer.get(6) == 50) {
                    byteBuffer.clear();
                    if (this.readBuffer(byteBuffer)) {
                        SimpleLogging.addLog("User: " + Operation.getText(byteBuffer, 0, 32));
                    }
                }
            } else {
                SimpleLogging.addLog("Protokoll falsch");
                this.setOpen(false);
            }
        }
    }

    public void addKey(int n) {
        this.mPing = (n >> 16) + 1 & 0xFF;
    }

    public void close() {
        try {
            this.mChannel.close();
        }
        catch (IOException iOException) {
            System.err.println("exception: " + iOException.getMessage());
        }
    }

    public ByteBuffer getNext(boolean bl) {
        return this.mReceives.nextRead(bl);
    }

    private boolean readBuffer(ByteBuffer byteBuffer) throws IOException {
        int n = this.mChannel.read(byteBuffer);
        if (n == byteBuffer.limit()) {
            return true;
        }
        if (n < 0) {
            SimpleLogging.addLog("Protokoll EOF");
            this.setOpen(false);
        } else {
            SimpleLogging.addLog("falsche Paketgroesse");
        }
        return false;
    }

    private void receive() throws IOException {
        ByteBuffer byteBuffer = this.mReceives.nextWrite();
        byteBuffer.rewind().limit(1024);
        if (this.readBuffer(byteBuffer)) {
            byteBuffer.clear();
            byteBuffer.put(1024, (byte)this.mFrame++);
            byteBuffer.put(1025, (byte)this.mPing);
            this.mReceives.received();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.mTime = System.currentTimeMillis();
        try {
            while (!FileHandler.interrupted()) {
                if (!this.isOpen()) continue;
                this.receive();
                this.send();
            }
        }
        catch (Exception exception) {
            SimpleLogging.addException(exception);
        }
        finally {
            this.close();
        }
    }

    private void send() throws IOException {
        this.mKey.clear();
        this.readBuffer(this.mKey);
    }
}

