/*
 * Decompiled with CFR 0.152.
 */
package asteroid.statistic;

public class AverageLong {
    public long mStart;
    private long mAverage;
    private int mMask;
    private int mPos;
    private long mRound;
    private int mShift;
    private long mSum;
    private long[] mValues;

    public AverageLong(int n) {
        this.mShift = n;
        int n2 = 1 << n;
        this.mValues = new long[n2];
        this.mMask = n2 - 1;
        this.mSum = this.mRound = (long)(n2 >> 1);
    }

    public void addDeviation(long l) {
        this.setValue(this.mPos++, l - this.mStart);
    }

    public void addValue(long l) {
        this.setValue(this.mPos++, l);
    }

    public double getAverage() {
        return this.mAverage;
    }

    public double getMean() {
        return (double)this.getSum() / (double)this.mValues.length;
    }

    public void reset() {
        for (int i = 0; i < this.mValues.length; ++i) {
            this.mValues[i] = 0L;
        }
        this.mAverage = 0L;
        this.mSum = this.mRound;
    }

    public long getSum() {
        return this.mSum - this.mRound;
    }

    public void setValue(int n, long l) {
        this.mSum -= this.mValues[n &= this.mMask];
        this.mSum += l;
        this.mValues[n] = l;
        this.mAverage = this.mSum >> this.mShift;
    }
}

