/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.Operation;
import asteroid.PrintWriterFormat;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class Source {
    protected PrintWriterFormat mOut;

    public Source(PrintStream printStream) {
        this.mOut = new PrintWriterFormat(printStream);
    }

    public Source(String string) {
        this.mOut = new PrintWriterFormat(string);
    }

    public void print(ByteBuffer byteBuffer) {
        int n = 0;
        for (int i = 0; i < 1024; i += 2) {
            this.mOut.savePos();
            int n2 = byteBuffer.getShort(i) & 0xFFFF;
            int n3 = byteBuffer.getShort(i + 2) & 0xFFFF;
            int n4 = n2 >> 12;
            this.printAddr(i >> 1);
            this.mOut.print(':');
            this.mOut.fill(6);
            this.printWord(n2);
            this.mOut.print(" ");
            if (n4 <= 10) {
                this.printWord(n3);
            }
            this.mOut.fill(18);
            switch (n4) {
                case 10: {
                    int n5 = n3 >> 12;
                    this.mOut.print("LABS (");
                    this.mOut.print(n3 & 0x3FF);
                    this.mOut.print(", ");
                    this.mOut.print(n2 & 0x3FF);
                    this.mOut.print("), gs");
                    this.mOut.print(n5);
                    this.printComment("Skalierung " + (n5 > 8 ? n5 - 16 : n5));
                    break;
                }
                case 11: {
                    this.mOut.print("HALT");
                    i = 99999;
                    break;
                }
                case 12: {
                    this.mOut.print("JSRL CALL_");
                    this.printCall(n2 & 0xFFF);
                    break;
                }
                case 13: {
                    this.mOut.print("RTSL");
                    break;
                }
                case 14: {
                    this.mOut.print("JMPL $");
                    this.printAddr(n2);
                    break;
                }
                case 15: {
                    this.mOut.print("SVEC (");
                    this.mOut.print(Operation.getSigned(n2 << 8 & 0x700));
                    this.mOut.print(", ");
                    this.mOut.print(Operation.getSigned(n2 & 0x700));
                    this.mOut.print("), s");
                    this.mOut.print((n2 >> 2 & 2) + (n2 >> 11 & 1) + 2);
                    this.mOut.print(", z");
                    this.mOut.print(n2 >> 4 & 0xF);
                    break;
                }
                default: {
                    int n6 = Operation.getSigned(n3);
                    int n7 = Operation.getSigned(n2);
                    int n8 = n3 >> 12;
                    this.mOut.print("VCTR (");
                    this.mOut.print(n6);
                    this.mOut.print(", ");
                    this.mOut.print(n7);
                    this.mOut.print("), s");
                    this.mOut.print(n4);
                    this.mOut.print(", z");
                    this.mOut.print(n8);
                    if (n6 == 0 && n7 == 0) {
                        if (n8 == 0) {
                            this.printComment("Ruhezeit");
                        }
                        if (n8 != 15) break;
                        this.printComment("Schuss");
                        break;
                    }
                    if (n8 == 12) {
                        if (++n != 1) break;
                        this.printComment("Schiff");
                        break;
                    }
                    n = 0;
                }
            }
            this.mOut.println();
            if (n4 > 10) continue;
            i += 2;
        }
        this.mOut.println();
    }

    private void printAddr(int n) {
        this.printHex(n >> 8);
        this.printHex(n >> 4);
        this.printHex(n);
    }

    private void printCall(int n) {
        for (int i = 0; i < Operation.ADDRESS.length; ++i) {
            if (Operation.ADDRESS[i] != n) continue;
            this.mOut.print(Operation.NAMES[i]);
            return;
        }
        this.mOut.print('$');
        this.printAddr(n);
    }

    private void printComment(String string) {
        this.mOut.fill(48);
        this.mOut.print("; ");
        this.mOut.print(string);
    }

    private void printHex(int n) {
        if ((n &= 0xF) < 10) {
            this.mOut.print((char)(48 + n));
        } else {
            this.mOut.print((char)(65 + n - 10));
        }
    }

    private void printWord(int n) {
        this.printHex(n >> 12);
        this.printHex(n >> 8);
        this.printHex(n >> 4);
        this.printHex(n);
    }
}

