/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class Analyse
extends APrinter {
    private HashMap mMap = new HashMap();
    private GameModel mModel;

    public Analyse(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public void forAsteroid(Asteroid asteroid) {
        if (asteroid.isVisible()) {
            this.forFlyable(asteroid);
        }
    }

    private void forFlyable(AFlyable aFlyable) {
        if (aFlyable.getModify() > 8) {
            int n = (aFlyable.getMoveX8() << 8) + aFlyable.getMoveY8();
            this.mMap.put(new Integer(n), aFlyable.toString());
        }
    }

    public void forUfo(Ufo ufo) {
        if (ufo.isVisible()) {
            this.forFlyable(ufo);
        }
    }

    public void print() {
        if (this.mModel.getShip().isVisible()) {
            this.mModel.forAllAsteroids(this);
            this.mModel.forUfo(this);
            Iterator iterator = this.mMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                String string = (String)this.mMap.get(k);
                this.mOut.println(string);
            }
            this.mOut.println();
        }
    }
}

