/* $Id: statistics.c,v 1.3 2008/05/06 18:32:29 raap Exp $ */

#include <math.h>
#include <stdio.h>

#include "vector.h"
#include "player.h"
#include "objects.h"
#include "dir.h"


double ship_shot_dist;
int	num_shots;

delta ast_dir_list[4*64*64];
int ast_dir_cnt;

/* Variables used for statistics purposes */
int dist_array_ast[50];
int dist_array_ownshot[50];
			


/* An old object was matched to a visible one at distance dist */
void stat_obj_matched(object *oldobj, int dist){
	if (oldobj->type == AST) dist_array_ast[dist/8]++;
	if ((oldobj->type == SHOT) && (oldobj->own == 1)) dist_array_ownshot[dist/8]++;	
};

extern struct dir_list_entry test_dir_list[64][8]; 

/* While developing, we need to gather some statistical data about the game physics
	It is easiest, to store this globally 
*/

int dir_list_comp(struct dir_list_entry *e1, struct dir_list_entry *e2){
	delta d1, d2;
	
	d1 = e1->shot_dir;
	d2 = e2->shot_dir;
	if ( is_null(&d1) ){
		d1.dx = 99999; d1.dy = 99999;
	};
	if ( is_null(&d2) ){
		d2.dx = 99999; d2.dy = 99999;
	};
		 
	return dir_comp(&d1, &d2);
};



						    
typedef struct {
	int cnt;
	int sum;
	int square_sum;
	int min;
	int max;
} stat_var;

	
/* We have a number of variables for the total lifetime of the program */
static int games_cnt;	/* number of games played so far */

static stat_var score;
static stat_var frame_loss;
static stat_var ins_per_frame;
static stat_var us_per_frame;

void init_stat_var(stat_var *var){
	var->cnt = 0;
	var->sum = 0;
	var->square_sum = 0;
	var->min =  999999999;
	var->max = -999999999;
};

/* We have observed a new value of statistic variable var */
void upd_stat_var( stat_var *var, int value){
	var->cnt++;
	var->sum += value;
	var->square_sum += (value * value);
	if (value > var->max) 
		var->max = value;
	if (value < var->min)
		var->min = value;
};

void prt_stat_var( stat_var *var, char *s){
	double avg=0.0, sigma=0.0;
	
	if (var->cnt > 0) avg = var->sum / var->cnt;
	if (var->cnt > 1) sigma = sqrt( (double) (var->cnt * var->square_sum - var->sum * var->sum) / (var->cnt * (var->cnt-1)) );
	

	printf("%s:\t%8.2f\t%8d\t%8d\t%8.2f\t%8d\t%8d\n", s, avg, var->min, var->max, sigma, var->sum, var->cnt);
};
		
void InitStatistics(){
	int i,j;
	games_cnt = 0;	

	init_stat_var(&score);
	init_stat_var(&frame_loss);
	init_stat_var(&us_per_frame);
	init_stat_var(&ins_per_frame);
};

void stat_game_over(int cur_score){
	games_cnt++;
	upd_stat_var(&score, cur_score); 	
};

void stat_frame_loss(int n){
	upd_stat_var(&frame_loss, n); 
};

void stat_time_per_frame(int us, int ins){
	upd_stat_var(&us_per_frame, us);
	upd_stat_var(&ins_per_frame, ins);
}	

void PrtStatistics(){
	int i,j,k, dir_idx;
	int cnt;
#ifdef DEBUG	
	printf("%d games played\n", games_cnt);
	
	printf(				"Var                    :\t     Avg\t     Min\t    Max\t\t   Sigma\t   Total\t     Cnt\n");
#endif	
	prt_stat_var(&score, 		"score_per_game         ");
#ifdef DEBUG	
	prt_stat_var(&ins_per_frame, 	"instructions_per_frame ");
	prt_stat_var(&us_per_frame, 	"microseconds_per_frame ");
	prt_stat_var(&frame_loss, 	"frame_loss             ");
#endif	

};




