// ============================================================================
// File:               Localizable.java
//
// Project:            i18n 
//
// Purpose:            Interface for Components which can be localized.
//
// Author:             Rammi
//-----------------------------------------------------------------------------
// Copyright Notice:   (c) 2002  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================

package de.caff.i18n;


import java.util.Locale;

/**
 *  Interface for Components which can be localized.
 *  <code>Component</code>s are localizable themselves, too.
 *  @author <a href="mailto:rammi@caff.de">Rammi</a>
 *  @version $Revision$
 */
public interface Localizable {
  /**
   *  Set the locale.
   *  @param  l   locale to set.
   */
  public void setLocale(Locale l);

  /**
   *  Get the locale.
   *  @return  the locale
   */
  public Locale getLocale();
}
