// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.util.Collection;

/**
 *  The ufo object.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>
 */
public class Ufo
        extends MovingGameObject
{
  /** Score for big ufo. */
  public static final int SCORE_BIG_UFO = 200;
  /** Score for small ufo. */
  public static final int SCORE_SMALL_UFO = 1000;
  /** The size (half extent) of the big ufo. */
  public static final int BIG_SIZE   = 16;
  /** The size (half extent) of the small ufo. */
  public static final int SMALL_SIZE = 8;
  /** The identity of the ufo. */
  public static final Integer IDENT = new Integer(-2);

  /** The ufo color. */
  private static final Color UFO_COLOR = new Color(0xC0, 0xC0, 0xC0);
  /** The ufo glyph. */
  public static final Glyph UFO_GLYPH = // 0x929
          new Glyph(new byte[] {16, -8, 0, -16, -8, 12, -40, 8, 0, 40, 8, 13, 16, 24, 13, -16, 24, 12, -40, 8, 13, -16, -8, 13, -8, -24, 12, 8, -24, 12, 16, -8, 12, 40, 8, 13});
  /** Shape used for big ufo. */
  private static final Shape BIG = AffineTransform.getScaleInstance(0.5, 0.5).createTransformedShape(UFO_GLYPH.getPath());
  /** Shape used for small ufo. */
  private static final Shape SMALL = AffineTransform.getScaleInstance(0.5, 0.5).createTransformedShape(BIG);

  /** Is this ufo big? */
  private final boolean big;

  /**
   *  Constructor.
   *  @param x  x coordinate
   *  @param y  y coordinate
   *  @param size incoming size from MAME
   */
  public Ufo(int x, int y, int size)
  {
    super(x, y);
    this.big = (size == 15);
    setIdentity(IDENT);
  }

  /**
   *  Get the size of the object.
   *
   *  The size returned by this method is half the length of a square which contains the object,
   *  so the object's bounding box is between (x - size, y - size) and (x + size, y + size).
   *  @return object size
   */
  public int getSize()
  {
    return big ? 16 : 8;
  }

  /**
   *  Draw the object.
   *  @param g graphics context
   */
  @Override
  public void draw(Graphics2D g)
  {
    g.setColor(UFO_COLOR);
    g.draw(AffineTransform.getTranslateInstance(x, y).createTransformedShape(big ? BIG : SMALL));

    drawVelocityVector(g, Color.red);
  }

  /**
   * Returns a string representation of the object.
   *
   * @return a string representation of the object.
   */
  @Override
  public String toString()
  {
    return String.format("Ufo@(%d,%d)*%d", getX(), getY(), getSize());
  }

  /**
   * Get the properties of this object.
   *
   * @return collection of properties
   */
  @Override
  public Collection<Property> getProperties()
  {
    Collection<Property> props = super.getProperties();
    props.add(new Property<String>("Ufo Size", big ? "BIG" : "small"));
    return props;
  }

  /**
   * Get the type of game object.
   *
   * @return game object type
   */
  public String getObjectType()
  {
    return "Ufo";
  }


  /**
   * Get the score which is added if this object is hit.
   *
   * @return score or {@link #NO_SCORE}
   */
  @Override
  public int getScore()
  {
    return big ? SCORE_BIG_UFO : SCORE_SMALL_UFO;
  }

  /**
   * Access method for visitor pattern.
   *
   * @param visitor visitor
   */
  public void visitedBy(GameObjectVisitor visitor)
  {
    visitor.handle(this);
  }

}

