// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

/**
 *  Automatic restarter for competition player.
 */
public class AutoRestarter
  implements Communication.ServerStateListener
{
  /** The communictaions object. */
  private final Communication com;


  public AutoRestarter(Communication com)
  {
    this.com = com;
  }

  /**
   * Called on server state changes.
   *
   * @param oldState old server state
   * @param newState new server state
   */
  public void serverStateChanged(Communication.ServerState oldState, Communication.ServerState newState)
  {
    System.out.println("Restarter: new state="+newState+", oldState="+oldState);
    if (oldState == Communication.ServerState.IN_GAME  &&
        newState == Communication.ServerState.GAME_OVER) {
      System.out.println("Restarting...");
      com.restart();
    }
  }

  /**
   * Called if new information on frames to wait during {@link de.caff.asteroid.Communication.ServerState#SERVER_BUSY} state is received.
   *
   * @param framesToWait new frames to wait number
   */
  public void framesToWaitUpdate(int framesToWait)
  {
    System.out.println("Restarting in "+framesToWait+" frames ...");
  }
}
