/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.IntegerPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.IntegerEditor;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SwingIntegerPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements IntegerPreferenceProperty {
    private final int minValue;
    private final int maxValue;
    private final int step;
    private int value;

    public SwingIntegerPreferenceProperty(String basicName, String baseTag, int value) {
        this(basicName, baseTag, value, 1);
    }

    public SwingIntegerPreferenceProperty(String basicName, String baseTag, int value, int step) {
        this(basicName, baseTag, value, Integer.MIN_VALUE, Integer.MAX_VALUE, step);
    }

    public SwingIntegerPreferenceProperty(String basicName, String baseTag, int value, int minValue, int maxValue) {
        this(basicName, baseTag, value, minValue, maxValue, 1);
    }

    public SwingIntegerPreferenceProperty(String basicName, String baseTag, int value, int minValue, int maxValue, int step) {
        super(basicName, baseTag);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.value = value;
    }

    public void readFrom(Preferences preferences) {
        this.setValue(preferences.getInt(this.getBasicName(), this.value));
    }

    public void storeTo(Preferences preferences) {
        preferences.putInt(this.getBasicName(), this.value);
    }

    public EditorProvider getEditorProvider(Locale l) {
        return new IntegerEditor(this, l);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getStep() {
        return this.step;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int oldValue = this.value;
        this.value = value > this.maxValue ? this.maxValue : (value < this.minValue ? this.minValue : value);
        if (oldValue != this.value) {
            this.fireValueChange(this.getBasicName(), oldValue, this.value);
        }
    }
}

