/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.util.settings.swing.AbstractBasicGroupEditor;
import de.caff.util.settings.swing.EditablePreferenceGroup;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PanelGroupEditor
extends AbstractBasicGroupEditor {
    private JPanel panel;

    public PanelGroupEditor(EditablePreferenceGroup property, Locale l) {
        super(property.getNameTag(), l);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.ipadx = 4;
        constraints.ipady = 4;
        constraints.insets = new Insets(6, 4, 6, 4);
        this.panel = new JPanel(gbl);
        Iterator iterator = property.propertyIterator();
        while (iterator.hasNext()) {
            String title;
            EditablePreferenceProperty epp = (EditablePreferenceProperty)iterator.next();
            EditorProvider provider = epp.getEditorProvider(l);
            this.addEditorProvider(provider);
            String name = provider.getLabelText();
            if (name != null) {
                JLabel label = new JLabel(I18n.format("valueNameFormat", name));
                constraints.gridwidth = -1;
                constraints.fill = 2;
                constraints.anchor = 18;
                gbl.setConstraints(label, constraints);
                this.panel.add(label);
                label.setToolTipText(provider.getToolTipText());
                constraints.anchor = 12;
            } else {
                constraints.anchor = 18;
            }
            constraints.gridwidth = 0;
            constraints.fill = 1;
            JComponent editor = provider.getEditor();
            gbl.setConstraints(editor, constraints);
            this.panel.add(editor);
            if (name == null && (title = provider.getTitleText()) != null) {
                editor.setBorder(BorderFactory.createTitledBorder(title));
            }
            editor.setToolTipText(provider.getToolTipText());
        }
    }

    public JComponent getEditor() {
        return this.panel;
    }
}

